/**
 * Project Name:engine-service
 * File Name:ResourcesRepeatLunchService.java
 * Package Name:cn.com.duiba.tuia.service.impl
 * Date:2019年1月11日上午10:22:26
 * Copyright (c) 2019, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.service;

import java.util.Map;

import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.duiba.tuia.domain.vo.AdvertFilterVO;

/**
 * TradeAppRepeatLunchService <br/>
 * Function: 行业分媒体维度重复发券逻辑. <br/>
 * Date:     2019年1月11日 上午10:22:26 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
public interface TradeAppRepeatLunchService {
    
    /**
     * 
     * resourcesRepeatLunch:(行业分媒体维度重复发券过滤). <br/>
     *
     * @author chencheng
     * @param filterResult
     * @param validAdverts
     * @param platform
     * @return
     * @since JDK 1.8
     */
    Map<Long, AdvertFilterVO> tradeAppRepeatLunch(FilterResult filterResult, Map<Long, AdvertFilterVO> validAdverts);

    /**
     *
     * buildTradeAppRepeatLunchType:(行业标签过滤打标). <br/>
     *
     * @author chencheng
     * @param filterResult
     * @since JDK 1.8
     */
    void buildTradeAppRepeatLunchType(FilterResult filterResult);
}

