/**
 * Project Name:engine-service
 * File Name:ValidFreeAdvertService.java
 * Package Name:cn.com.duiba.tuia.service
 * Date:2018年2月11日上午11:03:40
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.service;

import java.util.List;

import org.springframework.stereotype.Service;

import cn.com.duiba.tuia.exception.TuiaException;

/**
 * ClassName:ValidFreeAdvertService <br/>
 * Function: 有效排序. <br/>
 * Date:     2018年2月11日 上午11:03:40 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
@Service
public interface ValidAdvertService {

    /**
     * 
     * selectValidFreeAdvert:(免费有效广告重新排序). <br/>
     *
     * @author chencheng
     * @return
     * @throws TuiaException 
     * @since JDK 1.8
     */
    List<Long> getValidFreeAdvertAgain() throws TuiaException;
    
    /**
     * selectValidFreeAdvert:(查询数据库中付费有效广告排序). <br/>
     *
     * @author chencheng
     * @param query
     * @return
     * @throws TuiaException 
     * @since JDK 1.8
     */
    List<Long> selectValidPayAdvertFromDB() throws TuiaException;
    
    
}

