package cn.com.duiba.tuia.service.buildparam.impl;

import cn.com.duiba.tuia.domain.dataobject.MediaAccountWhiteDO;
import cn.com.duiba.tuia.domain.dataobject.MediaAdvertWhiteDO;
import cn.com.duiba.tuia.domain.flow.MediaList;
import cn.com.duiba.tuia.domain.flow.MediaSlotListVO;
import cn.com.duiba.tuia.service.SlotWhiteListService;
import cn.com.duiba.tuia.service.buildparam.MediaSlotListService;
import cn.com.duiba.tuia.ssp.center.api.dto.slot.SlotListStatusDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class MediaSlotListServiceImpl implements MediaSlotListService {

    //此处应该包含一个 缓存通知刷新的的缓存

    /** 默认流量策略 */
    public static final int DEFULT_STRATEGY_WHITE = 1;

    /** 新媒体流量策略*/
    public static final int FLOW_STRATEGY_WHITE = 2;

    /** 广告位媒体白名单排序开关为开 */
    public static final int SWITCH_OPEN = 1;

    /** 广告位媒体白名单排序开关为关 */
    public static final int SWITCH_CLOSE = 0;

    /** 广告位媒体白名单同步到流量策略 */
    public static final int SYNC_FLOW_STRATEGY = 1;

    /**
     * 白名单
     */
    public static final int WHITELIST = 0;
    /**
     * 黑名单
     */
    public static final int BLACKLIST = 1;



    public static final MediaList emptyList = MediaList.builder().
            accountIdSet(Collections.emptySet()).
            advertIdSet(Collections.emptySet()).
            build();

    public static final MediaSlotListVO emptyMediaSlotListVO = MediaSlotListVO.builder().
            mediaBlackList(emptyList).
            mediaWhiteList(emptyList).
            build();

    @Autowired
    private SlotWhiteListService slotWhiteListService;


    @Override
    public MediaSlotListVO queryMediaSlotList(Long slotId, Integer flowType) {

        //查询广告位 开关、策略
        SlotListStatusDto openSwitch = slotWhiteListService.isOpenSwitch(slotId);
        //若黑白名单 开关都是关闭状态 则直接返回空的
        Boolean whiteOpenStatus = getWhiteOpenStatus(openSwitch, flowType);
        Boolean blackOpenStatus = getBlackOpenStatus(openSwitch, flowType);
        if((!whiteOpenStatus)&&(!blackOpenStatus)){
            return emptyMediaSlotListVO;
        }

        //广告位广告维度名单
        List<MediaAdvertWhiteDO> mediaAdvertListDOs = slotWhiteListService.queryMediaAdvertList(slotId);
        //广告位广告主维度名单
        List<MediaAccountWhiteDO> mediaAccountListDOs = slotWhiteListService.queryMediaAccountList(slotId);

        Map<Integer, List<MediaAdvertWhiteDO>> mediaAdvertListMap = mediaAdvertListDOs.stream().collect(Collectors.groupingBy(MediaAdvertWhiteDO::getStatusType));
        Map<Integer, List<MediaAccountWhiteDO>> mediaAccountListMap = mediaAccountListDOs.stream().collect(Collectors.groupingBy(MediaAccountWhiteDO::getStatusType));

        MediaList mediaWhiteList = buildMediaList(WHITELIST,whiteOpenStatus, mediaAdvertListMap, mediaAccountListMap);
        MediaList mediaBlackList = buildMediaList(BLACKLIST,blackOpenStatus, mediaAdvertListMap, mediaAccountListMap);

        return MediaSlotListVO.builder().
                mediaWhiteList(mediaWhiteList).
                mediaBlackList(mediaBlackList).
                build();
    }


    private MediaList buildMediaList(Integer listType,Boolean openStatus, Map<Integer, List<MediaAdvertWhiteDO>> mediaAdvertListMap, Map<Integer, List<MediaAccountWhiteDO>> mediaAccountListMap) {

        List<MediaAdvertWhiteDO> mediaAdvertWhiteDOS = mediaAdvertListMap.get(listType);
        List<MediaAccountWhiteDO> mediaAccountWhiteDOS = mediaAccountListMap.get(listType);

        return openStatus ?
                MediaList.builder().
                        advertIdSet(null == mediaAdvertWhiteDOS ? Collections.emptySet() : mediaAdvertWhiteDOS.stream().map(MediaAdvertWhiteDO::getAdvertId).collect(Collectors.toSet())).
                        accountIdSet(null == mediaAccountWhiteDOS ? Collections.emptySet() : mediaAccountWhiteDOS.stream().map(MediaAccountWhiteDO::getAccountId).collect(Collectors.toSet())).
                        build() :
                emptyList;
    }

    /**
     * 查询 白名单开关状态
     * @param dto
     * @return
     */
    private Boolean getWhiteOpenStatus(SlotListStatusDto dto,Integer strategyType){

        //查不到
        if(null == dto){
            return false;
        }

        //未开启白名单开关
        if (dto.getOpenWihteList() == SWITCH_CLOSE) {
            return false;
        }

        if (strategyType == DEFULT_STRATEGY_WHITE) {
            //活动开启白名单默认是对应用管理生效
            return true;
        } else if (strategyType == FLOW_STRATEGY_WHITE && dto.getIsSyncWhiteList() == SYNC_FLOW_STRATEGY) {
            //当前请求未流量策略 且 活动白名单同步流量策略
            return true;
        }

        return false;
    }


    /**
     * 查询黑名单 开关状态
     * @param dto
     * @param strategyType
     * @return
     */
    private Boolean getBlackOpenStatus(SlotListStatusDto dto,Integer strategyType){

        //查不到则默认关闭
        if(null == dto){
            return false;
        }

        //未开启白名单开关
        if (dto.getOpenBlackList() == SWITCH_CLOSE) {
            return false;
        }

        //同步到全局
        if(dto.getIsSyncBlackList() == 1){
            return true;
        }

        //同步到流量策略
        if(dto.getIsSyncBlackList() == 0 && strategyType == FLOW_STRATEGY_WHITE){
            return true;
        }

        return false;
    }


}
