package cn.com.duiba.tuia.service.condition.impl;

import cn.com.duiba.tuia.constants.PackagePlanConstants;
import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.enums.AdvertConditionFilterOrderEnum;
import cn.com.duiba.tuia.service.condition.AdvertConditionFilter;
import cn.com.tuia.advert.enums.ActivityTypeEnum;
import cn.com.tuia.advert.enums.AdvertFilterTypeEnum;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 活动类型
 */
@Component
@Slf4j
public class ActivityTypeConditionFilter implements AdvertConditionFilter {

    /**
     * 过滤接口
     *
     *
     * @param advertConditionContext@return
     */
    @Override
    public boolean match(AdvertConditionContext advertConditionContext) {
        AdvOrientationItem item = advertConditionContext.getAdvOrientationItem();
        AdvQueryParam advQueryParam = advertConditionContext.getAdvQueryParam();
        ObtainAdvertReq req = advertConditionContext.getReq();
        Set<AdvertFilterType> filterTypeSets = advertConditionContext.getFilterTypeSets();

        boolean result = checkActivityType(item.getActivityType(), advQueryParam.getActivityType(),
                advQueryParam.getAdType(), req.getActivityTypeExt());
        if(!result){
            filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), getFilterType().getCode()));
        }

        return result;
    }

    /**
     * 过滤类型
     *
     * @return
     */
    @Override
    public AdvertFilterTypeEnum getFilterType() {
        return AdvertFilterTypeEnum.ACTIVITY_TYPE;
    }

    /**
     * 执行顺序
     *
     * @return
     */
    @Override
    public int getOrder() {
        return AdvertConditionFilterOrderEnum.ACTIVITY_TYPE_ORDER.getOrder();
    }

    /**
     *
     * @param activityTypeSet 配置的结果集合
     * @param activityType 传入的 类型
     * @param adType 广告类型
     * @return
     */
    private boolean checkActivityType(Set<String> activityTypeSet, String activityType, String adType, List<Integer> activityTypeExt) {

        //12 代表 活动工具类型 和 视频素材类型
        if (null != activityTypeExt && activityTypeExt.contains(12)) {
            return checkStrContains(activityTypeSet, String.valueOf(PackagePlanConstants.ACT_ACTIVITY_TYPE));
        }

        if(PackagePlanConstants.NEW_VEDIO_AD_ACTIVITY_TYPE.equals(activityType) || ActivityTypeEnum.DP_ADVERT_ACTIVITY_TYPE.getCodeStr().equals(activityType)){
            //不允许不限 必须包含 响应类型
            return CollectionUtils.isNotEmpty(activityTypeSet) && activityTypeSet.contains(activityType);
        }
        else if (CollectionUtils.isEmpty(activityTypeExt)) {
            //默认为老逻辑
            return checkStrContains(activityTypeSet, activityType);
        } else {
            if (checkStrContains(activityTypeSet, activityType)) {
                return true;
            }

            for (Integer ext : activityTypeExt) {
                if (checkStrContains(activityTypeSet, String.valueOf(ext))) {
                    return true;
                }
            }
            return false;
        }
    }

    /**
     * checkStrContains:(string类型，是否被包含。为空表示不限). <br/>
     */
    private Boolean checkStrContains(Set<String> list, String value) {
        // 请求参数或者广告属性为空，返回true
        if (list == null || list.size() == 0 || StringUtils.isBlank(value)) {
            return true;
        }
        return list.contains(value);
    }
}
