package cn.com.duiba.tuia.service.condition.impl;

import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.enums.AdvertConditionFilterOrderEnum;
import cn.com.duiba.tuia.service.condition.AdvertConditionFilter;
import cn.com.tuia.advert.enums.AdvertFilterTypeEnum;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * 屏蔽流量
 */
@Component
@Slf4j
public class BannedAppFlowConditionFilter implements AdvertConditionFilter {

    /**
     * 过滤接口
     *
     *
     * @param advertConditionContext@return
     */
    @Override
    public boolean match(AdvertConditionContext advertConditionContext) {
        AdvOrientationItem item = advertConditionContext.getAdvOrientationItem();
        AdvQueryParam advQueryParam = advertConditionContext.getAdvQueryParam();
        ObtainAdvertReq req = advertConditionContext.getReq();
        Set<AdvertFilterType> filterTypeSets = advertConditionContext.getFilterTypeSets();

        boolean result = checkBannedAppFlowType(item.getBannedAppFlowType(), advQueryParam.getBannedAppFlowType());
        if (result) {
            filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), getFilterType().getCode()));
        }

        return !result;
    }

    /**
     * 过滤类型
     *
     * @return
     */
    @Override
    public AdvertFilterTypeEnum getFilterType() {
        return AdvertFilterTypeEnum.BANNED_APP_FLOW;
    }

    /**
     * 执行顺序
     *
     * @return
     */
    @Override
    public int getOrder() {
        return AdvertConditionFilterOrderEnum.BANNED_APP_FLOW_ORDER.getOrder();
    }

    /**
     * checkBannedAppFlowType:(命中屏蔽流量). <br/>
     */
    private Boolean checkBannedAppFlowType(Set<String> advBannedAppFlowType, String reqBannedAppFlowType) {
        // 请求参数或者广告属性为空，返回false
        if (CollectionUtils.isEmpty(advBannedAppFlowType) || StringUtils.isBlank(reqBannedAppFlowType)) {
            return false;
        }
        return advBannedAppFlowType.contains(reqBannedAppFlowType);
    }
}
