package cn.com.duiba.tuia.service.condition.impl;

import cn.com.duiba.tuia.cache.AdvertPkgPutFlagCacheService;
import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.enums.AdvertConditionFilterOrderEnum;
import cn.com.duiba.tuia.service.condition.AdvertConditionFilter;
import cn.com.tuia.advert.enums.AdvertFilterTypeEnum;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Set;

@Component
@Slf4j
public class BudgetPerDayConditionFilter implements AdvertConditionFilter {

    @Autowired
    private AdvertPkgPutFlagCacheService advertPkgPutFlagCacheService;

    /**
     * 过滤接口
     *
     *
     * @param advertConditionContext@return
     */
    @Override
    public boolean match(AdvertConditionContext advertConditionContext) {
        AdvOrientationItem item = advertConditionContext.getAdvOrientationItem();
        AdvQueryParam advQueryParam = advertConditionContext.getAdvQueryParam();
        ObtainAdvertReq req = advertConditionContext.getReq();
        Set<AdvertFilterType> filterTypeSets = advertConditionContext.getFilterTypeSets();

        boolean result = advertPkgPutFlagCacheService.getAdvertPkgPutFlag(item.getAdvertId(), item.getOrientationId(), item.getBudgetPerDay());
        if(!result){
            filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), getFilterType().getCode()));
        }

        return result;
    }

    /**
     * 过滤类型
     *
     * @return
     */
    @Override
    public AdvertFilterTypeEnum getFilterType() {
        return AdvertFilterTypeEnum.BUDGET_PER_DAY;
    }

    /**
     * 执行顺序
     *
     * @return
     */
    @Override
    public int getOrder() {
        return AdvertConditionFilterOrderEnum.BUDGET_PER_DAY_ORDER.getOrder();
    }
}
