package cn.com.duiba.tuia.service.condition.impl;

import cn.com.duiba.tuia.domain.flow.MediaList;
import cn.com.duiba.tuia.domain.flow.SlotChooseAdverttVO;
import cn.com.duiba.tuia.domain.model.AdvOrientationItem;
import cn.com.duiba.tuia.domain.model.AdvQueryParam;
import cn.com.duiba.tuia.domain.model.AdvertConditionContext;
import cn.com.duiba.tuia.domain.model.AdvertFilterType;
import cn.com.duiba.tuia.enums.AdvertConditionFilterOrderEnum;
import cn.com.duiba.tuia.service.condition.AdvertConditionFilter;
import cn.com.tuia.advert.enums.AdvertFilterTypeEnum;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Set;

@Component
@Slf4j
public class ChoseAdvertConditionFilter implements AdvertConditionFilter {

    /**
     * 过滤接口
     *
     * @param advertConditionContext @return
     */
    @Override
    public boolean match(AdvertConditionContext advertConditionContext) {
        AdvOrientationItem item = advertConditionContext.getAdvOrientationItem();
        AdvQueryParam advQueryParam = advertConditionContext.getAdvQueryParam();
        ObtainAdvertReq req = advertConditionContext.getReq();
        Set<AdvertFilterType> filterTypeSets = advertConditionContext.getFilterTypeSets();

        boolean result = chooseAdvertFilter(item, advQueryParam);
        if(!result){
            filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), getFilterType().getCode()));
        }

        return result;
    }

    /**
     * 过滤类型
     *
     * @return
     */
    @Override
    public AdvertFilterTypeEnum getFilterType() {
        return AdvertFilterTypeEnum.CHOOSE_ADVERT;
    }

    /**
     * 执行顺序
     *
     * @return
     */
    @Override
    public int getOrder() {
        return AdvertConditionFilterOrderEnum.CHOOSE_ADVERT_ORDER.getOrder();
    }

    private boolean chooseAdvertFilter(AdvOrientationItem item, AdvQueryParam advQueryParam) {

        MediaList mediaWhiteList = advQueryParam.getMediaWhiteList();
        if(mediaWhiteList != null && mediaWhiteList.isAdvertInList(item.getAdvertId(),item.getAccountId())){
            //在白名单中 直接可投
            return true;
        }

        //资源标签
        String resourceTag = item.getResourceTag();
        //行业标签
        Set<String> advertTags = item.getAdvertTags();
        //定制的可投广告列表
        SlotChooseAdverttVO slotChooseAdverttVO = advQueryParam.getSlotChooseAdverttVO();

        return null == slotChooseAdverttVO || slotChooseAdverttVO.chooseItem(resourceTag,advertTags,item.getAdvertId(),item.getAccountId());
    }
}
