package cn.com.duiba.tuia.service.condition.impl;

import cn.com.duiba.tuia.cache.AdvertNewTradeCacheService;
import cn.com.duiba.tuia.domain.dataobject.AdvertNewTradeDO;
import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.enums.AdvertConditionFilterOrderEnum;
import cn.com.duiba.tuia.service.LimitingMaximunService;
import cn.com.duiba.tuia.service.condition.AdvertConditionFilter;
import cn.com.tuia.advert.enums.AdvertFilterTypeEnum;
import cn.com.tuia.advert.enums.ChargeTypeEnum;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Objects;
import java.util.Set;

@Component
@Slf4j
public class LimitAppConditionFilter implements AdvertConditionFilter {

    @Autowired
    private AdvertNewTradeCacheService advertNewTradeCacheService;

    @Autowired
    private LimitingMaximunService limitingMaximunService;

    /**
     * 过滤接口
     *
     *
     * @param advertConditionContext@return
     */
    @Override
    public boolean match(AdvertConditionContext advertConditionContext) {
        AdvOrientationItem item = advertConditionContext.getAdvOrientationItem();
        AdvQueryParam advQueryParam = advertConditionContext.getAdvQueryParam();
        ObtainAdvertReq req = advertConditionContext.getReq();
        Set<AdvertFilterType> filterTypeSets = advertConditionContext.getFilterTypeSets();

        boolean result = checkLimitApp(item,advQueryParam);
        if (result) {
            filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), getFilterType().getCode()));
        }
        return !result;
    }

    /**
     * 过滤类型
     *
     * @return
     */
    @Override
    public AdvertFilterTypeEnum getFilterType() {
        return AdvertFilterTypeEnum.LIMIT_APP;
    }

    /**
     * 执行顺序
     *
     * @return
     */
    @Override
    public int getOrder() {
        return AdvertConditionFilterOrderEnum.LIMIT_APP_ORDER.getOrder();
    }

    private Boolean checkLimitApp(AdvOrientationItem item, AdvQueryParam advQueryParam) {
        Boolean result = limitingMaximunService.hasInLimitingMaximunApps(item.getAdvertId(), item.getOrientationId(), advQueryParam.getAppId(), advQueryParam.getSlotId(), item.getInitialOrientationId());

        //配置被过滤 且 满足释放条件
        //释放条件
        if(result && releaseCondition(item,advQueryParam)){
            //打标记
            item.setAppLimitReleaseMark("1");
            //释放
            return false;
        }

        return result;
    }

    private Boolean releaseCondition(AdvOrientationItem item, AdvQueryParam advQueryParam) {
        //命中实验 且
        // 配置的行业在 配置的媒体行业 之中 且
        // 不在黑名单中 且
        // 是oCPC-抢量优先（高）的配置
        Set<String> tradeSet = advQueryParam.getExpTradeSet();
        //广告的行业标签，基本只有一个 可能为 null
        AdvertNewTradeDO advertNewTradeName = advertNewTradeCacheService.getAdvertNewTradeName(item.getAdvertId());
        String newTradeName = (null == advertNewTradeName ? "未知" : advertNewTradeName.getNewTradeName());

        Long advertId = item.getAdvertId();
        Set<Long> expBlackList = advQueryParam.getExpBlackList();

        // 配置的行业在 配置的媒体行业 之中 且
        //不在黑名单中
        //ocpc-抢量优先（高）的配置
        return CollectionUtils.isNotEmpty(tradeSet) &&  tradeSet.contains(newTradeName) &&
                (CollectionUtils.isEmpty(expBlackList) || !expBlackList.contains(advertId)) &&
                Objects.equals(ChargeTypeEnum.TYPE_CPA.getCode(),item.getChargeType()) && Objects.equals(3,item.getPutTargetType());
    }
}
