package cn.com.duiba.tuia.service.condition.impl;

import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.enums.AdvertConditionFilterOrderEnum;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.com.duiba.tuia.service.condition.AdvertConditionFilter;
import cn.com.tuia.advert.enums.AdvertFilterTypeEnum;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Component
@Slf4j
public class MediaTagConditionFilter implements AdvertConditionFilter {

    @Autowired
    private ApolloPanGuService apolloPanGuService;

    /**
     * 过滤接口
     *
     *
     * @param advertConditionContext@return
     */
    @Override
    public boolean match(AdvertConditionContext advertConditionContext) {
        AdvOrientationItem item = advertConditionContext.getAdvOrientationItem();
        AdvQueryParam advQueryParam = advertConditionContext.getAdvQueryParam();
        ObtainAdvertReq req = advertConditionContext.getReq();
        Set<AdvertFilterType> filterTypeSets = advertConditionContext.getFilterTypeSets();

        boolean result = mediaTagFilter(item, advQueryParam, req);
        if(!result){
            filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), getFilterType().getCode()));
        }

        return result;
    }

    /**
     * 过滤类型
     *
     * @return
     */
    @Override
    public AdvertFilterTypeEnum getFilterType() {
        return AdvertFilterTypeEnum.MEDIA_TAG;
    }

    /**
     * 执行顺序
     *
     * @return
     */
    @Override
    public int getOrder() {
        return AdvertConditionFilterOrderEnum.MEDIA_TAG_ORDER.getOrder();
    }

    private boolean mediaTagFilter(AdvOrientationItem item, AdvQueryParam advQueryParam, ObtainAdvertReq req) {
        List<String> mediaTags = req.getMediaTags();
        if(CollectionUtils.isEmpty(mediaTags)){
            return true;
        }

        Long advertId = item.getAdvertId();
        Long orientationId = item.getOrientationId();
        Map<String, String> idMapByKeyStr = apolloPanGuService.getIdMapByKeyStr("tuia-engine.media-tag");
        String tags = MapUtils.isEmpty(idMapByKeyStr) ? null : idMapByKeyStr.get(advertId + "-" + orientationId);
        if (StringUtils.isBlank(tags)) {
            return true;
        }

        String[] split = tags.split(",");
        Set<String> hashSet = new HashSet();
        for (String s : split) {
            if (StringUtils.isNotBlank(s)) {
                hashSet.add(s);
            }
        }

        return mediaTags.stream().anyMatch(mediatag->hashSet.contains(mediatag));
    }
}
