package cn.com.duiba.tuia.service.condition.impl;

import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.enums.AdvertConditionFilterOrderEnum;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.com.duiba.tuia.service.condition.AdvertConditionFilter;
import cn.com.tuia.advert.enums.AdvertFilterTypeEnum;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Set;

/**
 * 小程序ab测试
 */
@Component
@Slf4j
public class MicroProgramABTestConditionFilter implements AdvertConditionFilter {

    @Autowired
    private ApolloPanGuService apolloPanGuService;

    /**
     * 过滤接口
     *
     *
     * @param advertConditionContext@return
     */
    @Override
    public boolean match(AdvertConditionContext advertConditionContext) {
        AdvOrientationItem item = advertConditionContext.getAdvOrientationItem();
        AdvQueryParam advQueryParam = advertConditionContext.getAdvQueryParam();
        ObtainAdvertReq req = advertConditionContext.getReq();
        Set<AdvertFilterType> filterTypeSets = advertConditionContext.getFilterTypeSets();

        boolean result = microProgramABTestFilter(item, advQueryParam, req);
        if (!result) {
            filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), getFilterType().getCode()));
        }

        return result;
    }

    /**
     * 过滤类型
     *
     * @return
     */
    @Override
    public AdvertFilterTypeEnum getFilterType() {
        return AdvertFilterTypeEnum.MICRO_PROGRAM_AB_TEST;
    }

    /**
     * 执行顺序
     *
     * @return
     */
    @Override
    public int getOrder() {
        return AdvertConditionFilterOrderEnum.MICRO_PROGRAM_AB_TEST_ORDER.getOrder();
    }

    private boolean microProgramABTestFilter(AdvOrientationItem item, AdvQueryParam advQueryParam, ObtainAdvertReq req) {

        Map<String, String> abtestMap = advQueryParam.getAbtestMap();
        Map<String, String> idMapByKeyStr = apolloPanGuService.getIdMapByKeyStr("MiniProgramtest-payAD");

        /**
         * 此处逻辑修改了  命中 1 则过滤，其他（命中 2，不做此实验的流量）不过滤
         */

        Map<String, String> experimentUniqueKeyList = apolloPanGuService.getIdMapByKeyStr("MiniProgramtest-experiment");

        if (null != abtestMap && MapUtils.isNotEmpty(experimentUniqueKeyList) && experimentUniqueKeyList.keySet().stream().anyMatch(key -> abtestMap.containsKey(key))
                && null != idMapByKeyStr && idMapByKeyStr.containsKey(String.valueOf(item.getInitialOrientationId()))) {
            return false;
        }

        return true;
    }
}
