package cn.com.duiba.tuia.service.condition.impl;

import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.enums.AdvertConditionFilterOrderEnum;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.com.duiba.tuia.service.condition.AdvertConditionFilter;
import cn.com.duiba.tuia.service.impl.ExpNetCarrierServiceImpl;
import cn.com.tuia.advert.enums.AdvertFilterTypeEnum;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * 三网识别ab测试
 */
@Component
@Slf4j
public class NetCarrierABTestConditionFilter implements AdvertConditionFilter {

    @Autowired
    private ApolloPanGuService apolloPanGuService;

    /**
     * 过滤接口
     *
     *
     * @param advertConditionContext@return
     */
    @Override
    public boolean match(AdvertConditionContext advertConditionContext) {
        AdvOrientationItem item = advertConditionContext.getAdvOrientationItem();
        AdvQueryParam advQueryParam = advertConditionContext.getAdvQueryParam();
        ObtainAdvertReq req = advertConditionContext.getReq();
        Set<AdvertFilterType> filterTypeSets = advertConditionContext.getFilterTypeSets();

        boolean result = netCarrierABTestFilter(item, advQueryParam, req);
        if (!result) {
            filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), getFilterType().getCode()));
        }

        return result;
    }

    /**
     * 过滤类型
     *
     * @return
     */
    @Override
    public AdvertFilterTypeEnum getFilterType() {
        return AdvertFilterTypeEnum.NET_CARRIER_AB_TEST;
    }

    /**
     * 执行顺序
     *
     * @return
     */
    @Override
    public int getOrder() {
        return AdvertConditionFilterOrderEnum.NET_CARRIER_AB_TEST_ORDER.getOrder();
    }

    private boolean netCarrierABTestFilter(AdvOrientationItem item, AdvQueryParam advQueryParam, ObtainAdvertReq req) {
        if(ExpNetCarrierServiceImpl.HIT_VALUE.equals(advQueryParam.getExpNetCarrierHit())){
            Integer netCarrier = req.getNetCarrier();
            Map<String, String> idMapByKeyStr = null;
            try {
                idMapByKeyStr = apolloPanGuService.getIdMapByKeyStr("tuia-engine.abtest.net.carrier");
            } catch (Exception e) {
                idMapByKeyStr = new HashMap<>();
                log.warn("盘古获取配置失败异常。", e);
            }
            String carrier = MapUtils.isEmpty(idMapByKeyStr) ? null : idMapByKeyStr.get(String.valueOf(item.getAdvertId()));
            return null == carrier || (netCarrier != null && netCarrier.toString().equals(carrier));
        }
        return true;
    }
}
