package cn.com.duiba.tuia.service.condition.impl;

import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.enums.AdvertConditionFilterOrderEnum;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.com.duiba.tuia.service.condition.AdvertConditionFilter;
import cn.com.tuia.advert.enums.AdvertFilterTypeEnum;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Set;

/**
 * 快应用ab测试
 */
@Component
@Slf4j
public class QuickAppConditionFilter implements AdvertConditionFilter {

    @Autowired
    private ApolloPanGuService apolloPanGuService;

    /**
     * 过滤接口
     *
     *
     * @param advertConditionContext@return
     */
    @Override
    public boolean match(AdvertConditionContext advertConditionContext) {
        AdvOrientationItem item = advertConditionContext.getAdvOrientationItem();
        AdvQueryParam advQueryParam = advertConditionContext.getAdvQueryParam();
        ObtainAdvertReq req = advertConditionContext.getReq();
        Set<AdvertFilterType> filterTypeSets = advertConditionContext.getFilterTypeSets();

        boolean result = quickAppABTestFilter(item, advQueryParam, req);
        if (!result) {
            filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), getFilterType().getCode()));
        }

        return result;
    }

    /**
     * 过滤类型
     *
     * @return
     */
    @Override
    public AdvertFilterTypeEnum getFilterType() {
        return AdvertFilterTypeEnum.QUICK_APP;
    }

    /**
     * 执行顺序
     *
     * @return
     */
    @Override
    public int getOrder() {
        return AdvertConditionFilterOrderEnum.QUICK_APP_ORDER.getOrder();
    }

    private boolean quickAppABTestFilter(AdvOrientationItem item, AdvQueryParam advQueryParam, ObtainAdvertReq req) {
        if (StringUtils.isNotBlank(req.getQuickApp()) && StringUtils.equalsIgnoreCase(req.getQuickApp(), "0")) {
            Map<String, String> idMapByKeyStr = null;
            try {
                idMapByKeyStr = apolloPanGuService.getIdMapByKeyStr("tuia-engine.quickapp.advertList");
            } catch (Exception e) {
                log.warn("盘古配置获取异常", e);
            }
            if (MapUtils.isNotEmpty(idMapByKeyStr) && idMapByKeyStr.containsKey(String.valueOf(item.getAdvertId()))) {
                return false;
            }
        }
        return true;
    }
}
