package cn.com.duiba.tuia.service.condition.impl;

import cn.com.duiba.tuia.domain.flow.MediaList;
import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.enums.AdvertConditionFilterOrderEnum;
import cn.com.duiba.tuia.service.condition.AdvertConditionFilter;
import cn.com.tuia.advert.enums.AdvertFilterTypeEnum;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * 媒体广告位黑名单
 */
@Component
@Slf4j
public class SlotBlackListConditionFilter implements AdvertConditionFilter {

    /**
     * 过滤接口
     *
     *
     * @param advertConditionContext@return
     */
    @Override
    public boolean match(AdvertConditionContext advertConditionContext) {
        AdvOrientationItem item = advertConditionContext.getAdvOrientationItem();
        AdvQueryParam advQueryParam = advertConditionContext.getAdvQueryParam();
        ObtainAdvertReq req = advertConditionContext.getReq();
        Set<AdvertFilterType> filterTypeSets = advertConditionContext.getFilterTypeSets();

        boolean result = slotBlackListFilter(item,advQueryParam);
        if (result) {
            filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), getFilterType().getCode()));
        }
        return !result;
    }

    /**
     * 过滤类型
     *
     * @return
     */
    @Override
    public AdvertFilterTypeEnum getFilterType() {
        return AdvertFilterTypeEnum.SLOT_BLACKLIST;
    }

    /**
     * 执行顺序
     *
     * @return
     */
    @Override
    public int getOrder() {
        return AdvertConditionFilterOrderEnum.SLOT_BLACKLIST_ORDER.getOrder();
    }

    /**
     * 广告为黑名单过滤，判断是否在黑名单中
     * @param item
     * @param advQueryParam
     * @return
     */
    private boolean slotBlackListFilter(AdvOrientationItem item, AdvQueryParam advQueryParam) {

        MediaList mediaBlackList = advQueryParam.getMediaBlackList();
        if(null == mediaBlackList){
            return false;
        }
        return mediaBlackList.isAdvertInList(item.getAdvertId(),item.getAccountId());
    }
}
