package cn.com.duiba.tuia.service.condition.impl;

import cn.com.duiba.tuia.domain.dataobject.AdvertFilterKeywordDO;
import cn.com.duiba.tuia.domain.dataobject.GeneralFilterKeywordDO;
import cn.com.duiba.tuia.domain.dataobject.NewTradeFilterKeywordDO;
import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.enums.AdvertConditionFilterOrderEnum;
import cn.com.duiba.tuia.service.condition.AdvertConditionFilter;
import cn.com.tuia.advert.enums.AdvertFilterTypeEnum;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.Objects;
import java.util.Set;

/**
 * 媒体广告位关键词过滤
 */
@Component
@Slf4j
public class SlotKeywordConditionFilter implements AdvertConditionFilter {

    /**
     * 过滤接口
     *
     *
     * @param advertConditionContext@return
     */
    @Override
    public boolean match(AdvertConditionContext advertConditionContext) {
        AdvOrientationItem item = advertConditionContext.getAdvOrientationItem();
        AdvQueryParam advQueryParam = advertConditionContext.getAdvQueryParam();
        ObtainAdvertReq req = advertConditionContext.getReq();
        Set<AdvertFilterType> filterTypeSets = advertConditionContext.getFilterTypeSets();

        boolean result = keywordFilter(item, advQueryParam, req, filterTypeSets);

        return !result;
    }

    /**
     * 过滤类型
     *
     * @return
     */
    @Override
    public AdvertFilterTypeEnum getFilterType() {
        return AdvertFilterTypeEnum.SLOT_KEYWORD;
    }

    /**
     * 执行顺序
     *
     * @return
     */
    @Override
    public int getOrder() {
        return AdvertConditionFilterOrderEnum.SLOT_KEYWORD_ORDER.getOrder();
    }

    /**
     * 关键词屏蔽
     * @param item
     * @param advQueryParam
     * @return true 要屏蔽 false不需要屏蔽
     */
    private boolean keywordFilter(AdvOrientationItem item, AdvQueryParam advQueryParam, ObtainAdvertReq req, Set<AdvertFilterType> filterTypeSets) {

        //美团adx 不需要处理
        if (null != req.getAdxMediaType() && req.getAdxMediaType() == 1) {
            return false;
        }

        AdvertFilterKeywordDO advertFilterKeywordDO = advQueryParam.getAdvertFilterKeywordDO();
        if (null == advertFilterKeywordDO || Objects.isNull(advertFilterKeywordDO.getGeneralFilterKeywordDO()) || Objects.isNull(advertFilterKeywordDO.getNewTradeFilterKeywordDO())) {
            return false;
        }

        NewTradeFilterKeywordDO newTradeFilterKeywordDO = advertFilterKeywordDO.getNewTradeFilterKeywordDO();
        if (Objects.nonNull(newTradeFilterKeywordDO) && CollectionUtils.isNotEmpty(newTradeFilterKeywordDO.getAdvertIdList())) {
            Set<Long> advertIds = newTradeFilterKeywordDO.getAdvertIdList();
            boolean result = advertIds.contains(item.getAdvertId());
            if (result) {
                filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), AdvertFilterTypeEnum.SLOT_NEWTRADE_KEYWORD.getCode()));
                return true;
            }
        }


        GeneralFilterKeywordDO generalFilterKeywordDO = advertFilterKeywordDO.getGeneralFilterKeywordDO();
        if (Objects.nonNull(generalFilterKeywordDO) && CollectionUtils.isNotEmpty(generalFilterKeywordDO.getAdvertIdList())) {
            Set<Long> advertIds = generalFilterKeywordDO.getAdvertIdList();
            boolean result = advertIds.contains(item.getAdvertId());
            if (result) {
                filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), AdvertFilterTypeEnum.SLOT_KEYWORD.getCode()));
                return true;
            }
        }

        return false;
    }
}
