package cn.com.duiba.tuia.service.condition.impl;

import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.enums.AdvertConditionFilterOrderEnum;
import cn.com.duiba.tuia.service.condition.AdvertConditionFilter;
import cn.com.tuia.advert.enums.AdvertFilterTypeEnum;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.Set;

@Component
@Slf4j
public class TargetActivityConditionFilter implements AdvertConditionFilter {

    /**
     * 过滤接口
     *
     *
     * @param advertConditionContext@return
     */
    @Override
    public boolean match(AdvertConditionContext advertConditionContext) {
        AdvOrientationItem item = advertConditionContext.getAdvOrientationItem();
        AdvQueryParam advQueryParam = advertConditionContext.getAdvQueryParam();
        ObtainAdvertReq req = advertConditionContext.getReq();
        Set<AdvertFilterType> filterTypeSets = advertConditionContext.getFilterTypeSets();

        boolean result = checkBindActivity(item.getBinActivityId(), advQueryParam.getActivityId());
        if(!result){
            filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), getFilterType().getCode()));
        }
        return result;
    }

    /**
     * 过滤类型
     *
     * @return
     */
    @Override
    public AdvertFilterTypeEnum getFilterType() {
        return AdvertFilterTypeEnum.TARGET_ACTIVITY;
    }

    /**
     * 执行顺序
     *
     * @return
     */
    @Override
    public int getOrder() {
        return AdvertConditionFilterOrderEnum.TARGET_ACTIVITY_ORDER.getOrder();
    }

    /**
     *checkBindActivity:(定向活动过滤)
     */
    private Boolean checkBindActivity(Set<Long> bindActivityId, Long avtivityId){
        // false : 过滤掉 true :  留下来
        if(CollectionUtils.isEmpty(bindActivityId)){
            return true;
        }

        return bindActivityId.contains(avtivityId);
    }
}
