package cn.com.duiba.tuia.service.condition.impl;

import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.enums.AdvertConditionFilterOrderEnum;
import cn.com.duiba.tuia.service.condition.AdvertConditionFilter;
import cn.com.tuia.advert.enums.AdvertFilterTypeEnum;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * 已转化人群过滤
 */
@Component
@Slf4j
public class TransformPeopleConditionFilter implements AdvertConditionFilter {

    /**
     * 过滤接口
     *
     *
     * @param advertConditionContext@return
     */
    @Override
    public boolean match(AdvertConditionContext advertConditionContext) {
        AdvOrientationItem item = advertConditionContext.getAdvOrientationItem();
        AdvQueryParam advQueryParam = advertConditionContext.getAdvQueryParam();
        Set<AdvertFilterType> filterTypeSets = advertConditionContext.getFilterTypeSets();
        FilterResult filterResult = advertConditionContext.getFilterResult();

        boolean result = transformPeopleFilter(item, advQueryParam);

        if (!result) {
            //发生过滤且没有被过滤
            filterResult.setUserTfFilter("3");
            filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), getFilterType().getCode()));
        }

        return result;
    }

    /**
     * 过滤类型
     *
     * @return
     */
    @Override
    public AdvertFilterTypeEnum getFilterType() {
        return AdvertFilterTypeEnum.TRANSFORM_PEOPLE;
    }

    /**
     * 执行顺序
     *
     * @return
     */
    @Override
    public int getOrder() {
        return AdvertConditionFilterOrderEnum.TRANSFORM_PEOPLE_ORDER.getOrder();
    }

    private boolean transformPeopleFilter(AdvOrientationItem item, AdvQueryParam advQueryParam) {
        if (null == item.getTfUserFilter() || item.getTfUserFilter().doFilter(advQueryParam.getDeviceFilterDto())) {
            return true;
        }

        return false;
    }
}
