package cn.com.duiba.tuia.service.condition.impl;

import cn.com.duiba.tuia.cache.ServiceManager;
import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.enums.AdvertConditionFilterOrderEnum;
import cn.com.duiba.tuia.service.condition.AdvertConditionFilter;
import cn.com.tuia.advert.enums.AdvertFilterTypeEnum;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Set;

@Component
@Slf4j
public class UrgentAdvertConditionFilter implements AdvertConditionFilter {

    @Autowired
    private ServiceManager serviceManager;

    /**
     * 过滤接口
     *
     *
     * @param advertConditionContext@return
     */
    @Override
    public boolean match(AdvertConditionContext advertConditionContext) {
        AdvOrientationItem item = advertConditionContext.getAdvOrientationItem();
        AdvQueryParam advQueryParam = advertConditionContext.getAdvQueryParam();
        ObtainAdvertReq req = advertConditionContext.getReq();
        Set<AdvertFilterType> filterTypeSets = advertConditionContext.getFilterTypeSets();

        boolean result = urgentAdvertFilter(item);
        if(!result){
            filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), getFilterType().getCode()));
        }
        return result;
    }

    /**
     * 过滤类型
     *
     * @return
     */
    @Override
    public AdvertFilterTypeEnum getFilterType() {
        return AdvertFilterTypeEnum.URGENT_ADVERT;
    }

    /**
     * 执行顺序
     *
     * @return
     */
    @Override
    public int getOrder() {
        return AdvertConditionFilterOrderEnum.URGENT_ADVERT_ORDER.getOrder();
    }

    private boolean urgentAdvertFilter(AdvOrientationItem item) {
        try {
            Long advertId = item.getAdvertId();
            Long orientId = item.getOrientationId();
            String key = advertId.toString() + "-" + orientId.toString();
            Boolean status = serviceManager.getUrgentAdvertStatusByKey(key);

            if(null == status){
                return true;
            }
            return !status;
        } catch (Exception e) {
            log.error("urgentAdvertFilter获取配置消耗是否满足广告消耗占比失败，默认投放");
            return true;
        }
    }
}
