package cn.com.duiba.tuia.service.condition.impl;

import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.enums.AdvertConditionFilterOrderEnum;
import cn.com.duiba.tuia.service.condition.AdvertConditionFilter;
import cn.com.duiba.tuia.service.impl.TransferDayuServiceImpl;
import cn.com.tuia.advert.enums.AdvertFilterTypeEnum;
import cn.com.tuia.advert.enums.ChargeTypeEnum;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Component
@Slf4j
public class UserInterestConditionFilter implements AdvertConditionFilter {

    /**
     * 过滤接口
     *
     *
     * @param advertConditionContext@return
     */
    @Override
    public boolean match(AdvertConditionContext advertConditionContext) {
        AdvOrientationItem item = advertConditionContext.getAdvOrientationItem();
        AdvQueryParam advQueryParam = advertConditionContext.getAdvQueryParam();
        ObtainAdvertReq req = advertConditionContext.getReq();
        Set<AdvertFilterType> filterTypeSets = advertConditionContext.getFilterTypeSets();

        boolean result = checkUserInterest(item, advQueryParam);
        if(!result){
            filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), getFilterType().getCode()));
        }
        return result;
    }

    /**
     * 过滤类型
     *
     * @return
     */
    @Override
    public AdvertFilterTypeEnum getFilterType() {
        return AdvertFilterTypeEnum.USER_INTEREST;
    }

    /**
     * 执行顺序
     *
     * @return
     */
    @Override
    public int getOrder() {
        return AdvertConditionFilterOrderEnum.USER_INTEREST_ORDER.getOrder();
    }

    /**
     * 人群兴趣标签过滤
     *
     * 如果 当前流量的标签为空， 1。有定向的情况 则当前过滤掉    2。有排查的情况  则不过滤掉  (@周艺伟)
     * @param item
     * @return
     */
    private Boolean checkUserInterest(AdvOrientationItem item, AdvQueryParam advQueryParam) {

        List<String> userInterest = advQueryParam.getUserInterest();

        Boolean interest = doCheckUserInterest(item,userInterest);

        //人群包定向实验 添加逻辑
        Map<String, String> dayuArguments = advQueryParam.getDayuArguments();
        //命中实验 且 被人群包过滤
        if (null != dayuArguments &&
                TransferDayuServiceImpl.OPEN.equals(dayuArguments.get(TransferDayuServiceImpl.PEOPLE_PREFER))
                && interest.equals(false) && null != item.getChargeType() && ChargeTypeEnum.TYPE_CPA.getCode() == item.getChargeType()) {
            //人群包拓量打标
            item.setPeoplePrffer("1");

            return true;
        }
        return interest;

    }

    private Boolean doCheckUserInterest(AdvOrientationItem item, List<String> queryUserInterest) {
        List<? extends CustomMemFilter> peoplePkgPools = item.getPeoplePkgPools();
        List<? extends CustomMemFilter> exculdePeoplePkgPools = item.getExcludePeoplePkgPools();

        Set<String> userInterest = (null == queryUserInterest ? new HashSet<>() : new HashSet<>(queryUserInterest));

        //定向
        if(CollectionUtils.isNotEmpty(peoplePkgPools)){
            //无论定向排除 有一个池子被过滤 即被过滤
            for (CustomMemFilter peoplePkgPool : peoplePkgPools) {
                if(!peoplePkgPool.filter(userInterest)){
                    return false;
                }
            }
        }

        //排除
        if(CollectionUtils.isNotEmpty(exculdePeoplePkgPools)){
            for (CustomMemFilter exculdePeoplePkgPool : exculdePeoplePkgPools) {
                //有一个通过即可通过
                if(exculdePeoplePkgPool.filter(userInterest)){
                    return true;
                }
            }
            //全部都不通过 过滤
            return false;
        }

        //不限 或 全部通过
        return true;
    }
}
