package cn.com.duiba.tuia.service.engine;

import java.util.Map;

/**
 * ABTest服务
 *
 * @author lijicong
 * @since 2020-10-16
 */
public interface EngineABTestService {

    /**
     * AB测试
     * <p>获取盘古配置Key的值，进行ab分流测试</p>
     *
     * <p>盘古配置Key，代表走B场景的流量占比，默认值：0，范围：0-100，小于0大于100的情况取默认值0。</p>
     * <pre>
     *     举例：
     *     0   全部走A场景，不走B场景；
     *     10  90%走A场景，10%走B场景；
     *     100 不走A场景，全部走B场景；
     * </pre>
     *
     * @param panGuConfigKey 盘古配置Key
     * @param a A场景，一般代表老逻辑
     * @param b B场景，一般代表新逻辑
     * @param <R> 返回结果泛型
     * @return 回调接口的返回结果
     */
    <R> R abtest(String panGuConfigKey, TestCallback<R> a, TestCallback<R> b);

    /**
     * AB测试回调接口
     *
     * @param <R>
     */
    @FunctionalInterface
    interface TestCallback<R> {

        R doInTest();

    }

    /**
     * 获取新ocpc实验的广告配置白名单
     * @param panGuConfigKey
     * @return
     */
    Map<String, String> getNewOcpcAdvertWhiteMap(String panGuConfigKey);

}
