package cn.com.duiba.tuia.service.engine;

import cn.com.duiba.tuia.domain.model.AdvertFilter;
import cn.com.duiba.tuia.domain.model.engine.BuildParametersRtn;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;

import java.util.Map;
import java.util.concurrent.FutureTask;

/**
 * 风控检测 Service
 * @author lijicong
 * @since 2020-10-09
 */
public interface EngineRiskCheckService {

    /**
     * 风控反作弊接口，命中则走特权库发券
     * @param req
     * @param rsp
     * @param parametersRtn
     * @param advertFilter
     * @return
     */
    FutureTask<Map<String, Integer>> asynRiskCheckAndSendIfHit(ObtainAdvertReq req, ObtainAdvertRsp rsp, BuildParametersRtn parametersRtn, AdvertFilter advertFilter);

    /**
     * 获取异步结果，判断是否命中风控
     * @param futureTask
     * @return
     */
    boolean isHitRisk(FutureTask<Map<String, Integer>> futureTask);
}
