package cn.com.duiba.tuia.service.engine;

import cn.com.duiba.tuia.domain.model.AdvertFilter;
import cn.com.duiba.tuia.domain.model.engine.BuildParametersRtn;
import cn.com.duiba.tuia.domain.vo.AdvertFilterVO;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;

import java.util.Map;

/**
 * 发券场景 Sevice
 * @author lijicong
 * @since 2020-09-30
 */
public interface EngineSceneService {

    /**
     * 应用场景发券
     * @param req
     * @param rsp
     * @param advertFilter
     * @param parametersRtn
     * @param validAdverts
     * @throws TuiaException
     */
    void applyScene(ObtainAdvertReq req, ObtainAdvertRsp rsp, AdvertFilter advertFilter, BuildParametersRtn parametersRtn, Map<Long, AdvertFilterVO> validAdverts) throws TuiaException;

}
