package cn.com.duiba.tuia.service.engine.impl;

import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.com.duiba.tuia.service.engine.EngineABTestService;
import cn.com.duiba.tuia.tool.StringTool;
import cn.com.duiba.tuia.utils.WeightRandomUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * ABTest服务
 * @author lijicong
 * @since 2020-10-16
 */
@Service
@Slf4j
public class EngineABTestServiceImpl implements EngineABTestService {

    // 默认值
    private static final int DEFAULT_WEIGHT_VALUE = 0;

    @Resource
    private ApolloPanGuService apolloPanGuService;

    @Override
    public <R> R abtest(String panGuConfigKey, TestCallback<R> a, TestCallback<R> b) {
        // 区间[0,100)的随机数小于设置的权重，走B场景
        if (WeightRandomUtil.weightToSuccess(getWeight(panGuConfigKey))) {
            return b.doInTest();
        }
        // 走A场景
        return a.doInTest();
    }

    /**
     * 从盘古中获取权重
     * @param panGuConfigKey
     * @return
     */
    private int getWeight(String panGuConfigKey) {
        try {
            String value = apolloPanGuService.getIdMapStrByKeyStr(panGuConfigKey);
            if (StringUtils.isBlank(value)) {
                return DEFAULT_WEIGHT_VALUE;
            }
            int weight = Integer.parseInt(value);
            if (weight < 0 || weight > 100) {
                return DEFAULT_WEIGHT_VALUE;
            }
            return weight;
        } catch (Exception e) {
            log.warn("获取盘古配置失败 configKey={}, error", panGuConfigKey, e);
        }
        return DEFAULT_WEIGHT_VALUE;
    }

    /**
     * 从盘古中获取新O测试白名单
     * @param panGuConfigKey
     * @return
     */
    @Override
    public Map<String, String> getNewOcpcAdvertWhiteMap(String panGuConfigKey) {
        try {
            String value = apolloPanGuService.getIdMapStrByKeyStr(panGuConfigKey);

            List<String> newOWhiteAdvertList = StringTool.getStringListBySymbol(value, ";");

            Map<String, String> newOWhiteAdvertMap = new HashMap<>(newOWhiteAdvertList.size());

            newOWhiteAdvertList.forEach(str -> {

                List<String> list = StringTool.getStringListBySymbol(str, "-");

                newOWhiteAdvertMap.put(list.get(0) + "-" + list.get(1), list.get(2) + "-" + list.get(3));

            });

            return newOWhiteAdvertMap;
        } catch (Exception e) {
            log.warn("获取盘古配置失败 configKey={}, error", panGuConfigKey, e);
        }
        return Collections.emptyMap();
    }
}
