package cn.com.duiba.tuia.service.engine.impl;

import cn.com.duiba.boot.profiler.DBTimeProfiler;
import cn.com.duiba.tuia.cache.NewAppTestCacheService;
import cn.com.duiba.tuia.constants.ABTestConstant;
import cn.com.duiba.tuia.domain.model.AdvQueryParam;
import cn.com.duiba.tuia.domain.model.AdvertFilter;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.duiba.tuia.domain.model.engine.BusinessSceneRequest;
import cn.com.duiba.tuia.domain.model.engine.BusinessSceneResponse;
import cn.com.duiba.tuia.domain.vo.AdvertFilterVO;
import cn.com.duiba.tuia.service.AdvertPreFilterService;
import cn.com.duiba.tuia.service.engine.EngineABTestService;
import cn.com.duiba.tuia.service.engine.EngineFilterService;
import cn.com.duiba.tuia.service.engine.recall.BusinessScene;
import cn.com.duiba.tuia.service.engine.recall.BusinessSceneManager;
import cn.com.duiba.tuia.service.engine.recall.scene.MainBusinessScene;
import cn.com.duiba.tuia.service.engine.recall.scene.NewAppTestBusinessScene;
import cn.com.duiba.tuia.service.impl.EngineServiceImpl;
import cn.com.duibaboot.ext.autoconfigure.cat.annotation.CatTransaction;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.Map;

@Service
@Slf4j
public class EngineFilterServiceImpl implements EngineFilterService {

    @Autowired
    private EngineABTestService engineABTestService;

    @Autowired
    private EngineServiceImpl engineServiceImpl;

    @Autowired
    private AdvertPreFilterService advertPreFilterService;

    @Autowired
    private NewAppTestCacheService newAppTestCacheService;

    /**
     * 过滤 得到 候选 的 有效广告
     *
     * @param advQueryParamTmp
     * @param req
     * @param filterResult
     * @param advertFilter
     * @return
     */
    @Override
    @CatTransaction(type = "obtainAdvert", name = "memoryFilter")
    public Map<Long, AdvertFilterVO> getValidAdverts(AdvQueryParam advQueryParamTmp, ObtainAdvertReq req, FilterResult filterResult, AdvertFilter advertFilter) {

        //AB 测试 获取过滤后的有效广告  A 场景 老代码、B 场景新代码
        return engineABTestService.abtest(ABTestConstant.MEMORY_FILTER_KEY, () -> advertPreFilterService.preFilterAdvertWithEsHystrix(advQueryParamTmp, req, filterResult, advertFilter), () -> doGetValidAdverts(advQueryParamTmp, req, filterResult, advertFilter));
    }

    @DBTimeProfiler
    private Map<Long, AdvertFilterVO> doGetValidAdverts(AdvQueryParam advQueryParam, ObtainAdvertReq req, FilterResult filterResult, AdvertFilter advertFilter) {

        //1、根据此次请求的特征 及 配置 生成 场景标签
        String sceneLable = generateSceneLable(req);

        //2、根据场景标签 = 获取 场景
        BusinessScene filterScene = getSceneByLable(sceneLable);

        if(null == filterScene){
            log.error("filterScene 为 null,sceneLable = " + sceneLable + " , BUSINESS_SCENE_MAP=" + JSON.toJSONString(BusinessSceneManager.BUSINESS_SCENE_MAP) + " , main = "+JSON.toJSONString(BusinessSceneManager.MAIN_SCENE));
        }

        //3、执行场景
        BusinessSceneResponse businessSceneResponse = filterScene.doBusiness(new BusinessSceneRequest(advQueryParam, req, filterResult, advertFilter));

        return null == businessSceneResponse ? Collections.emptyMap():businessSceneResponse.getValidAdverts();
    }

    private BusinessScene getSceneByLable(String sceneLable) {
        try {
            BusinessScene businessScene = BusinessSceneManager.BUSINESS_SCENE_MAP.get(sceneLable);
            return null != businessScene ? businessScene : BusinessSceneManager.MAIN_SCENE;
        } catch (Exception e) {
            log.error("获取场景异常，sceneLable=" + sceneLable, e);
        }

        return BusinessSceneManager.MAIN_SCENE;
    }


    /***
     * 后面需要迁移到 参数构建
     * @param req
     * @return
     */
    private String generateSceneLable(ObtainAdvertReq req) {

        //判断是否新媒体测试
        if (newAppTestCacheService.ifTestNewApp(req.getAppId())) {
            return NewAppTestBusinessScene.LABLE;
        }

        return MainBusinessScene.LABLE;
    }
}
