package cn.com.duiba.tuia.service.engine.impl;

import cn.com.duiba.tuia.domain.model.AdvertFilter;
import cn.com.duiba.tuia.domain.model.engine.BuildParametersRtn;
import cn.com.duiba.tuia.service.engine.EngineRiskCheckService;
import cn.com.duiba.tuia.service.impl.EngineServiceImpl;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

/**
 * 风控检测
 * @author lijicong
 * @since 2020-10-10
 */
@Service
@Slf4j
public class EngineRiskCheckServiceImpl implements EngineRiskCheckService {

    /**
     * 风控线程池
     * @see cn.com.duiba.tuia.service.impl.EngineServiceImpl executor2
     */
    private final ExecutorService riskExecutor = Executors.newFixedThreadPool(8);
    @Resource
    private EngineServiceImpl engineServiceImpl;

    @Override
    public FutureTask<Map<String, Integer>> asynRiskCheckAndSendIfHit(ObtainAdvertReq req, ObtainAdvertRsp rsp, BuildParametersRtn parametersRtn, AdvertFilter advertFilter) {
        FutureTask<Map<String, Integer>> riskCheckTask = null;
        try {
            riskCheckTask = new FutureTask<>(() ->
                    engineServiceImpl.doRiskCheck(req, rsp,
                            parametersRtn.getFilterResult(),
                            parametersRtn.getShieldStrategyVO(),
                            parametersRtn.getAppDetail(),
                            parametersRtn.getAdvQueryParamTmp(),
                            advertFilter));
            riskExecutor.submit(riskCheckTask);
        } catch (Exception e) {
            log.error("EngineServiceImpl.obtainAdvert 风控反作弊接口：", e);
        }
        return riskCheckTask;
    }

    @Override
    public boolean isHitRisk(FutureTask<Map<String, Integer>> futureTask) {
        Map<String, Integer> mapRiskResult = null;
        try {
            if (null != futureTask) {
                mapRiskResult = futureTask.get();
            }
        } catch (Exception e) {
            log.error("EngineServiceImpl.obtainAdvert 异步风控出错：", e);
        }
        if (mapRiskResult == null) {
            return false;
        }
        Integer isRiskTrueOne = mapRiskResult.get("flag");
        // 异步不能返回 boolean ,这里1代表true被风控了，0代表false
        return null != isRiskTrueOne && 1 == isRiskTrueOne;
    }
}
