package cn.com.duiba.tuia.service.engine.impl;

import cn.com.duiba.boot.utils.WarningUtils;
import cn.com.duiba.nezha.engine.api.dto.ConsumerDto;
import cn.com.duiba.nezha.engine.api.enums.ActivitySceneEnum;
import cn.com.duiba.tuia.constants.ErrorCode;
import cn.com.duiba.tuia.domain.model.AdvQueryParam;
import cn.com.duiba.tuia.domain.model.AdvertFilter;
import cn.com.duiba.tuia.domain.model.AppDetail;
import cn.com.duiba.tuia.domain.model.CatMonitorWarnThreshold;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.duiba.tuia.domain.model.FilterResultTypes;
import cn.com.duiba.tuia.domain.model.engine.BuildParametersRtn;
import cn.com.duiba.tuia.domain.vo.AdvertFilterVO;
import cn.com.duiba.tuia.enums.CatGroupEnum;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.service.WhiteListService;
import cn.com.duiba.tuia.service.engine.EngineSceneService;
import cn.com.duiba.tuia.service.filter.AutoFlowbackFilter;
import cn.com.duiba.tuia.service.filter.LowNeedsAdFilter;
import cn.com.duiba.tuia.service.impl.EngineServiceImpl;
import cn.com.duiba.tuia.strategy.StrategyBeans;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 发券场景
 * @author lijicong
 * @since 2020-10-09
 */
@Service
public class EngineSendSceneServiceImpl implements EngineSceneService {

    @Resource
    private AutoFlowbackFilter autoFlowbackFilter;
    @Resource
    private EngineServiceImpl engineServiceImpl;
    @Resource
    private CatMonitorWarnThreshold catMonitorWarnThreshold;
    @Resource
    private LowNeedsAdFilter lowNeedsAdFilter;
    @Autowired
    private WhiteListService whiteListService;

    @Override
    public void applyScene(ObtainAdvertReq req, ObtainAdvertRsp rsp, AdvertFilter advertFilter, BuildParametersRtn parametersRtn, Map<Long, AdvertFilterVO> validAdverts) throws TuiaException {

        AdvQueryParam advQueryParam = parametersRtn.getAdvQueryParamTmp();
        AppDetail appDetail = parametersRtn.getAppDetail();
        FilterResult filterResult = parametersRtn.getFilterResult();
        ConsumerDto consumerDto = parametersRtn.getConsumerDto();

        // 1. 过滤后,只有有广告时才需要去做其他逻辑
        if (validAdverts.size() > 0) {

            // 1.1.1 特殊白名单过滤
            autoFlowbackFilter.doFilter(validAdverts, req);
            if (MapUtils.isEmpty(validAdverts)) {
                return;
            }

            // 1.1.2 直接返回：直接中广告、商业活动白名单、媒体白名单
            boolean checkReturnFlag;
//            = engineServiceImpl.whiteCheckReturn(req, rsp, filterResult, validAdverts, appDetail, advertFilter);
//            if (checkReturnFlag) {
//                return;
//            }

            //白名单 服务
            //推啊活动白名单 和 广告位白名单 都在这了
            validAdverts = whiteListService.doWhiteListBusiness(req, rsp, filterResult, validAdverts, appDetail, advertFilter);

            // 1.1.3 重复发券过滤
            validAdverts = engineServiceImpl.repeatLunch(filterResult, validAdverts, advQueryParam, advertFilter);

            // 1.1.4 直接返回：新媒体测试、DMP数据测试
            checkReturnFlag = engineServiceImpl.testCheckReturn(req, rsp, filterResult, validAdverts, advQueryParam, advertFilter);
            if (checkReturnFlag) {
                return;
            }

            // 1.1.5 用户低意向广告过滤
            lowNeedsAdFilter.doFilter(validAdverts, parametersRtn.getFilterResult(), req, advertFilter);

            // 1.1.6 哪吒算法推荐出券
            Map<Long, AdvertFilterVO> newValidAdverts = engineServiceImpl.recommendAdvert(validAdverts, advQueryParam, filterResult, req, rsp, consumerDto, appDetail, advertFilter);

            // 1.1.7 如果推荐算法发券不成功，则需要降级处理，走原来的投放逻辑
            if (!rsp.isResult()) {

                //强出券走降级监控日志
                if (Objects.equals(filterResult.getIsNeedExploit(), ActivitySceneEnum.ACTIVITY_CUSTOMIZED_ADVERT.getCode())) {
                    CatUtil.log(MapUtils.isEmpty(validAdverts)?CatGroupEnum.CAT_107035.getCode():CatGroupEnum.CAT_107034.getCode());
                }

                if (FilterResult.RECMD_VAILD_LIST_TYPE != filterResult.getType()) {
                    filterResult.setType(FilterResult.RECMD_DEGRADE_TYPE);
                }
                // 1.1.7.1 降级后的核心逻辑
                List<AdvertFilterVO> advertFilterVOList = engineServiceImpl.degradeAdverts(req, rsp, filterResult, validAdverts, newValidAdverts, advertFilter);
                // 1.1.7.2 付费券没有中之后,降级中免费券
                if (!rsp.isResult()) {
                    engineServiceImpl.doFreeAdverts(req, rsp, advertFilterVOList, filterResult, advertFilter);
                }
            }
        } else {
            CatUtil.catLog(CatGroupEnum.CAT_102003.getCode());//内存过滤-其他动态过滤后有效配置为空
            WarningUtils.markThresholdWarning("esOrDynaFilterNoData", catMonitorWarnThreshold.getEsFilterNoData());

            // 1.2 如果活动不是仅投 并且 福袋开启，走dsp竞价
            if (!engineServiceImpl.isOnlyPutActivity(req)
                    && engineServiceImpl.isSendLucky(appDetail, StrategyBeans.shieldingStrategyMap.get(rsp.getStrategyType()))
                    && rsp.getDspCompare() == null) {
                rsp.setDspCompare(true);
            }
        }

        // 2. 如果没有结果走特权库
        if (!rsp.isResult()) {
            filterResult.setType(FilterResultTypes.NORMAL_PRIVILEGE);
        }

        engineServiceImpl.privilegeFilter(filterResult, req, parametersRtn.getShieldStrategyVO(), parametersRtn.getCity(), rsp, appDetail, advQueryParam, advertFilter);

        // 3. 如果最终没有匹配到广告，则记录为遍历无结果
        if (!rsp.isResult()) {
            CatUtil.catLog(CatGroupEnum.CAT_102004.getCode());
            filterResult.setResultCode(ErrorCode.E0500003.getErrorCode());
        }
    }
}
