package cn.com.duiba.tuia.service.engine.recall;


import cn.com.duiba.tuia.domain.model.engine.BusinessSceneResponse;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;

/**
 * 过滤后有效广告获取场景模版
 */
@Slf4j
public abstract class BusinessSceneAbstract implements BusinessScene, InitializingBean {

    /**
     * 空的返回
     */
    protected static final BusinessSceneResponse EMPTY_RESPONSE =
            BusinessSceneResponse.builder().
                    validAdverts(Maps.newLinkedHashMap()).
                    build();

    @Override
    public void afterPropertiesSet(){
        doRegisterToManger();
    }

    private void doRegisterToManger() {
        try {
            //预留 SceneLableManager 注册。

            BusinessSceneManager.register(this);
        } catch (Exception e) {
            log.warn(e.getMessage(), e);
        }
    }
}
