package cn.com.duiba.tuia.service.engine.recall;

import cn.com.duiba.tuia.service.engine.recall.scene.MainBusinessScene;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Component
public class BusinessSceneManager {

    public static final Map<String,BusinessScene> BUSINESS_SCENE_MAP = new ConcurrentHashMap<>();

    public static BusinessScene MAIN_SCENE;

    public static void register(BusinessScene businessSceneAbstract) throws Exception {
        String key;

        if (null == businessSceneAbstract || null == (key = businessSceneAbstract.sceneLable())) {
            throw new Exception("business scene register fail");
        }

        if (MainBusinessScene.LABLE.equals(key)) {
            MAIN_SCENE = businessSceneAbstract;
        }

        BUSINESS_SCENE_MAP.put(key,businessSceneAbstract);
    }
}
