package cn.com.duiba.tuia.service.engine.recall.scene;

import cn.com.duiba.boot.profiler.DBTimeProfiler;
import cn.com.duiba.tuia.domain.model.AdvOrientationItem;
import cn.com.duiba.tuia.domain.model.AdvQueryParam;
import cn.com.duiba.tuia.domain.model.AdvertFilter;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.duiba.tuia.domain.model.engine.BusinessSceneRequest;
import cn.com.duiba.tuia.domain.model.engine.BusinessSceneResponse;
import cn.com.duiba.tuia.domain.vo.AdvertFilterVO;
import cn.com.duiba.tuia.service.AdvertPreFilterService;
import cn.com.duiba.tuia.service.AdvertQueryService;
import cn.com.duiba.tuia.service.engine.recall.BusinessSceneAbstract;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component
@Slf4j
public class MainBusinessScene extends BusinessSceneAbstract {

    public static final String LABLE = "main";


    @Autowired
    private AdvertPreFilterService advertPreFilterService;

    @Autowired
    private AdvertQueryService advertQueryService;





    @Override
    public String sceneLable() {
        return LABLE;
    }

    @Override
    @DBTimeProfiler
    public BusinessSceneResponse doBusiness(BusinessSceneRequest request) {

        AdvQueryParam advQueryParam = request.getAdvQueryParam();
        AdvertFilter advertFilter = request.getAdvertFilter();
        FilterResult filterResult = request.getFilterResult();
        ObtainAdvertReq req = request.getReq();

        try {
            //1.广告配置过滤
            List<AdvOrientationItem> filterAdv = advertQueryService.advertMemoryFilterMainScene(advQueryParam, advertFilter, filterResult, req);

            //TODO 这一步与 之前做的 测试dmp相关 或许可以下掉 2.将匹配的行业人群包标签存在filterResult
            advertPreFilterService.setMatchTradePackageTag(filterAdv, filterResult, advQueryParam);

            //TODO 可以优化掉 3、设置有效的素材列表
            filterResult.setValidAdvertMaterialSet(advQueryParam.getValidAdvertMaterialSet());

            //4、组装 候选广告 信息
            Map<Long, AdvertFilterVO> rtnMap = advertPreFilterService.storeOrientationPrice(filterAdv, advQueryParam, req, filterResult);

            return BusinessSceneResponse.builder().
                    validAdverts(rtnMap).
                    build();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return EMPTY_RESPONSE;
        }

    }

}
