package cn.com.duiba.tuia.service.engine.recall.scene;

import cn.com.duiba.tuia.domain.model.AdvQueryParam;
import cn.com.duiba.tuia.domain.model.AdvertFilter;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.duiba.tuia.domain.model.engine.BusinessSceneRequest;
import cn.com.duiba.tuia.domain.model.engine.BusinessSceneResponse;
import cn.com.duiba.tuia.service.AdvertPreFilterService;
import cn.com.duiba.tuia.service.AdvertQueryService;
import cn.com.duiba.tuia.service.engine.recall.BusinessSceneAbstract;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewAppTestBusinessScene extends BusinessSceneAbstract {

    public static final String LABLE = "newAppTest";

    @Autowired
    private AdvertPreFilterService advertPreFilterService;

    @Autowired
    private AdvertQueryService advertQueryService;


    @Override
    public String sceneLable() {
        return LABLE;
    }

    @Override
    public BusinessSceneResponse doBusiness(BusinessSceneRequest request) {

        AdvQueryParam advQueryParam = request.getAdvQueryParam();
        AdvertFilter advertFilter = request.getAdvertFilter();
        FilterResult filterResult = request.getFilterResult();
        ObtainAdvertReq req = request.getReq();

        return BusinessSceneResponse.builder().
                validAdverts(advertPreFilterService.preFilterAdvertWithEsHystrix(advQueryParam, req, filterResult, advertFilter)).
                build();

    }

}
