package cn.com.duiba.tuia.service.filter.impl;

import cn.com.duiba.bigdata.online.service.api.dto.DeviceFilterDto;
import cn.com.duiba.tuia.domain.model.TfUserFilter;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 广告主过滤
 */
public class TfUserFilterAccountImpl implements TfUserFilter {

    /**
     * 广告主id
     */
    private String accountId;

    /**
     * 转化指标
     */
    private List<String> targets;

    public TfUserFilterAccountImpl(String accountId, List<String> targets) {
        this.accountId = accountId;
        this.targets = targets;
    }

    @Override
    public Boolean doFilter(DeviceFilterDto deviceFilterDto) {
        //没有转化记录
        if(null == deviceFilterDto){
            return true;
        }

        Map<String, List<String>> effect = deviceFilterDto.getAccountEffect();
        if(CollectionUtils.isEmpty(effect)){
            return true;
        }

        List<String> tfTargets = Optional.ofNullable(effect.get(this.accountId)).
                orElse(Collections.emptyList());

        /**
         * 若有交集，则已有转化，需要过滤，返回false
         */
        return !CollectionUtils.containsAny(targets, tfTargets);
    }
}
