package cn.com.duiba.tuia.service.filter.impl;

import cn.com.duiba.bigdata.online.service.api.dto.DeviceFilterDto;
import cn.com.duiba.tuia.domain.model.TfUserFilter;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TfUserFilterAdPlanImpl implements TfUserFilter {

    /**
     * 广告主id
     */
    private String advertId;

    /**
     * 转化指标
     */
    private List<String> targets;

    public TfUserFilterAdPlanImpl(String advertId, List<String> targets) {
        this.advertId = advertId;
        this.targets = targets;
    }

    @Override
    public Boolean doFilter(DeviceFilterDto deviceFilterDto) {
        //没有转化记录
        if(null == deviceFilterDto){
            return true;
        }

        Map<String, List<String>> effect = deviceFilterDto.getAdvertEffect();
        if(CollectionUtils.isEmpty(effect)){
            return true;
        }

        List<String> tfTargets = Optional.ofNullable(effect.get(this.advertId)).
                orElse(Collections.emptyList());

        /**
         * 若有交集，则已有转化，需要过滤，返回true
         */
        return !CollectionUtils.containsAny(targets, tfTargets);
    }
}
