package cn.com.duiba.tuia.service.filter.peoplepkg;

import cn.com.duiba.tuia.domain.model.CustomMemFilter;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

public class PeoplePkgPool implements CustomMemFilter {
    private static Logger logger = LoggerFactory.getLogger(PeoplePkgPool.class);

    /**
     * 池子编号
     */
    private Integer poolNum;

    /**
     * 定向类型
     */
    private Integer orientType;

    /**
     * 池子中的标签
     */
    private Set<String> tags;

    /**
     * 过滤器 定向 或 排除
     */
    private PeoplePkgPoolFilter peoplePkgPoolFilter;


    ////////////////////////////////////////////////////////////////////////////////////////
    /** 定向类型 */
    public static final Integer ORIENT_TYPE = 0;
    /** 排除类型 */
    public static final Integer EXCLUDE_TYPE = 1;
    /** 过滤器map */
    private static final Map<Integer,PeoplePkgPoolFilter> peoplePkgPoolFilterMap;

    static {
        peoplePkgPoolFilterMap = new HashMap<>();

        //定向类型 有交集 则返回true 通过
        peoplePkgPoolFilterMap.put(ORIENT_TYPE,(srcTags,queryTags)->{

            //如果 传入的 查询标签是空的，肯定没有交集 过滤。
            if(CollectionUtils.isEmpty(queryTags)){
                return false;
            }

            Set<String> drivers;
            Set<String> car;

            if(queryTags.size() > srcTags.size()){
               drivers = srcTags;
               car = queryTags;
            }else{
                drivers = queryTags;
                car = srcTags;
            }

            for (String driver : drivers) {
                if(car.contains(driver)){
                    return true;
                }
            }
            return false;
        });

        //排除类型 有交集 则返回false 过滤
        peoplePkgPoolFilterMap.put(EXCLUDE_TYPE,(srcTags,queryTags)->{

            //如果 传入的 查询标签是空的，肯定没有交集 通过。
            if(CollectionUtils.isEmpty(queryTags)){
                return true;
            }

            Set<String> drivers;
            Set<String> car;

            if(queryTags.size() > srcTags.size()){
                drivers = srcTags;
                car = queryTags;
            }else{
                drivers = queryTags;
                car = srcTags;
            }

            for (String driver : drivers) {
                if(car.contains(driver)){
                    return false;
                }
            }
            return true;
        });
    }

    /**
     * 用于校验定向类型参数
     * @param orientType
     * @return
     */
    public static boolean checkOrientTypeFail(Integer orientType) {
        return !peoplePkgPoolFilterMap.containsKey(orientType);
    }

    public PeoplePkgPool(Integer poolNum, Integer orientType) {
        this.poolNum = poolNum;
        this.orientType = orientType;
        this.peoplePkgPoolFilter = peoplePkgPoolFilterMap.get(orientType);
        this.tags = new HashSet<>();
    }

    /**
     * 获取定向类型
     * @return
     */
    public Integer getOrientType(){
        return this.orientType;
    }

    /**
     * 添加 标签
     */
    public void addTag(String tag) {
        this.tags.add(tag);
    }

    /**
     * 批量添加标签
     * @param advertTradeAccept
     */
    public void addTags(List<String> advertTradeAccept) {
        this.tags.addAll(advertTradeAccept);
    }

    /**
     * 判断是否通过过滤
     */
    @Override
    public Boolean filter(Object object) {
        if(object instanceof Set){
            return peoplePkgPoolFilter.doFilter(this.tags,(Set) object);
        }

        //如果传入的参数类型不对 直接过滤
        logger.error("人群定向，过滤流程中传入参数异常");
        return false;
    }
}
