package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.dao.account.AccountNewMainTypeFinanceDAO;
import cn.com.duiba.tuia.domain.dataobject.AccountFinanceDO;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.service.AccountFinanceService;
import cn.com.tuia.advert.enums.AccountMainTypeEnum;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Objects;
import java.util.Optional;

/**
 * @author zhanganbo
 * 2019-07-04 下午 17:12
 */
@Service
public class AccountFinanceServiceImpl implements AccountFinanceService {

    @Resource
    private AccountNewMainTypeFinanceDAO accountNewMainTypeFinanceDAO;
    @Override
    public Long fetchAccountMainTypBalance(AccountFinanceDO accountFinanceDO, Integer companyOwner) throws TuiaException {
        Long balance = 0L;
        if(Objects.isNull(accountFinanceDO) || Objects.isNull(companyOwner)){
            return balance;
        }
        //杭州推啊
        if(AccountMainTypeEnum.HZ_TUIA_TYPE.getCode().equals(companyOwner)){
            balance = Optional.ofNullable(accountFinanceDO).map(AccountFinanceDO::getBalance).orElse(0L);
        }//霍尔果斯推啊
        else if(AccountMainTypeEnum.HOERGOS_TUIA_TYPE.getCode().equals(companyOwner)){
            balance = Optional.ofNullable(accountFinanceDO).map(AccountFinanceDO::getHoergosBalance).orElse(0L);
        }//新主体(霍城兑捷)
        else{
            balance =  accountNewMainTypeFinanceDAO.getBalanceByAccountIdAndMainType(accountFinanceDO.getAccountId(),companyOwner);
        }
        return balance;
    }
}
