/**
 * Project Name:engine-service
 * File Name:AdvertAppPackageServiceImpl.java
 * Package Name:cn.com.duiba.tuia.service.impl
 * Date:2018年7月11日上午10:56:54
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import cn.com.duiba.tuia.dao.advert.AdvertAppPackageDAO;
import cn.com.duiba.tuia.dao.apppackage.AppPackageDAO;
import cn.com.duiba.tuia.domain.dataobject.AppPackageDO;
import cn.com.duiba.tuia.service.AdvertAppPackageService;
import cn.com.duiba.tuia.tool.StringTool;


/**
 * ClassName:AdvertAppPackageServiceImpl <br/>
 * Function: 配置id对应的定向媒体包. <br/>
 * Date:     2018年7月11日 上午10:56:54 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
@Service
public class AdvertAppPackageServiceImpl implements AdvertAppPackageService {

    @Resource
    private AdvertAppPackageDAO advertAppPackageDao;
    @Resource
    private AppPackageDAO appPackageDao;
    
    @Override
    public List<Long> getAppIdsByAdvertOrientationPackageId(Long id) {

        List<Long> appPackageIds = advertAppPackageDao.getAppPackageIdsByAdvertOrientationPackageId(id);
        if (appPackageIds.size()==0)
            return new ArrayList<>();
        List<AppPackageDO> appPackageDOList = appPackageDao.selectByIds(appPackageIds);

       return appPackageDOList.stream()
               .map(appPackageDO -> StringTool.getLongListByStr(appPackageDO.getAppIds()))
               .flatMap(List::stream)
               .distinct()
               .collect(Collectors.toList());
    }

    @Override
    public List<AppPackageDO> getAppPackageByAdvertOrientationId(Long id) {
        List<Long> appPackageIds = advertAppPackageDao.getAppPackageIdsByAdvertOrientationPackageId(id);

        if (appPackageIds.size() == 0) return new ArrayList<>();

        return appPackageDao.selectByIds(appPackageIds);
    }

}

