package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.service.AdvertCondtionFilterService;
import cn.com.duiba.tuia.service.condition.AdvertConditionFilter;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.*;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;

@Service
@Slf4j
public class AdvertCondtionFilterServiceImpl implements AdvertCondtionFilterService {

    private static ForkJoinPool forkJoinPoolSimpleFilter = new ForkJoinPool(4);

    @Autowired
    private List<AdvertConditionFilter> advertConditionFilterList;

    /**
     * 过滤接口
     *
     * @param advQueryParam
     * @param advOrientationItemList
     * @param filterTypeSets
     * @param req
     * @return
     */
    @Override
    public List<AdvOrientationItem> filter(AdvQueryParam advQueryParam, List<AdvOrientationItem> advOrientationItemList, Set<AdvertFilterType> filterTypeSets, ObtainAdvertReq req, FilterResult filterResult) {
        List<AdvOrientationItem> advOrientationItems;

        try {
            ForkJoinTask<List<AdvOrientationItem>> submit = forkJoinPoolSimpleFilter.submit(() ->
                            advOrientationItemList.parallelStream().filter(adv -> match(adv, advQueryParam, filterTypeSets, req, filterResult))
                            .collect(Collectors.toList()));
            advOrientationItems = submit.get();
        } catch (Exception e) {
            log.error("AdvertCondtionFilterServiceImpl.filter e:", e);
            advOrientationItems = new ArrayList<>();
        }

        return Optional.ofNullable(advOrientationItems).orElse(Collections.emptyList());
    }

    /**
     * 配置过滤
     * @param item
     * @param advQueryParam
     * @param filterTypeSets
     * @param req
     * @return
     */
    private boolean match(AdvOrientationItem item, AdvQueryParam advQueryParam, Set<AdvertFilterType> filterTypeSets, ObtainAdvertReq req, FilterResult filterResult) {
        AdvertConditionContext advertConditionContext = AdvertConditionContext.builder().advOrientationItem(item)
                .advQueryParam(advQueryParam).filterResult(filterResult).req(req).filterTypeSets(filterTypeSets).build();

        return advertConditionFilterList.stream().allMatch(advertConditionFilter -> advertConditionFilter.match(advertConditionContext));
    }

    @PostConstruct
    public void init() {
        //对规则集合根据order排序
        advertConditionFilterList = advertConditionFilterList.stream().sorted(Comparator.comparing(AdvertConditionFilter::getOrder)).collect(Collectors.toList());
    }
}
