package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.boot.utils.WarningUtils;
import cn.com.duiba.nezha.engine.api.dto.ReqAdvertMaterialDto;
import cn.com.duiba.nezha.engine.api.remoteservice.advert.RemoteAdvertMaterialRecommendService;
import cn.com.duiba.tuia.cache.*;
import cn.com.duiba.tuia.constants.AdvertReqLogExtKeyConstant;
import cn.com.duiba.tuia.constants.CommonConstants;
import cn.com.duiba.tuia.constants.ErrorCode;
import cn.com.duiba.tuia.constants.PackagePlanConstants;
import cn.com.duiba.tuia.core.api.dto.rsp.RspMaterialList;
import cn.com.duiba.tuia.dao.engine.AdvertOrderDAO;
import cn.com.duiba.tuia.dao.engine.NewAppTestToAdvertDAO;
import cn.com.duiba.tuia.dao.material.AdvertMaterialRealtionService;
import cn.com.duiba.tuia.domain.dataobject.*;
import cn.com.duiba.tuia.domain.enums.ABTestLayerCodeEnum;
import cn.com.duiba.tuia.domain.enums.ABTestSkipEnum;
import cn.com.duiba.tuia.domain.flow.MediaList;
import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.domain.model.abtest.ABResult;
import cn.com.duiba.tuia.domain.vo.*;
import cn.com.duiba.tuia.enums.*;
import cn.com.duiba.tuia.service.router.FlowRouterProxyService;
import cn.com.tuia.advert.enums.AdvertFilterTypeEnum;
import cn.com.duiba.tuia.enums.AdvertSubtypeEnum;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.log.InnerExtTwoLog;
import cn.com.duiba.tuia.log.MaterialDiffLog;
import cn.com.duiba.tuia.log.SpmLog;
import cn.com.duiba.tuia.log.StatLaunchJsonLog;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.com.duiba.tuia.service.*;
import cn.com.duiba.tuia.service.router.PromoteABTestService;
import cn.com.duiba.tuia.ssp.center.api.constant.NewMediaTestEnum;
import cn.com.duiba.tuia.task.EngineSyncRealTimeService;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.duiba.tuia.tool.StringTool;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import cn.com.duiba.wolf.redis.RedisLock;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.tuia.advert.constants.CommonConstant;
import cn.com.tuia.advert.constants.SystemConfigKeyConstant;
import cn.com.tuia.advert.enums.*;
import cn.com.tuia.advert.enums.ResourceTagsTypeEnum;
import cn.com.tuia.advert.exception.ReadableMessageException;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertReqLogExt;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import cn.com.tuia.advert.model.SpmlogReq;
import cn.com.tuia.advert.model.dsp.AdxAdvertPriceDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;

import static cn.com.duiba.tuia.domain.enums.DomainTestResultEnum.*;

/**
 * Created by hujinliang on 2017/8/14.
 */

@Service
public class AdvertExposeServiceImpl implements AdvertExposeService {
    private static final Logger logger = LoggerFactory.getLogger(AdvertExposeServiceImpl.class);

    @Autowired
    private RemoteAdvertMaterialRecommendService remoteAdvertMaterialRecommendService;
    @Autowired
    private AdvertMaterialRealtionService advertMaterialRealtionService;
    @Autowired
    private EngineSyncRealTimeService engineSyncRealTimeService;
    @Autowired
    private AdvertMapCacheManager advertMapCacheManager;
    @Autowired
    private ResourceTagsService resourceTagsService;
    @Autowired
    private IdWokerService idWokerService;
    @Autowired
    private AdvertMaterialRecommendService advertMaterialRecommendService;
    @Autowired
    private AdvertOrderDAO advertOrderDAO;
    @Autowired
    private AdvertOrderCacheService advertOrderCacheService;
    @Autowired
    private ServiceManager serviceManager;

    @Resource
    private AdvertRealDataService advertRealDataService;

    @Autowired
    private NewAppTestToAdvertDAO newAppTestToAdvertDAO;

    @Autowired
    private NewAppTestCacheService newAppTestCacheService;

    @Resource(name = "redisTemplate")
    private RedisAtomicClient redisAtomicClient;

    @Autowired
    private CatMonitorWarnThreshold catMonitorWarnThreshold;

    @Resource
    private ExecutorService executorService;
    @Resource
    private AdvertCompensateCacheService advertCompensateCacheService;

    @Autowired
    private AdvertPromoteTestCacheService advertPromoteTestCacheService;

    @Autowired
    private MaterialBindPromoteUrlService materialBindPromoteUrlService;
    @Autowired
    private PromoteABTestService promoteABTestService;

    @Autowired
    private AdvertABTestCacheService advertABTestCacheService;
    @Autowired
    private IQiyiService iQiyiService;
    @Autowired
    private FlowRouterProxyService flowRouterProxyService;
    @Autowired
    private DomainTestService domainTestService;
    @Autowired
    private ApolloPanGuService apolloPanGuService;

    @Resource
    private MakeTagCacheService makeTagCacheService;


    public static Long WITHOUT_WEIGHT_MATERIAL_TYPE = 0L;

    private void invalidStatusFresh(AdvertVO advertVO, Long advertId) throws TuiaException {
        //压测时不判断广告状态,因为测试数据源的数据状态与内存里的不一致
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            return;
        }
        //验证广告投放状态
        if (advertVO.getAdvertPlan().getValidStatus().intValue() != AdvertDO.VALID_STATUS) {
            RedisLock lock = redisAtomicClient.getLock(advertId.toString(), 3);
            if (lock != null) {
                advertMapCacheManager.pushAdvertCacheUpdate(advertId);
            }
            logger.info("ObtainAdvertRsp finishBiz is not valid status=" + advertVO.getAdvertPlan().getValidStatus()
                    + ",advertId=" + advertId);
            throw new TuiaException(ErrorCode.E0500015);
        }
    }

    @Override
    @SuppressWarnings("squid:S3776")
    public ObtainAdvertRsp finishBiz(ObtainAdvertReq req, ObtainAdvertRsp rsp, Long advertId, AdvertVO advertVO,
                                     FilterResult filterResult, AdvertPriceVO advertPriceVO, Long aFee, AdvertFilter advertFilter) throws TuiaException {
        //1.1再次验证广告有效状态
        invalidStatusFresh(advertVO, advertId);

        // 1.2新的广告重复发券切量打标测试
        filterResult.setRepeatLunchType(Optional.ofNullable(filterResult.getRepeatLunchType()).orElse(AdvertRepeatLunchTypeEnum.NEW_CUT.getCode()));

        // 1.3.新媒体试投记录，是否能够发券
        NewAppTest newAppTest = newMediaTestCheck(filterResult, req.getAppId(), advertId);

        //2.生成一个全局ID
        Long advertOrderId = idWokerService.getNextID();

        //4.获取推荐素材,获取广告所有素材集
        Set<Long> materialSet = advertMaterialRecommendService.getMaterialSetByAdvertId(advertId);

        // 执行素材测试/域测试逻辑
        doMaterialTest(req, rsp, advertId, advertPriceVO, filterResult, advertVO);

        //5.如果推荐素材为空，则走人工推荐获取素材,如果人工推荐获取素材为空，则取默认素材投放
        if (rsp.getMaterialId() == null) {
            Long materialId = null;
            try {
                materialId = CatUtils.executeInCatTransaction(
                        () -> getMaterialIdByAdvertId(advertId, req, advertPriceVO, materialSet),
                        "finishBizWzj1", "getMaterialIdByAdvertId");

            } catch (Throwable throwable) {
                logger.error("finishBiz.getMaterialIdByAdvertId 异常", throwable);
            }
            if (materialId == null) {
                Long defaultMaterialId = advertMaterialRecommendService.getDefaultByAdvertId(advertId);
                //校验默认素材是否可投，如果被屏蔽了，则随机取可投素材中的一个
                materialId = getDegradeValidMaterialId(filterResult, advertPriceVO, defaultMaterialId);
            }
            if (materialId == null) {
                logger.error("degrade materialId is null,advertId:{},appId:{},slotId:{}", advertId, req.getAppId(), req.getSlotId());
                CatUtil.log(CatGroupEnum.CAT_107008.getCode());
                throw new TuiaException(ErrorCode.E0500034);
            }

            // 素材ID为-1 表示降级使用优惠券素材
            rsp.setMaterialId(materialId);
        } else {
            // 推荐返回里有素材

            // 测试打标
            postHandlerTestMaterialId(rsp.getMaterialId(), advertPriceVO);
        }
        //6.如果最后的素材与广告本身素材不匹配，则投默认素材，打印日志
        if (!materialSet.isEmpty() && !materialSet.contains(rsp.getMaterialId())) {
            Long oldMaterialId = rsp.getMaterialId();
            Long defaultMaterialId = advertMaterialRecommendService.getDefaultByAdvertId(advertId);
            //校验默认素材是否可投，如果被屏蔽了，则随机取可投素材中的一个
            Long degradeMaterialId = getDegradeValidMaterialId(filterResult, advertPriceVO, defaultMaterialId);
            if (degradeMaterialId == null) {
                logger.error("degrade materialId is null,advertId:{},appId:{},slotId:{}", advertId, req.getAppId(), req.getSlotId());
                CatUtil.log(CatGroupEnum.CAT_107008.getCode());
                throw new TuiaException(ErrorCode.E0500034);
            }
            rsp.setMaterialId(degradeMaterialId);
            MaterialDiffLog.log("advertId =" + advertId + " and old materialId is :" + oldMaterialId + "; now materialId is :" + rsp.getMaterialId());
        }

        //7.广告id设置
        req.setAdvertId(advertId);

        //将set落地页url提到这里，为了测试落地页的筛选和日志入order表
        AdvertCoupon advertCoupon;
        try {
            advertCoupon = CatUtils.executeInCatTransaction(() -> serviceManager.getAdvertCouponByLocal(advertVO.getAdvertPlan().getId()), "finishBizWzj", "getAdvertCouponByLocal");
        } catch (Throwable t) {
            if (t instanceof TuiaException) {
                throw (TuiaException) t;
            } else {
                logger.warn("finishBiz.getAdvertCouponByLocal error", t);
                throw new TuiaException(ErrorCode.E9999999);
            }
        }

        //普通落地页过滤
        if (!filterNormalLoadingPage(advertId, filterResult, req) && iQiyiService.isReplace(req, advertPriceVO, CommonConstants.PROMOTE_URL)) {
            rsp.setPromoteUrl(advertCoupon.getPromoteURL());
            filterResult.setPromoteSource(PromoteSource.ADVERT_BASIC);
        }
        //根据广告ID去匹配是否用测试落地页
        buildPromoteTest(rsp, filterResult, advertPriceVO, advertVO, req);

        // 新媒体试投落地页链接
        if (filterResult.getNewAppTestType() != null && filterResult.getNewAppTestType().equals(NewAppAdvertTradeDO.APP_TYPE_NEW_TEST.toString())) {
            if (StringUtils.isNotBlank(advertVO.getAdvertPlan().getNewAppTestUrl())
                    && !filterNewMediaLoadingPage(advertId, filterResult, req)
                    && !checkUrlPromoteTag(advertId, 1, advertVO.getAdvertPlan().getNewAppTestUrl(), filterResult, advertVO)) {
                rsp.setPromoteUrl(advertVO.getAdvertPlan().getNewAppTestUrl());
                filterResult.setPromoteSource(PromoteSource.NEW_APP_TEST);
            }
        }

        // 配置维度 多连接测试 不为空 1、填写了配置多连接测试 2、关闭使用广告维度推广链接 3、该审核通过
        if (StringUtils.isNotEmpty(advertPriceVO.getPromoteTestUrl()) && !filterConfigLoadingPage(advertPriceVO, filterResult, advertId, req)
                && iQiyiService.isReplace(req, advertPriceVO, CommonConstants.ORIENT_PKG_URL)
                && !checkUrlPromoteTag(advertId, 2, advertPriceVO.getPromoteTestUrl(), filterResult, advertVO)) {
            rsp.setPromoteUrl(advertPriceVO.getPromoteTestUrl());
            filterResult.setPromoteSource(PromoteSource.ORIENTATION_MORE_URL);
        }

        if (null != advertPriceVO.getDomainTestPlan() && Objects.equals(advertPriceVO.getDomainTestPlan().getDomainTestResult(), 1)) {
            // 广告测试素材 绑定落地页 替换
            String bindPromoteUrl = advertPriceVO.getDomainTestPlan().getPromoteUrl();
            if (null != bindPromoteUrl) {
                rsp.setPromoteUrl(bindPromoteUrl);
                filterResult.setPromoteSource(PromoteSource.MATERIAL_BIND_URL);
            }
        }


        // 域测试调用实验平台的日志
        putDomainTestResultLog(req.getLogExtExpMap(), advertPriceVO.getDomainTestPlan());
        // 素材测试调用实验平台的日志
        putABResultLog(req.getLogExtExpMap(), advertPriceVO.getMaterialTestPlanDO());

        //如果都被关键词屏蔽则该广告不可投
        if (StringUtils.isBlank(rsp.getPromoteUrl())) {
            Set<AdvertFilterType> advertFilterTypeSet = advertFilter.getReason();
            Long advertOrientationPackageId = advertPriceVO.getAdvertOrientationPackageId() == null ? 0L :
                    advertPriceVO.getAdvertOrientationPackageId();
            advertFilterTypeSet.add(new AdvertFilterType(advertId, advertOrientationPackageId, AdvertFilterTypeEnum.SLOT_KEYWORD.getCode()));

            //CatUtil.log(CatGroupEnum.CAT_107008.getCode());
            throw new TuiaException(ErrorCode.E0500042);
        }


        //设置记录广告arpu值比对结果
        setEncArpuResult(filterResult, rsp);

        Long targetPackageId = getTargetPackageId(req.getAppId(), req.getSlotId(), advertPriceVO);
        filterResult.setTargetPackageId(targetPackageId);

        //设置弹层id
        setHdLayerId(rsp, advertId);

        //设置全链路日志 限流媒体释放实验
        Optional.ofNullable(advertPriceVO.getAppLimitReleaseMark()).ifPresent(mark -> {
            Map<String, String> logExtExpMap = req.getLogExtExpMap();
            if (null == logExtExpMap) {
                logExtExpMap = new HashMap<>();
                req.setLogExtExpMap(logExtExpMap);
            }
            logExtExpMap.put("appLimitReleaseMark", mark);
        });
        // 广告指定媒体提权的日志
        Optional.ofNullable(advertPriceVO.getSpecifyWeight()).ifPresent(weight -> {
            Map<String, String> logExtExpMap = req.getLogExtExpMap();
            if (null == logExtExpMap) {
                logExtExpMap = new HashMap<>();
                req.setLogExtExpMap(logExtExpMap);
            }
            logExtExpMap.put(AdvertReqLogExtKeyConstant.SPECIFY_WEIGHT, String.valueOf(weight));
        });

        //8.添加一条领取记录
        AdvertOrderDO advertOrderDO = buildAdvertOrder(advertVO, req, advertOrderId, rsp.getMaterialId(), rsp.getPromoteUrl());

        //9.获取投放时段
        AdvertPlanPeriodDO advertPeriod = advertPriceVO.gainPeriods();

        //10.计算发券次数
        int times = advertOrderCacheService.getAdvertLaunchedTimes(filterResult.getAllUserTimesMap(), advertId) + 1;

        String replacePromoteUrl = replaceUrl(rsp.getPromoteUrl(), rsp.getMaterialId(), req.getOrderId());
        String replaceDpUrl = replaceUrl(advertVO.getPromoteDeepLink(), rsp.getMaterialId(), req.getOrderId());

        //11.构建广告订单json信息
        OrderJsonVO vo = buildOrderJsonInfo(advertVO, advertPriceVO, req, rsp, advertPeriod, aFee, times, filterResult, replacePromoteUrl, replaceDpUrl);

        //原始长度提取出来,进行重新赋值，避免插入订单失败，导致日志丢失
        String orignJson = JSONObject.toJSONString(vo);
        //json信息设入
        advertOrderDO.setJson(orignJson);

        //13.插入订单
        int row = 0;
        try {
            DBTimeProfile.enter("finishBiz.insertOrder");
            row = CatUtils.executeInCatTransaction(() -> advertOrderDAO.insert(advertOrderDO), "finishBizWzj", "insert");
        } catch (Throwable throwable) {
            logger.error("finishBiz.insert 异常", throwable);
        } finally {
            DBTimeProfile.release();
        }

        //15.通知增加该时段的发券量
        if (advertPeriod != null && advertPeriod.getId() != null) {
            engineSyncRealTimeService.addPeriodReq(advertPeriod.getId(), advertPeriod.getPeriodValue(), advertPeriod.getPeriodType());
        }

        advertOrderDO.setJson(orignJson);

        //16.将请求到的广告订单放入缓存中
        serviceManager.setAdvertOrderDO(req.getConsumerId(), req.getOrderId(), advertOrderDO);

        //17.记录用户记录(移动至曝光环节记录用户消费记录)

        //18.获取广告计划
        AdvertPlan advertPlan = advertVO.getAdvertPlan();

        //19.组装记录发券日志
        ObtainAdvertReqLogExt reqLogExt = buildReqLogExt(advertPlan, advertVO, advertPriceVO, filterResult, req, rsp, aFee, times);

        //21.filter-result日志里打印materialId
        filterResult.setMaterialId(String.valueOf(rsp.getMaterialId()));

        //23.构造返回结果
        ObtainAdvertRsp result = buildObtainAdvertResult(rsp, advertVO, advertOrderId, advertOrderDO, filterResult);

        if (StringUtils.isNotBlank(replacePromoteUrl)) {
            rsp.setPromoteUrl(replacePromoteUrl);
        }
        if (StringUtils.isNotBlank(replaceDpUrl)) {
            rsp.setPromoteDeepLink(replaceDpUrl);
        }

        //广告订单正常记录，如果dsp竞价成功，则覆盖数据(避免有些数据dsp-engine 无法获取)
        //如果进行是dsp竞价的，不记录发券日志，否则记录
        if (req.getDspCompare() != null && req.getDspCompare() && rsp.getDspCompare() != null && rsp.getDspCompare()) {
            result.setReqLogExt(reqLogExt);
            return result;
        }

        //dp广告 需要补打发券 日志（在曝光的时候补报）
        if (ActivityTypeEnum.DP_ADVERT_ACTIVITY_TYPE.getCode().equals(req.getActivitySceneType())) {
            return result;
        }

        //20.添加发券次数统计
        advertRealDataService.incrLaunchAdvert(advertPlan.getAgentId(), advertPlan.getAccountId(), advertId, advertPlan.getAdvertPlanId(), advertVO.getEffectMainType(),
                newAppTest, req.getAppId(), filterResult.getSupportWeightStatus());

        //22.发券日志打印
        SpmLog.log(reqLogExt, SpmType.SPM_LOG_LAUNCH, advertOrderDO.getId());
        // 虚拟广告位模拟请求发券标识
        if ("1".equals(vo.getImoa())) {
            // 虚拟广告位模拟发券
            StatLaunchJsonLog.imitateLog(reqLogExt);

            //可以替换，则打印另外类型的发券日志，否则正常打印
        } else if (filterResult.getFinalLowArpu() != null && filterResult.getFinalLowArpu() == CommonConstant.YES) {
            StatLaunchJsonLog.lowArpulog(reqLogExt);
        } else {
            StatLaunchJsonLog.log(reqLogExt);
        }

        //23.构造返回结果
        return result;
    }


    private String replaceUrl(String url, Long materialId, String orderId) {

        if (StringUtils.isBlank(url)) {
            return url;
        }
//        Map<String,String> paramMap = UrlUtils2.extractUrlParamsFromUrl(url);

        String rtnUrl = doReplaceParam(url, "JD-ideaid", String.valueOf(materialId));
        rtnUrl = doReplaceParam(rtnUrl, "JD-clickkey", orderId);

        return Objects.equals(rtnUrl, url) ? null : rtnUrl;
    }

    private String doReplaceParam(String url, String key, String value) {
        return url.replaceAll(key, null == value ? "" : value);
    }

    @Override
    public ObtainAdvertRsp finishBizForDsp(ObtainAdvertReq req, ObtainAdvertRsp rsp
            , AdxAdvertMaterialDO adxAdvert, FilterResult filterResult, AdxAdvertPriceVO adxAdvertPrice) throws TuiaException {
        //1.再次验证广告有效状态
        //压测时不判断广告状态,因为测试数据源的数据状态与内存里的不一致
        if (!PerfTestContext.isCurrentInPerfTestMode() && adxAdvert == null) {
            return null;
        }
        //2.生成一个全局ID
        Long advertOrderId = idWokerService.getNextID();

        //3.广告id设置
        req.setAdvertId(adxAdvert.getAdvertId());

        rsp.setPromoteUrl(adxAdvert.getPromoteUrl());
        filterResult.setPromoteSource(PromoteSource.ADVERT_BASIC);
        //4.设置记录广告arpu值比对结果
        rsp.setEncArpuResult(filterResult.getFinalLowArpu() == null ? CommonConstant.NO : filterResult.getFinalLowArpu());

        //5.添加一条领取记录
        AdvertOrderDO advertOrderDO = buildAdxAdvertOrder(adxAdvert, req, advertOrderId);

        //6.计算发券次数  不做计算
        String key = String.valueOf(req.getDspId()) + ";" + String.valueOf(adxAdvert.getAdvertId());
        int times = advertOrderCacheService.getAdxAdvertLaunched(filterResult.getAllUserAdxMap(), key) + 1;


        //7.构建广告订单json信息
        OrderJsonVO vo = buildOrderJsonInfo(adxAdvert, req, rsp, adxAdvertPrice, times, filterResult);
        //原始长度提取出来,进行重新赋值，避免插入订单失败，导致日志丢失
        String originJson = JSONObject.toJSONString(vo);
        //json信息设入
        advertOrderDO.setJson(originJson);

        //8.插入订单
        try {
            DBTimeProfile.enter("adxAdvert finishBiz.insertOrder");
            AdvertOrderExtDO orderExtDO = new AdvertOrderExtDO();
            orderExtDO.setId(advertOrderId);
            orderExtDO.setDuibaOrderId(req.getOrderId());
            orderExtDO.setShowUrl(adxAdvertPrice.getShowUrl());
            orderExtDO.setClickUrl(adxAdvertPrice.getPromoteUrl());
            CatUtils.executeInCatTransaction(() -> advertOrderDAO.insertForDsp(advertOrderDO, orderExtDO), "adxAdvertFinishBizWzj", "insert");
        } catch (Throwable throwable) {
            logger.error("adxAdvertFinish.insert 异常", throwable);
        } finally {
            DBTimeProfile.release();
        }

        //.通知增加该时段的发券量
        //9.将请求到的广告订单放入缓存中
        serviceManager.setAdvertOrderDO(req.getConsumerId(), req.getOrderId(), advertOrderDO);

        //.添加发券次数统计
        //10.构造返回结果
        return buildObtainAdxAdvertResult(rsp, adxAdvert, adxAdvertPrice, advertOrderDO, filterResult);
    }

    /**
     * 请求接口中构造福袋返回结果 <一句话功能描述>.
     *
     * @param rsp            the rsp
     * @param adxAdvert      the advert vo
     * @param adxAdvertPrice the coupon code
     * @param advertOrderDO  广告订单信息
     * @param filterResult
     * @return the obtain advert rsp
     */
    @SuppressWarnings("squid:S3776")
    private ObtainAdvertRsp buildObtainAdxAdvertResult(ObtainAdvertRsp rsp, AdxAdvertMaterialDO adxAdvert
            , AdxAdvertPriceVO adxAdvertPrice, AdvertOrderDO advertOrderDO, FilterResult filterResult) {
        try {
            rsp.setDspId(adxAdvert.getDspId());
            // 优惠券，基本信息
            rsp.setCouponRemark(adxAdvert.getCouponName());
            rsp.setCouponType(AdvertDO.GENERAL_PREFERENCE_CODE);
            rsp.setPromoteUrl(adxAdvert.getPromoteUrl());
            rsp.setThumbnailPngUrl(adxAdvert.getImgUrl());
            rsp.setIsWeixin(0);
            rsp.setSpecialHide(0);

            //日志拓展字段解析，包含屏蔽策略类型，广告定向配置包id，计费方式，当前出价等。
            Map<String, Object> logExtMap = rsp.getLogExtMap();
            if (rsp.getLogExtMap() == null) {
                logExtMap = Maps.newHashMap();
            }
            OrderJsonVO vo = JSONObject.parseObject(advertOrderDO.getJson(), OrderJsonVO.class);

            rsp.setAdSpecId(0L);
            rsp.setStrategyType(vo.getSt());
            rsp.setSlotId(advertOrderDO.getSlotId());
            rsp.setMaterialId(advertOrderDO.getMaterialId());
            // 只在互动广告打印（为空时不打印）
            if (StringUtils.isNotBlank(vo.getSaw())) {
                logExtMap.put(AdvertReqLogExtKeyConstant.SUB_ACTIVITY_WAY, vo.getSaw());
            }
            // 自定义活动（活动工具）打印
            if (StringUtils.isNotBlank(vo.getAp())) {
                logExtMap.put(AdvertReqLogExtKeyConstant.ACTIVITY_PAGE, vo.getAp());
            }
            if (vo.getCt() != null) {
                logExtMap.put(AdvertOrderJsonKeyEnum.KEY_CHARGE_TYPE.getCode(), ChargeTypeEnum.getDescByCode(vo.getCt()));
            }
            logExtMap.put(AdvertOrderJsonKeyEnum.KEY_APP_ID.getCode(), advertOrderDO.getAppId());
            logExtMap.put(AdvertOrderJsonKeyEnum.KEY_FEE.getCode(), vo.getFe());
            logExtMap.put(AdvertOrderJsonKeyEnum.KEY_TIMES.getCode(), String.valueOf(vo.getTs()));
            logExtMap.put(AdvertOrderJsonKeyEnum.KEY_EFFECTIVE_MAIN_TYPE.getCode(), 1);
            logExtMap.put(AdvertReqLogExtKeyConstant.GMT_CREATE_TIME, StringTool.getStringTime(advertOrderDO.getGmtCreate()));
            logExtMap.put(AdvertReqLogExtKeyConstant.DUIBA_SLOT_id, rsp.getDuibaSlotId());
            logExtMap.put(AdvertReqLogExtKeyConstant.CID, advertOrderDO.getConsumerId());
            logExtMap.put(AdvertReqLogExtKeyConstant.LAUNCH_LOG_PROMOTE_URL, rsp.getPromoteUrl());
            logExtMap.put(AdvertReqLogExtKeyConstant.FLOW_TAG, rsp.getFlowTag());
            logExtMap.put(AdvertReqLogExtKeyConstant.MAIN_TYPE, AdvertReqLogExtKeyConstant.INTERACT);
            logExtMap.put(AdvertReqLogExtKeyConstant.PRE_ARUP, filterResult.getArpuValue());
            // 原生的Ua很长那种，这里再打印一个ip
            logExtMap.put(AdvertReqLogExtKeyConstant.USER_IP, vo.getIp());
            logExtMap.put(AdvertReqLogExtKeyConstant.USER_AGENT, vo.getUat());
            // 获取 deviceId
            String deviceIdM5 = getDeviceId(vo);

            logExtMap.put(AdvertReqLogExtKeyConstant.DEVICE_ID_M5, deviceIdM5);
            // 广告主落地页，和广告主的回传链接
            //logExtMap.put(AdvertReqLogExtKeyConstant.LAUNCH_LOG_PROMOTE_BACK_URL, advertVO.getPromoteBackUserUrl());

            rsp.setLogExtMap(logExtMap);

            // 设置落地页标签
            rsp.setPromoteUrlTags(adxAdvert.getPromoteTags());

            //构建素材信息
            rsp.setBannerPngUrl(adxAdvert.getImgUrl());
            rsp.setViceTitle("");
            rsp.setTitle(adxAdvert.getCouponName());
            rsp.setButtonText(adxAdvert.getButtonText() != null ? adxAdvert.getButtonText() : AdvertCoupon.DEFAULT_BTN_TEXT);
            filterResult.setAccountId(adxAdvertPrice.getDspId());
            rsp.setOrderId(advertOrderDO.getDuibaOrderId());

            // 广告订单信息
            rsp.setAdvertOrderId(advertOrderDO.getId());
            rsp.setAdvertId(adxAdvertPrice.getAdvertId());
            rsp.setAdvertiserName(adxAdvert.getDspName());
            // 优惠券卷码
            rsp.setEndValid(null);
            // 结果状态
            rsp.setResult(true);
            //免费&付费券日志打印
            CatUtil.log(CatGroupEnum.CAT_104005.getCode());
            rsp.setIsFreeAdvert(CommonConstants.IS_PAY_ADVERT);
        } catch (Exception e) {
            logger.error("buildObtainAdvertResult happen error", e);
            rsp.setResult(false);
        }
        return rsp;
    }

    /**
     * 构建广告订单json字段
     *
     * @param adxAdvert
     * @param req
     * @param rsp
     * @param adxAdvertPrice
     * @return
     * @throws TuiaException
     * @author zp
     * @since JDK 1.6
     */
    private OrderJsonVO buildOrderJsonInfo(AdxAdvertMaterialDO adxAdvert, ObtainAdvertReq req, ObtainAdvertRsp rsp,
                                           AdxAdvertPriceVO adxAdvertPrice, Integer times, FilterResult result) {

        Map<String, String> extMap = Optional.ofNullable(req.getLogExtMap()).orElse(new HashMap<>());

        OrderJsonVO vo = new OrderJsonVO();
        vo.setDspId(adxAdvert.getDspId());
        vo.setAdxFe(adxAdvertPrice.getDecryptPrice());
        vo.setEnFe(adxAdvertPrice.getPrice());
        //供活动使用 fee 进行一些判断，dsp adx 广告精确到0.001  活动只用于比较的话 可以向上取正而不影响结果
        vo.setFe(Double.valueOf(Math.ceil(adxAdvertPrice.getFee())).longValue());

        //曝光监控链接 ，点击监控链接  放入订单扩展hbase
//        vo.setsUrl(adxAdvertPrice.getShowUrl());
//        vo.setcUrl(adxAdvertPrice.getClickUrl());

        vo.setDeli(req.getDeliveryType());
        //vo.setPid(advertOrientationPackageId);
        vo.setTp(rsp.isPrivilege());
        //vo.setAfe(advertPriceVO.getChargeType() == ChargeTypeEnum.TYPE_CPA.getCode() ? aFee : null);
        //vo.setTca(advertPriceVO.getTargetCpa());
        //vo.setAppFee(advertPriceVO.getConvertTypeCost());
        vo.setTs(times);
        //vo.setTap(result.getTargetPackageId());
        //vo.setTrt(advertPriceVO.getTargetRecommendType());
        //vo.setAss(advertPriceVO.getSupportStatus());
        //vo.setSws(result.getSupportWeightStatus());
        //vo.setSw(result.getSupportWeight());
        //vo.setSt(rsp.getStrategyType());
        //vo.setFe(aFee);
        //vo.setCt(advertPriceVO.getChargeType());
        vo.setuT(String.valueOf(req.getActivityUseType()));
        vo.setAcT(String.valueOf(req.getDuibaActivityType()));
        vo.setAcI(String.valueOf(req.getActivityId()));
        //vo.setPeid(setPeriodId(advertPeriod));
        //vo.setExps(rsp.getExps());
        //vo.setPkt(advertPriceVO.getPackageType());
        vo.setAst(Optional.ofNullable(req.getActivitySceneType()).map(type -> type.toString()).orElse(PackagePlanConstants.INTERACTION_TYPE));
        vo.setProv(result.getProvince());
        vo.setNtw(result.getNetworkTypes());
        vo.setOpri(result.getOperators());
        // 原先只有Ua处理，这里同时插入用户外网Ip
        vo.setUa(result.getUa());
        vo.setIp(result.getIp());

        //全链路日志需要打印字段，给到各个链路
        vo.setLgEp(req.getLogExtExpMap());


        //vo.setTsp(advertPriceVO.getTrusteeship());
        //vo.setTal(advertPriceVO.getTargetAppLimit());
        //vo.setSwt(advertPriceVO.getStrongTarget());
        //vo.setPtt(advertPriceVO.getPutTargetType());
        //vo.setFacc(advertPriceVO.getFocusAppConvertCost());
        //vo.setTspFee(advertPriceVO.getConvertCost());
        vo.setDevi(req.getDeviceId());
        vo.setfTag(rsp.getFlowTag());
        vo.setRc(result.getRiskCheat());
        //vo.setEncAr(rsp.getEncArpuResult());
        // 临时记录流量类型，是否经过了广告主发券限制的过滤
        String limitAccountType = Optional.ofNullable(req.getLogExtMap()).map(logmap -> {
            return Optional.ofNullable(logmap.get("limitAccountType")).orElse(AccountLimitTypeEnum.UNKNOW.getCode());
        }).orElse(AccountLimitTypeEnum.UNKNOW.getCode());

        // 资源标签重复发券逻辑打标
        vo.setRlt(result.getRepeatLunchType());
        vo.setAt(result.getNewAppTestType());
        vo.setAtn(result.getNewTradeName());
        vo.setNbf(result.getNewAppTestBeforeFee());
        //vo.setSty(Optional.ofNullable(advertPriceVO.getSubtype()).orElse(AdvertSubtypeEnum.CVR.getSubtype()));
        //vo.setDsty(advertPriceVO.getDepthSubtype());
        vo.setCity(result.getCity());
        //vo.setRt(advertPriceVO.getResourceTag());
        //vo.setBs(advertPriceVO.getBudgetSmooth());

        //vo.setHui(StringTool.getStringBySet(advertPriceVO.getHitUserInterest(), "_"));
        //vo.setNh(advertPriceVO.getNezhaHitUserInterestTags());

        // 行业标签重复过滤逻辑打标
        vo.setTat(result.getTradeAppLunchType());

        if (extMap != null && extMap.size() > 0) {
            vo.setDsm(req.getLogExtMap().get("dsm"));
            vo.setDsm2(req.getLogExtMap().get(AdvertReqLogExtKeyConstant.DSM2));
            vo.setDcm(req.getLogExtMap().get("dcm"));
            vo.setDpm(req.getLogExtMap().get("dpm"));
            vo.setDtPage(req.getLogExtMap().get("directpage"));
            vo.setSaw(req.getLogExtMap().get(AdvertReqLogExtKeyConstant.SUB_ACTIVITY_WAY));
            vo.setAp(req.getLogExtMap().get(AdvertReqLogExtKeyConstant.ACTIVITY_PAGE));

            vo.setIdeId(extMap.get(AdvertReqLogExtKeyConstant.IDEAL_ID));
            vo.setPte(extMap.get(AdvertReqLogExtKeyConstant.PRICE_TYPE));
            vo.setPp(extMap.get(AdvertReqLogExtKeyConstant.PAR_PRICE));
            vo.setBt(extMap.get(AdvertReqLogExtKeyConstant.BILL_TYPE));
            vo.setFt(extMap.get(AdvertReqLogExtKeyConstant.FEE_TYPE));
            vo.setArd(extMap.get(AdvertReqLogExtKeyConstant.ADX_RID));
            vo.setPt(extMap.get(AdvertReqLogExtKeyConstant.PUT_TYPE));
            vo.setIt(extMap.get(AdvertReqLogExtKeyConstant.IS_TEST_ACTIVITY_TYPE));
            vo.setPli(extMap.get(AdvertReqLogExtKeyConstant.PLAN_ID));
            vo.setNtwn(extMap.get(AdvertReqLogExtKeyConstant.CONNECTION_TYPE));
            vo.setIcg(extMap.get(AdvertReqLogExtKeyConstant.IS_COMPARE_GROUP));
            vo.setRsd(extMap.get(AdvertReqLogExtKeyConstant.RESOURCE_ID));
            vo.setApl(extMap.get(AdvertReqLogExtKeyConstant.ADX_PRICE_LEVEL));

            vo.setSat(extMap.get(AdvertReqLogExtKeyConstant.SHORT_ACTIVITY_ID));

            vo.setLvl(extMap.get(AdvertReqLogExtKeyConstant.LEVEL));
            vo.setStgy(extMap.get(AdvertReqLogExtKeyConstant.STRATEGY));

            // 设备信息
            vo.setIme(extMap.get(AdvertReqLogExtKeyConstant.IMEI));
            vo.setIme5(extMap.get(AdvertReqLogExtKeyConstant.IMEI_MD5));
            vo.setIdfa(extMap.get(AdvertReqLogExtKeyConstant.IDFA));
            vo.setIdfa5(extMap.get(AdvertReqLogExtKeyConstant.IDFA_MD5));
            vo.setOaid(extMap.get(AdvertReqLogExtKeyConstant.OAID));
            vo.setOaid5(extMap.get(AdvertReqLogExtKeyConstant.OAID_MD5));


            // 活动素材id
            vo.setSckId(extMap.get(AdvertReqLogExtKeyConstant.SCK_ID));
            // 分流标识
            vo.setSft(extMap.get(AdvertReqLogExtKeyConstant.SCK_FORM_TYPE));
            // 虚拟广告位模拟发券标识
            vo.setImoa(extMap.get(AdvertReqLogExtKeyConstant.IMITATE_REQ));

            // 资源位
            vo.setSop(extMap.get(AdvertReqLogExtKeyConstant.SOURCE_PAGE));
            // 媒体测试打标字段
            vo.setPgt(extMap.get(AdvertReqLogExtKeyConstant.PANGE_TEST));
            vo.setBtg(extMap.get(AdvertReqLogExtKeyConstant.BELONG_TO_GROUP));
            vo.setAskt(extMap.get(AdvertReqLogExtKeyConstant.ACTIVITY_SKIN_TYPE));
            vo.setAset(extMap.get(AdvertReqLogExtKeyConstant.ACTIVITY_SECOND_TYPE));
            vo.setAsa(extMap.get(AdvertReqLogExtKeyConstant.ACTIVITY_SUB_ACTIVITY));
            vo.setMu(extMap.get(AdvertReqLogExtKeyConstant.MEDIA_UNIT));
            //1105新增
            vo.setApi(extMap.get(AdvertReqLogExtKeyConstant.ACTIVITY_PUT_INDEX));
            vo.setpType(extMap.get(AdvertReqLogExtKeyConstant.PLUGIN_TYPE));
            vo.setXf(extMap.get(AdvertReqLogExtKeyConstant.XYSCJ_FREQUENCY));
            vo.setXpt(extMap.get(AdvertReqLogExtKeyConstant.XYSCJ_PASS_TYPE));
            vo.setPrt(extMap.get(AdvertReqLogExtKeyConstant.PG_RESOURCE_TEST));
            vo.setPgId(extMap.get(AdvertReqLogExtKeyConstant.PLUGIN_ID));
            vo.setAcrp(extMap.get(AdvertReqLogExtKeyConstant.ACT_CONF_RSP_PLUGIN_ID));
            vo.setSdkV(extMap.get(AdvertReqLogExtKeyConstant.SDK_VERSION));
            vo.setAdxs(extMap.get(AdvertReqLogExtKeyConstant.ADX_SCENE));
            vo.setAlgT(extMap.get(AdvertReqLogExtKeyConstant.ALG_TYPE));//算法策略类型
            vo.setAgid(extMap.get(AdvertReqLogExtKeyConstant.ADX_GROUPID));//推广组id
            vo.setPlh(extMap.get(AdvertReqLogExtKeyConstant.PRE_LAUNCH));//预发券状态
            vo.setItg(extMap.get(AdvertReqLogExtKeyConstant.IS_TEST_GROUP));

            //20191231新增
            vo.setAlgV(extMap.get(AdvertReqLogExtKeyConstant.ALGO_VERSION));
            vo.setAlgTp(extMap.get(AdvertReqLogExtKeyConstant.ALGO_TEST_PLANID));
            vo.setSeI(extMap.get(AdvertReqLogExtKeyConstant.SEQ_INDEX));

            //20200220新增
            vo.setRlr(extMap.get(AdvertReqLogExtKeyConstant.REAL_TIME_RTA));

            //20200302新增
            vo.setApid(extMap.get(AdvertReqLogExtKeyConstant.APP_PAID));

            //20200401新增
            vo.setBip(extMap.get(AdvertReqLogExtKeyConstant.ADX_BID_PRICE));

        }
        vo.setOsv(req.getOsVersion());
        vo.setPi(result.getPutIndex());
        vo.setCi(result.getCityId());
        vo.setPs(result.getPriceSection());
        vo.setBn(result.getBrandName());
        String appFlowType = Optional.ofNullable(req.getLogExtMap())
                .map(logExtMap -> logExtMap.get(AdvertOrderJsonKeyEnum.KEY_APP_FLOW_TYPE.getCode()))
                .orElse(AppFlowPlatform.OTHER.getCode().toString());
        vo.setAft(AppFlowTypeEnum.getByName(appFlowType).getCode());
        vo.setMl(result.getModel());
        String collRid = Optional.ofNullable(req.getLogExtMap())
                .map(logExtMap -> logExtMap.get(AdvertReqLogExtKeyConstant.COLL_RID))
                .orElse("");
        vo.setCrd(collRid);
        vo.setAid(req.getAppId());
        vo.setFtg(rsp.getFlowTag());
        // 防止过长，外面进行json的判断，截断
        vo.setUat(req.getUserAgent());
        //vo.setNaf(aFee);
        /**
         *  设置落地页出处{@link PromoteSource}
         */
        vo.setPros(PromoteSource.DSP_ADVERT.getType());
        // 分媒体出价类型
        vo.setDaft(DisAppFeeTypeEnum.DEFULT_TYPE.getCode());
        //vo.setAcs(advertPriceVO.getAppCostStableSwitch());
        vo.setArup(result.getArpuValue());

        // 当前计划是否要赔付
        //vo.setCmpd(DateUtils.getDayStr(compensateDate));
        vo.setWd(rsp.getWindId());
        vo.setTage(req.getIsTage());
        vo.setAmt(req.getActivityMaterialType());
        //将用户记录相关的数据放入订单json中 券曝光的时候使用
        //vo.setRrt(StringUtils.isBlank(advertPriceVO.getResourceTag()) ? AdvertRepeatLunchConfigDO.BLANK_SOURCE_ID : advertPriceVO.getResourceTag());
        //随机服务标记
        vo.setRst(result.getRandomServiceTag());
        //流量类型
        vo.setLat(limitAccountType);
        // 是否是风控导量广告位出券标记
        vo.setSdt(CommonConstants.NOT_SLOT_DIRECTION);
        vo.setTpm(false);
        vo.setTbp(adxAdvert.getImgUrl());
        return vo;
    }

    /**
     * 构造广告订单 <一句话功能描述>.
     *
     * @param adxAdvert     the advert vo
     * @param req
     * @param advertOrderId
     * @return the advert order do
     */
    private AdvertOrderDO buildAdxAdvertOrder(AdxAdvertMaterialDO adxAdvert, ObtainAdvertReq req,
                                              Long advertOrderId) {
        AdvertOrderDO advertOrderDO = new AdvertOrderDO();
        //构建广告优惠券的信息
        advertOrderDO.setAdvertId(adxAdvert.getAdvertId());
        advertOrderDO.setCouponType(AdvertDO.GENERAL_PREFERENCE_CODE);
        //advertOrderDO.setOverDue(new DateTime(advertVO.getAdvertPlan().getEndDate()).toString("yyyy-MM-dd"));
        //构建广告基本信息
        advertOrderDO.setId(advertOrderId);
        advertOrderDO.setAppId(req.getAppId());
        advertOrderDO.setConsumerId(req.getConsumerId());
        advertOrderDO.setDuibaOrderId(req.getOrderId());
        advertOrderDO.setDuibaActivityId(req.getActivityId());
        advertOrderDO.setUa(req.getUa());
        advertOrderDO.setSlotId(req.getSlotId());
        advertOrderDO.setMaterialId(adxAdvert.getId());
        //把落地页url放到订单里，给日志需要的时候查询订单即可
        advertOrderDO.setPromoteUrl(adxAdvert.getPromoteUrl());
        advertOrderDO.setGmtCreate(new Date());
        advertOrderDO.setGmtModified(new Date());

        return advertOrderDO;
    }

    /**
     * 设置素材对于的弹层id
     *
     * @param rsp
     */
    private void setHdLayerId(ObtainAdvertRsp rsp, Long advertId) {

        Long windId = advertMaterialRecommendService.getWindId(advertId, rsp.getMaterialId());
        rsp.setWindId(windId);
    }

    private Long getTargetPackageId(Long appId, Long slotId, AdvertPriceVO advertPriceVO) {
        //优先判断广告位，如果广告位已经判断出结果了就不需要在判断媒体了
        if (MapUtils.isNotEmpty(advertPriceVO.getSlotTargetPackage())) {
            Long slotTargetPackageId = advertPriceVO.getSlotTargetPackage().get(slotId);
            if (slotTargetPackageId != null) {
                return slotTargetPackageId;
            }
        }
        if (MapUtils.isNotEmpty(advertPriceVO.getAppTargetPackage())) {
            Long appTargetPackageId = advertPriceVO.getAppTargetPackage().get(appId);
            if (appTargetPackageId != null) {
                return appTargetPackageId;
            }
        }

        return null;
    }

    private Long getDegradeValidMaterialId(FilterResult filterResult, AdvertPriceVO advertPriceVO, Long defaultMaterialId) {
        if (CollectionUtils.isEmpty(advertPriceVO.getMaterialsBind())) {
            return null;
        }

        Long materialId;
        //boolean isDefaultMaterialValid = checkDefaultMaterial(defaultMaterialId, filterResult.getShieldMaterialTags());

        // 默认素材与屏蔽标签过滤后有效且包含于互选等有效列表中则返回默认素材
        if (advertPriceVO.getMaterialsBind().contains(defaultMaterialId)) {
            materialId = defaultMaterialId;
        } else {

            // 随机返回一个有效素材
            materialId = getRandomValidMaterialId(advertPriceVO.getMaterialsBind());
        }
        return materialId;
    }

    private Long getRandomValidMaterialId(Set<Long> bindMaterials) {
        if (CollectionUtils.isEmpty(bindMaterials)) {
            return null;
        }
        return bindMaterials.stream().findAny().orElse(null);
    }

    private boolean checkDefaultMaterial(Long defaultMaterialId, Set<String> shieldMaterialTags) {
        if (CollectionUtils.isEmpty(shieldMaterialTags)) {
            return true;
        }
        Set<String> materialTags = resourceTagsService.getResoureTagsDOById(defaultMaterialId, ResourceTagsTypeEnum.MATERIAL);
        if (CollectionUtils.isNotEmpty(materialTags) && CollectionUtils.isNotEmpty(CollectionUtils.intersection(materialTags, shieldMaterialTags))) {
            return false;
        }
        return true;
    }

    private void setEncArpuResult(FilterResult filterResult, ObtainAdvertRsp rsp) {
        rsp.setEncArpuResult(filterResult.getFinalLowArpu() == null ? CommonConstant.NO : filterResult.getFinalLowArpu());
    }

    private NewAppTest newMediaTestCheck(FilterResult filterResult, Long appId, Long advertId) throws TuiaException {
        filterResult.setNewAppTestType(Optional.ofNullable(filterResult.getNewAppTestType()).orElse(NewAppAdvertTradeDO.APP_TYPE_OLD.toString()));
        NewAppTest newAppTest = getNewAppTest(filterResult.getNewAppTestType(), appId, advertId, filterResult.getNewTradeName());
        Boolean checkNewAppTestToAdvert;
        try {
            DBTimeProfile.enter("finishBiz->newMediaTestCheck");
            checkNewAppTestToAdvert = checkNewAppTestToAdvert(newAppTest);
        } finally {
            DBTimeProfile.release();
        }
        if (!checkNewAppTestToAdvert) {
            throw new TuiaException(ErrorCode.E0500038);
        }
        return newAppTest;
    }

    /**
     * checkNewAppTestToAdvert:(是否发券，正常发券或者新媒体试投发券). <br/>
     *
     * @param newAppTest
     * @return
     * @author chencheng
     * @since JDK 1.8
     */
    private Boolean checkNewAppTestToAdvert(NewAppTest newAppTest) {

        // 非新媒体试投
        if (newAppTest.getNewAppType() != NewAppAdvertTradeDO.APP_TYPE_NEW_TEST.intValue()) {
            return true;
        }
        // 先调用缓存查询，如果缓存已存在，将不更新。这个会过滤掉很大一部分数据。
        Boolean check = newAppTestCacheService.checkAdvertTestToApp(newAppTest.getAppId(), newAppTest.getAdvertId());
        if (check) {
            return true;
        }
        // 调用数据库查询，如果已存在。只更新缓存
        NewAppTestToAdvertDO newAppTestToAdvertDO = new NewAppTestToAdvertDO();
        newAppTestToAdvertDO.setAdvertId(newAppTest.getAdvertId());
        newAppTestToAdvertDO.setAppId(newAppTest.getAppId());
        newAppTestToAdvertDO.setCurDate(DateUtils.getDayStr(new Date()) + " 00:00:00");
        NewAppTestToAdvertDO oldAppTestToAdvertDO = newAppTestToAdvertDAO.selectCurDateByAppAdvert(newAppTestToAdvertDO);
        if (oldAppTestToAdvertDO != null) {
            // 更新缓存，可以发券
            newAppTestCacheService.sendUpdateNewAppTestAdvertCacheMsg(newAppTest.getAppId(), newAppTest.getAdvertId());
            return true;
        }
        // 关系不存在，插入数据。如果异常，则不能发券。
        int insertRow = this.changeNormalApp(newAppTestToAdvertDO);
        if (insertRow < 1) {
            return false;
        }

        // 删除因为并发而超过媒体限制个数的 广告->媒体关系
        deleteMoreLimitSize(newAppTest.getAdvertId());

        // 更新缓存，可以发券
        newAppTestCacheService.sendUpdateNewAppTestAdvertCacheMsg(newAppTest.getAppId(), newAppTest.getAdvertId());

        return true;
    }

    /**
     * 如果广告已投媒体个数已经等于了限制媒体个数，则替换掉普通
     *
     * @param newAppTestToAdvertDO
     * @return
     */
    private int changeNormalApp(NewAppTestToAdvertDO newAppTestToAdvertDO) {

        try {

            Map<Long, Integer> newAppPriorityMap = newAppTestCacheService.getNewAppPriorityByPub();

            Set<Long> appIds = newAppTestCacheService.getAdvertTestToApps(newAppTestToAdvertDO.getAdvertId());

            // 获取限制媒体个数
            Integer appLimitSize = serviceManager.getIntValue(SystemConfigKeyConstant.NEW_APP_TEST_ADVERT_LIMIT_APP_SIZE);

            if (appIds.size() == appLimitSize) {
                // 走到这里，说明该媒体是优先媒体，且要投放到广告有普通媒体。

                // 将普通媒体给删除。
                for (Long oldAppId : appIds) {
                    Integer priority = newAppPriorityMap.get(oldAppId);
                    if (NewMediaTestEnum.PriorityEnum.NORMAL.getValue().equals(priority)) {
                        NewAppTestToAdvertDO delDO = new NewAppTestToAdvertDO();
                        delDO.setAppId(oldAppId);
                        delDO.setAdvertId(newAppTestToAdvertDO.getAdvertId());
                        delDO.setCurDate(newAppTestToAdvertDO.getCurDate());
                        newAppTestToAdvertDAO.deleteByQuery(delDO);
                        break;
                    }
                }
            }

            return newAppTestToAdvertDAO.insertCurDateNewAppTest(newAppTestToAdvertDO);
        } catch (Exception e) {
            logger.info("优先媒体替换普通媒体失败", e);
            return 0;
        }


    }


    /**
     * @param advertId
     * @return false-没有超过,true超过了
     */
    public void deleteMoreLimitSize(Long advertId) {

        executorService.submit(() -> {
            try {
                List<NewAppTestToAdvertDO> lists = newAppTestToAdvertDAO.selectCurDateNewAppTest(Collections.singletonList(advertId));

                if (CollectionUtils.isEmpty(lists)) {
                    return;
                }

                // 获取可投媒体个数
                Integer appLimitSize = serviceManager.getIntValue(SystemConfigKeyConstant.NEW_APP_TEST_ADVERT_LIMIT_APP_SIZE);

                // 如果数据库里可投媒体可数大于限定媒体个数,则删掉最新的媒体个数.(并发会导致插入大于可投媒体个数)
                if (lists.size() > appLimitSize) {
                    // 获取最开始的限制媒体个数.
                    List<NewAppTestToAdvertDO> filtLists = lists.stream().sorted(Comparator.comparing(NewAppTestToAdvertDO::getGmtCreate)).limit(appLimitSize).collect(Collectors.toList());

                    lists.removeAll(filtLists);

                    if (CollectionUtils.isEmpty(lists)) {
                        return;
                    }

                    List<Long> delIds = lists.stream().map(NewAppTestToAdvertDO::getId).collect(Collectors.toList());

                    newAppTestToAdvertDAO.deleteByIds(delIds);
                }
            } catch (Exception e) {
                logger.info("删除并发媒体失败,广告id:{}已经超过限制媒体个数", advertId);
                return;
            }
        });
    }

    /**
     * getNewAppTest:(新媒体试投参数组装). <br/>
     *
     * @param type
     * @param appId
     * @param advertId
     * @param tradeName
     * @return
     * @author chencheng
     * @since JDK 1.8
     */
    private NewAppTest getNewAppTest(String type, Long appId, Long advertId, String tradeName) {
        NewAppTest newAppTest = new NewAppTest();
        if (NewAppAdvertTradeDO.APP_TYPE_NEW_TEST.toString().equals(type)) {
            newAppTest.setAdvertId(advertId);
            newAppTest.setAppId(appId);
            newAppTest.setNewAppType(NewAppAdvertTradeDO.APP_TYPE_NEW_TEST);
            newAppTest.setTradeName(tradeName);
        }
        return newAppTest;
    }


    /**
     * 构造广告订单 <一句话功能描述>.
     *
     * @param advertVO the advert vo
     * @param req
     * @return the advert order do
     */
    private AdvertOrderDO buildAdvertOrder(AdvertVO advertVO, ObtainAdvertReq req,
                                           Long advertOrderId, Long materialId, String promoteUrl) {
        AdvertOrderDO advertOrderDO = new AdvertOrderDO();
        AdvertPlan advertPlan = advertVO.getAdvertPlan();
        CouponBase couponBase = advertVO.getCouponBase();
        //构建广告优惠券的信息
        advertOrderDO.setAdvertId(advertPlan.getId());
        Integer codeType = couponBase.getCouponType().intValue() == 0 ? AdvertDO.GENERAL_PREFERENCE_CODE : couponBase.getCouponType();
        advertOrderDO.setCouponType(codeType);
        advertOrderDO.setOverDue(new DateTime(advertVO.getAdvertPlan().getEndDate()).toString("yyyy-MM-dd"));

        //构建广告基本信息
        advertOrderDO.setId(advertOrderId);
        advertOrderDO.setAppId(req.getAppId());
        advertOrderDO.setConsumerId(req.getConsumerId());
        advertOrderDO.setDuibaOrderId(req.getOrderId());
        advertOrderDO.setDuibaActivityId(req.getActivityId());
        advertOrderDO.setUa(req.getUa());
        advertOrderDO.setSlotId(req.getSlotId());
        advertOrderDO.setMaterialId(materialId);
        //把落地页url放到订单里，给日志需要的时候查询订单即可
        advertOrderDO.setPromoteUrl(promoteUrl);
        advertOrderDO.setGmtCreate(new Date());
        advertOrderDO.setGmtModified(new Date());

        return advertOrderDO;
    }

    /**
     * 构建广告订单json字段
     *
     * @param advertPriceVO
     * @param req
     * @param rsp
     * @param advertPeriod
     * @param aFee
     * @return
     * @throws TuiaException
     * @author zp
     * @since JDK 1.6
     */
    private OrderJsonVO buildOrderJsonInfo(AdvertVO advertVO, AdvertPriceVO advertPriceVO, ObtainAdvertReq req, ObtainAdvertRsp rsp, // NOSONAR
                                           AdvertPlanPeriodDO advertPeriod, Long aFee, Integer times, FilterResult result, String replacePromoteUrl, String replaceDpUrl) {
        Long advertOrientationPackageId = advertPriceVO.getAdvertOrientationPackageId() == null ? 0L :
                advertPriceVO.getAdvertOrientationPackageId();

        Map<String, String> extMap = Optional.ofNullable(req.getLogExtMap()).orElse(new HashMap<>());

        OrderJsonVO vo = new OrderJsonVO();
        vo.setDeli(req.getDeliveryType());
        vo.setPid(advertOrientationPackageId);
        vo.setTp(rsp.isPrivilege());
        vo.setAfe(advertPriceVO.getChargeType() == ChargeTypeEnum.TYPE_CPA.getCode() ? aFee : null);
        vo.setTca(advertPriceVO.getTargetCpa());
        vo.setAppFee(advertPriceVO.getConvertTypeCost());
        vo.setTs(times);
        vo.setTap(result.getTargetPackageId());
        vo.setTrt(advertPriceVO.getTargetRecommendType());
        vo.setAss(advertPriceVO.getSupportStatus());
        vo.setSws(result.getSupportWeightStatus());
        vo.setSw(result.getSupportWeight());
        vo.setSt(rsp.getStrategyType());
        vo.setFe(advertPriceVO.getFee());
        vo.setCt(advertPriceVO.getChargeType());
        vo.setuT(String.valueOf(req.getActivityUseType()));
        vo.setAcT(String.valueOf(req.getDuibaActivityType()));
        vo.setAcI(String.valueOf(req.getActivityId()));
        vo.setPeid(setPeriodId(advertPeriod));
        vo.setExps(rsp.getExps());
        vo.setPkt(advertPriceVO.getPackageType());
        vo.setAst(Optional.ofNullable(req.getActivitySceneType()).map(type -> type.toString()).orElse(PackagePlanConstants.INTERACTION_TYPE));
        vo.setProv(result.getProvince());
        vo.setNtw(result.getNetworkTypes());
        // 原先只有Ua处理，这里同时插入用户外网Ip
        vo.setUa(result.getUa());
        vo.setIp(result.getIp());

        vo.setPctr(result.getPreCtr());
        vo.setPcvr(result.getPreCvr());

        //全链路日志需要打印字段，给到各个链路
        vo.setLgEp(req.getLogExtExpMap());

        vo.setOpri(result.getOperators());
        vo.setTsp(advertPriceVO.getTrusteeship());
        vo.setTal(advertPriceVO.getTargetAppLimit());
        vo.setSwt(advertPriceVO.getStrongTarget());
        vo.setPtt(advertPriceVO.getPutTargetType());
        vo.setFacc(advertPriceVO.getFocusAppConvertCost());
        vo.setTspFee(advertPriceVO.getConvertCost());
        vo.setDevi(req.getDeviceId());
        vo.setfTag(rsp.getFlowTag());
        vo.setRc(result.getRiskCheat());
        vo.setEncAr(rsp.getEncArpuResult());
        // 临时记录流量类型，是否经过了广告主发券限制的过滤
        String limitAccountType = Optional.ofNullable(req.getLogExtMap()).map(logmap -> {
            return Optional.ofNullable(logmap.get("limitAccountType")).orElse(AccountLimitTypeEnum.UNKNOW.getCode());
        }).orElse(AccountLimitTypeEnum.UNKNOW.getCode());
        if (null != req.getLogExtMap()) {
            vo.setDsm(req.getLogExtMap().get("dsm"));
            vo.setDsm2(req.getLogExtMap().get(AdvertReqLogExtKeyConstant.DSM2));
            vo.setDcm(req.getLogExtMap().get("dcm"));
            vo.setDpm(req.getLogExtMap().get("dpm"));
            vo.setDtPage(req.getLogExtMap().get("directpage"));
            vo.setSaw(req.getLogExtMap().get(AdvertReqLogExtKeyConstant.SUB_ACTIVITY_WAY));
            vo.setAp(req.getLogExtMap().get(AdvertReqLogExtKeyConstant.ACTIVITY_PAGE));
        }
        // 资源标签重复发券逻辑打标
        vo.setRlt(result.getRepeatLunchType());
        vo.setAt(result.getNewAppTestType());
        vo.setAtn(result.getNewTradeName());
        vo.setNbf(result.getNewAppTestBeforeFee());
        vo.setSty(Optional.ofNullable(advertPriceVO.getSubtype()).orElse(AdvertSubtypeEnum.CVR.getSubtype()));
        vo.setDsty(null != advertPriceVO.getDepthSubtype() ? advertPriceVO.getDepthSubtype() : advertVO.getDepthSubtype());
        vo.setCity(result.getCity());
        vo.setRt(advertPriceVO.getResourceTag());
        vo.setBs(advertPriceVO.getBudgetSmooth());

        vo.setHui(StringTool.getStringBySet(advertPriceVO.getHitUserInterest(), "_"));
        vo.setNh(advertPriceVO.getNezhaHitUserInterestTags());

        // 行业标签重复过滤逻辑打标
        vo.setTat(result.getTradeAppLunchType());

        if (extMap != null && extMap.size() > 0) {
            vo.setIdeId(extMap.get(AdvertReqLogExtKeyConstant.IDEAL_ID));
            vo.setPte(extMap.get(AdvertReqLogExtKeyConstant.PRICE_TYPE));
            vo.setPp(extMap.get(AdvertReqLogExtKeyConstant.PAR_PRICE));
            vo.setBt(extMap.get(AdvertReqLogExtKeyConstant.BILL_TYPE));
            vo.setFt(extMap.get(AdvertReqLogExtKeyConstant.FEE_TYPE));
            vo.setArd(extMap.get(AdvertReqLogExtKeyConstant.ADX_RID));
            vo.setPt(extMap.get(AdvertReqLogExtKeyConstant.PUT_TYPE));
            vo.setIt(extMap.get(AdvertReqLogExtKeyConstant.IS_TEST_ACTIVITY_TYPE));
            vo.setPli(extMap.get(AdvertReqLogExtKeyConstant.PLAN_ID));
            vo.setNtwn(extMap.get(AdvertReqLogExtKeyConstant.CONNECTION_TYPE));
            vo.setIcg(extMap.get(AdvertReqLogExtKeyConstant.IS_COMPARE_GROUP));
            vo.setRsd(extMap.get(AdvertReqLogExtKeyConstant.RESOURCE_ID));
            vo.setApl(extMap.get(AdvertReqLogExtKeyConstant.ADX_PRICE_LEVEL));

            vo.setSat(extMap.get(AdvertReqLogExtKeyConstant.SHORT_ACTIVITY_ID));

            vo.setLvl(extMap.get(AdvertReqLogExtKeyConstant.LEVEL));
            vo.setStgy(extMap.get(AdvertReqLogExtKeyConstant.STRATEGY));

            // 设备信息
            vo.setIme(extMap.get(AdvertReqLogExtKeyConstant.IMEI));
            vo.setIme5(extMap.get(AdvertReqLogExtKeyConstant.IMEI_MD5));
            vo.setIdfa(extMap.get(AdvertReqLogExtKeyConstant.IDFA));
            vo.setIdfa5(extMap.get(AdvertReqLogExtKeyConstant.IDFA_MD5));
            vo.setOaid(extMap.get(AdvertReqLogExtKeyConstant.OAID));
            vo.setOaid5(extMap.get(AdvertReqLogExtKeyConstant.OAID_MD5));


            // 活动素材id
            vo.setSckId(extMap.get(AdvertReqLogExtKeyConstant.SCK_ID));
            // 分流标识
            vo.setSft(extMap.get(AdvertReqLogExtKeyConstant.SCK_FORM_TYPE));
            // 虚拟广告位模拟发券标识
            vo.setImoa(extMap.get(AdvertReqLogExtKeyConstant.IMITATE_REQ));

            // 资源位
            vo.setSop(extMap.get(AdvertReqLogExtKeyConstant.SOURCE_PAGE));
            // 媒体测试打标字段
            vo.setPgt(extMap.get(AdvertReqLogExtKeyConstant.PANGE_TEST));
            vo.setBtg(extMap.get(AdvertReqLogExtKeyConstant.BELONG_TO_GROUP));
            vo.setAskt(extMap.get(AdvertReqLogExtKeyConstant.ACTIVITY_SKIN_TYPE));
            vo.setAset(extMap.get(AdvertReqLogExtKeyConstant.ACTIVITY_SECOND_TYPE));
            vo.setAsa(extMap.get(AdvertReqLogExtKeyConstant.ACTIVITY_SUB_ACTIVITY));
            vo.setMu(extMap.get(AdvertReqLogExtKeyConstant.MEDIA_UNIT));
            //1105新增
            vo.setApi(extMap.get(AdvertReqLogExtKeyConstant.ACTIVITY_PUT_INDEX));
            vo.setpType(extMap.get(AdvertReqLogExtKeyConstant.PLUGIN_TYPE));
            vo.setXf(extMap.get(AdvertReqLogExtKeyConstant.XYSCJ_FREQUENCY));
            vo.setXpt(extMap.get(AdvertReqLogExtKeyConstant.XYSCJ_PASS_TYPE));
            vo.setPrt(extMap.get(AdvertReqLogExtKeyConstant.PG_RESOURCE_TEST));
            vo.setPgId(extMap.get(AdvertReqLogExtKeyConstant.PLUGIN_ID));
            vo.setAcrp(extMap.get(AdvertReqLogExtKeyConstant.ACT_CONF_RSP_PLUGIN_ID));
            vo.setSdkV(extMap.get(AdvertReqLogExtKeyConstant.SDK_VERSION));
            vo.setAdxs(extMap.get(AdvertReqLogExtKeyConstant.ADX_SCENE));
            vo.setAlgT(extMap.get(AdvertReqLogExtKeyConstant.ALG_TYPE));//算法策略类型
            vo.setAgid(extMap.get(AdvertReqLogExtKeyConstant.ADX_GROUPID));//推广组id
            vo.setPlh(extMap.get(AdvertReqLogExtKeyConstant.PRE_LAUNCH));//预发券状态
            vo.setItg(extMap.get(AdvertReqLogExtKeyConstant.IS_TEST_GROUP));

            //20191231新增
            vo.setAlgV(extMap.get(AdvertReqLogExtKeyConstant.ALGO_VERSION));
            vo.setAlgTp(extMap.get(AdvertReqLogExtKeyConstant.ALGO_TEST_PLANID));
            vo.setSeI(extMap.get(AdvertReqLogExtKeyConstant.SEQ_INDEX));

            //20200220新增
            vo.setRlr(extMap.get(AdvertReqLogExtKeyConstant.REAL_TIME_RTA));

            //20200302新增
            vo.setApid(extMap.get(AdvertReqLogExtKeyConstant.APP_PAID));

            //20200401新增
            vo.setBip(extMap.get(AdvertReqLogExtKeyConstant.ADX_BID_PRICE));

        }
        vo.setOsv(req.getOsVersion());

        //日志补全
        vo.setPi(result.getPutIndex());
        vo.setCi(result.getCityId());
        vo.setPs(result.getPriceSection());
        vo.setBn(result.getBrandName());
        // 设备类型
        if (StringUtils.isNotBlank(req.getLogExtMap().get(AdvertReqLogExtKeyConstant.EQUIPMENT_MODEL))) {
            vo.setEquipmentModel(req.getLogExtMap().get(AdvertReqLogExtKeyConstant.EQUIPMENT_MODEL));
        }
        String appFlowType = Optional.ofNullable(req.getLogExtMap())
                .map(logExtMap -> logExtMap.get(AdvertOrderJsonKeyEnum.KEY_APP_FLOW_TYPE.getCode()))
                .orElse(AppFlowPlatform.OTHER.getCode().toString());
        vo.setAft(AppFlowTypeEnum.getByName(appFlowType).getCode());
        vo.setMl(result.getModel());
        String collRid = Optional.ofNullable(req.getLogExtMap())
                .map(logExtMap -> logExtMap.get(AdvertReqLogExtKeyConstant.COLL_RID))
                .orElse("");
        vo.setCrd(collRid);
        vo.setAid(req.getAppId());
        vo.setFtg(rsp.getFlowTag());
        // 防止过长，外面进行json的判断，截断
        vo.setUat(req.getUserAgent());
        vo.setNaf(aFee);
        /**
         *  设置落地页出处{@link PromoteSource}
         */
        vo.setPros(result.getPromoteSource().getType());
        // 分媒体出价类型
        vo.setDaft(Optional.ofNullable(advertPriceVO.getDisAppFeeType()).orElse(DisAppFeeTypeEnum.DEFULT_TYPE.getCode()));
        vo.setAcs(advertPriceVO.getAppCostStableSwitch());
        vo.setArup(result.getArpuValue());

        /**素材ctr提高测试**/
        handlerMaterialTestOrder(vo, advertPriceVO);

        // 当前计划是否要赔付
        Date compensateDate = null;
        Optional<CompensateAdvertDO> compensateOptional = advertCompensateCacheService.getCompensateAdvert(advertPriceVO.getAdvertId());
        if (compensateOptional.isPresent()) {
            compensateDate = compensateOptional.get().getCompensateDate();
        }
        vo.setCmpd(DateUtils.getDayStr(compensateDate));
        vo.setWd(rsp.getWindId());
        vo.setTage(req.getIsTage());
        vo.setAmt(req.getActivityMaterialType());
        //将用户记录相关的数据放入订单json中 券曝光的时候使用
        vo.setRrt(StringUtils.isBlank(advertPriceVO.getResourceTag()) ? AdvertRepeatLunchConfigDO.BLANK_SOURCE_ID : advertPriceVO.getResourceTag());
        //随机服务标记
        vo.setRst(result.getRandomServiceTag());
        //流量类型
        vo.setLat(limitAccountType);
        // 是否是风控导量广告位出券标记
        String slotDirection;
        if (result.getType() == FilterResultTypes.RISK_SLOT_DIRCTION_TYPE) {
            slotDirection = CommonConstants.HIT_SLOT_DIRECTION;
        } else {
            slotDirection = CommonConstants.NOT_SLOT_DIRECTION;
        }
        vo.setSdt(slotDirection);
        Boolean testPlanMaterial = Optional.ofNullable(advertPriceVO.getMaterialTestPlanDO()).map(MaterialTestPlanDO::getTestPlanMaterial).orElse(false);
        vo.setTpm(testPlanMaterial);

        //20200512新增  广告扶持信息
        Optional.ofNullable(advertPriceVO.getSupportAdvertInfoDto()).ifPresent(dto -> {
            vo.setIsp((Objects.nonNull(dto.getSupportAdvert()) && dto.getSupportAdvert()) ? "1" : "0");
            vo.setSpp(StringUtils.isBlank(advertPriceVO.getSupportPlanPromote()) ? "2" : advertPriceVO.getSupportPlanPromote());
            vo.setSpw(StringUtils.isBlank(advertPriceVO.getSupportPlanWeight()) ? "0" : advertPriceVO.getSupportPlanWeight());
            vo.setSptt(Objects.isNull(dto.getPlanCvrType()) ? "" : String.valueOf(dto.getPlanCvrType()));
            vo.setSptc(Objects.isNull(dto.getPlanTargetCost()) ? "" : String.valueOf(dto.getPlanTargetCost()));
        });

        //20201120新增 配置的活动类型信息
        if (CollectionUtils.isNotEmpty(advertPriceVO.getActivityType())) {
            vo.setOact(JSON.toJSONString(advertPriceVO.getActivityType()));
        }

        //20201224新增 广告的dp链接
        if (StringUtils.isNotBlank(advertVO.getPromoteDeepLink())) {
            vo.setDpl(advertVO.getPromoteDeepLink());
        }

        //20210512 新增
        vo.setRpl(replacePromoteUrl);
        vo.setRdp(replaceDpUrl);

        return vo;
    }

    private void handlerMaterialTestOrder(OrderJsonVO vo, AdvertPriceVO advertPriceVO) {
        MaterialTestPlanDO materialTestPlanDO = advertPriceVO.getMaterialTestPlanDO();
        if (Objects.isNull(materialTestPlanDO)) {
            return;
        }

        if (Optional.ofNullable(materialTestPlanDO.getTestPlanMaterial()).orElseGet(() -> false)) {
            vo.setMta(1);// 参与素材测试
            vo.setMtr(getMaterialTestResult(materialTestPlanDO));
            if (Objects.nonNull(materialTestPlanDO.getPlanId())) {
                vo.setPaId(materialTestPlanDO.getPlanId());
            }
            if (Objects.nonNull(materialTestPlanDO.getMaterialType())) {
                vo.setMtp(materialTestPlanDO.getMaterialType());
            }
            if (Objects.nonNull(materialTestPlanDO.getMaterialId())) {
                vo.setMtId(materialTestPlanDO.getMaterialId());
            }
        } else {
            vo.setMta(0);// 没有参与素材测试
        }
    }

    @SuppressWarnings("squid:S3776")
    private ObtainAdvertReqLogExt buildReqLogExt(AdvertPlan advertPlan, AdvertVO advertVO, AdvertPriceVO advertPriceVO, FilterResult filterResult,
                                                 ObtainAdvertReq req, ObtainAdvertRsp rsp, Long aFee, Integer times) {
        AdvertTagDO advertTagDO = advertVO.getAdvertTagDO();
        //获取广告折扣率
        double discountrate = advertMapCacheManager.getAdvertBidRate(advertPlan.getId(), advertPriceVO.getChargeType());
        //重复曝光的次数：今天已经种过的次数
        Integer repeatCount = filterResult.getLimitAdvertTodayMap() == null ? 0 : filterResult.getLimitAdvertTodayMap().get(advertPlan.getId());

        Map<String, String> extMap = Optional.ofNullable(req.getLogExtMap()).orElse(new HashMap<>());

        ObtainAdvertReqLogExt reqLogExt = new ObtainAdvertReqLogExt();
        BeanCopierManager.getBeanCopier(ObtainAdvertReq.class, ObtainAdvertReqLogExt.class).copy(req, reqLogExt, null);

        reqLogExt.setMaterialId(rsp.getMaterialId());
        reqLogExt.setCityId(filterResult.getCityId());
        reqLogExt.setPriceSection(filterResult.getPriceSection());
        reqLogExt.setPutIndex(filterResult.getPutIndex());
        reqLogExt.setFee(advertPriceVO.getFee());
        reqLogExt.setaFee(aFee);
        reqLogExt.setChargeType(ChargeTypeEnum.getByCode(advertPriceVO.getChargeType()).getDesc());
        reqLogExt.setModel(filterResult.getModel());
        reqLogExt.setActivityOrderId(req.getOrderId());
        reqLogExt.setHour(StringTool.getStringHourBy(req.getTimestamp()));
        reqLogExt.setOrientationId(advertPriceVO.getAdvertOrientationPackageId());
        //account表中的1和2扣除的都是杭州推啊账户余额，属于杭州主体，只有3扣除的才是霍尔果斯余额

        reqLogExt.setEffectiveMainType(advertVO.getEffectMainType());
        reqLogExt.setDiscountRate(discountrate);
        reqLogExt.setDmp(filterResult.getDmpTagMap());
        if (null == reqLogExt.getLogExtMap()) {
            reqLogExt.setLogExtMap(Maps.newHashMap());
        }

        //增加落地页日志打印
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.LAUNCH_LOG_PROMOTE_URL, rsp.getPromoteUrl());
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.TARGET_PACKAGE_ID, filterResult.getTargetPackageId() == null ? null : filterResult.getTargetPackageId() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.TARGET_RECOMMEND_TYPE, Optional.ofNullable(advertPriceVO.getTargetRecommendType()).orElse(0) + "");
        reqLogExt.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_TIMES.getCode(), String.valueOf(times));
        reqLogExt.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_PRIVILEGE.getCode(), String.valueOf(rsp.isPrivilege()));
        reqLogExt.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_ACCOUNT_ID.getCode(), String.valueOf(advertPlan.getAccountId()));
        reqLogExt.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_AGENT_ID.getCode(), String.valueOf(advertPlan.getAgentId()));
        reqLogExt.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_TYPE.getCode(), String.valueOf(filterResult.getType()));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.IS_OPEN_REPEAT, String.valueOf(advertPlan.getRepeatExposure()));
        reqLogExt.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_EXPS.getCode(), String.valueOf(rsp.getExps()));
        reqLogExt.getLogExtMap().put(AdvertOrderJsonKeyEnum.FLOW_TAG.getCode(), String.valueOf(rsp.getFlowTag()));
        reqLogExt.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_PACKAGE_TYPE.getCode(), String.valueOf(advertPriceVO.getPackageType()));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.REPEAT_COUNT, String.valueOf(repeatCount == null ? 0 : repeatCount));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PHONE_BRAND, filterResult.getPhoneBrand());
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.TRUSTEESHIP, advertPriceVO.getTrusteeship() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PUT_TARGET_TYPE, advertPriceVO.getPutTargetType() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.FOCUS_APP_CONVERT_COST, advertPriceVO.getFocusAppConvertCost() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.TARGET_APP_LIMIT, advertPriceVO.getTargetAppLimit() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.NE_ZHA_LAUNCH_STATUS, Optional.ofNullable(filterResult.getNezhaLaunchStatus()).orElse(CommonConstant.NO) + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.STRONG_TARGET, advertPriceVO.getStrongTarget() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.TRUSTEESHIP_CONVERT_COST, advertPriceVO.getConvertCost() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUPPORT_STATUS, advertPriceVO.getSupportStatus() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUPPORT_WEIGHT_STATUS, filterResult.getSupportWeightStatus() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUPPORT_WEIGHT, filterResult.getSupportWeight() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.ADVERT_WEIGHT, advertPriceVO.getWeight() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.ENC_ARPU_RESULT, rsp.getEncArpuResult() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.BRAND_NAME, filterResult.getBrandName());
        if (rsp.getLogExtMap() == null) {
            rsp.setLogExtMap(Maps.newHashMap());
        }
        rsp.getLogExtMap().put(AdvertReqLogExtKeyConstant.BRAND_NAME, filterResult.getBrandName());
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PHONE_MODEL_NUM, filterResult.getPhoneModelNum());
        // 设备类型
        if (StringUtils.isNotBlank(req.getLogExtMap().get(AdvertReqLogExtKeyConstant.EQUIPMENT_MODEL))) {
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.EQUIPMENT_MODEL, req.getLogExtMap().get(AdvertReqLogExtKeyConstant.EQUIPMENT_MODEL));
        }
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PRE_CTR, filterResult.getPreCtr() == null ? null : filterResult.getPreCtr() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PRE_CVR, filterResult.getPreCvr() == null ? null : filterResult.getPreCvr() + "");
        String appFlowType = Optional.ofNullable(req.getLogExtMap())
                .map(logExtMap -> logExtMap.get(AdvertOrderJsonKeyEnum.KEY_APP_FLOW_TYPE.getCode()))
                .orElse(AppFlowPlatform.OTHER.getCode().toString());
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.APP_FLOW_TYPE, AppFlowTypeEnum.getByName(appFlowType).getCode());
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.SCENCE_NUM, String.valueOf(filterResult.getLogExtMap().getOrDefault("scenceId", "")));
        reqLogExt.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_ACTIVITY_TYPE.getCode(), Optional.ofNullable(req.getActivitySceneType()).map(type -> type.toString()).orElse(PackagePlanConstants.INTERACTION_TYPE));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.CONNECT_TYPE, filterResult.getNetworkTypes());
        Optional.ofNullable(advertTagDO).ifPresent(dto -> {
            Optional.ofNullable(dto.getAdvertTradeId()).ifPresent(advertTradeId -> reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.TRADE_ID_NUM, String.valueOf(advertTradeId)));
            Optional.ofNullable(dto.getNewAdvertTradeId()).ifPresent(newAdvertTradeId -> reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.NEW_TRADE_ID, String.valueOf(newAdvertTradeId)));
            Optional.ofNullable(dto.getMatchTagNums()).ifPresent(matchTagNums -> reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.MATCH_TAG_NUM, matchTagNums));
        });
        // 新广告重复逻辑发券切量类型
        Integer repeatLunchType = filterResult.getRepeatLunchType();
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.REPEAT_LUNCH_TYPE, repeatLunchType.toString());
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.RISK_CHEAT, filterResult.getRiskCheat());
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.APP_TYPE, filterResult.getNewAppTestType());
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.LINK_PARAGRAPH, Optional.ofNullable(filterResult.getLinkParagraph()).orElse(CommonConstants.OTHER));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.NEW_APP_TEST_FEE, String.valueOf(filterResult.getNewAppTestBeforeFee()));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUBTYPE, String.valueOf(Optional.ofNullable(advertPriceVO.getSubtype()).orElse(AdvertSubtypeEnum.CVR.getSubtype())));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.DEPTH_SUBTYPE, String.valueOf(null != advertPriceVO.getDepthSubtype() ? advertPriceVO.getDepthSubtype() : advertVO.getDepthSubtype()));
        // 注:根据 depthSubtype判断打印哪个 depthTargetPrice
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.DEPTH_TARGET_PRICE, String.valueOf(null != advertPriceVO.getDepthSubtype() ? advertPriceVO.getDepthTargetPrice() : advertVO.getDepthTargetPrice()));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.APP_FEE, String.valueOf(advertPriceVO.getConvertTypeCost()));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.MAIN_TYPE, String.valueOf(AdvertReqLogExtKeyConstant.INTERACT));
        // 互动广告打印:测试广告位子投放方式
        if (StringUtils.isNotBlank(req.getLogExtMap().get(AdvertReqLogExtKeyConstant.SUB_ACTIVITY_WAY))) {
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUB_ACTIVITY_WAY, req.getLogExtMap().get(AdvertReqLogExtKeyConstant.SUB_ACTIVITY_WAY));
        }
        // 自定义活动（活动工具）打印
        if (StringUtils.isNotBlank(req.getLogExtMap().get(AdvertReqLogExtKeyConstant.ACTIVITY_PAGE))) {
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.ACTIVITY_PAGE, req.getLogExtMap().get(AdvertReqLogExtKeyConstant.ACTIVITY_PAGE));
        }
        //资源标签
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.RESOURCE_TAG, advertPriceVO.getResourceTag());

        // 人群标签
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.NEZHA_HITUSERINTEREST_TAGS, advertPriceVO.getNezhaHitUserInterestTags());

        // 预算平滑消耗模式
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.BUDGET_SMOOTH, Optional.ofNullable(advertPriceVO.getBudgetSmooth())
                .map(bs -> bs.toString()).orElse(AdvertOrientationPackageDO.BUDGET_SMOOTH_DEFULT.toString()));
        // nezha返回的平滑因子
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.SMOOTH_FACTOR, Optional.ofNullable(filterResult.getSmoothFactor())
                .map(sf -> sf.toString()).orElse(null));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.ADJUST_PRICE_FACTOR, filterResult.getAdjustPriceFactor() + "");
        //行业标签重复过滤逻辑。老逻辑还需要打轮投标识，否则不用打
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.TRADE_APP_LUNCH_TYPE, Optional.ofNullable(filterResult.getTradeAppLunchType())
                .map(sf -> sf.toString()).orElse(null));
        // 落地页出处 {@link PromoteSource}
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.ADVERT_PROMOTE_SOURCE, String.valueOf(filterResult.getPromoteSource().getType()));
        reqLogExt.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_STRATEGY_TYPE.getCode(), rsp.getStrategyType());

        if (extMap.size() > 0) {
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.IDEAL_ID, extMap.get(AdvertReqLogExtKeyConstant.IDEAL_ID));
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PRICE_TYPE, extMap.get(AdvertReqLogExtKeyConstant.PRICE_TYPE));
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PAR_PRICE, extMap.get(AdvertReqLogExtKeyConstant.PAR_PRICE));
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.BILL_TYPE, extMap.get(AdvertReqLogExtKeyConstant.BILL_TYPE));
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.FEE_TYPE, extMap.get(AdvertReqLogExtKeyConstant.FEE_TYPE));
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.ADX_RID, extMap.get(AdvertReqLogExtKeyConstant.ADX_RID));
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PUT_TYPE, extMap.get(AdvertReqLogExtKeyConstant.PUT_TYPE));
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.DSM2, extMap.get(AdvertReqLogExtKeyConstant.DSM2));

            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.SOURCE_PAGE, extMap.get(AdvertReqLogExtKeyConstant.SOURCE_PAGE));

            //dmp人群包
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.DMP_PACKAGE, extMap.get(AdvertReqLogExtKeyConstant.DMP_PACKAGE));
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.DMP_PACKAGE_IS_TOO_LONG, extMap.get(AdvertReqLogExtKeyConstant.DMP_PACKAGE_IS_TOO_LONG));

            //白名单投放模式相关
            Optional.ofNullable(extMap.get(AdvertReqLogExtKeyConstant.WHITELIST_MODE)).ifPresent(hereValue->reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.WHITELIST_MODE,hereValue));
            Optional.ofNullable(extMap.get(AdvertReqLogExtKeyConstant.ORDER_CUSTOM_FLAG)).ifPresent(hereValue->reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.ORDER_CUSTOM_FLAG,hereValue));

        }
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.OS_VERSION, req.getOsVersion());
        // 分媒体出价类型
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.DIS_APP_FEE_TYPE, Optional.ofNullable(advertPriceVO.getDisAppFeeType()).map(type -> type.toString()).orElse(DisAppFeeTypeEnum.DEFULT_TYPE.getCode().toString()));
        // 素材ctr提高测试
        handlerMaterialTestLogExtMap(reqLogExt.getLogExtMap(), reqLogExt.getLogExtExpMap(), advertPriceVO);
        // 素材绑定落地页测试
        handlerDomainTestLogExtMap(reqLogExt.getLogExtMap(), advertPriceVO);

        //
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.REPEAT_EXPOSURE_SHOT, String.valueOf(filterResult.getRepeatExposureLuckyConsumer()));
        Set<Long> repeatExposureADList = filterResult.getRepeatExposureADList();
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.REPEAT_EXPOSURE_RELEASE, String.valueOf(null != repeatExposureADList && repeatExposureADList.contains(advertPlan.getId())));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.WIND_ID, rsp.getWindId() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.IS_TAGE, req.getIsTage() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.ACTIVITY_MATERIAL_TYPE, req.getActivityMaterialType() + "");


        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.LOW_NEEDS_AD_CUT, String.valueOf(filterResult.getRsHitCut() != null && filterResult.getRsHitCut()));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.LOW_NEEDS_AD_FILT, String.valueOf(filterResult.getRsFilted() != null && filterResult.getRsFilted()));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.LOW_NEEDS_AD_FILT_FREE, String.valueOf(filterResult.getRsFiltFree() != null && filterResult.getRsFiltFree()));

        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.USER_TF_FILTER, String.valueOf(filterResult.getUserTfFilter()));
        //打印geo/dmp 地理位置信息
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.GEO_REGION, String.valueOf(filterResult.getGeoRegion()));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.DMP_REGION, String.valueOf(filterResult.getDmpRegion()));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.REGION_DMP_GEO, filterResult.getRegionUseDmpOrGeo());

        //20200512新增  广告扶持信息
        Optional.ofNullable(advertPriceVO.getSupportAdvertInfoDto()).ifPresent(dto -> {
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.IS_SUPPORT_PLAN,
                    (Objects.nonNull(dto.getSupportAdvert()) && dto.getSupportAdvert()) ? "1" : "0");
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUPPORT_PLAN_PROMOTE,
                    StringUtils.isBlank(advertPriceVO.getSupportPlanPromote()) ? "2" : advertPriceVO.getSupportPlanPromote());
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUPPORT_PLAN_WEIGHT,
                    StringUtils.isBlank(advertPriceVO.getSupportPlanWeight()) ? "0" : advertPriceVO.getSupportPlanWeight());
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUPPORT_PLAN_TARGET_TYPE,
                    Objects.isNull(dto.getPlanCvrType()) ? "" : String.valueOf(dto.getPlanCvrType()));
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUPPORT_PLAN_TARGET_COST,
                    Objects.isNull(dto.getPlanTargetCost()) ? "" : String.valueOf(dto.getPlanTargetCost()));
        });

        // [广告分媒体调控]媒体权重策略id
        if (CollectionUtils.isNotEmpty(advertPriceVO.getLayeredStrategyIds())) {
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.LAYERED_STRATEGY_IDS,
                    Joiner.on(",").join(advertPriceVO.getLayeredStrategyIds()));
        }

        return reqLogExt;
    }

    private void handlerMaterialTestLogExtMap(Map<String, String> logExtMap, Map<String, String> logExtExpMap,
                                              AdvertPriceVO advertPriceVO) {
        MaterialTestPlanDO materialTestPlanDO = advertPriceVO.getMaterialTestPlanDO();
        if (Objects.isNull(materialTestPlanDO)) {
            return;
        }

        if (Optional.ofNullable(materialTestPlanDO.getTestPlanMaterial()).orElseGet(() -> false)) {
            // 参与素材测试
            logExtMap.put(AdvertReqLogExtKeyConstant.MATERIAL_TEST, "1");
            logExtMap.put(AdvertReqLogExtKeyConstant.MATERIAL_TEST_RESULT, String.valueOf(getMaterialTestResult(materialTestPlanDO)));

            // 命中素材测试但是被放弃的情况下打标
            if (materialTestPlanDO.isHitByInvalid()) {
                logExtMap.put(AdvertReqLogExtKeyConstant.MATERIAL_TEST_RESULT, "2");
            }

            if (Objects.nonNull(materialTestPlanDO.getPlanId())) {
                logExtMap.put(AdvertReqLogExtKeyConstant.MATERIAL_TEST_PLAN_ID, String.valueOf(materialTestPlanDO.getPlanId()));
            }
        } else {
            // 没有参与素材测试
            logExtMap.put(AdvertReqLogExtKeyConstant.MATERIAL_TEST, "0");
        }

        if (Objects.nonNull(materialTestPlanDO.getMaterialType())) {
            logExtMap.put(AdvertReqLogExtKeyConstant.MATERIAL_TYPE, materialTestPlanDO.getMaterialType());
        }
        if (Objects.nonNull(materialTestPlanDO.getMaterialId())) {
            logExtMap.put(AdvertReqLogExtKeyConstant.MATERIAL_TEST_ID, String.valueOf(materialTestPlanDO.getMaterialId()));
        }
        if (Objects.nonNull(materialTestPlanDO.getSupportMaterialId())) {
            logExtMap.put(AdvertReqLogExtKeyConstant.SUPPORT_MATERIAL_ID, String.valueOf(materialTestPlanDO.getSupportMaterialId()));
        }
    }

    /**
     * 素材绑定落地页测试日志
     */
    private void handlerDomainTestLogExtMap(Map<String, String> logExtMap, AdvertPriceVO advertPriceVO) {
        DomainTestPlanDTO domainTestPlan = advertPriceVO.getDomainTestPlan();
        if (Objects.isNull(domainTestPlan)) {
            return;
        }

        Optional.ofNullable(domainTestPlan.getDomainTestResult()).ifPresent(result ->
                logExtMap.put(AdvertReqLogExtKeyConstant.DOMAIN_TEST_RESULT, String.valueOf(domainTestPlan.getDomainTestResult())));

        Optional.ofNullable(domainTestPlan.getPlanId()).ifPresent(result ->
                logExtMap.put(AdvertReqLogExtKeyConstant.DOMAIN_TEST_PLAN_ID, String.valueOf(domainTestPlan.getPlanId())));
    }

    /**
     * 请求接口中构造福袋返回结果 <一句话功能描述>.
     *
     * @param rsp           the rsp
     * @param advertVO      the advert vo
     * @param advertOrderDO
     * @param advertOrderId 广告订单ID
     * @return the obtain advert rsp
     */
    @SuppressWarnings("squid:S3776")
    private ObtainAdvertRsp buildObtainAdvertResult(ObtainAdvertRsp rsp, AdvertVO advertVO,
                                                    long advertOrderId, AdvertOrderDO advertOrderDO, FilterResult filterResult) {
        try {
            AdvertPlan advertPlan = advertVO.getAdvertPlan();
            AdvertCoupon advertCoupon = serviceManager.getAdvertCouponByLocal(advertPlan.getId());

            rsp.setPromoteDeepLink(advertVO.getPromoteDeepLink());
            rsp.setAppDownloadUrl(advertVO.getAppDownloadUrl());

            // 优惠券，基本信息
            rsp.setCouponRemark(advertCoupon.getCouponRemark());
            rsp.setCouponType(advertCoupon.getCouponType().intValue() == 0 ? AdvertDO.GENERAL_PREFERENCE_CODE : advertCoupon.getCouponType());
            if (StringUtils.isBlank(rsp.getPromoteUrl())) {
                rsp.setPromoteUrl(advertCoupon.getPromoteURL());
            }
            rsp.setThumbnailPngUrl(advertCoupon.getThumbnailPng());
            rsp.setIsWeixin(advertCoupon.getIsWeixin() ? 1 : 0);
            rsp.setSpecialHide(advertCoupon.getIsDisplayMenu() ? 1 : 0);

            //日志拓展字段解析，包含屏蔽策略类型，广告定向配置包id，计费方式，当前出价等。
            Map<String, Object> logExtMap = rsp.getLogExtMap();
            if (rsp.getLogExtMap() == null) {
                logExtMap = Maps.newHashMap();
            }
            OrderJsonVO vo = JSONObject.parseObject(advertOrderDO.getJson(), OrderJsonVO.class);

            rsp.setAdSpecId(null == vo.getPid() ? 0L : vo.getPid());
            rsp.setStrategyType(vo.getSt());
            rsp.setSlotId(advertOrderDO.getSlotId());
            //去掉兑吧落地页日志广告位id
            if (StringUtils.isNotBlank(vo.getuT())) {
                Integer ut = Integer.parseInt(vo.getuT());
                if (ut == 0 || ut == 1) {
                    rsp.setDuibaSlotId(rsp.getSlotId());
                    rsp.setSlotId(null);
                }
            }
            rsp.setMaterialId(advertOrderDO.getMaterialId());
            // 只在互动广告打印（为空时不打印）
            if (StringUtils.isNotBlank(vo.getSaw())) {
                logExtMap.put(AdvertReqLogExtKeyConstant.SUB_ACTIVITY_WAY, vo.getSaw());
            }
            // 自定义活动（活动工具）打印
            if (StringUtils.isNotBlank(vo.getAp())) {
                logExtMap.put(AdvertReqLogExtKeyConstant.ACTIVITY_PAGE, vo.getAp());
            }
            if (vo.getCt() != null) {
                logExtMap.put(AdvertOrderJsonKeyEnum.KEY_CHARGE_TYPE.getCode(), ChargeTypeEnum.getDescByCode(vo.getCt()));
            }
            logExtMap.put(AdvertOrderJsonKeyEnum.KEY_APP_ID.getCode(), advertOrderDO.getAppId());
            logExtMap.put(AdvertOrderJsonKeyEnum.KEY_FEE.getCode(), vo.getFe());
            logExtMap.put(AdvertOrderJsonKeyEnum.KEY_TIMES.getCode(), String.valueOf(vo.getTs()));
            logExtMap.put(AdvertOrderJsonKeyEnum.KEY_EFFECTIVE_MAIN_TYPE.getCode(), advertVO.getEffectMainType());
            logExtMap.put(AdvertReqLogExtKeyConstant.GMT_CREATE_TIME, StringTool.getStringTime(advertOrderDO.getGmtCreate()));
            logExtMap.put(AdvertReqLogExtKeyConstant.DUIBA_SLOT_id, rsp.getDuibaSlotId());
            logExtMap.put(AdvertReqLogExtKeyConstant.CID, advertOrderDO.getConsumerId());
            logExtMap.put(AdvertReqLogExtKeyConstant.LAUNCH_LOG_PROMOTE_URL, rsp.getPromoteUrl());
            logExtMap.put(AdvertReqLogExtKeyConstant.FLOW_TAG, rsp.getFlowTag());
            logExtMap.put(AdvertReqLogExtKeyConstant.MAIN_TYPE, AdvertReqLogExtKeyConstant.INTERACT);
            logExtMap.put(AdvertReqLogExtKeyConstant.PRE_ARUP, filterResult.getArpuValue());
            // 原生的Ua很长那种，这里再打印一个ip
            logExtMap.put(AdvertReqLogExtKeyConstant.USER_IP, vo.getIp());
            logExtMap.put(AdvertReqLogExtKeyConstant.USER_AGENT, vo.getUat());
            // 获取 deviceId
            String deviceIdM5 = getDeviceId(vo);

            logExtMap.put(AdvertReqLogExtKeyConstant.DEVICE_ID_M5, deviceIdM5);
            // 广告主落地页，和广告主的回传链接
            logExtMap.put(AdvertReqLogExtKeyConstant.LAUNCH_LOG_PROMOTE_BACK_URL, advertVO.getPromoteBackUserUrl());

            //20201120 新增
            logExtMap.put(AdvertReqLogExtKeyConstant.ORIENT_ACTIVITY_TYPE, vo.getOact());

            rsp.setLogExtMap(logExtMap);

            // 设置落地页标签
            rsp.setPromoteUrlTags(Optional.ofNullable(advertVO.getAdvertTagDO())
                    .map(tag -> tag.getPromoteUrlTags()).orElse(Collections.emptyList()));

            //构建素材信息
            this.buildMaterial(rsp, advertCoupon, filterResult);
            filterResult.setAccountId(advertPlan.getAccountId());

            rsp.setOrderId(advertOrderDO.getDuibaOrderId());


            // 广告订单信息
            rsp.setAdvertOrderId(advertOrderId);
            rsp.setAdvertId(advertPlan.getId());
            rsp.setAdvertiserName(advertVO.getAdvertiserName());
            // 优惠券卷码
            String endValid = advertVO.getAdvertPlan().getEndDate() == null ? null : (new DateTime(advertVO.getAdvertPlan().getEndDate())).toString("yyyy-MM-dd");
            rsp.setEndValid(endValid);

            //添加 包名、应用名
            Optional.ofNullable(serviceManager.getAdvertSdkDtoByAdvertId(advertPlan.getId())).ifPresent(advertSdkDO -> {
                rsp.setPackageName(advertSdkDO.getPackageName());
                rsp.setAppName(advertSdkDO.getApplicationName());
                rsp.setAppIconUri(advertSdkDO.getAppIconUri());
                rsp.setAppPro(advertSdkDO.getAppProUrls());
            });

            // 结果状态
            rsp.setResult(true);
            //免费&付费券日志打印
            if (vo.getFe() == 0L) {
                CatUtil.log(CatGroupEnum.CAT_102005.getCode());
                WarningUtils.markThresholdWarning("freeAdvertLauch", catMonitorWarnThreshold.getFreeAdvert());
                rsp.setIsFreeAdvert(CommonConstants.IS_FREE_ADVERT);
            } else {
                CatUtil.log(CatGroupEnum.CAT_102006.getCode());
                rsp.setIsFreeAdvert(CommonConstants.IS_PAY_ADVERT);
            }
        } catch (Exception e) {
            logger.error("buildObtainAdvertResult happen error", e);
            rsp.setResult(false);
        }
        return rsp;
    }

    /**
     * 设置deviceId
     *
     * @param vo
     * @return
     */
    private String getDeviceId(OrderJsonVO vo) {

        String deviceIdM5;

        if (StringUtils.isNotEmpty(vo.getIme5())) {
            deviceIdM5 = vo.getIme5();
        } else if (StringUtils.isNotEmpty(vo.getIdfa5())) {
            deviceIdM5 = vo.getIdfa5();
        } else {
            deviceIdM5 = vo.getOaid5();
        }
        return deviceIdM5;
    }

    /**
     * 过滤主链接
     *
     * @param advertId
     * @param filterResult
     * @return true 要过滤 false 不需要过滤
     */
    private boolean filterNormalLoadingPage(Long advertId, FilterResult filterResult, ObtainAdvertReq req) {
        //美团adx 不需要过滤
        if (null != req.getAdxMediaType() && req.getAdxMediaType() == 1) {
            return false;
        }

        AdvertFilterKeywordDO advertFilterKeywordDO = filterResult.getAdvertFilterKeywordDO();
        if (Objects.nonNull(advertFilterKeywordDO)) {

            NewTradeFilterKeywordDO newTradeFilterKeywordDO = advertFilterKeywordDO.getNewTradeFilterKeywordDO();
            if (Objects.nonNull(newTradeFilterKeywordDO) && CollectionUtils.isNotEmpty(newTradeFilterKeywordDO.getShieldNormalLandingList())) {
                return newTradeFilterKeywordDO.getShieldNormalLandingList().contains(advertId);
            }

            GeneralFilterKeywordDO generalFilterKeywordDO = advertFilterKeywordDO.getGeneralFilterKeywordDO();
            if (Objects.nonNull(generalFilterKeywordDO) && CollectionUtils.isNotEmpty(generalFilterKeywordDO.getShieldNormalLandingList())) {
                return generalFilterKeywordDO.getShieldNormalLandingList().contains(advertId);
            }
        }
        return false;
    }

    /**
     * 过滤测试落地页
     *
     * @param urls
     * @param filterResult
     * @return true 屏蔽 false 不屏蔽
     */
    private boolean filterABTestLoadingPage(List<String> urls, FilterResult filterResult, Long advertId, ObtainAdvertReq req) {
        Set<String> copyNewUrls = Sets.newHashSet(urls);

        //美团adx 不需要过滤
        if (null != req.getAdxMediaType() && req.getAdxMediaType() == 1) {
            return false;
        }

        AdvertFilterKeywordDO advertFilterKeywordDO = filterResult.getAdvertFilterKeywordDO();
        if (Objects.nonNull(advertFilterKeywordDO)) {
            NewTradeFilterKeywordDO newTradeFilterKeywordDO = advertFilterKeywordDO.getNewTradeFilterKeywordDO();
            if (Objects.nonNull(newTradeFilterKeywordDO) && MapUtils.isNotEmpty(newTradeFilterKeywordDO.getShieldABTestLandingPageList())) {
                Map<Long, Set<String>> advertShieldList = newTradeFilterKeywordDO.getShieldABTestLandingPageList();
                if (advertShieldList.containsKey(advertId)) {
                    Set<String> urlShieldList = advertShieldList.get(advertId);
                    if (CollectionUtils.isNotEmpty(urlShieldList)) {
                        for (String url : copyNewUrls) {
                            if (urlShieldList.contains(url)) {
                                return true;
                            }
                        }
                    }
                }
            }

            GeneralFilterKeywordDO generalFilterKeywordDO = advertFilterKeywordDO.getGeneralFilterKeywordDO();
            if (Objects.nonNull(generalFilterKeywordDO) && MapUtils.isNotEmpty(generalFilterKeywordDO.getShieldABTestLandingPageList())) {
                Map<Long, Set<String>> advertShieldList = generalFilterKeywordDO.getShieldABTestLandingPageList();
                if (advertShieldList.containsKey(advertId)) {
                    Set<String> urlShieldList = advertShieldList.get(advertId);
                    if (CollectionUtils.isNotEmpty(urlShieldList)) {
                        for (String url : copyNewUrls) {
                            if (urlShieldList.contains(url)) {
                                return true;
                            }
                        }
                    }
                }
            }
        }

        return false;
    }

    /**
     * 配置维度过滤
     *
     * @param
     * @param filterResult
     * @return true 要过滤 false 不要过滤
     */
    private boolean filterConfigLoadingPage(AdvertPriceVO advertPriceVO, FilterResult filterResult, Long advertId, ObtainAdvertReq req) {
        //美团adx 不需要过滤
        if (null != req.getAdxMediaType() && req.getAdxMediaType() == 1) {
            return false;
        }

        AdvertFilterKeywordDO advertFilterKeywordDO = filterResult.getAdvertFilterKeywordDO();
        if (Objects.nonNull(advertFilterKeywordDO)) {

            NewTradeFilterKeywordDO newTradeFilterKeywordDO = advertFilterKeywordDO.getNewTradeFilterKeywordDO();
            if (Objects.nonNull(newTradeFilterKeywordDO) && MapUtils.isNotEmpty(newTradeFilterKeywordDO.getShieldConfigLandingPageList())) {
                Map<Long, Set<Long>> advertShieldList = newTradeFilterKeywordDO.getShieldConfigLandingPageList();
                if (null != advertShieldList && advertShieldList.containsKey(advertId)) {
                    Set<Long> configIdShieldList = advertShieldList.get(advertId);
                    if (CollectionUtils.isNotEmpty(configIdShieldList) && configIdShieldList.contains(advertPriceVO.getOriginalOrientationId())) {
                        return true;
                    }
                }
            }

            GeneralFilterKeywordDO generalFilterKeywordDO = advertFilterKeywordDO.getGeneralFilterKeywordDO();
            if (Objects.nonNull(generalFilterKeywordDO) && MapUtils.isNotEmpty(generalFilterKeywordDO.getShieldConfigLandingPageList())) {
                Map<Long, Set<Long>> advertShieldList = generalFilterKeywordDO.getShieldConfigLandingPageList();
                if (null != advertShieldList && advertShieldList.containsKey(advertId)) {
                    Set<Long> configIdShieldList = advertShieldList.get(advertId);
                    if (CollectionUtils.isNotEmpty(configIdShieldList) && configIdShieldList.contains(advertPriceVO.getOriginalOrientationId())) {
                        return true;
                    }
                }
            }
        }

        return false;
    }

    /**
     * 新媒体试投过滤
     *
     * @param advertId
     * @param filterResult
     * @return true 要过滤 false 不要过滤
     */
    private boolean filterNewMediaLoadingPage(Long advertId, FilterResult filterResult, ObtainAdvertReq req) {
        //美团adx 不需要过滤
        if (null != req.getAdxMediaType() && req.getAdxMediaType() == 1) {
            return false;
        }

        AdvertFilterKeywordDO advertFilterKeywordDO = filterResult.getAdvertFilterKeywordDO();
        if (Objects.nonNull(advertFilterKeywordDO)) {

            NewTradeFilterKeywordDO newTradeFilterKeywordDO = advertFilterKeywordDO.getNewTradeFilterKeywordDO();
            if (Objects.nonNull(newTradeFilterKeywordDO) && CollectionUtils.isNotEmpty(newTradeFilterKeywordDO.getShieldNewMediaLandingPageList())) {
                if (newTradeFilterKeywordDO.getShieldNewMediaLandingPageList().contains(advertId)) {
                    return true;
                }
            }

            GeneralFilterKeywordDO generalFilterKeywordDO = advertFilterKeywordDO.getGeneralFilterKeywordDO();
            if (Objects.nonNull(generalFilterKeywordDO) && CollectionUtils.isNotEmpty(generalFilterKeywordDO.getShieldNewMediaLandingPageList())) {
                if (generalFilterKeywordDO.getShieldNewMediaLandingPageList().contains(advertId)) {
                    return true;
                }
            }

        }

        return false;
    }

    /**
     * 是否用测试落地页，根据分配流量占比，权重
     *  @param rsp
     * @param filterResult
     */
    private void buildPromoteTest(ObtainAdvertRsp rsp, FilterResult filterResult, AdvertPriceVO advertPriceVO, AdvertVO advertVO, ObtainAdvertReq req) throws TuiaException {

        Long advertId = advertVO.getAdvertPlan().getId();

        // 0.域测试校验
        DomainTestPlanDTO domainTestPlan = advertPriceVO.getDomainTestPlan();
        if (null != domainTestPlan && !Objects.equals(domainTestPlan.getDomainTestResult(), 0)) {
            // 域测试命中
            if (Objects.equals(domainTestPlan.getDomainTestResult(), 1)) {
                String promoteUrl = domainTestPlan.getPromoteUrl();
                abtestSkipReasonLog(req, ABTestSkipEnum.AB1009);
                if (null == promoteUrl) {
                    logger.warn("ABTest命中域测试，但是无落地页，advertId{}, planId={}", advertId, domainTestPlan.getPlanId());
                    return;
                }
            }
            // 域测试命中但放弃
            return;
        }


        //1.查询测试落地页数据
        MaterialPromoteTestUrlsVO testUrlsVO = advertPromoteTestCacheService.getMaterialPromoteTest(advertId);

        //2.判断，如果测试落地页为null，配置ID不在测试ID内，测试URL为空，则不进行测试落地页
        if (null == testUrlsVO
                || testOrientIdsNotContainRspOrientIds(testUrlsVO.getOrientIds(), advertPriceVO.getAdvertOrientationPackageId())
                || testUrlsVO.getPromoteUrls().size() < 1) {
            abtestSkipReasonLog(req, ABTestSkipEnum.AB1001);
            return;
        }

        //媒体关键词过滤
        if (filterABTestLoadingPage(testUrlsVO.getPromoteUrls(), filterResult, advertId, req)) {
            abtestSkipReasonLog(req, ABTestSkipEnum.AB1002);
            return;
        }

        //爱奇艺特殊判断
        if (iQiyiService.isIQiyiFlow(req)) {
            ABTestFilterUrlDO abTestFilterUrlDO = advertABTestCacheService.getAdvertABTestCache(advertId);
            if (null == abTestFilterUrlDO || !abTestFilterUrlDO.isSupportTest()) {
                abtestSkipReasonLog(req, ABTestSkipEnum.AB1003);
                return;
            }
        }

        //3.查询素材->测试落地页关系。
        List<AdvertPromoteTestDO> materialPromoteTestDOS = advertPromoteTestCacheService.getMaterialPromoteTestRelation(rsp.getMaterialId());

        //4.判断素材不全可投,且切量为100,走降级
        if (CollectionUtils.isEmpty(materialPromoteTestDOS)
                || materialPromoteTestDOS.size() != testUrlsVO.getPromoteUrls().size()) {
            //且切量为100%，走降级
            if (testUrlsVO.getWeight() >= 1) {
                logger.info("素材不全可投,且切量为100,走降级 广告ID:{}, 素材ID:{}, weight:{}", advertId, rsp.getMaterialId(), testUrlsVO.getWeight());
                abtestSkipReasonLog(req, ABTestSkipEnum.AB1005);
                throw new TuiaException(ErrorCode.E0500040);
            }
            abtestSkipReasonLog(req, ABTestSkipEnum.AB1004);
            //不为100%，不替换测试连接，走后门出券逻辑
            return;
        }


        //5.判断用户是否发过券
        Integer integer = filterResult.getLimitAdvertTodayMap().get(advertId);
        if (integer != null && integer > 0) {
            //且切量为100%，走降级
            if (testUrlsVO.getWeight() >= 1) {
                logger.info("已经发过券,且切量为100,走降级 广告ID:{}, weight:{}", advertId, testUrlsVO.getWeight());
                abtestSkipReasonLog(req, ABTestSkipEnum.AB1007);
                throw new TuiaException(ErrorCode.E0500041);
            }
            abtestSkipReasonLog(req, ABTestSkipEnum.AB1006);
            //不为100%，不替换测试连接，走后门出券逻辑
            return;
        }

        // 6.调用实验平台分流
        Long orientId = Optional.ofNullable(advertPriceVO.getOriginalOrientationId()).orElse(advertPriceVO.getAdvertOrientationPackageId());
//        String promoteUrl = promoteABTestService.getPromoteUrl(req, advertId, orientId);
        ABResult abResult = promoteABTestService.routeFlowWithoutLog(req, advertId, orientId);
        if(abResult==null){
            abtestSkipReasonLog(req, ABTestSkipEnum.AB1008);
            return;
        }
        Map<String, String> arguments = abResult.getArguments();
        String promoteUrl = arguments.get("promoteUrl");
        if (null == promoteUrl) {
            abtestSkipReasonLog(req, ABTestSkipEnum.AB1008);
            return;
        }
        //落地页id
        String promoteIdstr = arguments.get("promoteId");
        //校验abtest平台返回的落地页是否有效
        if(!testUrlsVO.getPromoteUrls().contains(promoteUrl)){
            //如果无效

            if (testUrlsVO.getWeight() >= 1) {
                //且切量为100%，走降级 放弃该广告
                logger.info("命中ABTest但是落地页不是审核通过状态&&且切量为100,走降级 广告ID:{}, 素材ID:{}, weight:{}", advertId, rsp.getMaterialId(), testUrlsVO.getWeight());
                abtestSkipReasonLog(req, ABTestSkipEnum.AB1011);
                throw new TuiaException(ErrorCode.E0500043);
            }else {
                //且切量不为100%，投主链接
                logger.info("命中ABTest但是落地页不是审核通过状态&&且切量不为100,走主链接 广告ID:{}, 素材ID:{}, weight:{}", advertId, rsp.getMaterialId(), testUrlsVO.getWeight());
                abtestSkipReasonLog(req, ABTestSkipEnum.AB1012);
                return;
            }
        }



        if (testUrlsVO.getNewType()) {
            Long promoteId=0L;
            if(StringUtils.isNotEmpty(promoteIdstr) && StringUtils.isNumeric(promoteIdstr)){
                promoteId = Long.parseLong(promoteIdstr);
            }
            if(checkPromoteIdPromoteTag(advertId,promoteId, filterResult, advertVO)) {
                abtestSkipReasonLog(req, ABTestSkipEnum.AB1010);
                return;
            }

        } else {
            //老的数据走老的校验落地页标签是否屏蔽逻辑
            //校验落地页标签是否屏蔽
            if (checkUrlPromoteTag(advertId, 0, promoteUrl, filterResult, advertVO)) {
                abtestSkipReasonLog(req, ABTestSkipEnum.AB1010);
                return;
            }
        }
        // 7.对rsp重新设置落地页
        rsp.setPromoteUrl(promoteUrl);
        filterResult.setPromoteSource(PromoteSource.AB_TEST);

        // 打印实验评结果日志
        putPromoteLogExtExpMap(req, abResult);
    }

    private void putPromoteLogExtExpMap(ObtainAdvertReq req, ABResult abResult) {
        try {
            String abtest = req.getLogExtExpMap().get(AdvertReqLogExtKeyConstant.ABTEST);
            if (org.apache.commons.lang3.StringUtils.isNotBlank(abtest)) {
                List<ABResult.ABResultDTO> abResultDTOS = JSON.parseArray(abtest, ABResult.ABResultDTO.class);
                abResultDTOS.addAll(abResult.getAbResultList());
                req.getLogExtExpMap().put(AdvertReqLogExtKeyConstant.ABTEST, JSON.toJSONString(abResultDTOS));
            } else {
                req.getLogExtExpMap().put(AdvertReqLogExtKeyConstant.ABTEST, JSON.toJSONString(abResult.getAbResultList()));
            }
        } catch (Exception e) {
            logger.warn("打印实验平台结果异常", e);
        }
    }

    /**
     * 判断是否命中落地页ID 落地页标签屏蔽
     * @author fanjia
     * @date 2021/7/12 下午7:14
     * @param advertId
     * @param promoteId
     * @param filterResult
     * @param advertVO
     * @return boolean
     */
    private boolean checkPromoteIdPromoteTag(Long advertId, Long promoteId, FilterResult filterResult, AdvertVO advertVO) {

        try {

            AdvertPlan advertPlan = advertVO.getAdvertPlan();
            MediaList mediaWhiteList = filterResult.getMediaWhiteList();
            if (mediaWhiteList != null && mediaWhiteList.isAdvertInList(advertId, advertPlan.getAccountId())) {
                return false;
            }

            //获取屏蔽落地页标签
            AdvBannedTag advQueryBannedTag = filterResult.getAdvBannedTag();
            if (advQueryBannedTag == null) {
                return false;
            }

            Set<String> shieldPromoteTagSet = advQueryBannedTag.getPromoteUrlTags();
            if (CollectionUtils.isEmpty(shieldPromoteTagSet)) {
                return false;
            }

            //获取URL落地页标签
            Set<String> promoteTags = new HashSet();
            AdvertPromoteTestDO dto = makeTagCacheService.getPromoteTestTagByIdKey(promoteId);
            if (dto != null && dto.getPromoteTag()!=null) {
                List<String> promoteIdList = StringTool.getStringListByStr(dto.getPromoteTag());
                promoteTags.addAll(promoteIdList);
                if (dto.getSourceId() != null && dto.getSourceType() != null) {
                    List<String> makeTags = makeTagCacheService.getMakeTagByKey(dto.getSourceId(), dto.getSourceType());
                    if (CollectionUtils.isNotEmpty(makeTags)) {
                        promoteTags.addAll(makeTags);
                    }
                }
            }
            if (CollectionUtils.isEmpty(promoteTags)) {
                return false;
            }
            return shieldPromoteTagSet.stream().anyMatch(promoteTags::contains);
        } catch (Exception e) {
            logger.error("url 落地页标签屏蔽error");
        }
        return false;
    }

    /**
     * 本次发券ID不在测试ID集里
     *
     * @param orientIds
     * @param packageId
     * @return
     */
    private boolean testOrientIdsNotContainRspOrientIds(String orientIds, Long packageId) {

        //如果为空，说明全部配置可测
        if (StringUtils.isBlank(orientIds)) {
            return false;
        }

        //不包含
        return !orientIds.contains(packageId.toString());
    }

    /**
     * 构建素材信息
     *
     * @param rsp
     * @param filterResult
     */
    @SuppressWarnings("squid:S3776")
    private void buildMaterial(ObtainAdvertRsp rsp, AdvertCoupon advertCoupon, FilterResult filterResult) {
        Long defaultMaterialId = advertMaterialRecommendService.getDefaultByAdvertId(rsp.getAdvertId());
        boolean isDefault = false;
        AdvertMaterialVO advertMaterialCache = null;
        if (null == rsp.getMaterialId() || -1L == rsp.getMaterialId() || rsp.getMaterialId().equals(defaultMaterialId)) {
            isDefault = true;
            advertMaterialCache = advertMaterialRealtionService.getMaterialCache(defaultMaterialId);
        } else {
            advertMaterialCache = advertMaterialRealtionService.getMaterialCache(rsp.getMaterialId());
            if (null == advertMaterialCache) {
                isDefault = true;
            }
        }

        //标记素材类型是否为动态素材
        filterResult.setDynamicMaterial(null == advertMaterialCache || advertMaterialCache.getProductNameTag() == CommonConstant.NO ? "0" : "1");

        rsp.setBannerPngUrl(isDefault ? advertCoupon.getBannerPng() : advertMaterialCache.getBannerPng());
        rsp.setViceTitle(isDefault ? advertCoupon.getDescription() : advertMaterialCache.getDescription());
        if (isDefault) {
            rsp.setTitle(null == advertMaterialCache ? advertCoupon.getCouponName() :
                    advertMaterialRealtionService.getMaterialTitle(advertMaterialCache, filterResult.getProvince(),
                            StringUtils.isNotBlank(filterResult.getNetworkTypes()) ? Integer.valueOf(filterResult.getNetworkTypes()) : null,
                            StringUtils.isNotBlank(filterResult.getOperators()) ? Integer.valueOf(filterResult.getOperators()) : null,
                            filterResult.getUa(),
                            filterResult.getCity()));
            rsp.setButtonText(advertCoupon.getButtonText() != null ? advertCoupon.getButtonText() : AdvertCoupon.DEFAULT_BTN_TEXT);
        } else {
            rsp.setTitle(advertMaterialRealtionService.getMaterialTitle(advertMaterialCache, filterResult.getProvince(),
                    StringUtils.isNotBlank(filterResult.getNetworkTypes()) ? Integer.valueOf(filterResult.getNetworkTypes()) : null,
                    StringUtils.isNotBlank(filterResult.getOperators()) ? Integer.valueOf(filterResult.getOperators()) : null,
                    filterResult.getUa(),
                    filterResult.getCity()));
            rsp.setButtonText(advertMaterialCache.getButtonText() != null ? advertMaterialCache.getButtonText() : AdvertCoupon.DEFAULT_BTN_TEXT);

            //视频广告需要
            rsp.setMaterialName(advertMaterialCache.getMaterialName());
            rsp.setCouponName(advertMaterialCache.getCouponName());

            rsp.setVideoCoverUrl(advertMaterialCache.getVideoCoverUrl());
            rsp.setVideoCompletionUrl(advertMaterialCache.getVideoCompletionUrl());
            rsp.setVideoDuration(advertMaterialCache.getVideoDuration());
            rsp.setVideoActivityId(advertMaterialCache.getVideoActivityId());
            rsp.setVideoCompletionUrlVertical(advertMaterialCache.getVideoCompletionUrlVertical());
            rsp.setVideoCompletionDirection(advertMaterialCache.getVideoCompletionDirection());
            rsp.setVideoCardUrl(advertMaterialCache.getVideoCardUrl());
            rsp.setVideoExt(advertMaterialCache.getVideoExt());
        }
    }

    /**
     * 根据广告id查询广告包含的素材信息，并返回合适的素材id
     *
     * @param req
     * @param advertId
     * @param advertPriceVO
     * @return
     * @throws TuiaException
     */
    public Long getMaterialIdByAdvertId(
            Long advertId, ObtainAdvertReq req, AdvertPriceVO advertPriceVO, Set<Long> materialSetIds) throws TuiaException {
        try {
            MaterialTestPlanDO materialTestPlanDO = advertPriceVO.getMaterialTestPlanDO();

            // 第一次请求的参数为空
            if (Objects.isNull(materialTestPlanDO)) {
                return null;
            }

            // 获取有效的新老素材
            RspMaterialList materialIds = materialTestPlanDO.getRspMaterialList();

            //2.判断查询结果，是否需要降级
            if (null == materialIds
                    || (CollectionUtils.isEmpty(materialIds.getNewMaterials()) && CollectionUtils.isEmpty(materialIds.getOldMaterials()))) {
                return null;
            }

            //3.构建推荐引擎请求参数
            ReqAdvertMaterialDto reqAdvertMaterialDto = new ReqAdvertMaterialDto();
            reqAdvertMaterialDto.setAdvertId(advertId);
            reqAdvertMaterialDto.setAppId(req.getAppId());
            // 获取打标的测试素材ID
            reqAdvertMaterialDto.setTestMaterialId(materialTestPlanDO.getMaterialId());

            //4.新素材需要投放配置上的素材，过滤掉已领取的素材和定制素材
            reqAdvertMaterialDto.setNewMaterialList(materialIds.getNewMaterials());

            //5.老素材需要投放配置上的素材，过滤掉已领取的素材和定制素材
            reqAdvertMaterialDto.setOldMaterialList(materialIds.getOldMaterials());

            reqAdvertMaterialDto.setOldMaterialRatio(materialIds.getOldMaterialRatio());
            reqAdvertMaterialDto.setOldMaterialTraffic(materialIds.getOldMaterialTraffic());

            //7.调用推荐引擎，返回合适ID
            DubboResult<Long> recommedMaterialIdResult;
            try {
                DBTimeProfile.enter("finishBiz.recommendMaterial");
                recommedMaterialIdResult = remoteAdvertMaterialRecommendService.recommendMaterial(reqAdvertMaterialDto);
            } finally {
                DBTimeProfile.release();
            }
            //8.判断推荐结果，是否需要降级
            if (null == recommedMaterialIdResult || !recommedMaterialIdResult.isSuccess()) {
                return null;
            }
            Long materialId = recommedMaterialIdResult.getResult();

            // 测试打标
            postHandlerTestMaterialId(materialId, advertPriceVO);

            //9.如果推荐素材与广告本身拥有的素材不一样,则记录日志
            if (!materialSetIds.isEmpty() && !materialSetIds.contains(materialId)) {
                MaterialDiffLog.log("advertId:" + advertId +
                        ";newMaterialList:" + JSONObject.toJSONString(materialIds.getNewMaterials())
                        + ";oldMaterialList:" + JSONObject.toJSONString(materialIds.getOldMaterials())
                        + ";result:" + materialId);
            }
            return materialId;
        } catch (Exception e) {
            logger.error("EngineServiceImpl.getMaterialIdByAdvertId happen error", e);
            return null;
        }
    }

    /**
     * 素材测试打标处理
     *
     * @param recomMaterialId
     * @param advertPriceVO
     */
    public void postHandlerTestMaterialId(Long recomMaterialId, AdvertPriceVO advertPriceVO) {
        MaterialTestPlanDO materialTestPlanDO = advertPriceVO.getMaterialTestPlanDO();

        // 没有参与测试, 不用处理
        if (Objects.isNull(materialTestPlanDO)) {
            return;
        }

        Long testMaterialId = materialTestPlanDO.getMaterialId();

        // 设置素材类型
        setMaterialType(testMaterialId, materialTestPlanDO);
    }

    private static void setMaterialType(Long testMaterialId, MaterialTestPlanDO materialTestPlanDO) {
        if (Objects.isNull(testMaterialId)) {
            return;
        }
        // 获取有效的新老素材
        List<Long> newMaterials = materialTestPlanDO.getRspMaterialList().getNewMaterials();
        // 测试素材列表
        List<Long> validTestMaterial = materialTestPlanDO.getValidTestMaterial();

        if (CollectionUtils.isNotEmpty(validTestMaterial) && validTestMaterial.contains(testMaterialId)) {
            // 测试新素材
            if (CollectionUtils.isNotEmpty(newMaterials) && newMaterials.contains(testMaterialId)) {
                materialTestPlanDO.setMaterialType(MaterialTestPlanLogTypeEnum.TEST_NEW_MATERIAL.toLogString());
            }
            // 测试老素材
            else {
                materialTestPlanDO.setMaterialType(MaterialTestPlanLogTypeEnum.TEST_OLD_MATERIAL.toLogString());
            }
        } else {
            materialTestPlanDO.setPlanId(null);
            // 新素材
            if (CollectionUtils.isNotEmpty(newMaterials) && newMaterials.contains(testMaterialId)) {
                materialTestPlanDO.setMaterialType(MaterialTestPlanLogTypeEnum.NEW_MATERIAL.toLogString());
            }
            // 老素材
            else {
                materialTestPlanDO.setMaterialType(MaterialTestPlanLogTypeEnum.OLD_MATERIAL.toLogString());
            }
        }
    }

    private Long setPeriodId(AdvertPlanPeriodDO advertPeriod) {
        if (advertPeriod != null) {
            return advertPeriod.getId();
        }
        return null;
    }


    private static int getMaterialTestResult(MaterialTestPlanDO materialTestPlanDO) {
        return Optional.ofNullable(materialTestPlanDO).map(v -> v.getTestResult()).orElseGet(() -> false) ? 1 : 0;
    }

    @Override
    public void insertDspAdvertOrder(AdvertOrderDO advertOrderDO, AdvertOrderExtDO orderExtDO) throws ReadableMessageException {
        try {
            DBTimeProfile.enter("insertDspAdvertOrder");
            CatUtils.executeInCatTransaction(() -> advertOrderDAO.insertForDsp(advertOrderDO, orderExtDO), "adxAdvertFinishBizWzj", "insert");
        } catch (Throwable throwable) {
            logger.error("insertDspAdvertOrder.insert 异常", throwable);
        } finally {
            DBTimeProfile.release();
        }

    }


    /**
     * 正常 补打发券日志
     */
    @Override
    public void reLog(SpmlogReq req) {

        //TODO 校验参数
        Long advertId = req.getAdvertId();
        Long appId = req.getAppId();
        Long consumerId = req.getConsumerId();
        String orderId = req.getOrderId();


        // 广告检查
        AdvertVO advertVO = advertMapCacheManager.getAdvertCache(advertId);
        if (advertVO == null) {
            logger.error("advertVO is null, advertId = {}", advertId);
            return;
        }

        // 配置检查
        AdvOrientationItem advOrientationItem = advertMapCacheManager.getValidAdvOrientation(req.getAdvertId(), req.getOrientationId());
        if (advOrientationItem == null) {
            return;
        }

        // 查询广告订单信息
        // 1.查询广告订单
        AdvertOrderDO advertOrderDO = null;
        try {
            advertOrderDO = serviceManager.getAdvertOrderDO(consumerId, orderId, null);
        } catch (TuiaException e) {
            logger.error("getAdvertOrderDO 异常", e);
            return;
        }
        if (null == advertOrderDO) {
            logger.error("advertOrderDO is null, orderId = {}", orderId);
            return;
        }

        OrderJsonVO vo = JSONObject.parseObject(advertOrderDO.getJson(), OrderJsonVO.class);

        AdvertPlan advertPlan = advertVO.getAdvertPlan();

        NewAppTest newAppTest = newMediaTestCheck(vo, appId, advertId);

        //TODO 构建 发券日志
        ObtainAdvertReqLogExt reqLogExt = buildReqLogExtReLog(req, advertVO, advOrientationItem, advertOrderDO);

        //添加发券次数统计
        advertRealDataService.incrLaunchAdvert(advertPlan.getAgentId(), advertPlan.getAccountId(), advertId, advertPlan.getAdvertPlanId(), advertVO.getEffectMainType(),
                newAppTest, appId, vo.getSws());

        //22.发券日志打印
        SpmLog.log(reqLogExt, SpmType.SPM_LOG_LAUNCH, advertOrderDO.getId());

        Integer encArpuResult = vo.getEncAr();
        if (null == encArpuResult) {
            encArpuResult = getEncArpuResult(req.getLogExtMap());
        }

        // 虚拟广告位模拟请求发券标识
        if ("1".equals(vo.getImoa())) {
            // 虚拟广告位模拟发券
            StatLaunchJsonLog.imitateLog(reqLogExt);
            //可以替换，则打印另外类型的发券日志，否则正常打印
        } else if (encArpuResult == CommonConstant.YES) {
            StatLaunchJsonLog.lowArpulog(reqLogExt);
        } else {
            StatLaunchJsonLog.log(reqLogExt);
        }
    }

    private Integer getEncArpuResult(Map<String, String> logExtMap) {
        try {
            String encArpuResult = logExtMap.get(AdvertReqLogExtKeyConstant.ENC_ARPU_RESULT);
            if (org.apache.commons.lang3.StringUtils.isBlank(encArpuResult) || !org.apache.commons.lang3.StringUtils.isNumeric(encArpuResult)) {
                return CommonConstant.NO;
            }
            return Integer.valueOf(encArpuResult);
        } catch (Exception e) {
            logger.error("getEncArpuResult exception,logExtMap:{}", JSON.toJSONString(logExtMap), e);
            return CommonConstant.NO;
        }
    }

    private ObtainAdvertReqLogExt buildReqLogExtReLog(SpmlogReq req, AdvertVO advertVO, AdvOrientationItem advOrientationItem, AdvertOrderDO advertOrderDO) {

        //
        AdvertPlan advertPlan = advertVO.getAdvertPlan();

        //
        AdvertPriceVO advertPriceVO = advOrientationItem.simple2PriceVO();

        AdvertTagDO advertTagDO = advertVO.getAdvertTagDO();
        OrderJsonVO vo = JSONObject.parseObject(advertOrderDO.getJson(), OrderJsonVO.class);

        //获取广告折扣率
        double discountrate = advertMapCacheManager.getAdvertBidRate(advertPlan.getId(), advertPriceVO.getChargeType());

        Map<String, String> extMap = Optional.ofNullable(req.getLogExtMap()).orElse(new HashMap<>());

        ObtainAdvertReqLogExt reqLogExt = BeanUtils.copy(req, ObtainAdvertReqLogExt.class);

        reqLogExt.setOrderId(req.getOrderId());
        reqLogExt.setInfo(req.getOrderId());
        reqLogExt.setMaterialId(advertOrderDO.getMaterialId());
        //发券日志 城市id 取订单的
        reqLogExt.setCityId(vo.getCi());
        reqLogExt.setPriceSection(vo.getPs());
        reqLogExt.setPutIndex(vo.getPi());
        reqLogExt.setFee(vo.getFe());
        reqLogExt.setChargeType(ChargeTypeEnum.getByCode(vo.getCt()).getDesc());
        reqLogExt.setActivityOrderId(req.getOrderId());
        reqLogExt.setHour(StringTool.getStringHourBy(req.getTimestamp()));
        reqLogExt.setOrientationId(advertPriceVO.getAdvertOrientationPackageId());
        reqLogExt.setaFee(vo.getNaf());
        //account表中的1和2扣除的都是杭州推啊账户余额，属于杭州主体，只有3扣除的才是霍尔果斯余额

        reqLogExt.setEffectiveMainType(advertVO.getEffectMainType());
        reqLogExt.setDiscountRate(discountrate);

        if (null == reqLogExt.getLogExtMap()) {
            reqLogExt.setLogExtMap(Maps.newHashMap());
        }

        //增加落地页日志打印
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.TARGET_RECOMMEND_TYPE, Optional.ofNullable(advertPriceVO.getTargetRecommendType()).orElse(0) + "");
        reqLogExt.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_ACCOUNT_ID.getCode(), String.valueOf(advertPlan.getAccountId()));
        reqLogExt.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_AGENT_ID.getCode(), String.valueOf(advertPlan.getAgentId()));
//        reqLogExt.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_TYPE.getCode(), String.valueOf(AdxTypeEnum.BIGCUSTOMER.getCode()));
        reqLogExt.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_ACTIVITY_TYPE.getCode(), String.valueOf(vo.getAst()));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.IS_OPEN_REPEAT, String.valueOf(advertPlan.getRepeatExposure()));
        reqLogExt.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_PACKAGE_TYPE.getCode(), String.valueOf(advertPriceVO.getPackageType()));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.REPEAT_COUNT, String.valueOf(0));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.TRUSTEESHIP, advertPriceVO.getTrusteeship() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PUT_TARGET_TYPE, advertPriceVO.getPutTargetType() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.FOCUS_APP_CONVERT_COST, advertPriceVO.getFocusAppConvertCost() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.TARGET_APP_LIMIT, advertPriceVO.getTargetAppLimit() + "");

        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.STRONG_TARGET, advertPriceVO.getStrongTarget() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.TRUSTEESHIP_CONVERT_COST, advertPriceVO.getConvertCost() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUPPORT_STATUS, advertPriceVO.getSupportStatus() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.ADVERT_WEIGHT, advertPriceVO.getWeight() + "");

        if (!reqLogExt.getLogExtMap().containsKey(AdvertReqLogExtKeyConstant.IDEAL_ID)) {
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.IDEAL_ID, vo.getIdeId());
        }
        if (!reqLogExt.getLogExtMap().containsKey(AdvertReqLogExtKeyConstant.PRICE_TYPE)) {
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PRICE_TYPE, vo.getPte());
        }
        if (!reqLogExt.getLogExtMap().containsKey(AdvertReqLogExtKeyConstant.PAR_PRICE)) {
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PAR_PRICE, vo.getPp());
        }
        if (!reqLogExt.getLogExtMap().containsKey(AdvertReqLogExtKeyConstant.BILL_TYPE)) {
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.BILL_TYPE, vo.getBt());
        }
        if (!reqLogExt.getLogExtMap().containsKey(AdvertReqLogExtKeyConstant.FEE_TYPE)) {
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.FEE_TYPE, vo.getFt());
        }
        if (!reqLogExt.getLogExtMap().containsKey(AdvertReqLogExtKeyConstant.ADX_RID)) {
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.ADX_RID, vo.getArd());
        }
        if (!reqLogExt.getLogExtMap().containsKey(AdvertReqLogExtKeyConstant.PUT_TYPE)) {
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PUT_TYPE, vo.getPt());
        }

        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.DSM2, extMap.get(AdvertReqLogExtKeyConstant.DSM2));

        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.SOURCE_PAGE, extMap.get(AdvertReqLogExtKeyConstant.SOURCE_PAGE));

        String appFlowType = Optional.ofNullable(req.getLogExtMap())
                .map(logExtMap -> logExtMap.get(AdvertOrderJsonKeyEnum.KEY_APP_FLOW_TYPE.getCode()))
                .orElse(AppFlowPlatform.OTHER.getCode().toString());
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.APP_FLOW_TYPE, AppFlowTypeEnum.getByName(appFlowType).getCode());
        Optional.ofNullable(advertTagDO).ifPresent(dto -> {
            Optional.ofNullable(dto.getAdvertTradeId()).ifPresent(advertTradeId -> reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.TRADE_ID_NUM, String.valueOf(advertTradeId)));
            Optional.ofNullable(dto.getNewAdvertTradeId()).ifPresent(newAdvertTradeId -> reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.NEW_TRADE_ID, String.valueOf(newAdvertTradeId)));
            Optional.ofNullable(dto.getMatchTagNums()).ifPresent(matchTagNums -> reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.MATCH_TAG_NUM, matchTagNums));
        });

        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUBTYPE, String.valueOf(Optional.ofNullable(advertPriceVO.getSubtype()).orElse(AdvertSubtypeEnum.CVR.getSubtype())));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.DEPTH_SUBTYPE, String.valueOf(null != advertPriceVO.getDepthSubtype() ? advertPriceVO.getDepthSubtype() : advertVO.getDepthSubtype()));
        // 注:根据 depthSubtype 判断打印哪个 depthTargetPrice
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.DEPTH_TARGET_PRICE, String.valueOf(null != advertPriceVO.getDepthSubtype() ? advertPriceVO.getDepthTargetPrice() : advertVO.getDepthTargetPrice()));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.APP_FEE, String.valueOf(advertPriceVO.getConvertTypeCost()));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.MAIN_TYPE, String.valueOf(AdvertReqLogExtKeyConstant.INTERACT));
        // 互动广告打印:测试广告位子投放方式
        if (req.getLogExtMap() != null && StringUtils.isNotBlank(req.getLogExtMap().get(AdvertReqLogExtKeyConstant.SUB_ACTIVITY_WAY))) {
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUB_ACTIVITY_WAY, req.getLogExtMap().get(AdvertReqLogExtKeyConstant.SUB_ACTIVITY_WAY));
        }
        // 自定义活动（活动工具）打印
        if (req.getLogExtMap() != null && StringUtils.isNotBlank(req.getLogExtMap().get(AdvertReqLogExtKeyConstant.ACTIVITY_PAGE))) {
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.ACTIVITY_PAGE, req.getLogExtMap().get(AdvertReqLogExtKeyConstant.ACTIVITY_PAGE));
        }

        //资源标签
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.RESOURCE_TAG, advertPriceVO.getResourceTag());
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.A_FEE, vo.getNaf() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.FEE, vo.getFe() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.ADJUST_PRICE_FACTOR, vo.getApf() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PRE_CTR, vo.getPctr() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PRE_CVR, vo.getPcvr() + "");


        // 预算平滑消耗模式
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.BUDGET_SMOOTH, Optional.ofNullable(advertPriceVO.getBudgetSmooth())
                .map(Object::toString).orElse(AdvertOrientationPackageDO.BUDGET_SMOOTH_DEFULT.toString()));

        // 分媒体出价类型
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.DIS_APP_FEE_TYPE, Optional.ofNullable(advertPriceVO.getDisAppFeeType()).map(
                Object::toString).orElse(DisAppFeeTypeEnum.DEFULT_TYPE.getCode().toString()));

        //新增times字段 20191126 字段新增
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.TIMES, String.valueOf(vo.getTs()));

        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.ADX_GROUPID, vo.getAgid());

        //20191231新增字段
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.ALGO_VERSION, String.valueOf(vo.getAlgV()));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.ALGO_TEST_PLANID, String.valueOf(vo.getAlgTp()));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.SEQ_INDEX, String.valueOf(vo.getSeI()));

        //20200220新增
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.REAL_TIME_RTA, vo.getRlr());

        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.SDK_VERSION, vo.getSdkV());
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.BRAND_NAME, vo.getBn());
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PRICE_SECTION, vo.getPs());
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.EQUIPMENT_MODEL, vo.getEquipmentModel());
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.UA, vo.getUa());

        reqLogExt.setLogExtExpMap(vo.getLgEp());
        return reqLogExt;
    }


    /**
     * dsp-engine 发券日志补打
     *
     * @param req
     * @param rsp
     * @param adxAdvertPrice
     */
    public void dspLaunchLog(ObtainAdvertReq req, ObtainAdvertRsp rsp, AdxAdvertPriceDto adxAdvertPrice) {
        // 1.查询广告订单
        AdvertOrderDO advertOrderDO = null;
        try {
            advertOrderDO = serviceManager.getAdvertOrderDO(req.getConsumerId(), req.getOrderId(), null);
        } catch (TuiaException e) {
            logger.error("getAdvertOrderDO 异常", e);
            return;
        }
        OrderJsonVO vo = JSONObject.parseObject(advertOrderDO.getJson(), OrderJsonVO.class);
        //打印dsp广告或推啊广告日志
        if (rsp.getDspId() == null) {
            launchLog(req, rsp, advertOrderDO, vo);
        } else {
            //如果是dsp 查询广告扩展表  获取监控链接数据
            AdvertOrderExtDO orderExt = advertOrderDAO.getAdvertOrderExt(req.getConsumerId(), req.getOrderId());
            if (orderExt != null) {
                vo.setcUrl(orderExt.getClickUrl());
                vo.setsUrl(orderExt.getShowUrl());
            }
            //dsp 发券日志
            JSONObject log = buildAdxAdvertLaunchLog(req, rsp, adxAdvertPrice, vo);
            InnerExtTwoLog.launchLog(log);
        }

    }

    /**
     * 发券日志打印
     *
     * @param req
     * @param rsp
     * @param advertOrderDO
     * @param vo
     */
    private void launchLog(ObtainAdvertReq req, ObtainAdvertRsp rsp, AdvertOrderDO advertOrderDO, OrderJsonVO vo) {
        // 广告检查
        AdvertVO advertVO = advertMapCacheManager.getAdvertCache(rsp.getAdvertId());
        if (advertVO == null) {
            logger.error("advertVO is null, advertId = {}", rsp.getAdvertId());
            return;
        }
        AdvertPlan advertPlan = advertVO.getAdvertPlan();

        NewAppTest newAppTest = newMediaTestCheck(vo, req.getAppId(), rsp.getAdvertId());
        //20.添加发券次数统计
        advertRealDataService.incrLaunchAdvert(advertPlan.getAgentId(), advertPlan.getAccountId(), rsp.getAdvertId(), advertPlan.getAdvertPlanId(), advertVO.getEffectMainType(),
                newAppTest, req.getAppId(), vo.getSws());

        //组装日志
        ObtainAdvertReqLogExt reqLogExt = rsp.getReqLogExt();
        //发券日志打印
        SpmLog.log(reqLogExt, SpmType.SPM_LOG_LAUNCH, advertOrderDO.getId());
        // 虚拟广告位模拟请求发券标识
        if ("1".equals(vo.getImoa())) {
            // 虚拟广告位模拟发券
            StatLaunchJsonLog.imitateLog(reqLogExt);
            //可以替换，则打印另外类型的发券日志，否则正常打印
        } else if (rsp.getEncArpuResult() != null && rsp.getEncArpuResult() == CommonConstant.YES) {
            StatLaunchJsonLog.lowArpulog(reqLogExt);
        } else {
            StatLaunchJsonLog.log(reqLogExt);
        }
    }

    private NewAppTest newMediaTestCheck(OrderJsonVO vo, Long appId, Long advertId) {
        String newAppTestType = Optional.ofNullable(vo.getAt()).orElse(NewAppAdvertTradeDO.APP_TYPE_OLD.toString());
        NewAppTest newAppTest = getNewAppTest(newAppTestType, appId, advertId, vo.getAtn());
        Boolean checkNewAppTestToAdvert;
        try {
            DBTimeProfile.enter("finishBiz->newMediaTestCheck");
            checkNewAppTestToAdvert = checkNewAppTestToAdvert(newAppTest);
        } finally {
            DBTimeProfile.release();
        }
        if (!checkNewAppTestToAdvert) {
            logger.error("newMediaTestCheck:新媒体试投同一广告发到不同媒体");
        }
        return newAppTest;
    }

    /**
     * adx 广告发券 日志
     *
     * @param req
     * @param adxAdvertPrice
     * @return
     */
    private JSONObject buildAdxAdvertLaunchLog(ObtainAdvertReq req, ObtainAdvertRsp rsp, AdxAdvertPriceDto adxAdvertPrice, OrderJsonVO vo) {
        JSONObject log = new JSONObject();
        Map<String, String> extMap = Optional.ofNullable(req.getLogExtMap()).orElse(new HashMap<>());
        //每次请求 的唯一标识，推啊活动id
        log.put("rid", req.getOrderId());
        log.put("activity_id", req.getActivityId());
        log.put("activity_type", Optional.ofNullable(req.getActivitySceneType()).map(type -> type.toString()).orElse(PackagePlanConstants.INTERACTION_TYPE));
        log.put("order_id", rsp.getAdvertOrderId());
        log.put("consumer_id", req.getConsumerId());
        log.put("material_id", rsp.getMaterialId());

        //dsp_id,多个dsp_id按逗号分隔
        log.put("dsp_id", req.getDspId());
        //千次出劵单价 单位为分
        log.put("adx_fee", adxAdvertPrice.getDecryptPrice());
        //dsp 广告id
        log.put("advert_id", rsp.getAdvertId());
        log.put("promote_url", rsp.getPromoteUrl());
        //广告展示设备信息
        log.put("device_id", req.getDeviceId());

        //本地应用信息
        log.put("app_id", req.getAppId());
        //广告位id
        log.put("slot_id", req.getSlotId());

        //广告展现位次（互动广告中发券次序）
        log.put("put_index", vo.getPi());
        //可接受的广告类型
        log.put("ad_type", 1);
        //千次展示出价底价，单位为分;注意:价格为动态门槛(暂定默认2000)
        log.put("bid_floor", adxAdvertPrice.getDecryptPrice());

        //扣费方式
        log.put("fee_type", 1);
        //活动主体类型	1-杭州推啊，2-霍尔果斯推啊
        log.put("effective_main_type", 1);

        //素材ID
        log.put("sck_id", extMap.get(AdvertReqLogExtKeyConstant.SCK_ID));
        //插件Id
        log.put("plugin_id", extMap.get(AdvertReqLogExtKeyConstant.PLUGIN_ID));
        //插件类型
        log.put("plugin_type", extMap.get(AdvertReqLogExtKeyConstant.PLUGIN_TYPE));
        // 弹层ID
        log.put("layer_id", rsp.getWindId());

        //投放方式:仅投1 优投人工2 优投算法3 纯算法4 其他0
        log.put("subactivity_way", extMap.get(AdvertReqLogExtKeyConstant.SUB_ACTIVITY_WAY));
        // 分流标识
        log.put("sck_from_type", extMap.get(AdvertReqLogExtKeyConstant.SCK_FORM_TYPE));

        //广告类型：-1互动，4展示，6激励
        log.put("main_type", String.valueOf(AdvertReqLogExtKeyConstant.INTERACT));
        // 自定义活动工具id
        log.put("activity_page", extMap.get(AdvertReqLogExtKeyConstant.ACTIVITY_PAGE));
        //SDK版本
        log.put("sdk_version", extMap.get(AdvertReqLogExtKeyConstant.SDK_VERSION));

        //盘古一期活动测试
        log.put("pange_test", extMap.get(AdvertReqLogExtKeyConstant.PANGE_TEST));

        //盘古二期测试
        log.put("pg_resource_test", extMap.get(AdvertReqLogExtKeyConstant.PG_RESOURCE_TEST));

        //创意ID
        log.put("idea_id", extMap.get(AdvertReqLogExtKeyConstant.IDEAL_ID));

        log.put("dsm", extMap.get("dsm"));
        log.put("dsm2", extMap.get(AdvertReqLogExtKeyConstant.DSM2));
        log.put("dcm", extMap.get("dcm"));
        log.put("dpm", extMap.get("dpm"));

        //ADX全链路唯一标识
        log.put("adxr_id", extMap.get(AdvertReqLogExtKeyConstant.ADX_RID));

        //创意投放方式：0:依次投放,1:按比例投放
        log.put("put_type", extMap.get(AdvertReqLogExtKeyConstant.PUT_TYPE));

        //出价类型0:人工出价,1:算法出价
        log.put("price_type", 0);

        //dmp流量人群包列表
        log.put("dmp_package", extMap.get(AdvertReqLogExtKeyConstant.DMP_PACKAGE));
        //流量标记，响应插件ID
        log.put("act_conf_rsp_pluginId", extMap.get(AdvertReqLogExtKeyConstant.ACT_CONF_RSP_PLUGIN_ID));

        //投放类型 1-分流算法，2-配置大盘默认，3-配置活动，4-配置广告位定制，5-配置算法，6-盘古，7-算法2.0
        log.put("xyscj_pass_type", extMap.get(AdvertReqLogExtKeyConstant.XYSCJ_PASS_TYPE));

        //流量标记，响应插件投放次序
        log.put("xyscj_frequency", extMap.get(AdvertReqLogExtKeyConstant.XYSCJ_FREQUENCY));

        //城市
        log.put("city", vo.getCi());

        //地区
        log.put("region", rsp);
        //浏览器的 user agent string
        log.put("ua", req.getUa());

        //ip 地址
        log.put("ip", req.getIp());

        //MD5加密后的oaid设备标示号，32位小写
        log.put("oaid_md5", extMap.get(AdvertReqLogExtKeyConstant.OAID_MD5));

        //MD5加密后的imei设备标示号，32位小写
        log.put("imei_md5", extMap.get(AdvertReqLogExtKeyConstant.IMEI_MD5));

        //MD5加密后的idfa设备标示号，32位小写
        log.put("idfa_md5", extMap.get(AdvertReqLogExtKeyConstant.IDFA_MD5));

        //设备运营商名称，1-移动,2-联通,3-电信,4-unknow
        log.put("carrier", vo.getOpri());

        //设备厂商(如Apple)
        log.put("make", vo.getBn());
        //手机型号(如iPhone 5)
        log.put("model", vo.getMl());

        //操作系统(如iOS or Android)
        log.put("os", req.getOs());

        //操作系统版本(如7.1)
        log.put("osv", req.getOsVersion());
        //网络连接信息枚举：1-wifi,2-3G,3-4G,4-其它,5-ethernet,6-cellular
        log.put("connection_type", vo.getNtw());
        //device_type 设备类型枚举（如2-平板、1-手机）,无
        //api_version	请求 API的版本号默认:1.0.0.1

        //geohash 地理位置信息
        log.put("geohash", extMap.get(AdvertReqLogExtKeyConstant.GEOHASH));

        //标准出价：分/1000次
        log.put("par_price", extMap.get(AdvertReqLogExtKeyConstant.PAR_PRICE));

        //计费方式：0:cpc，1:cpm
        log.put("bill_type", extMap.get(AdvertReqLogExtKeyConstant.BILL_TYPE));

        //活动测试字段,活动大类
        log.put("activity_skin_type", extMap.get(AdvertReqLogExtKeyConstant.ACTIVITY_SKIN_TYPE));

        Map<String, String> extExtMap = Optional.ofNullable(req.getLogExtExpMap()).orElse(new HashMap<>());
        log.put("'act_main_title_td'", extExtMap.get("actMainTitleId"));
        log.put("'act_sub_title_td'", extExtMap.get("actSubTitleId"));
        log.put("'act_page_main_title_id'", extExtMap.get("actPageMainTitleId"));
        log.put("'act_page_sub_title_id'", extExtMap.get("actPageSubTitleId"));

        log.put("time", req.getTime());
        return log;
    }

    /**
     * 全链路打印域测试ABTEST实验评结果日志
     */
    private void putDomainTestResultLog(Map<String, String> logExtExpMap, DomainTestPlanDTO domainTestPlan) {
        // 无域测试不打印
        if (Objects.isNull(domainTestPlan)) {
            return;
        }

        // 未参与或者命中但无效的不打印
        if (!Objects.equals(domainTestPlan.getDomainTestResult(), 1)) {
            return;
        }

        List<ABResult.ABResultDTO> abResultDTOS = domainTestPlan.getAbResultDTOS();
        if (CollectionUtils.isEmpty(abResultDTOS)) {
            return;
        }

        try {
            String abtest = logExtExpMap.get(AdvertReqLogExtKeyConstant.ABTEST);
            if (StringUtils.isNotBlank(abtest)) {
                List<ABResult.ABResultDTO> abResultList = JSON.parseArray(abtest, ABResult.ABResultDTO.class);
                abResultList.addAll(abResultDTOS);
                logExtExpMap.put(AdvertReqLogExtKeyConstant.ABTEST, JSON.toJSONString(abResultList));
            } else {
                logExtExpMap.put(AdvertReqLogExtKeyConstant.ABTEST, JSON.toJSONString(abResultDTOS));
            }
        } catch (Exception e) {
            logger.warn("域测试打印实验平台结果异常", e);
        }
    }

    /**
     * 全链路打印素材测试ABTEST实验评结果日志
     */
    private void putABResultLog(Map<String, String> logExtExpMap, MaterialTestPlanDO materialTestPlanDO) {
        // 无素材测试不打印
        if (Objects.isNull(materialTestPlanDO)) {
            return;
        }

        // 未参与或者命中但无效的不打印
        if (!Objects.equals(materialTestPlanDO.getTestPlanMaterial(), true) || materialTestPlanDO.isHitByInvalid()) {
            return;
        }

        List<ABResult.ABResultDTO> abResultDTOS = materialTestPlanDO.getAbResultDTOS();
        if (CollectionUtils.isEmpty(abResultDTOS)) {
            return;
        }

        try {
            String abtest = logExtExpMap.get(AdvertReqLogExtKeyConstant.ABTEST);
            if (StringUtils.isNotBlank(abtest)) {
                List<ABResult.ABResultDTO> abResultList = JSON.parseArray(abtest, ABResult.ABResultDTO.class);
                abResultList.addAll(abResultDTOS);
                logExtExpMap.put(AdvertReqLogExtKeyConstant.ABTEST, JSON.toJSONString(abResultList));
            } else {
                logExtExpMap.put(AdvertReqLogExtKeyConstant.ABTEST, JSON.toJSONString(abResultDTOS));
            }
        } catch (Exception e) {
            logger.warn("素材测试打印实验平台结果异常", e);
        }
    }

    /**
     * 调用实验平台素材测试
     *
     * @param req           广告请求参数
     * @param rsp           广告响应参数
     * @param advertId      广告Id
     * @param advertPriceVO 广告价格配置
     * @param filterResult  过滤结果
     */
    private void doMaterialTest(ObtainAdvertReq req, ObtainAdvertRsp rsp, Long advertId, AdvertPriceVO advertPriceVO,
                                FilterResult filterResult, AdvertVO advertVO) {

        if (null == advertPriceVO.getMaterialTestPlanDO()) {
            abtestSkipReasonLog(req, ABTestSkipEnum.AB2001);
            abtestSkipReasonLog(req, ABTestSkipEnum.AB3001);
            return;
        }

        // 固定出券特殊判断
        if (canTest(req, filterResult, advertPriceVO)) {
            abtestSkipReasonLog(req, ABTestSkipEnum.AB2009);
            abtestSkipReasonLog(req, ABTestSkipEnum.AB3009);
            return;
        }

        MaterialTestPlanDO materialTestPlan = advertPriceVO.getMaterialTestPlanDO();
        abtestSkipReasonLog(req, materialTestPlan.getAbTestSkip());

        if (!Optional.ofNullable(materialTestPlan.getTestPlanMaterial()).orElse(false)) {
            abtestSkipReasonLog(req, ABTestSkipEnum.AB2001);
        }

        DomainTestPlanDTO domainTestPlan = new DomainTestPlanDTO();
        advertPriceVO.setDomainTestPlan(domainTestPlan);

        // 组装实验平台分流请求参数
        Long orientId = Optional.ofNullable(advertPriceVO.getOriginalOrientationId()).orElse(advertPriceVO.getAdvertOrientationPackageId());
        Map<String, Object> extraMap = new HashMap<>(1);
        extraMap.put("orientId", orientId);

        // 域测试（同时对素材测试和落地页测试进行UV分流）
        ABResult abResult = flowRouterProxyService.routeFlowWithoutLog(req, ABTestLayerCodeEnum.DOMAIN_TEST, advertId, extraMap);
        if (CollectionUtils.isEmpty(abResult.getAbResultList())) {
            abtestSkipReasonLog(req, ABTestSkipEnum.AB2002);
            abtestSkipReasonLog(req, ABTestSkipEnum.AB3002);
            domainTestPlan.setDomainTestResult(MISS.getType());
            return;
        }

        Map<String, String> arguments = abResult.getArguments();
        Integer domainStatus = Integer.valueOf(arguments.getOrDefault("domainStatus", "0"));
        Long planId = Optional.ofNullable(arguments.get("planId")).map(Long::valueOf).orElse(null);
        Long testMaterialId = Optional.ofNullable(arguments.get("materialId")).map(Long::valueOf).orElse(null);

        // 设置域测试实验结果
        domainTestPlan.setDomainTestResult(domainStatus);

        // 域测试命中的情况下校验素材和落地页
        if (isDomainStatusHit(domainStatus)) {
            abtestSkipReasonLog(req, ABTestSkipEnum.AB2008);

            // 域测试命中的素材校验是否可投
            if (null != testMaterialId) {
                // 校验是否为有效素材
                if (CollectionUtils.isNotEmpty(materialTestPlan.getValidMaterialIds()) && materialTestPlan.getValidMaterialIds().contains(testMaterialId)) {
                    String promoteUrl = arguments.get("promoteUrl");
                    Long promoteId = Long.valueOf(arguments.getOrDefault("promoteId", "0"));

                    // 校验落地页是否为空
                    if (null == promoteUrl) {
                        domainTestPlan.setDomainTestResult(HIT_BUT_INVALID_PROMOTE.getType());
                        abtestSkipReasonLog(req, ABTestSkipEnum.AB3007);
                        return;
                    }

                    // 校验落地页是否审核通过
                    Set<Long> promoteIdSet = advertPromoteTestCacheService.getLandPageRepoSet(advertId);
                    if (!promoteIdSet.contains(promoteId)) {
                        domainTestPlan.setDomainTestResult(HIT_BUT_INVALID_PROMOTE.getType());
                        abtestSkipReasonLog(req, ABTestSkipEnum.AB3008);
                        return;
                    }

                    // 校验素材和落地页的关联关系
                    Set<String> promoteUrlSet = advertPromoteTestCacheService.getMaterialPromoteTestSet(testMaterialId);
                    if (!promoteUrlSet.contains(promoteUrl)) {
                        domainTestPlan.setDomainTestResult(HIT_BUT_NO_RELATION.getType());
                        abtestSkipReasonLog(req, ABTestSkipEnum.AB3006);
                        return;
                    }

                    //校验落地页标签是否屏蔽
                    if (checkUrlPromoteTag(advertId, 4, promoteUrl, filterResult, advertVO)) {
                        domainTestPlan.setDomainTestResult(HIT_BUT_INVALID_PROMOTE.getType());
                        abtestSkipReasonLog(req, ABTestSkipEnum.AB3010);
                        return;
                    }

                    // 校验所有的域测试实验落地页，是否有效且是否爱奇艺流量
                    if (!domainTestService.isPlanValid(planId, advertId, req, filterResult)) {
                        domainTestPlan.setDomainTestResult(HIT_BUT_INVALID_PROMOTE.getType());
                        abtestSkipReasonLog(req, ABTestSkipEnum.AB3005);
                        return;
                    }

                    domainTestPlan.setPlanId(planId);
                    domainTestPlan.setPromoteUrl(promoteUrl);
                    domainTestPlan.setAbResultDTOS(mergeABResult(abResult.getAbResultList()));

                    // 替换广告响应rsp中的素材ID
                    rsp.setMaterialId(testMaterialId);
                } else {
                    // 命中但是无效素材打标
                    domainTestPlan.setDomainTestResult(HIT_BUT_INVALID_MATERIAL.getType());
                    abtestSkipReasonLog(req, ABTestSkipEnum.AB3003);
                }
            }
            return;
        }

        // 判断是否进行素材测试
        if (!Optional.ofNullable(materialTestPlan.getTestPlanMaterial()).orElse(false)) {
            return;
        }

        // 未命中域，解析实验结果并处理
        String layerCodeMaterialTest = flowRouterProxyService.getLayerCode(ABTestLayerCodeEnum.MATERIAL_TEST);
        ABResult.ABResultDTO abResultDTO = abResult.getAbResultList().stream()
                .filter(s -> Objects.equals(s.getLayerCode(), layerCodeMaterialTest))
                .findFirst().orElse(null);
        if (null == abResultDTO) {
            abtestSkipReasonLog(req, ABTestSkipEnum.AB2002);
            return;
        }

        // 设置素材测试的ABTest结果
        materialTestPlan.setAbResultDTOS(Collections.singletonList(abResultDTO));

        // 如果命中测试素材，进行有效素材的校验，通过打标
        if (null != testMaterialId) {
            // 校验是否为有效素材
            if (materialTestPlan.getValidMaterialIds().contains(testMaterialId)) {
                materialTestPlan.setTestResult(true);
                materialTestPlan.setMaterialId(testMaterialId);

                materialTestPlan.setPlanId(planId);

                // 替换广告响应rsp中的素材ID
                rsp.setMaterialId(testMaterialId);
            } else {
                // 命中但是无效素材打标
                materialTestPlan.setHitByInvalid(true);
                abtestSkipReasonLog(req, ABTestSkipEnum.AB2003);
            }
        }
    }

    /**
     * 判断是否命中链接落地页标签屏蔽
     *
     * @param advertId
     * @param promoteUrl
     * @param filterResult
     * @return
     */
    private boolean checkUrlPromoteTag(Long advertId, Integer urlType, String promoteUrl, FilterResult filterResult, AdvertVO advertVO) {
        try {

            AdvertPlan advertPlan = advertVO.getAdvertPlan();
            MediaList mediaWhiteList = filterResult.getMediaWhiteList();
            if (mediaWhiteList != null && mediaWhiteList.isAdvertInList(advertId, advertPlan.getAccountId())) {
                return false;
            }

            //获取屏蔽落地页标签
            AdvBannedTag advQueryBannedTag = filterResult.getAdvBannedTag();
            if (advQueryBannedTag == null) {
                return false;
            }

            Set<String> shieldPromoteTagSet = advQueryBannedTag.getPromoteUrlTags();
            if (CollectionUtils.isEmpty(shieldPromoteTagSet)) {
                return false;
            }

            //获取URL落地页标签
            Set<String> promoteTags = new HashSet();
            AdvertPromoteTestDO dto = makeTagCacheService.getAdvertPromoteTestTagByKey(advertId, urlType, promoteUrl);
            if (dto != null && CollectionUtils.isNotEmpty(dto.getPromoteTags())) {
                promoteTags.addAll(dto.getPromoteTags());
                if (dto.getSourceId() != null && dto.getSourceType() != null) {
                    List<String> makeTags = makeTagCacheService.getMakeTagByKey(dto.getSourceId(), dto.getSourceType());
                    if (CollectionUtils.isNotEmpty(makeTags)) {
                        promoteTags.addAll(makeTags);
                    }
                }
            }
            if (CollectionUtils.isEmpty(promoteTags)) {
                return false;
            }
            return shieldPromoteTagSet.stream().anyMatch(promoteTags::contains);
        } catch (Exception e) {
            logger.error("url 落地页标签屏蔽error");
        }
        return false;
    }

    /**
     * 能否进行测试
     *
     * @return
     */
    private boolean canTest(ObtainAdvertReq req, FilterResult filterResult, AdvertPriceVO advertPriceVO) {

        List<Integer> activityTypeExt = req.getActivityTypeExt();
        if (CollectionUtils.isNotEmpty(activityTypeExt) && activityTypeExt.contains(12)) {
            Map<String, String> idMapByKeyStr = null;
            try {
                idMapByKeyStr = apolloPanGuService.getIdMapByKeyStr("tuia-engine.orientId.joinnum");
            } catch (Exception e) {
                logger.warn("盘古配置获取异常", e);
            }

            if (MapUtils.isNotEmpty(idMapByKeyStr)) {
                Long orientId = Optional.ofNullable(advertPriceVO.getOriginalOrientationId()).orElse(advertPriceVO.getAdvertOrientationPackageId());
                String value = idMapByKeyStr.get(String.valueOf(orientId));

                if (StringUtils.isNotBlank(value)) {
                    List<String> values = Arrays.asList(value.trim().split(","));
                    if (values.contains(String.valueOf(filterResult.getPutIndex()))) {
                        return true;
                    }
                }
            }
        }

        return false;
    }

    /**
     * 不进行ABTest的原因记录logExtMap日志
     */
    private void abtestSkipReasonLog(ObtainAdvertReq req, ABTestSkipEnum skipReason) {
        if (null == skipReason) {
            return;
        }

        String abtestSkip = req.getLogExtMap().get(AdvertReqLogExtKeyConstant.ABTEST_SKIP);
        JSONObject jo = Optional.ofNullable(abtestSkip).map(s -> JSON.parseObject(s, JSONObject.class)).orElse(new JSONObject());
        jo.put(skipReason.getCategory(), skipReason.getCode());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ABTEST_SKIP, jo.toJSONString());
    }

    /**
     * 合并abtest结果中的域测试的层code（为了日志打印）
     */
    private List<ABResult.ABResultDTO> mergeABResult(List<ABResult.ABResultDTO> abResultList) {
        if (CollectionUtils.isEmpty(abResultList)) {
            return abResultList;
        }

        Map<String, Integer> map = new HashMap<>(abResultList.size());
        List<ABResult.ABResultDTO> list = new ArrayList<>();

        for (int i = 0; i < abResultList.size(); i++) {
            ABResult.ABResultDTO abResultDTO = abResultList.get(i);
            String key = abResultDTO.getPlanId() + "-" + abResultDTO.getGroupId();
            if (map.containsKey(key)) {
                ABResult.ABResultDTO tmpABResult = abResultList.get(map.get(key));
                tmpABResult.setLayerCode(tmpABResult.getLayerCode() + "," + abResultDTO.getLayerCode());
            } else {
                list.add(abResultDTO);
                map.put(key, i);
            }
        }
        return list;
    }
}
