package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.domain.dataobject.ConsumerInteractiveRecordDO;
import cn.com.duiba.tuia.service.AdvertGroupService;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年06月24日 17:34
 * @descript:
 * @version: 1.0
 */
@Service
public class AdvertGroupServiceImpl implements AdvertGroupService {

    private static final Logger logger = LoggerFactory.getLogger(AdvertGroupServiceImpl.class);

    @Override
    public void filterConsumeReceiveInfo(List<Long> receiveAdvertIds, Map<Long, Integer> limitAdvertTodayMap, Set<Long> testMaterialAdvertIds, List<ConsumerInteractiveRecordDO> todayConsumeList) {
        try {
            DBTimeProfile.enter("EngineServiceImpl.filterConsumeReceiveInfo");

            if (CollectionUtils.isEmpty(todayConsumeList)) {
                return;
            }

            for (ConsumerInteractiveRecordDO consumerVO : todayConsumeList) {
                // 设置用户参与的素材测试的广告
                if (isTestMaterialAdvert(getJsonObject(consumerVO))) {
                    testMaterialAdvertIds.add(consumerVO.getAdvertId());
                }

                //该广告用户当天已经领取过的次数
                Integer todayConsumeReceiveCount = limitAdvertTodayMap.get(consumerVO.getAdvertId());

                limitAdvertTodayMap.put(consumerVO.getAdvertId(), todayConsumeReceiveCount == null ? 1 : ++todayConsumeReceiveCount);
            }
        } finally {
            DBTimeProfile.release();
        }
    }

    private static JSONObject getJsonObject(ConsumerInteractiveRecordDO consumerVO) {
        if (StringUtils.isBlank(consumerVO.getJson())) {
            return new JSONObject();
        }
        try {
            return JSONObject.parseObject(consumerVO.getJson());
        } catch (Exception e) {
            logger.info("用户记录扩展字段解析错误, id={}", consumerVO.getId(), e);
            return new JSONObject();
        }
    }

    private static Boolean isTestMaterialAdvert(JSONObject jsonObject) {
        return jsonObject.containsKey("tmaId");
    }
}
