package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.cache.RedisKeys;
import cn.com.duiba.tuia.service.AdvertInvalidHandleService;
import cn.com.tuia.advert.cache.CacheKeyTool;
import cn.com.tuia.advert.enums.AdvertInvalidReasonEnum;
import cn.com.tuia.advert.message.RedisMessageChannel;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * Created by huangch on 2018/1/3 19:10
 * description:
 *
 * @since JDK 1.6
 */
@Service
public class AdvertInvalidHandleServiceImpl implements AdvertInvalidHandleService {

    private static Logger logger = LoggerFactory.getLogger(AdvertInvalidHandleServiceImpl.class);
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private RedisTemplate<String, String> redisTemplate;

    @Override
    public void sendBudgetNotEnoughDingNotice(Long advertId, Long pkgId, String curDate) {
        try {
            String key = CacheKeyTool.getCacheKey(RedisKeys.K29, curDate, advertId, pkgId);
            if (stringRedisTemplate.opsForValue().setIfAbsent(key, "1")) {
                stringRedisTemplate.expire(key, 60, TimeUnit.SECONDS);

                //发送无效广告消息
                this.publishInvalidAdvertMsg(advertId, AdvertInvalidReasonEnum.ORIENT_PKG_BUDGET_NOT_ENOUGH.getType());
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    //发送消息给center处理，发送钉钉通知给AE
    public void publishInvalidAdvertMsg(Long advertId, Integer validStatus) {
        int invalidType = AdvertInvalidReasonEnum.getInvalidTypeByValidStatus(validStatus);
        logger.info("send publishInvalidAdvertMsg, the advertId=[{}],invalidType=[{}]", advertId, invalidType);

        Map<String, Object> bodyMap = Maps.newHashMapWithExpectedSize(2);
        bodyMap.put("advertId", advertId);
        bodyMap.put("type", invalidType);
        redisTemplate.convertAndSend(RedisMessageChannel.SEND_INVALID_ADVERT_DING_NOTICE.getChannel(), JSON.toJSONString(bodyMap));
    }
}
