package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DeviceTagDto;
import cn.com.duiba.bigdata.online.service.api.dto.DeviceFilterDto;
import cn.com.duiba.bigdata.online.service.api.form.DeviceResourceForm;
import cn.com.duiba.bigdata.online.service.api.remoteservice.RemoteDeviceResourceService;
import cn.com.duiba.nezha.engine.api.dto.ConsumerDto;
import cn.com.duiba.nezha.engine.api.dto.SupportAdvertInfoDto;
import cn.com.duiba.tuia.api.TuiaMediaClientService;
import cn.com.duiba.tuia.cache.*;
import cn.com.duiba.tuia.constants.AdvertConstants;
import cn.com.duiba.tuia.constants.AdvertReqLogExtKeyConstant;
import cn.com.duiba.tuia.constants.PackagePlanConstants;
import cn.com.duiba.tuia.constants.ApolloPanGuConstant;
import cn.com.duiba.tuia.constants.TrusteeshipConstants;
import cn.com.duiba.tuia.domain.dataobject.AdvertFilterKeywordDO;
import cn.com.duiba.tuia.domain.dataobject.AdvertNewTradeDO;
import cn.com.duiba.tuia.domain.dataobject.AdvertSimilarTradeDO;
import cn.com.duiba.tuia.domain.dataobject.ConsumerInteractiveRecordDO;
import cn.com.duiba.tuia.domain.flow.MediaSlotListVO;
import cn.com.duiba.tuia.domain.flow.SlotChooseAdverttVO;
import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.domain.vo.AdvertFilterVO;
import cn.com.duiba.tuia.domain.vo.AdvertPriceVO;
import cn.com.duiba.tuia.domain.vo.ConsumerRecordJsonVO;
import cn.com.duiba.tuia.domain.vo.SimilarAdvertLogVO;
import cn.com.duiba.tuia.enums.*;
import cn.com.duiba.tuia.enums.PlatformTypeEnum;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.filter.service.TradeTagRuleFilterService;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.com.duiba.tuia.service.*;
import cn.com.duiba.tuia.service.buildparam.MediaSlotListService;
import cn.com.duiba.tuia.service.buildparam.SlotChooseAdvertService;
import cn.com.duiba.tuia.ssp.center.api.remote.advertselect.dto.advert.AdvertAndTagSelected4AdRsp;
import cn.com.duiba.tuia.ssp.center.api.remote.advertselect.dto.media.req.AuditedAdvertAndMaterial4AdDto;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.duiba.tuia.tool.StringTool;
import cn.com.duiba.tuia.utils.ActPreUtils;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.tuia.advert.cache.CacheKeyTool;
import cn.com.tuia.advert.cache.RedisCommonKeys;
import cn.com.tuia.advert.constants.CommonConstant;
import cn.com.tuia.advert.constants.PotentionalAdvertConstant;
import cn.com.tuia.advert.constants.SystemConfigKeyConstant;
import cn.com.tuia.advert.enums.*;
import cn.com.tuia.advert.enums.AdvertSubtypeEnum;
import cn.com.tuia.advert.enums.userinfo.SexEnum;
import cn.com.tuia.advert.enums.userinfo.WorkStateEnum;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static java.util.stream.Collectors.groupingBy;
import static java.util.stream.Collectors.toList;

/**
 * Created by hujinliang on 2017/8/11.
 */
@Service
public class AdvertPreFilterServiceImpl implements AdvertPreFilterService {

    private static final Logger logger = LoggerFactory.getLogger(AdvertPreFilterServiceImpl.class);

    private static final String[] SEX_INFO = {"male", "female"};
    private static final String[] WORK_INFO = {"work", "student", "workother"};

    private static final String SEPARATOR = "-";

    private static final String COMMA_SEPARATOR = ",";

    private static final Long MARKET_APP_ID = -1L;

    //提升竞价的广告权重倍数
    private static final BigDecimal IMPROVE_WEIGHT_MULTIPLE = BigDecimal.valueOf(1.2d);
    //提升了广告竞价能力的状态
    private static final int IMPROVE_BIDDING_STATUS = 1;

    private static final Integer OPEN_POTENTIONAL = 1;

    private static final Integer NOT_OPEN_POTENTIONAL = 0;

    public static final String CPC_AUTOMATIC_BIDDING_CONTROL_OPEN = "1";
    public static final String CPC_AUTOMATIC_BIDDING_CONTROL_CLOSE = "0";

    public static final Integer AUTO_BIDDING_WHITELIST_NO = 0;
    public static final Integer AUTO_BIDDING_WHITELIST_YES = 1;

    @Autowired
    private MultipleExposureService multipleExposureService;
    @Autowired
    private AdvertGroupService advertGroupService;
    @Autowired
    private ServiceManager serviceManager;
    @Autowired
    private TuiaMediaClientService tuiaMediaClientService;

    @Autowired
    private CommonService commonService;

    @Autowired
    private AdvertMaterialRecommendService advertMaterialRecommendService;

    @Autowired
    private AdvertSimilarTradeCache advertSimilarTradeCache;

    @Autowired
    private AdvertPackageAppAdjustFeeCacheService adjustFeeCacheService;

    @Autowired
    private AppImproveBiddingAdvertCache appImproveBiddingAdvertCache;

    @Autowired
    private LowArpuCacheService lowArpuCacheService;

    @Autowired
    private ConsumerRecordSerivce consumerRecordSerivce;
    @Autowired
    private ConsumerService consumerService;
    @Autowired
    private AdvertQueryService advertQueryService;

    @Value("${engine.hystrix.esquery.coresize}")
    private Integer coresize;
    @Value("${engine.hystrix.esquery.maxsize}")
    private Integer maxsize;
    @Value("${engine.hystrix.esquery.queuesize}")
    private Integer queuesize;
    @Value("${engine.hystrix.esquery.timeout}")
    private Integer timeout;
    @Resource
    protected StringRedisTemplate stringRedisTemplate;
    @Autowired
    private AdvertRealDataService advertRealDataService;

    @Autowired
    private TradeTagRuleFilterService tagRuleFilterService;
    @Autowired
    private AdvertOrientationService advertOrientationService;

    @Autowired
    private NewAppTestCacheService newAppTestCacheService;

    @Autowired
    private TradeAppRepeatLunchService tradeAppRepeatLunchService;

    @Autowired
    private AdvertTradePackageService advertTradePackageService;

    @Autowired
    private MediaCacheService mediaCacheService;

    @Autowired
    private DmpTagDataService dmpTagDataService;

    @Autowired
    private MediaSlotListService mediaSlotListService;

    @Reference(timeout = 15)
    private RemoteDeviceResourceService remoteDeviceResourceService;
    @Autowired
    private AdvertSupportPlanCacheManager advertSupportPlanCacheManager;
    @Autowired
    private RepeatAdvertTestService repeatAdvertTestService;
    @Autowired
    private AdvertKeywordCacheService advertKeywordCacheService;
    @Autowired
    private ApolloPanGuService apolloPanGuService;
    @Autowired
    private SlotChooseAdvertService slotChooseAdvertService;
    @Autowired
    private AdvertNewTradeCacheService advertNewTradeCacheService;

    @Override
    public AdvQueryParam buildAdvQueryParam(AdvQueryParam advQueryParam, ObtainAdvertReq req, ObtainAdvertRsp rsp, ShieldStrategyVO shieldStrategyVO,
                                            List<ConsumerInteractiveRecordDO> consumerVOList, List<Long> receiveAdvertIds,
                                            ConsumerDto consumerDto, FilterResult filterResult, DeviceTagDto deviceTagDto, Map<String, String> newUserDmpTagsMap) throws Throwable {
        try {
            DBTimeProfile.enter("buildAdvQueryParam");
            // 1.基础类型转换，包含了媒体互选的功能
            CatUtils.executeInCatTransaction(() -> {
                buildDirectAdvQueryParam(advQueryParam, req, shieldStrategyVO);
                return null;
            }, "buildAdvQueryParam", "buildDirectAdvQueryParam");


            // 2.查询用户今日中券次数
            List<ConsumerInteractiveRecordDO> todayConsumeList = filterResult.getTodayConsumeList();
            Integer consumerJionNum = todayConsumeList.size() + 1;
            advQueryParam.setJoinNum(consumerJionNum.longValue());
            //将用户的发券次序放入req的extMap里
            putActivityPutIndex(req, todayConsumeList);

            // [重复发券测试需求]如果测试组间隔小于当天已经过去的时间，则限制同广告组领取的时间范围为测试组时间间隔而非当天
            final List<ConsumerInteractiveRecordDO> repeatTestConsumeList;
            if (repeatAdvertTestService.isRepeatIntervalLessThanTodayHours(advQueryParam.getRepeatTestGroup())) {
                repeatTestConsumeList = filterResult.getRepeatTestConsumeList();
            } else {
                repeatTestConsumeList = todayConsumeList;
            }

            // 3.设置已领取素材
            List<Long> receiveMaterial = CatUtils.executeInCatTransaction(() -> advertMaterialRecommendService.getReceiveMaterial(repeatTestConsumeList), "buildAdvQueryParam", "getReceiveMaterial");
            advQueryParam.setReceiveMaterials(receiveMaterial);

            // 4.当天用户广告对应的领取的次数
            Map<Long, Integer> limitAdvertTodayMap = Maps.newHashMap();

            // 两天内用户参与的素材测试的广告
            Set<Long/*advertId*/> testMaterialAdvertIds = Sets.newHashSet();

            //当天用户领取的广告次数和同广告组领取限制过滤组装
            List<Long> finalReceiveAdvertIds = receiveAdvertIds;
            CatUtils.executeInCatTransaction(() -> {
                advertGroupService.filterConsumeReceiveInfo(finalReceiveAdvertIds, limitAdvertTodayMap, testMaterialAdvertIds, repeatTestConsumeList);
                return null;
            }, "buildAdvQueryParam", "getReceiveMaterial");

            advQueryParam.setLimitAdvertTodayMap(limitAdvertTodayMap);

            // 设置两天内用户参与的素材测试的广告
            filterResult.setTestMaterialAdvertIdSet(testMaterialAdvertIds);

            // 6.重复曝光过滤
            List<Long> multipleExposureIds = CatUtils.executeInCatTransaction(() -> multipleExposureService.filter(req.getConsumerId(), finalReceiveAdvertIds, limitAdvertTodayMap), "buildAdvQueryParam", "multipleExposureService#filter");
            advQueryParam.setMultipleExposureIds(multipleExposureIds);

            // 7.已经显示过的广告
            receiveAdvertIds = receiveAdvertIds.stream().filter(receiveAdvertId -> !multipleExposureIds.contains(receiveAdvertId)).collect(toList());
            advQueryParam.setReceiveIds(Sets.newHashSet(receiveAdvertIds));//最后去重

            //用户对应相似广告接受度人群日志
            List<SimilarAdvertLogVO> similarAdvertLogList = Lists.newArrayList();
            // 9.用户兴趣点(不在ES里面过滤,放到后面过滤)
            List<String> userInterest = CatUtils.executeInCatTransaction(() -> getUserInterest(consumerDto, consumerVOList, similarAdvertLogList, req.getDeviceId(), filterResult, req, deviceTagDto, newUserDmpTagsMap), "buildAdvQueryParam", "getUserInterestMethod");
            advQueryParam.setUserInterest(userInterest);
            advQueryParam.setSimilarAdvertLogList(similarAdvertLogList);

            //9.1 设置app安装的应用列表、用户基础标签列表、短信列表
            Map<String, String> reqMap = Optional.ofNullable(req.getLogExtMap()).orElse(new HashMap<>());
            String imeiMd5 = reqMap.get(AdvertReqLogExtKeyConstant.IMEI_MD5);
            String oaidMd5 = reqMap.get(AdvertReqLogExtKeyConstant.OAID_MD5);
            CatUtils.executeInCatTransaction(() -> getDeviceInstallApps(req.getDeviceId(), consumerDto, imeiMd5, oaidMd5), "buildAdvQueryParam", "getDeviceInstallApps");
            Joiner joiner = Joiner.on(",");
            if (CollectionUtils.isNotEmpty(consumerDto.getUserTagList())) {
                advQueryParam.setImeiBasicTags(joiner.join(consumerDto.getUserTagList()));
            }

            Integer personCrowdType = req.getPersonCrowdType();
            Integer personCrowdValue = req.getPersonCrowdValue();
            // 10.处理用户属性的性别
            if (Objects.equals(personCrowdType, UserResourceEnum.SEX.getCode()) && SexEnum.isCorrect(personCrowdValue)) {
                //当落地页传来的数据指定性别 则以传过来数据为主  这里要求强匹配
                String sex = SexEnum.getSexByCode(personCrowdValue).orElse(null);
                //这里允许设置用户性别为null
                advQueryParam.setSex(sex);
            } else {
                //当落地页没有传过来有效的性别信息的时候 走之前的逻辑
                List<String> sexList = advQueryParam.getUserInterest().stream().filter(item -> Arrays.asList(SEX_INFO).contains(item)).collect(toList());
                if (!CollectionUtils.isEmpty(sexList)) {
                    //不为空的话，里面就一个值，取第一个即可
                    advQueryParam.setSex(sexList.get(0));
                }
            }

            // 11.设置和工作状态
            if (Objects.equals(personCrowdType, UserResourceEnum.WORK_STATE.getCode())) {
                WorkStateEnum workStateEnum = WorkStateEnum.getByCode(personCrowdValue);
                advQueryParam.setWorkState(Lists.newArrayList(workStateEnum.getDesc()));
            } else {
                //当没有指定工作状态的时候 走先前的工作状态处理逻辑
                List<String> workList = advQueryParam.getUserInterest().stream().filter(item -> Arrays.asList(WORK_INFO).contains(item)).collect(toList());
                if (!CollectionUtils.isEmpty(workList)) {
                    advQueryParam.setWorkState(workList);
                } else {
                    advQueryParam.setWorkState(Lists.newArrayList(WorkStateEnum.WORKOTHER.getDesc()));
                }
            }


            // 活动类型
            advQueryParam.setActivityType(Optional.ofNullable(req.getActivitySceneType()).map(type -> type.toString()).orElse("0"));
            //广告投放类型
            advQueryParam.setAdType(req.getAdType());

            //12.如果要替换低arpu值的券才获取数据
            if (req.getReplaceLowArpu() == CommonConstant.YES) {
                CatUtils.executeInCatTransaction(() -> {
                    putLowArpuParam(advQueryParam);
                    return null;
                }, "buildAdvQueryParam", "putLowArpuParam");
            }
            //13.行业标签过滤打标
            CatUtils.executeInCatTransaction(() -> {
                tradeAppRepeatLunchService.buildTradeAppRepeatLunchType(filterResult);
                return null;
            }, "buildAdvQueryParam", "buildTradeAppRepeatLunchType");
            advQueryParam.setShieldMaterialTags(filterResult.getShieldMaterialTags());

            // 14.活动id
            advQueryParam.setActivityId(req.getActivityId());

            //构建新媒体测试需要排除的配置
            Map<Long, List<Long>> newAppNotTestAdvertConfig = CatUtils.executeInCatTransaction(() -> getNewAppNotTestAdvertConfig(), "buildAdvQueryParam", "getNewAppNotTestAdvertConfig");
            advQueryParam.setNewAppNotTestAdvertMap(newAppNotTestAdvertConfig);

            //15.设置活动需要素材类型
            advQueryParam.setActivityMaterialType(req.getActivityMaterialType());

            //16.流量是否带有设备号
            advQueryParam.setHaveDevice(haveDevice(reqMap));

            // 17. 设置活动预发券参数
            advQueryParam.setActPre(ActPreUtils.isActPre(req));
            advQueryParam.setActPreNewTradeTagName(req.getActPreNewTradeTagName());

            //18.如果互选广告不进行dsp 竞价
            if (advQueryParam.isElectApp()) {
                rsp.setDspCompare(false);
            }
            //设置禁用标签
            rsp.setShieldBannedTags(advQueryParam.getBannedTags());
            rsp.setShieldMaterialTags(advQueryParam.getShieldMaterialTags());

            // 设置媒体关键词过滤参数
            AdvertFilterKeywordDO advertFilterKeywordDO = advertKeywordCacheService.getShieldKeywordListBySlotId(req.getSlotId());
            advQueryParam.setAdvertFilterKeywordDO(advertFilterKeywordDO);
            filterResult.setAdvertFilterKeywordDO(advertFilterKeywordDO);
            filterResult.setMediaWhiteList(advQueryParam.getMediaWhiteList());
            return advQueryParam;
        } finally {
            DBTimeProfile.release();
        }
    }

    private boolean haveDevice(Map<String, String> logExtExpMap){
        if (StringUtils.isNotBlank(MapUtils.getString(logExtExpMap, "imei"))
        || StringUtils.isNotBlank(MapUtils.getString(logExtExpMap, "imeiMd5"))
        || StringUtils.isNotBlank(MapUtils.getString(logExtExpMap, "idfa"))
        || StringUtils.isNotBlank(MapUtils.getString(logExtExpMap, "idfaMd5"))
        || StringUtils.isNotBlank(MapUtils.getString(logExtExpMap, "oaid"))
        || StringUtils.isNotBlank(MapUtils.getString(logExtExpMap, "oaidMd5"))) {
            return true;
        }

       return false;
    }

    /**
     * 设置app安装的应用列表、用户基础标签列表、短信列表
     *
     * @param deviceId
     * @param consumerDto
     * @param imeiMd5
     * @return
     */
    private ConsumerDto getDeviceInstallApps(String deviceId, ConsumerDto consumerDto, String imeiMd5,String oaidMd5) {
        consumerDto.setDeviceId(deviceId);
        return consumerDto;
    }

    private void putActivityPutIndex(ObtainAdvertReq req,
                                     List<ConsumerInteractiveRecordDO> todayConsumeList) {
        Map<String, String> logExtMap = req.getLogExtMap();
        try {
            List<ConsumerRecordJsonVO> recordJsonVOS = todayConsumeList.stream()
                    .filter(record -> Objects.equals(record.getActivityId(), req.getActivityId()))
                    .filter(record -> record.getJson() != null)
                    .map(ConsumerInteractiveRecordDO::getJson)
                    .map(json -> JSON.parseObject(json, ConsumerRecordJsonVO.class))
                    .filter(jsonVo -> Objects.equals(jsonVo.getSlotId(), req.getSlotId()))
                    .collect(Collectors.toList());
            if (logExtMap != null) {
                Long activityPutIndex = CollectionUtils.isNotEmpty(recordJsonVOS) ?
                        recordJsonVOS.size() + 1 :
                        1L;
                logExtMap.put(AdvertReqLogExtKeyConstant.ACTIVITY_PUT_INDEX,
                        String.valueOf(activityPutIndex));
            }
        } catch (Exception ex) {
            logger.error("PutActivityPutIndex error:{}", req, ex);
        }
    }

    /**
     * 低arpu替换
     *
     * @param advQueryParam
     */
    private void putLowArpuParam(AdvQueryParam advQueryParam) {
        //获取广告主第一次发券时间
        advQueryParam.setAccountFirstLaunchDate(lowArpuCacheService.getAdvertiserFirstLaunchFromCache());
        //获取低arpu值的白名单广告主和广告
        advQueryParam.setLowArpuWhiteMap(lowArpuCacheService.getLowArpuWhiteFromCache());
        //获取系统配置的低arpu值阈值
        advQueryParam.setLowArpuThresholdValue(getConfigLowArpuValue());
    }

    @Override
    public AdvQueryParam secondBuildAdvQueryParam(AdvQueryParam advQueryParam, ObtainAdvertReq req, FilterResult filterResult) throws TuiaException {
        try {
            DBTimeProfile.enter("secondBuildAdvQueryParam");

            // 用户今日中券次数
            List<ConsumerInteractiveRecordDO> todayConsumeList = filterResult.getTodayConsumeList();

            //单用户广告主发券上限设置
            String limitAccountType = ifLimitAccount(req, todayConsumeList);
            if (AccountLimitTypeEnum.IOS_LIMIT.getCode().equals(limitAccountType) || AccountLimitTypeEnum.ANDROID_LIMIT.getCode().equals(limitAccountType)) {
                advQueryParam.setLimitAccountIds(consumerService.getLimitAccountIds(todayConsumeList));
            }
            buildLimitAccountIdType(req, limitAccountType);

            return advQueryParam;
        } finally {
            DBTimeProfile.release();
        }
    }

    @SuppressWarnings(value = "unchecked")
    private Map<Long, List<Long>> getNewAppNotTestAdvertConfig() {
        try {
            String newAppNotTestPackageStr = serviceManager.getStrValue(SystemConfigKeyConstant.TUIA_NEW_APP_NOT_TEST_ORIENTATION);
            if (StringUtils.isBlank(newAppNotTestPackageStr)) {
                return Collections.emptyMap();
            }
            Map newAppNotTestPackageMap = JSON.parseObject(newAppNotTestPackageStr, Map.class);

            Map<Long, List<Long>> resultMap = Maps.newHashMap();
            newAppNotTestPackageMap.forEach((k, v) -> {
                Long advertId = Long.valueOf(k.toString());

                List packageIdsStr = JSON.parseObject(v.toString(), List.class);

                List<Long> packageIds = Lists.newArrayList();

                packageIdsStr.forEach(packageId -> {
                    packageIds.add(Long.valueOf(packageId.toString()));
                });

                resultMap.put(advertId, packageIds);
            });

            return resultMap;
        } catch (Exception e) {
            logger.error("getNewAppNotTestAdvertConfig exception", e);
            return Collections.emptyMap();
        }
    }

    private Double getConfigLowArpuValue() {
        try {
            String encArpuThreshold = serviceManager.getStrValue(SystemConfigKeyConstant.TUIA_ENC_ARPU_THRESHOLD);
            if (StringUtils.isBlank(encArpuThreshold)) {
                return 0.0d;
            }
            return Double.valueOf(encArpuThreshold);
        } catch (Exception e) {
            return 0.0d;
        }
    }

    private Set<String> getConfigNewTradePromoteTags() {
        try {
            String strValue = serviceManager.getStrValue(SystemConfigKeyConstant.TUIA_NEWTRADE_PROMOTE_TAG);
            return StringTool.getStringSetByStr(strValue);
        } catch (Exception e) {
            return Collections.emptySet();
        }
    }

    private List<String> getUserInterest(ConsumerDto consumerDto, List<ConsumerInteractiveRecordDO> consumerVOList, List<SimilarAdvertLogVO> similarAdvertLogList, String deviceId, FilterResult filterResult, ObtainAdvertReq req, DeviceTagDto deviceTagDto, Map<String, String> newUserDmpTagsMap) {

        List<String> userInterestTmp = null;
        try {
            //从大数据查询当前用户的所有标签

            userInterestTmp = CatUtils.executeInCatTransaction(() -> tagRuleFilterService.getUserInterest(consumerDto, consumerVOList, deviceId, filterResult, req, deviceTagDto, newUserDmpTagsMap), "buildParameters", "getUserInterest");
        } catch (Throwable throwable) {
//            throwable.printStackTrace();
        }

        List<String> userInterest = userInterestTmp;

        if (CollectionUtils.isEmpty(userInterest)) {
            return Collections.emptyList();
        }
        //新用户不会存在点击过的广告，也就不存在相似广告逻辑
        if (CollectionUtils.isEmpty(consumerVOList)) {
            return userInterest;
        }
        Long consumeId = consumerDto.getConsumerId();
        List<Long> consumeClickAdvertList = CollectionUtils.isEmpty(deviceTagDto.getClickAdvertList()) ? null : deviceTagDto.getClickAdvertList().stream().map(dto -> Long.valueOf(dto)).collect(Collectors.toList());
        //用户点击过的广告获取对应的相似行业
        Map<Integer, List<AdvertSimilarTradeDO>> advertSimilarTradeMap = advertSimilarTradeCache.getTradeSimilarAdvert(consumeClickAdvertList);

        if (org.springframework.util.CollectionUtils.isEmpty(advertSimilarTradeMap)) {
            CatUtil.catLog(CatGroupEnum.CAT_107002.getCode());
            return userInterest;
        }
        advertSimilarTradeMap.forEach((acceptType, similarTradeList) -> {
            similarTradeList.forEach(similarTrade -> {
                //用户对相似行业的接受度人群日志
                SimilarAdvertLogVO similarAdvertLog = new SimilarAdvertLogVO();
                similarAdvertLog.setConsumeId(consumeId);
                similarAdvertLog.setTagNum(similarTrade.getTagNum());
                similarAdvertLog.setMark(similarTrade.getMark());
                similarAdvertLogList.add(similarAdvertLog);

                String otherInterest = similarTrade.getTagNum() + SEPARATOR + AdvertTradeAcceptLevelEnum.OTHER.getCode();
                //包含其他接受度行业的替换为相似广告对应接受度
                boolean removed = userInterest.remove(otherInterest);
                if (removed) {
                    userInterest.add(similarTrade.getTagNum() + SEPARATOR + acceptType);
                }
            });
        });
        return userInterest;
    }


    /**
     * 从hbase 获取对于的 社会属性，行业接受，dmp，行业接受 等标签
     *
     * @param deviceId
     * @return
     */
    @Override
    public DeviceTagDto getDmpTagData(String deviceId, boolean activityPriorityCondition) {

        return dmpTagDataService.getDeviceTag(deviceId, activityPriorityCondition);
    }

    /**
     * 获取设备已转化数据
     *
     * @param deviceId
     * @return
     */
    @Override
    public DeviceFilterDto getDeviceFilterDto(String deviceId) {
        if (StringUtils.isEmpty(deviceId)) {
            return new DeviceFilterDto();
        }

        try {
            DeviceResourceForm deviceResourceForm = new DeviceResourceForm();
            deviceResourceForm.setDeviceId(deviceId);
            return remoteDeviceResourceService.getDeviceData(deviceResourceForm);
        } catch (Exception e) {
            return new DeviceFilterDto();
        }
    }

    /**
     * ifLimitAccount:(是否需要限制：0-其他不受限，1-IOS发券受限，2-IOS发券不受限，3-android发券受限，4-android发券不受限). <br/>
     *
     * @param req
     * @param todayConsumeList
     * @return
     * @author chencheng
     * @since JDK 1.8
     */
    private String ifLimitAccount(ObtainAdvertReq req, List<ConsumerInteractiveRecordDO> todayConsumeList) {
        PlatformTypeEnum ua = PlatformTypeEnum.getByDesc(req.getUa());
        // 其他平台不走广告主发券限制逻辑
        if (ua == PlatformTypeEnum.UNKNOW) {
            return AccountLimitTypeEnum.UNKNOW.getCode();
        }
        // ios走广告主发券限制逻辑
        if (ua == PlatformTypeEnum.IOS) {
            return AccountLimitTypeEnum.IOS_LIMIT.getCode();
        }
        if (CollectionUtils.isEmpty(todayConsumeList)) {
            // 未标记的用户,会取一定的比例来测试
            return get10Percent();
        }
        ConsumerInteractiveRecordDO lastConsumerVO = todayConsumeList.get(0);
        // 用户已标记过
        if (null != lastConsumerVO.getLimitAccountType()) {
            return lastConsumerVO.getLimitAccountType();
        }
        // 有领券记录，未标记的用户,会取一定的比例来测试
        return get10Percent();
    }

    /**
     * buildLimitAccountIdType:(经过广告主限制的校验，暂时标记会删除). <br/>
     *
     * @param req
     * @param limitAccountType
     * @author chencheng
     * @since JDK 1.8
     */
    private void buildLimitAccountIdType(ObtainAdvertReq req, String limitAccountType) {
        if (req.getLogExtMap() != null) {
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.LIMIT_AC_TYPE, limitAccountType);
        } else {
            Map<String, String> logExtMap = Maps.newHashMap();
            logExtMap.put(AdvertReqLogExtKeyConstant.LIMIT_AC_TYPE, limitAccountType);
            req.setLogExtMap(logExtMap);
        }
    }

    /**
     * get10Percent:(测试暂时使用，10%的概率). <br/>
     *
     * @return
     * @author chencheng
     * @since JDK 1.8
     */
    private String get10Percent() {
        Random rand = new Random();
        int num = rand.nextInt(100);
        if (num < consumerService.getPercentTest()) {
            return AccountLimitTypeEnum.ANDROID_LIMIT.getCode();
        }
        return AccountLimitTypeEnum.ANDROID_NO_LIMIT.getCode();
    }

    @Override
    public AdvQueryParam buildDirectAdvQueryParam(AdvQueryParam advQueryParam, ObtainAdvertReq req, ShieldStrategyVO shieldStrategyVO) throws Exception {
        try {
            DBTimeProfile.enter("buildDirectAdvQueryParam");
            //1.设置媒体平台选择的信息，媒体互选功能
            buildAppSelectInfo(advQueryParam, req);
            //2.定向媒体
            advQueryParam.setAppId(req.getAppId());
            advQueryParam.setSlotId(req.getSlotId());
            //3.禁用标签，放es过滤
            advQueryParam.setBannedTags(shieldStrategyVO.getAppBannedTags());
            advQueryParam.setAdvBannedTag(shieldStrategyVO.getAdvBannedTag());
            //4.禁用url，放es过滤
            advQueryParam.setBannedUrls(shieldStrategyVO.getShieldUrls());
            //5.平台
            advQueryParam.setPlatform(req.getUa());
            //6.手机型号
            PhoneInfo phoneInfo = commonService.getPhoneInfo(req.getUa(), req.getUserAgent());
            advQueryParam.setPhoneLevels(phoneInfo.getPriceLevel());
            advQueryParam.setPhoneModel(phoneInfo.getPhoneModel());
            advQueryParam.setPhoneBrand(phoneInfo.getPhoneBrand());
            advQueryParam.setPhoneModelNum(phoneInfo.getPhoneModelNum());
            advQueryParam.setBrandName(phoneInfo.getBrandName());
            req.setOsVersion(phoneInfo.getOsVersion());
            if (Objects.nonNull(phoneInfo.getEquipmentType())) {
                if (Objects.isNull(req.getLogExtExpMap())) {
                    req.setLogExtExpMap(new HashMap<>());
                }
                req.getLogExtExpMap().put("equipment_type", phoneInfo.getEquipmentType());
            }

            //7.网络类型
            setNetWorkType(advQueryParam, req);

            //8.屏蔽流量类型转换
            String appFlowType = Optional.ofNullable(req.getLogExtMap())
                    .map(logExtMap -> logExtMap.get(AdvertOrderJsonKeyEnum.KEY_APP_FLOW_TYPE.getCode()))
                    .orElse(AppFlowPlatform.OTHER.getCode().toString());
            advQueryParam.setBannedAppFlowType(appFlowType + "." + PlatformTypeEnum.getByDesc(req.getUa()).getCode());
            //KA广告扶持
            advQueryParam.setNewTradePromoteTags(getConfigNewTradePromoteTags());
            // 素材过滤默认不过滤，轮投默认为false
            advQueryParam.setReceiveMaterials(Lists.newArrayList());

            // 定向活动
            advQueryParam.setActivityId(req.getActivityId());

            //广告类型
            advQueryParam.setAdType(req.getAdType());

            //设置媒体广告位白单状态
            advQueryParam.setMediaSlotStatus(setMediaSlotStatus(advQueryParam.getSlotId(), shieldStrategyVO.getFlowType()));

            /**
             * 广告位定制 可投广告列表（屏蔽标签（在白名单中 则屏蔽标签失效） + 可投广告名单（广告+广告主维度））
             * 屏蔽标签包含两个维度：广告行业标签 + 广告资源标签
             */
            SlotChooseAdverttVO slotChooseAdverttVO = slotChooseAdvertService.queryChooseAdvertList(advQueryParam.getSlotId());

            //设置 定制广告名单
            advQueryParam.setSlotChooseAdverttVO(slotChooseAdverttVO);

            /**
             * 广告位黑名单业务逻辑：
             * 黑名单存在3种状态：1、关闭，2、全局生效，3、仅对流量策略生效
             * 基于当前广告位的状态生成黑名单。
             */
            MediaSlotListVO mediaSlotListVO = mediaSlotListService.queryMediaSlotList(advQueryParam.getSlotId(), shieldStrategyVO.getFlowType());

            //设置广告位白名单（屏蔽标签）
            advQueryParam.setMediaWhiteList(mediaSlotListVO.getMediaWhiteList());

            //设置广告位黑名单
            advQueryParam.setMediaBlackList(mediaSlotListVO.getMediaBlackList());

            //设置关键词过滤对象
            AdvertFilterKeywordDO advertFilterKeywordDO = advertKeywordCacheService.getShieldKeywordListBySlotId(req.getSlotId());
            advQueryParam.setAdvertFilterKeywordDO(advertFilterKeywordDO);

            return advQueryParam;
        } finally {
            DBTimeProfile.release();
        }
    }

    private void setNetWorkType(AdvQueryParam advQueryParam, ObtainAdvertReq req) {
        // 【信标库】运营商覆盖 @link NetTypeEnum : GSM(1,"4G"), WIFI(2,"wifi");
        if (apolloPanGuService.getIdMapStrIsOne(ApolloPanGuConstant.IP_BEACON_REPLACE_SWITCH)) {
            Integer netType = req.getNetType();
            // NetworkTypeEnum :  WIFI(1,"wifi"), G4(3,"4G"),  OTHER(4,"其它")
            if (NetTypeEnum.WIFI.getCode().equals(netType)) advQueryParam.setNetworkTypes(NetworkTypeEnum.WIFI.getIndex().toString());
            if (NetTypeEnum.GSM.getCode().equals(netType)) advQueryParam.setNetworkTypes(NetworkTypeEnum.G4.getIndex().toString());
            if (netType == null) advQueryParam.setNetworkTypes(NetworkTypeEnum.OTHER.getIndex().toString());
            return;
        }

        String connectionType = "";
        if (req.getLogExtMap() != null && req.getLogExtMap().containsKey("connection_type")) {//优先使用活动传递的网络类型
            CatUtil.catLog(CatGroupEnum.CAT_107001.getCode());
            connectionType = req.getLogExtMap().get("connection_type");
        }
        NetworkTypeEnum networkTypeEnum = NetworkTypeEnum.getByName(connectionType);
        if (networkTypeEnum != null) {
            if (networkTypeEnum.equals(NetworkTypeEnum.ETHERNET)) networkTypeEnum = NetworkTypeEnum.WIFI;
            if (networkTypeEnum.equals(NetworkTypeEnum.CELLULAR)) networkTypeEnum = NetworkTypeEnum.G3;
            advQueryParam.setNetworkTypes(networkTypeEnum.getIndex().toString());
        }
    }


    /**
     * 设置媒体广告位白单状态
     *
     * @param slotId
     * @param flowType
     * @return
     */
    private Boolean setMediaSlotStatus(Long slotId, Integer flowType) {

        return mediaCacheService.isOpenSlotWhiteSwitch(slotId, flowType);
    }

    private void buildAppSelectInfo(AdvQueryParam advQueryParam, ObtainAdvertReq req) throws Exception {
        try {
            DBTimeProfile.enter("buildAppSelectInfo");
            //1.判断该媒体是否开启了广告互选功能,如果开启了则获取媒体选择的广告列表和标签列表
            boolean isElectApp = tuiaMediaClientService.isElectApp(req.getAppId(), advQueryParam);
            advQueryParam.setElectApp(isElectApp);
            if (!isElectApp) {
                return;
            }

            //2.返回媒体选择的标签
            Optional<AdvertSelectInvokeRsp> invokeRsp = tuiaMediaClientService.getAppSelectConfigCache(req.getSlotId());
            if (!invokeRsp.isPresent() || !invokeRsp.get().getInvokeSuccess()) {
                throw new IllegalAccessException("互选广告调用异常");
            }
            AdvertAndTagSelected4AdRsp appSelectConfig = invokeRsp.get().getRsp();
            if (appSelectConfig == null) {
                advQueryParam.setElectApp(false);
                return;
            }
            //媒体选择的标签
            if (CollectionUtils.isNotEmpty(appSelectConfig.getSelectedTagCodes())) {
                advQueryParam.setAppSelectTags(appSelectConfig.getSelectedTagCodes());
            }
            //媒体选择的广告
            if (CollectionUtils.isNotEmpty(appSelectConfig.getSelectedAdvertIds())) {
                advQueryParam.setAppSelectAdvertIds(appSelectConfig.getSelectedAdvertIds());
            }
            //广告位下设置的 可投广告 和 素材
            if (CollectionUtils.isNotEmpty(appSelectConfig.getSelectedAdvertAndMaterialIds())) {
                Map<Long, Set<Long>> selectedAdvertAndMaterialIds = new HashMap<>();
                for (AuditedAdvertAndMaterial4AdDto selectedAdvertAndMaterialId : appSelectConfig.getSelectedAdvertAndMaterialIds()) {
                    Set<Long> materialSets = selectedAdvertAndMaterialId.getMaterialIds().stream().map(AuditedAdvertAndMaterial4AdDto.Material::getId).collect(
                            Collectors.toSet());
                    selectedAdvertAndMaterialIds.put(selectedAdvertAndMaterialId.getAdvertId(), materialSets);
                }
                advQueryParam.setSelectedAdvertAndMaterialIds(selectedAdvertAndMaterialIds);
            }

            //
            advQueryParam.setAdvertAndMaterial4AdDtoSet(appSelectConfig.getSelectedAdvertAndMaterialIds());
        } finally {
            DBTimeProfile.release();
        }
    }


    @Override
    public Map<Long, AdvertFilterVO> preFilterAdvertWithEsHystrix(AdvQueryParam advQueryParam, ObtainAdvertReq req,
                                                                  FilterResult filterResult, AdvertFilter advertFilter) {
        try {
            DBTimeProfile.enter("preFilterAdvertWithEsHystrix");
            List<AdvOrientationItem> filterAdv = directAdvertOrientationWithEsHystrix(advQueryParam, req, filterResult, advertFilter);

            List<AdvOrientationItem> newAppTestfilterAdv = filterResult.getListNewAppTestAdvertBackUp();
            if (CollectionUtils.isEmpty(newAppTestfilterAdv)) {
                return storeOrientationPrice(filterAdv, advQueryParam, req, filterResult);
            }

            // 先获取过滤定向媒体前的数据，进行其他过滤。
            Map<Long, AdvertFilterVO> newAppTestAdvertBackUpMap = storeOrientationPrice(newAppTestfilterAdv, advQueryParam, req, filterResult);
            filterResult.setNewAppTestAdvertBackUpMap(newAppTestAdvertBackUpMap);

            if (newAppTestAdvertBackUpMap.isEmpty()) {
                return newAppTestAdvertBackUpMap;
            }

            // 获取正常流量可投的广告
            return storeOrientationPrice(filterAdv, advQueryParam, req, filterResult);
        } catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
            return Maps.newLinkedHashMap();
        } finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public List<AdvOrientationItem> directAdvertOrientationWithEsHystrix(AdvQueryParam advQueryParam, ObtainAdvertReq req,
                                                                         FilterResult filterResult, AdvertFilter advertFilter) {
        Map<String, List<AdvOrientationItem>> itemListMap;
        List<AdvOrientationItem> filterAdv = Lists.newArrayListWithExpectedSize(3000);
        try {
            DBTimeProfile.enter("AdvertOrientionWithEsHystrix");
            //1.广告配置过滤
            itemListMap = advertQueryService.advertMemoryFilter(advQueryParam, advertFilter, filterResult, req);
            filterAdv = itemListMap.get("itemList");

            //2.内存过滤-配置定向条件过滤后为空
            if (CollectionUtils.isEmpty(filterAdv)) {
                CatUtil.catLog(CatGroupEnum.CAT_102002.getCode());
            }

            //4.如果是新媒体试投，备份数据
            if (newAppTestCacheService.ifTestNewApp(req.getAppId())) {
                List<AdvOrientationItem> newAppTestList = itemListMap.get("newAppTestList");
                filterResult.setListNewAppTestAdvertBackUp(newAppTestList);
            }

        } catch (Throwable e) {
            logger.error(e.getMessage(), e);
        } finally {
            DBTimeProfile.release();
        }

        //5.将匹配的行业人群包标签存在filterResult
        setMatchTradePackageTag(filterAdv, filterResult, advQueryParam);

        // 设置有效的素材列表
        filterResult.setValidAdvertMaterialSet(advQueryParam.getValidAdvertMaterialSet());

        return filterAdv;
    }

    /**
     * 将行业人群包匹配的配置存到filterResult
     *
     * @param filterAdv
     * @param filterResult
     */
    @Override
    public void setMatchTradePackageTag(List<AdvOrientationItem> filterAdv, FilterResult filterResult, AdvQueryParam advQueryParam) {

        List<String> userInterests = advQueryParam.getUserInterest();

        if (CollectionUtils.isEmpty(filterAdv) || CollectionUtils.isEmpty(userInterests)) {
            return;
        }

        //获取所有的测试标签
        //所有有效的行业人群包标签
        List<String> tradePackageTagValues = advertTradePackageService.getAllValidTradePackageDO();

        if (CollectionUtils.isEmpty(tradePackageTagValues)) {
            return;
        }

        Map<String, String> orientPackageIdTagMap = Maps.newHashMapWithExpectedSize(filterAdv.size());

        filterAdv.stream().forEach(adv -> {
            Set<String> orientPackageTradePackTags = Optional.ofNullable(adv.getUserInterest()).orElse(new HashSet<>());

            Set<String> noOrientPackageTradePackTags = Optional.ofNullable(adv.getUserNotInterest()).orElse(new HashSet<>());

            if (CollectionUtils.isEmpty(orientPackageTradePackTags)) {
                return;
            }

            List<String> excludeTags = (List<String>) CollectionUtils.intersection(noOrientPackageTradePackTags, userInterests);

            if (CollectionUtils.isNotEmpty(excludeTags)) {
                return;
            }

            List<String> commonTags = (List<String>) CollectionUtils.intersection(orientPackageTradePackTags, userInterests);

            if (CollectionUtils.isEmpty(commonTags) || CollectionUtils.isEmpty(tradePackageTagValues)) {
                return;
            }

            List<String> needTags = (List<String>) CollectionUtils.intersection(tradePackageTagValues, commonTags);


            if (CollectionUtils.isNotEmpty(needTags)) {
                orientPackageIdTagMap.put(String.valueOf(adv.getAdvertId()).concat(String.valueOf(adv.getOrientationId())), needTags.get(0));
            }

        });

        filterResult.setAdvertTradePackageTags(orientPackageIdTagMap);
    }

    /**
     * 存储(广告+定向)级别的的价格和时段信息.用于后面获取每个广告的最高报价和素材id
     *
     * @param filterAdv
     * @param filterResult
     */
    @SuppressWarnings("squid:S3776")
    @Override
    public Map<Long, AdvertFilterVO> storeOrientationPrice(List<AdvOrientationItem> filterAdv, AdvQueryParam advQueryParam,
                                                           ObtainAdvertReq req, FilterResult filterResult) {
        try {
            DBTimeProfile.enter("storeOrientationPrice");

            Map<Long, AdvertFilterVO> advertFilterVOMap = Maps.newLinkedHashMap();//保证有序性,group要使用linkdedhashmap
            if (CollectionUtils.isEmpty(filterAdv)) {
                return advertFilterVOMap;
            }
            LinkedHashMap<Long, List<AdvOrientationItem>> advertOrientationMap = filterAdv.stream().collect(groupingBy(AdvOrientationItem::getAdvertId, LinkedHashMap::new, toList()));

            List<Long> appImproveBidAdvertIds = appImproveBiddingAdvertCache.getAppImproveBiddingAdvertCache(req.getAppId());

            // 获取广告扶持发券量
            Map<Long, SupportAdvertInfoDto> supportLaunchMap = advertSupportPlanCacheManager.getCacheSupportPlanLaunch(req.getAppId());

            //用来记录筛选出来的广告ids
            StringBuilder sb = new StringBuilder();

            List<Integer> activityTypeExt = req.getActivityTypeExt();
            Boolean autoBindMaterial = (null != activityTypeExt && activityTypeExt.contains(12));

            Map<Long, List<Long>> newAppNotTestAdvertMap = advQueryParam.getNewAppNotTestAdvertMap();
            advertOrientationMap.forEach((Long advertId, List<AdvOrientationItem> list) -> {
                SortedSet<AdvertPriceVO> advertPriceVOSet = Sets.newTreeSet();
                //人工包
                SortedSet<AdvertPriceVO> manualAdvertSet = Sets.newTreeSet();
                //自动模式包
                SortedSet<AdvertPriceVO> autoModelAdvertSet = Sets.newTreeSet();
                //优投模式
                SortedSet<AdvertPriceVO> optimalModelAdvertSet = Sets.newTreeSet();

                Long accountId = list.get(0).getAccountId();

                List<Long> newAppNotTestPackageIds = newAppNotTestAdvertMap.get(advertId);
                if (newAppNotTestPackageIds == null) {
                    newAppNotTestPackageIds = Lists.newArrayList();
                }

                // 获取广告扶持状态
                SupportAdvertInfoDto supportDto = advertSupportPlanCacheManager.getSupportPlanByAdvertId(advertId, supportLaunchMap);

                //获取新行业标签
                AdvertNewTradeDO advertNewTradeDO = advertNewTradeCacheService.getAdvertNewTradeName(advertId);

                for (AdvOrientationItem advOrientationItem : list) {
                    AdvertPriceVO priceVO = new AdvertPriceVO(advOrientationItem.getPeriodList(),
                            advOrientationItem.getChargeType().equals(ChargeTypeEnum.TYPE_CPA.getCode()) ? advOrientationItem.getCpaPrice() : advOrientationItem.getCpcPrice(),
                            advOrientationItem.getChargeType());
                    priceVO.setAdvertId(advertId);
                    priceVO.setAdvertOrientationPackageId(advOrientationItem.getOrientationId());
                    priceVO.setOriginalOrientationId(advOrientationItem.getInitialOrientationId());
                    //剩下的素材已经过滤掉了屏蔽的素材
                    Set<Long> validMaterials = advOrientationItem.getLeftMaterial();
                    setPackageMaterials(priceVO, advOrientationItem, validMaterials,autoBindMaterial);

                    //如果没有可投的素材配置包不可投
                    if (CollectionUtils.isEmpty(priceVO.getMaterialsBind())) {
                        continue;
                    }

                    // 设置广告扶持信息
                    Optional.ofNullable(supportDto).ifPresent(dto -> {
                        priceVO.setSupportAdvertInfoDto(dto);
                        priceVO.setSupportStatus(dto.getSupportAdvert() ? 1 : 0);
                    });

                    // 设置广告权重
                    priceVO.setWeight(advOrientationItem.getAdvertWeight().doubleValue());

                    // 命中流量人群的标签
                    priceVO.setHitUserInterest(advOrientationItem.getHitUserInterest());

                    // priceVO.setSupportStatus(advOrientationItem.getSupportStatus());
                    priceVO.setNewTradeTagNum(advOrientationItem.getNewTradeTagNum());
                    priceVO.setNewTradeTagId(advOrientationItem.getNewTradeTagId());
                    //设置是否可以加权
                    // if (advOrientationItem.getSupportStatus() == CommonConstant.YES) {
                    //     //判断广告在该媒体的加权发券数是否小于媒体发券数的5%
                    //     priceVO.setNeedSupportWeight(advertRealDataService.appSupportLaunchCheck(advertId, req.getAppId()));
                    // } else {
                    //     priceVO.setNeedSupportWeight(false);
                    // }

                    //设置是否可以替换低arpu值标识
                    if (req.getReplaceLowArpu() == CommonConstant.YES) {
                        priceVO.setCanReplaceLowArpu(getCanReplaceLowArpuStatus(advQueryParam, accountId, advertId));
                    } else {
                        priceVO.setCanReplaceLowArpu(CommonConstant.NO);
                    }

                    //是否开启了自动托管，1-开启、0-未开启(这个字段不能动，日志里面有统计)
                    //todo 如果后面优投模式的弱定向生效了，则还需要判断是否是弱定向(即自动模式和优投模式的弱定向都是自动托管)
                    priceVO.setTrusteeship(advOrientationItem.getTargetAppLimit() == TrusteeshipConstants.AUTO_MODE ? CommonConstant.YES : CommonConstant.NO);
                    priceVO.setTargetAppLimit(Optional.ofNullable(advOrientationItem.getTargetAppLimit()).orElse(1));
                    priceVO.setStrongTarget(advOrientationItem.getStrongTarget());

                    priceVO.setPackageType(advOrientationItem.getPackageType());
                    priceVO.setActivityType(advOrientationItem.getActivityType());
                    priceVO.setBudgetPerDay(advOrientationItem.getBudgetPerDay());
                    priceVO.setAdvertBudgetPerDay(advOrientationItem.getAdvertBudgetPerDay());
                    //如果开启了自动托管则设置自动托管转换出价，用于打日志和传给哪吒
                    priceVO.setConvertCost(advOrientationItem.getCpaPrice());
                    priceVO.setAppTargetPackage(advOrientationItem.getAppTargetPackage());
                    priceVO.setSlotTargetPackage(advOrientationItem.getSlotTargetPackage());
                    priceVO.setTargetRecommendType(advOrientationItem.getTargetRecommendType());

                    // 是否存在定向了媒体或者广告位
                    priceVO.setExistTargetAppOrSlot(advOrientationItem.getExistTargetAppOrSlot());


                    //设置签收因子,如果是ocpc并且改配置选择了 调整因子为签收
                    priceVO.setSubtype(advOrientationItem.getSubtype());
                    priceVO.setDepthSubtype(advOrientationItem.getDepthSubtype());
                    priceVO.setDepthTargetPrice(advOrientationItem.getDepthTargetPrice());
                    priceVO.setPutTargetType(AdvOrientationItem.configPutTargetType(advOrientationItem.getPutTargetType(), advOrientationItem.getStrongTarget(), advOrientationItem.getTargetAppLimit()));

                    // 分媒体出价（重点媒体转化出价，潜力广告分媒体出价，普通的分媒体出价）
                    disAppFeeChange(priceVO, advOrientationItem, req.getAppId());

                    priceVO.setResourceTag(advOrientationItem.getResourceTag());
                    //当计费方式为ocpc并且为签收数据时(下面逻辑是覆盖操作，所以需要放到后面)
                    /*start*/
                    if (ChargeTypeEnum.TYPE_CPA.getCode() == advOrientationItem.getChargeType() &&
                            AdvertSubtypeEnum.SIGN_FOR.getSubtype().equals(advOrientationItem.getSubtype())) {
                        Long packageId = getOrientationId(advertId, advOrientationItem.getOrientationId());

                        String finalConvertCostKey = getCpaKey(advertId, packageId, req.getAppId());

                        String marketConvertCostKey = getCpaKey(advertId, packageId, MARKET_APP_ID);
                        // 大盘签收率对应的出价 用于成本维稳
                        Long marketConvertCost = adjustFeeCacheService.getCpaFee(marketConvertCostKey);
                        //当前媒体最终的转化出价(如果媒体没有转化出价则取的是大盘的转化出价)
                        Long finalConvertCost = adjustFeeCacheService.getCpaFee(finalConvertCostKey);

                        //此处设置转化出价用于排序
                        // priceVO.setConvertCost(finalConvertCost);
                        priceVO.setFee(finalConvertCost);
                        //此处设置大盘转化出价用于维稳，后面传给nezha时维稳用的是finalConvertCost
                        priceVO.setConvertTypeCost(marketConvertCost);
                        priceVO.setMarketConvertCost(marketConvertCost);
                        priceVO.setFocusAppConvertCost(finalConvertCost);
                        priceVO.setDisAppFeeType(DisAppFeeTypeEnum.SIGN_FOR_APP_TYPE.getCode());
                    }
                    /*end*/

                    //自动模式和非自动模式分组,自动模式的包需要全部传给哪吒
                    if (advOrientationItem.getTargetAppLimit() == TrusteeshipConstants.OPTIMAL_MODE) {
                        optimalModelAdvertSet.add(priceVO);
                    } else if (advOrientationItem.getTargetAppLimit() == TrusteeshipConstants.AUTO_MODE) {
                        autoModelAdvertSet.add(priceVO);
                    } else {
                        manualAdvertSet.add(priceVO);
                    }
                    // 消耗模式
                    priceVO.setBudgetSmooth(advOrientationItem.getBudgetSmooth());

                    //多连接测试链接设置
                    priceVO.setPromoteTestUrl(advOrientationItem.getPromoteTestUrl());

                    //设置 是否在 托管底价白名单 中
                    priceVO.setIsObctTag(advOrientationItem.getIsObctTag());

                    //设置考核指标，可nezha用.
                    priceVO.setAssessType(advOrientationItem.getAssessType());

                    priceVO.setOutOrderRate(advOrientationItem.getOutOrderRate());

//                    priceVO.setOriginalOrientationId(advOrientationItem.getInitialOrientationId());

                    priceVO.setOcpcExpandTag(advOrientationItem.getOcpcExpandTag());

                    priceVO.setPeoplePrffer(advOrientationItem.getPeoplePrffer());

                    priceVO.setAppLimitReleaseMark(advOrientationItem.getAppLimitReleaseMark());

                    priceVO.setOrientPkgFilterUrlDO(advOrientationItem.getOrientPkgFilterUrlDO());

                    if(ChargeTypeEnum.TYPE_CPC.getCode() == advOrientationItem.getChargeType() &&
                            PackageTypeEnum.INTERACTIVE_TYPE.getCode() == advOrientationItem.getPackageType()){
                        //判断是否需要设置自动竞价类型（当且仅当cpc、在白名单中（或白名单关闭）时需要）
                        if (judgeIfNeedAutoBiddingType(advertId)) {
                            //设置自动竞价白名单
                            priceVO.setAutoBiddingType(advOrientationItem.getAutoBiddingType());
                        }
                    }

                    advertPriceVOSet.add(priceVO);
                }

                if (advertPriceVOSet.size() > 0) {
                    AdvertFilterVO advertFilterVO = new AdvertFilterVO();
                    advertFilterVO.setAdvertId(advertId);
                    advertFilterVO.setAccountId(list.get(0).getAccountId());
                    if (list.get(0).getAdvertTags() != null) {
                        advertFilterVO.setMatchTags(Joiner.on(",").join(list.get(0).getAdvertTags()));
                    }
                    advertFilterVO.setNewAppNotTestPackageIds(newAppNotTestPackageIds);
                    advertFilterVO.setResourceTag(list.get(0).getResourceTag());
                    advertFilterVO.setNewTradeName(null == advertNewTradeDO ? null : advertNewTradeDO.getNewTradeName());
                    advertFilterVO.setAdvertPriceVOSortedSet(advertPriceVOSet);
                    advertFilterVO.setManualAdvertSet(manualAdvertSet);
                    advertFilterVO.setAutoModelAdvertSet(autoModelAdvertSet);
                    advertFilterVO.setOptimalModelAdvertSet(optimalModelAdvertSet);

                    //将es中的权重塞进advertFilterVO
                    BigDecimal advertWeight = list.get(0).getAdvertWeight();
                    if (appImproveBidAdvertIds.contains(advertId)) {
                        advertWeight = advertWeight.multiply(IMPROVE_WEIGHT_MULTIPLE);
                        advertFilterVO.setImproveBiddingStatus(IMPROVE_BIDDING_STATUS);
                    }
                    advertFilterVO.setAdvertWeight(advertWeight);
                    buildTargetedAppMap(advertFilterVO, list);
                    advertFilterVOMap.put(advertId, advertFilterVO);
                    sb.append(advertId).append(",");

                }
            });
            filterResult.setAdvertIds(sb.toString());
            return advertFilterVOMap;
        } catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
            return Maps.newLinkedHashMap();
        } finally {
            DBTimeProfile.release();
        }
    }

    private boolean judgeIfNeedAutoBiddingType(Long advertId) {

        //1.判断白名单开关状态
        //2.获取广告是否在白名单中
        String autoBiddingWhiteListStatus;
        try {
            autoBiddingWhiteListStatus = serviceManager.getStrValue(SystemConfigKeyConstant.CPC_AUTOMATIC_BIDDING_CONTROL_ENABLESTATE);
        } catch (TuiaException e) {
            autoBiddingWhiteListStatus = null;
        }
        //开关关闭
        if (CPC_AUTOMATIC_BIDDING_CONTROL_CLOSE.equals(autoBiddingWhiteListStatus)) {
            return true;
        }

        //开关开启
        if (CPC_AUTOMATIC_BIDDING_CONTROL_OPEN.equals(autoBiddingWhiteListStatus)) {
            Integer isInAutoBiddingWhiteList = serviceManager.getAdvertExpandById(advertId);
            //在白名单中
            if (AUTO_BIDDING_WHITELIST_YES.equals(isInAutoBiddingWhiteList)) {
                return true;
            }
        }

        return false;
    }

    /**
     * 设置广告不同的配置下对应的互动媒体的数量
     *
     * @param advertFilterVO 当前广告信息
     * @param list           当前广告对应的配置相关的信息
     */
    private void buildTargetedAppMap(AdvertFilterVO advertFilterVO, List<AdvOrientationItem> list) {
        Integer tempAppSize;
        try {
            tempAppSize = Integer.valueOf(serviceManager.getStrValue(SystemConfigKeyConstant.NEW_APP_TEST_ORIENTATION_APP_SIZE_KEY));
        } catch (Exception e) {
            logger.error("[Get AppSize] error", e);
            //如果这里出现异常使用初始值
            tempAppSize = 5;
        }
        final int appSize = tempAppSize;
        //设置广告下不同配置对应的互动媒体的数量 当这里的定向媒体不限的时候需要处理下
        Map<Long, Integer> advertAppSizeMap = list.stream().collect(groupingBy(AdvOrientationItem::getOrientationId,
                Collectors.summingInt(temp -> {
                    if (temp == null || temp.getTargetApps() == null) {
                        return 0;
                    }
                    //这里如果是定向媒体不限里面只有元素且为-1
                    if (temp.getTargetApps().size() == 1 && temp.getTargetApps().contains(-1L)) {
                        //这里将全局配置限制数量加1 保证定向媒体不限的配置可以通过过滤
                        return appSize + 1;
                    }
                    return temp.getTargetApps().size();
                })));
        advertFilterVO.setTargetedAppMap(advertAppSizeMap);
    }

    /**
     * disAppFeeChange:(分媒体出价转换). <br/>
     *
     * @param priceVO
     * @param advOrientationItem
     * @param appId
     * @author chencheng
     * @since JDK 1.8
     */
    @SuppressWarnings("squid:S3776")
    private void disAppFeeChange(AdvertPriceVO priceVO, AdvOrientationItem advOrientationItem, Long appId) {

        DisAppFeeTypeEnum disAppFeeType = Optional.ofNullable(advOrientationItem.getDisAppFeeType()).orElse(DisAppFeeTypeEnum.DEFULT_TYPE);
        // 媒体对应的出价
        Map<Long, Long> focusAppConvertCostMap = advOrientationItem.getFocusAppConvertCost();
        Long disAppFee = Optional.ofNullable(focusAppConvertCostMap).map(appFeeMap -> appFeeMap.get(appId)).orElse(null);
        priceVO.setDisAppFeeType(DisAppFeeTypeEnum.DEFULT_TYPE.getCode());
        if (disAppFee == null) {
            return;
        }
        switch (disAppFeeType) {
            case IMPORTANT_APP_TYPE:
                priceVO.setFocusAppConvertCost(disAppFee);
                priceVO.setDisAppFeeType(DisAppFeeTypeEnum.IMPORTANT_APP_TYPE.getCode());
                break;
            case ORDINARY_APP_CPC_TYPE:
                priceVO.setFee(disAppFee);
                priceVO.setAppCostStableSwitch(advOrientationItem.getAppCostStableSwitch());
                priceVO.setDisAppFeeType(DisAppFeeTypeEnum.ORDINARY_APP_CPC_TYPE.getCode());
                break;
            case ORDINARY_APP_CPA_TYPE:
                // priceVO.setConvertCost(disAppFee);
                // priceVO.setConvertTypeCost(disAppFee);
                priceVO.setFocusAppConvertCost(disAppFee);
                priceVO.setFee(disAppFee);
                priceVO.setAppCostStableSwitch(advOrientationItem.getAppCostStableSwitch());
                priceVO.setDisAppFeeType(DisAppFeeTypeEnum.ORDINARY_APP_CPA_TYPE.getCode());
                break;
            case POTENTIAL_APP_TYPE:
                priceVO.setFee(disAppFee);
                // priceVO.setPotentionalStatus(OPEN_POTENTIONAL);
                priceVO.setDisAppFeeType(DisAppFeeTypeEnum.POTENTIAL_APP_TYPE.getCode());
                //设置潜力广告是否需要扶持
                // setNeedPotentinoalSupport(priceVO, advOrientationItem, appId);
                break;
            case POTENTIAL_APP_OVER_TYPE:
                // priceVO.setPotentionalStatus(OPEN_POTENTIONAL);
                priceVO.setFee(disAppFee);
                priceVO.setDisAppFeeType(DisAppFeeTypeEnum.POTENTIAL_APP_OVER_TYPE.getCode());
                break;
            default:
                priceVO.setDisAppFeeType(DisAppFeeTypeEnum.DEFULT_TYPE.getCode());
                break;
        }

    }

    private Long getOrientationId(Long advertId, Long orientId) {
        return orientId.equals(AdvertConstants.DEFAULT_ORIENTATION_ID) ? advertOrientationService.getOrientation(advertId, orientId).getId() : orientId;
    }

    private String getCpaKey(Long advertId, Long advertOrientationPackageId, Long appId) {
        return String.valueOf(advertId) + COMMA_SEPARATOR + advertOrientationPackageId + COMMA_SEPARATOR + appId;
    }

    @Override
    public Integer getCanReplaceLowArpuStatus(AdvQueryParam advQueryParam, Long accountId, Long advertId) {
        Map<Long, Date> firstLaunchMap = advQueryParam.getAccountFirstLaunchDate();

        Date accountFirstLaunchDate = firstLaunchMap.get(accountId);

        //第一次发券时间在7日内的则不符合(604800000为7天的毫秒数)——广告主第一次发券时间为空也是在7日内(可能是今天新创建的广告主)
        if (accountFirstLaunchDate == null || (DateTime.now().getMillis() - new DateTime(accountFirstLaunchDate).getMillis()) <= 604800000) {
            return CommonConstant.NO;
        }

        Map<Integer, List<Long>> lowArpuWhiteMap = advQueryParam.getLowArpuWhiteMap();
        if (MapUtils.isEmpty(lowArpuWhiteMap)) {
            return CommonConstant.YES;
        }

        //白名单广告主
        List<Long> whiteAccountIds = lowArpuWhiteMap.get(1);
        if (CollectionUtils.isNotEmpty(whiteAccountIds) && whiteAccountIds.contains(accountId)) {
            return CommonConstant.NO;
        }

        //白名单广告
        List<Long> whiteAdvertIds = lowArpuWhiteMap.get(2);
        if (CollectionUtils.isNotEmpty(whiteAdvertIds) && whiteAdvertIds.contains(advertId)) {
            return CommonConstant.NO;
        }
        return CommonConstant.YES;
    }

    /**
     * 设置定向配置包绑定的素材
     *
     * @param priceVO
     * @param validMaterials
     * @return 配置是否有可投素材
     */
    private void setPackageMaterials(AdvertPriceVO priceVO, AdvOrientationItem advOrientationItem, Set<Long> validMaterials, Boolean autoBindMaterial) {

        //如果配置的素材是空的，投放全部素材
        if (CollectionUtils.isNotEmpty(advOrientationItem.getMaterialIds())) {
            Set<Long> packageMaterials = Sets.newHashSet(advOrientationItem.getMaterialIds());
            packageMaterials.retainAll(validMaterials);
            priceVO.setMaterialsBind(packageMaterials);
            return;
        }

        //绑定的素材是空的
//        if (autoBindMaterial) {
//
//            Set<Long> advertVideoMaterialSet = advertMaterialRecommendService.getAdvertVideoMaterialSet(advOrientationItem.getAdvertId());
//            //根据配置类型
//            Set<Long> bindMaterials = new HashSet<>(validMaterials);
//            Set<String> activityTypeSet = advOrientationItem.getActivityType();
//            if (null != activityTypeSet && activityTypeSet.contains(PackagePlanConstants.NEW_VEDIO_AD_ACTIVITY_TYPE)) {
//                //定向激励视频的配置
//                bindMaterials.retainAll(advertVideoMaterialSet);
//            } else {
//                //其他配置
//                bindMaterials.removeAll(advertVideoMaterialSet);
//            }
//            priceVO.setMaterialsBind(bindMaterials);
//            return;
//        }

        priceVO.setMaterialsBind(validMaterials);
    }
}
