package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.boot.profiler.DBTimeProfiler;
import cn.com.duiba.nezha.engine.api.enums.DayuArgumentsEnum;
import cn.com.duiba.tuia.cache.*;
import cn.com.duiba.tuia.constants.PackagePlanConstants;
import cn.com.duiba.tuia.constants.TrusteeshipConstants;
import cn.com.duiba.tuia.domain.dataobject.*;
import cn.com.duiba.tuia.domain.flow.MediaList;
import cn.com.duiba.tuia.domain.flow.SlotChooseAdverttVO;
import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.domain.vo.AdvertTargetAppVO;
import cn.com.duiba.tuia.domain.vo.AdvertVO;
import cn.com.tuia.advert.enums.AdvertFilterTypeEnum;
import cn.com.duiba.tuia.enums.CatGroupEnum;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.com.duiba.tuia.service.*;
import cn.com.duiba.tuia.service.engine.EngineABTestService;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.duiba.tuia.tool.StringTool;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.tuia.advert.constants.PangeaRelevantConstant;
import cn.com.tuia.advert.enums.ActivityTypeEnum;
import cn.com.tuia.advert.enums.ChargeTypeEnum;
import cn.com.tuia.advert.enums.PutTargetTypeEnum;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.Period;
import cn.hutool.core.collection.ConcurrentHashSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;

import static java.util.stream.Collectors.toList;
import static java.util.stream.Collectors.toSet;

/**
 * Created by hujinliang on 2017/8/14.
 */
@Service
@RefreshScope
public class AdvertQueryServiceImpl implements AdvertQueryService {
    private static Logger logger = LoggerFactory.getLogger(AdvertQueryServiceImpl.class);

    /**
     * 并行流开关，默认为-1
     * -1或null，表示关闭并行流
     */
    @Value("${advert.launch.parallel.flag:-1}")
    private String parallelFlag;

    private static final Integer CHARGE_TYPE_CPA = 2;
    private static final Integer CHARGE_TYPE_CPC = 1;

    private static final Integer AUTO_MATCH_OPEN = 1;

    /**
     * 自定义ForkJoinPoll，注意95线问题，此处不适合阻塞，比如此处方法95线100ms（拆分后），就只能处理QPS10以下的
     * 报错一般不是它报错，是它调用线程池，线程池不够报错
     * 也可以进行拆分任务
     */
    private static ForkJoinPool forkJoinPoolBeforeFilter = new ForkJoinPool(4);
    private static ForkJoinPool forkJoinPoolSimpleFilter = new ForkJoinPool(4);
    private static ForkJoinPool forkJoinPoolCopyAndPut = new ForkJoinPool(12);

    // 最大参与次数
    private static final int MAX_JOIN = 6;
    @Autowired
    private AdvertTargetAppCacheService advertTargetAppCacheService;
    @Autowired
    private AdvertMapCacheManager advertMapCacheManager;
    @Autowired
    private ServiceManager serviceManager;
    @Autowired
    private AdvertPkgPutFlagCacheService advertPkgPutFlagCacheService;
    @Autowired
    private LimitingMaximunService limitingMaximunService;

    @Autowired
    private AdvertMaterialRecommendService advertMaterialRecommendService;

    @Autowired
    private AdvertNewTradeCacheService advertNewTradeCacheService;

    @Autowired
    private MediaCacheService mediaCacheService;

    @Autowired
    private RepeatExposureFilterService repeatExposureFilterService;
    @Autowired
    private ActPreCache actPreCache;
    @Autowired
    private ApolloPanGuService apolloPanGuService;
    @Autowired
    private TransferService transferService;

    @Autowired
    private AdvertPkgCacheService advertPkgCacheService;
    @Autowired
    private IQiyiService iQiyiService;
    @Autowired
    private EngineABTestService engineABTestService;

    @Autowired
    private AdvertPromoteTestCacheService advertPromoteTestCacheService;

    @Autowired
    private MakeTagCacheService makeTagCacheService;

    @Autowired
    private AdvertCondtionFilterService advertCondtionFilterService;

    private boolean checkSpecialApp(AdvOrientationItem item, AdvertVO advertVO, Long appId) {
        if (advertVO == null) {
            return false;
        }
        //为空则没有设置过可投的特殊媒体，不用过滤
        if (MapUtils.isEmpty(advertVO.getSpecialApps())) {
            return true;
        }

        List<Period> periods = advertVO.getSpecialApps().get(appId);

        //periods为空就说明广告设置了可投的特殊媒体，但是该请求媒体不在特殊媒体内，该媒体不能出该广告
        //空包appId写死了-1，拿出时就为空，不能出
        if (CollectionUtils.isEmpty(periods)) {
            return false;
        }
        //现在开始校验时段

        if(!periodsCheck(periods)){
            return false;
        }

        //TODO 此处逻辑有问题，cpa(ocpc)怎么过滤
        if(!CHARGE_TYPE_CPC.equals(item.getChargeType())){
            return true;
        }

        SpecialAppBo specialAppBo= Optional.ofNullable(advertVO.getSpecialAppsOtherData()).map(data->data.get(appId)).orElse(null);
        if(null == specialAppBo){
            return false;
        }

        //特殊广告 最低出价过滤(互动广告 需要 对 cpc 计费的 广告主 和 媒体进行 过滤)
        if(!lowestPriceCheck(specialAppBo.getLowestPrice(),item.getCpcPrice())){
            return false;
        }

        return true;
    }

    private boolean lowestPriceCheck(Long lowestPrice,Long cpcPrice){
        if(null == lowestPrice||null == cpcPrice){
            return false;
        }

        /**
         * 最低出价 要求 大于等于0，=-1时为没有最低出价(数据合理性校验)
         */
        if(lowestPrice == -1){
            return true;
        }

        if(lowestPrice > cpcPrice){
            return false;
        }

        return true;
    }


    private boolean periodsCheck(List<Period> periods) {
        DateTime dateTime = new DateTime(new Date());

        int curHourInt = Integer.parseInt(dateTime.toString("HHmm"));

        for (Period period : periods) {
            //时段为空则当不限处理，可以出
            if (StringUtils.isEmpty(period.getEndHour()) || StringUtils.isEmpty(period.getStartHour())) {
                return true;
            }

            String startHour = period.getStartHour().replaceAll(":", "");
            String endHour = period.getEndHour().replaceAll(":", "");

            int startHourInt = Integer.parseInt(startHour);
            int endHourInt = Integer.parseInt(endHour);

            //当前时段在配置的时间区间内则可投
            if (curHourInt >= startHourInt && curHourInt < endHourInt) {
                return true;
            }
        }

        //不在配置的时间区间内则不可投
        return false;
    }

    private String getAdvertTagNum(Set<String> newTradePromoteTags, AdvOrientationItem advOrientationItem) {
        //广告行业标签
        String advertIndustryTag = advOrientationItem.getAdvertTags().iterator().next();
        //广告落地页标签
        Set<String> advertPromoteTags = advOrientationItem.getPromoteUrlTags();
        Set<String> commonPromoteTags = Sets.newHashSet(newTradePromoteTags);
        commonPromoteTags.retainAll(advertPromoteTags);
        if (CollectionUtils.isNotEmpty(commonPromoteTags)) {
            return commonPromoteTags.iterator().next();
        } else {
            return advertIndustryTag;
        }
    }

    /**
     * @return false-媒体选择的行业或者广告和我们的广告池没有交集，过滤、true-媒体选择的行业或者广告和我们的广告池有交集，可以出券
     */
    @SuppressWarnings("squid:S3776")
    @Override
    public boolean appSelectAdvertCheck(AdvQueryParam advQueryParam,Set<Long> leftMaterial,Long advertId, AdvertVO advertVO) {
        boolean isElectApp = advQueryParam.isElectApp();

        //只有开启了互选功能的媒体才需要做下面的判断
        if (isElectApp) {
            if (advertVO == null) {
                return false;
            }
            Set<Long> appSelectAdvertIds = advQueryParam.getAppSelectAdvertIds();
            Set<String> appSelectTags = advQueryParam.getAppSelectTags();

            //如果媒体既没有选择行业也没有选择广告，则该媒体不能出券
            if (CollectionUtils.isEmpty(appSelectAdvertIds) && CollectionUtils.isEmpty(appSelectTags)) {
                return false;
            }
            //媒体既选择了广告又选择了标签，取合集，两个一起判断
            if (CollectionUtils.isNotEmpty(appSelectAdvertIds) && CollectionUtils.isNotEmpty(appSelectTags)) {
                Boolean result = appSelectAdvertIds.contains(advertId) || checkSelectIndustryTag(appSelectTags, advertVO);
                if(!result){
                    return result;
                }
            }
            //媒体只选择了行业标签，只用判断行业标签
            else if (CollectionUtils.isNotEmpty(appSelectTags)) {
                Boolean result = checkSelectIndustryTag(appSelectTags, advertVO);
                if(!result){
                    return result;
                }
            }
            //媒体只选择了广告，只用判断广告
            else if (CollectionUtils.isNotEmpty(appSelectAdvertIds)) {
                Boolean result = appSelectAdvertIds.contains(advertId);
                if(!result){
                    return result;
                }
            }

            //互选广告需优化-增加素材维度选择新增逻辑  不用考虑熔断情况
            Map<Long, Set<Long>> selectedAdvertAndMaterialIds = advQueryParam.getSelectedAdvertAndMaterialIds();
            if(null == selectedAdvertAndMaterialIds){
                //媒体后台 传过来的值是空的
                return false;
            }
            Set<Long> materialIds = selectedAdvertAndMaterialIds.get(advertId);
            if(null == materialIds||materialIds.isEmpty()||null == leftMaterial||leftMaterial.isEmpty()){
                //没有选中该广告，或者广告下可用素材是空的
                return false;
            }
            //素材取交集
            leftMaterial.retainAll(materialIds);
            return !leftMaterial.isEmpty();
        }
        return true;
    }

    private boolean checkSelectIndustryTag(Set<String> selectIndustryTags, AdvertVO advertVO) {
        AdvertTagDO advertTagDO = advertVO.getAdvertTagDO();
        if (advertTagDO == null) {
            return false;
        }
        //行业标签
        List<String> advertIndustryTags = StringTool.getStringListByStr(advertTagDO.getMatchTagNums());

        //不为空就有交集(true)，有交集就可以出券
        return CollectionUtils.isNotEmpty(CollectionUtils.intersection(selectIndustryTags, advertIndustryTags));
    }

    @Override
    public Map<String, List<AdvOrientationItem>>advertMemoryFilter(AdvQueryParam advQueryParam, AdvertFilter advertFilter, FilterResult filterResult, ObtainAdvertReq req) {
        try {
            DBTimeProfile.enter("advertMemoryFilter");
            // 获取有效广告的配置数据
            List<AdvOrientationItem> originalList = advertMapCacheManager.getValidPkgFilterCache();
            if (CollectionUtils.isEmpty(originalList)) {
                logger.warn("advOrientationItemList is empty");
                CatUtil.catLog(CatGroupEnum.CAT_102022.getCode());
                advertMapCacheManager.initAllValidAdvertFilterCache();
                return memoryFilterEmptyMap();
            }


            // 对配置包内容复制与设值
            List<AdvOrientationItem> advOrientationItemList = CatUtils.executeInCatTransaction(() -> copyAndPutItem(originalList, advQueryParam, advertFilter, req), "memoryFilter", "copyAndPut");

            // 新O实验
            this.newOcpcExp(advQueryParam, advOrientationItemList);

            // 过滤类型列表
            ConcurrentHashSet<AdvertFilterType> filterTypeSets = new ConcurrentHashSet<>(advOrientationItemList.size());

            // 已领取广告
            Set<Long> notInAdvertIds = getNotInIds(advQueryParam.getReceiveIds());
            advQueryParam.setReceiveIds(notInAdvertIds);

            Long joinNum = getUserJoinNum(advQueryParam.getJoinNum());
            advQueryParam.setFilterJoinNum(joinNum);

            // 定向媒体过滤
            Map<Boolean, List<AdvOrientationItem>> targetMap = CatUtils.executeInCatTransaction(() -> advOrientationItemList.stream().collect(Collectors.partitioningBy(adv -> targetAppFilter(adv, advQueryParam))), "memoryFilter", "targetApp");

            // 定向媒体过滤完剩下的配置
            List<AdvOrientationItem> targetRestList = targetMap.get(true);

            // 被定向媒体过滤掉的配置
            List<AdvOrientationItem> targetFilterList = targetMap.get(false);

            List<AdvOrientationItem> listAdvOrientationItem = CatUtils.executeInCatTransaction(() -> advertCondtionFilterService.filter(advQueryParam, advOrientationItemList, filterTypeSets, req, filterResult),"memoryFilter", "newFilterList");

//            // 用于二分法观察线上过滤耗时情况，前置过滤：地域过滤、操作平台系统、活动类型、屏蔽流量类型、参与次数、屏蔽标签
//            List<AdvOrientationItem> listAdvOrientationItem = CatUtils.executeInCatTransaction(() ->
//                    getBeforeFilterList(advQueryParam, advOrientationItemList, filterTypeSets, req),"memoryFilter", "getBeforeFilterList");
//
//            // 简单过滤：地域过滤，操作平台系统，活动类型，屏蔽流量类型等
//            List<AdvOrientationItem> listAdvOrientationItemFinal1 = listAdvOrientationItem;
//            listAdvOrientationItem = CatUtils.executeInCatTransaction(() ->
//                    getParallelStreamFilterList(advQueryParam, listAdvOrientationItemFinal1, filterTypeSets, req),"memoryFilter", "getParallelStreamFilterList");

//            //已转化人群过滤
//            listAdvOrientationItem = listAdvOrientationItem.stream().filter(
//                    item -> {
//                        if (null == item.getTfUserFilter() || item.getTfUserFilter().doFilter(advQueryParam.getDeviceFilterDto())) {
//                            return true;
//                        }else{
//                            //发生过滤且没有被过滤
//                            filterResult.setUserTfFilter("3");
//                            filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), AdvertFilterTypeEnum.TRANSFORM_PEOPLE.getCode()));
//                            return false;
//                        }
//                    }).collect(Collectors.toList());

            // 条件过滤完后可投列表
            List<AdvOrientationItem> resultList = ListUtils.intersection(listAdvOrientationItem, targetRestList);

            //重复曝光规则释放优化
            resultList = repeatExposureFilterService.filterRepeatExposureAd(resultList,advQueryParam, filterTypeSets, filterResult);

            // 活动预发券, 新行业标签过滤
            List<AdvOrientationItem> newAdvOrientationItemList = filterByActPreNewTradeTag(advQueryParam, resultList, filterTypeSets);

            Map<String, List<AdvOrientationItem>> oriItemListMap = Maps.newHashMapWithExpectedSize(newAdvOrientationItemList.size());
            oriItemListMap.put("itemList",  newAdvOrientationItemList);

            //新媒体试投重复曝光规则释放优化
            listAdvOrientationItem = repeatExposureFilterService.repeatExposureFilter(listAdvOrientationItem,advQueryParam, filterTypeSets);
            // 新媒体测试可投列表
            oriItemListMap.put("newAppTestList",  listAdvOrientationItem);


            // 被定向媒体过滤掉的
            Set<String> targetFilterStrSets = targetFilterList.stream().map(e -> e.getAdvertId() + "-" + e.getOrientationId()).collect(toSet());

            Set<AdvertFilterType> resultSets = advertFilter.getReason();
            // 去除定向媒体列表,设置过滤列表
            resultSets.addAll(filterTypeSets.stream().filter(e -> !targetFilterStrSets.contains(e.getA() + "-" + e.getO())).collect(toSet()));

            advertFilter.setReason(resultSets);

            return oriItemListMap;
        } catch (Throwable e) {
            logger.warn("advOrientationItemList is empty", e);
            CatUtil.catLog(CatGroupEnum.CAT_102022.getCode());
            return memoryFilterEmptyMap();
        } finally {
            DBTimeProfile.release();
        }
    }


    /**
     * 新ocpc实验
     * @param advQueryParam
     * @param originalList
     */
    private void newOcpcExp(AdvQueryParam advQueryParam, List<AdvOrientationItem> originalList) {

        Map<String, String> dayuArgumentMap = advQueryParam.getDayuArguments();

        if (dayuArgumentMap == null) {
            return;
        }

        // 获取
        String newO_ab = dayuArgumentMap.get(DayuArgumentsEnum.NEWO_AB.getKey());

        try {

            // 针对实验组或者对照组，取对应的白名单
            String panGuConfigKey = "";
            if (DayuArgumentsEnum.ab_exp.equals(newO_ab)) {
                panGuConfigKey = PangeaRelevantConstant.NEWO_WHITE_ADVERT;
            }

            if (DayuArgumentsEnum.ab_control.equals(newO_ab)) {
                panGuConfigKey = PangeaRelevantConstant.NEWO_WHITE_ADVERT_CONTROL;
            }

            // 获取白名单的配置::advertId-pkgId -> subType-cost
            Map<String, String> newOcpcAdvertWhiteMap = engineABTestService.getNewOcpcAdvertWhiteMap(panGuConfigKey);

            if (MapUtils.isEmpty(newOcpcAdvertWhiteMap)) {
                return;
            }

            // 遍历配置
            originalList.forEach(pkg -> {

                // cpc的配置不用管
                if (pkg.getChargeType() != null && ChargeTypeEnum.TYPE_CPC.getCode() == pkg.getChargeType()) {
                    return;
                }

                String adPkgStr = pkg.getAdvertId() + "-" + pkg.getOrientationId();

                // 在白名单内的配置
                if (newOcpcAdvertWhiteMap.containsKey(adPkgStr)) {

                    String valueStr = newOcpcAdvertWhiteMap.get(adPkgStr);

                    String[] split = valueStr.split("-");

                    // 覆盖掉原来的配置的优化目标和转化目标
                    pkg.setSubtype(Integer.parseInt(split[0]));

                    pkg.setCpaPrice(Long.parseLong(split[1]));
                }
            });

        } catch (Exception e) {
            logger.error("AdvertQueryServiceImpl.newOcpcExp is error", e);
        }
    }


    /**
     * 大盘主要场景 内存过滤代码
     *
     * @param advQueryParam
     * @param advertFilter
     * @param filterResult
     * @param req
     * @return
     */
    @Override
    @DBTimeProfiler
    public List<AdvOrientationItem> advertMemoryFilterMainScene(AdvQueryParam advQueryParam, AdvertFilter advertFilter, FilterResult filterResult, ObtainAdvertReq req) {

        try {
            // 获取有效广告的配置数据
            List<AdvOrientationItem> originalList = advertMapCacheManager.getValidPkgFilterCache();
            if (CollectionUtils.isEmpty(originalList)) {
                logger.warn("advOrientationItemList is empty");
                CatUtil.catLog(CatGroupEnum.CAT_102022.getCode());
                advertMapCacheManager.initAllValidAdvertFilterCache();
                return Collections.emptyList();
            }

            // 对配置包内容复制与设值
            List<AdvOrientationItem> advOrientationItemList = CatUtils.executeInCatTransaction(() -> copyAndPutItem(originalList, advQueryParam, advertFilter, req), "memoryFilter", "copyAndPut");

            // 新O实验
            this.newOcpcExp(advQueryParam, advOrientationItemList);

            //TODO 下面的代码 可以全部优化掉
            // 已领取广告
            Set<Long> notInAdvertIds = getNotInIds(advQueryParam.getReceiveIds());
            advQueryParam.setReceiveIds(notInAdvertIds);

            Long joinNum = getUserJoinNum(advQueryParam.getJoinNum());
            advQueryParam.setFilterJoinNum(joinNum);
            //TODO 上面两行代码可以优化

            // 过滤类型列表
            ConcurrentHashSet<AdvertFilterType> filterTypeSets = new ConcurrentHashSet<>(advOrientationItemList.size());

            //1、定向媒体过滤 定向媒体 不需要打印 过滤原因日志 已经确认
            List<AdvOrientationItem> orientAdvOrientationItem = advOrientationItemList.stream().
                    filter(adv -> targetAppFilter(adv, advQueryParam)).collect(Collectors.toList());


            List<AdvOrientationItem> listAdvOrientationItem = CatUtils.executeInCatTransaction(() -> advertCondtionFilterService.filter(advQueryParam, orientAdvOrientationItem, filterTypeSets, req, filterResult),"memoryFilter", "newFilterList");

//            // 2、用于二分法观察线上过滤耗时情况，前置过滤：地域过滤、操作平台系统、活动类型、屏蔽流量类型、参与次数、屏蔽标签
//            List<AdvOrientationItem> listAdvOrientationItem = CatUtils.executeInCatTransaction(() ->
//                    getBeforeFilterList(advQueryParam, orientAdvOrientationItem, filterTypeSets, req),"memoryFilter", "getBeforeFilterList");
//
//            // 3、简单过滤：地域过滤，操作平台系统，活动类型，屏蔽流量类型等
//            List<AdvOrientationItem> listAdvOrientationItemFinal1 = listAdvOrientationItem;
//            listAdvOrientationItem = CatUtils.executeInCatTransaction(() ->
//                    getParallelStreamFilterList(advQueryParam, listAdvOrientationItemFinal1, filterTypeSets, req),"memoryFilter", "getParallelStreamFilterList");

//            //4、已转化人群过滤
//            listAdvOrientationItem = listAdvOrientationItem.stream().filter(
//                    item -> {
//                        if (null == item.getTfUserFilter() || item.getTfUserFilter().doFilter(advQueryParam.getDeviceFilterDto())) {
//                            return true;
//                        }else{
//                            //发生过滤且没有被过滤
//                            filterResult.setUserTfFilter("3");
//                            filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), AdvertFilterTypeEnum.TRANSFORM_PEOPLE.getCode()));
//                            return false;
//                        }
//                    }).collect(Collectors.toList());

            //5、重复曝光规则释放优化
            listAdvOrientationItem = repeatExposureFilterService.filterRepeatExposureAd(listAdvOrientationItem,advQueryParam, filterTypeSets, filterResult);

            //6、活动预发券, 新行业标签过滤
            listAdvOrientationItem = filterByActPreNewTradeTag(advQueryParam, listAdvOrientationItem, filterTypeSets);


            //TODO 下面的代码可以优化
            Set<AdvertFilterType> resultSets = advertFilter.getReason();
            // 去除定向媒体列表,设置过滤列表
            resultSets.addAll(filterTypeSets);

            advertFilter.setReason(resultSets);

            //内存过滤-配置定向条件过滤后为空
            if (CollectionUtils.isEmpty(listAdvOrientationItem)) {
                CatUtil.catLog(CatGroupEnum.CAT_102002.getCode());
            }

            return listAdvOrientationItem;
        } catch (Throwable e) {
            logger.warn("advOrientationItemList is empty", e);
            CatUtil.catLog(CatGroupEnum.CAT_102022.getCode());
            return Collections.emptyList();
        }
    }

    /**
     * 活动预发券过滤
     * @param advQueryParam
     * @param listAdvOrientationItem
     * @param filterTypeSets
     * @return
     */
    private List<AdvOrientationItem> filterByActPreNewTradeTag(
            AdvQueryParam advQueryParam, List<AdvOrientationItem> listAdvOrientationItem, Set<AdvertFilterType> filterTypeSets) {
        if (CollectionUtils.isEmpty(listAdvOrientationItem)) {
            return listAdvOrientationItem;
        }
        // 1. 不是活动预发券 或者 新行业标签为空, 则不过滤
        if (StringUtils.isBlank(advQueryParam.getActPreNewTradeTagName())) {
            return listAdvOrientationItem;
        }

        // 2. 查询新行业标签的对应的广告列表
        List<Long> advertList = actPreCache.getAdvertList(advQueryParam.getActPreNewTradeTagName());

        return listAdvOrientationItem.stream()
                .filter(item -> {
                    Boolean result = advertList.contains(item.getAdvertId());
                    // 过滤掉的广告,添加过滤日志 (活动预发券类型)
                    if (!result) {
                        filterTypeSets.add(new AdvertFilterType(item.getAdvertId(),
                                item.getOrientationId(), AdvertFilterTypeEnum.ACTIVITY_PRE_TYPE_NEW_TRADE_TAG.getCode()));
                    }
                    return result;
                })
                .collect(Collectors.toList());
    }

    /**
     * 构建内存过滤后返回空map
     * @return
     */
    private Map<String,List<AdvOrientationItem>> memoryFilterEmptyMap() {
        Map<String, List<AdvOrientationItem>> oriItemListMap = Maps.newHashMap();
        oriItemListMap.put("itemList",  Lists.newArrayList());
        oriItemListMap.put("newAppTestList",  Lists.newArrayList());
        return oriItemListMap;
    }

    /**
     * 简单过滤：地域过滤，操作平台系统，活动类型，屏蔽流量类型等
     * @param advQueryParam
     * @param advOrientationItemList
     * @param filterTypeSets
     * @return
     */
    private List<AdvOrientationItem> getParallelStreamFilterList(AdvQueryParam advQueryParam,
                                                                 List<AdvOrientationItem> advOrientationItemList,
                                                                 Set<AdvertFilterType> filterTypeSets, ObtainAdvertReq req) {
        List<AdvOrientationItem> advOrientationItems;

        // 1.串行流过滤，关闭并行流方法
        if (StringUtils.isNotEmpty(parallelFlag) && "-1".equals(parallelFlag)) {

            advOrientationItems =  advOrientationItemList.stream().filter(adv ->isBooleanFilterCheck(advQueryParam, filterTypeSets, adv, req))
                    .collect(Collectors.toList());
            return advOrientationItems;
        }

        // 2.【或】并行流执行过滤
        try {
            ForkJoinTask<List<AdvOrientationItem>> submit = forkJoinPoolSimpleFilter.submit(() ->
                    advOrientationItemList.parallelStream().filter(adv ->isBooleanFilterCheck(advQueryParam, filterTypeSets, adv, req))
                            .collect(Collectors.toList()));
            advOrientationItems = submit.get();
        } catch (Exception e) {
            logger.error("AdvertQueryServiceImpl.getSimpleFilterList e:",e);
            advOrientationItems = new ArrayList<>();
        }
        return advOrientationItems;
    }

    /**
     * 并行流下的简单判断
     * @param advQueryParam
     * @param filterTypeSets
     * @param adv
     * @return
     */
    private boolean isBooleanFilterCheck(AdvQueryParam advQueryParam, Set<AdvertFilterType> filterTypeSets, AdvOrientationItem adv, ObtainAdvertReq req) {
        return !filterCheck(adv, AdvertFilterTypeEnum.BANNED_URL, advQueryParam, filterTypeSets, req)
                // 定向活动
                && filterCheck(adv, AdvertFilterTypeEnum.TARGET_ACTIVITY, advQueryParam, filterTypeSets, req)
                // 运营商
                && filterCheck(adv, AdvertFilterTypeEnum.OPERATORS, advQueryParam, filterTypeSets, req)
                // 手机价格区间
                && filterCheck(adv, AdvertFilterTypeEnum.BRAND_LEVEL, advQueryParam, filterTypeSets, req)
                // 网络类型
                && filterCheck(adv, AdvertFilterTypeEnum.NETWORK_TYPE, advQueryParam, filterTypeSets, req)
                // 手机品牌名称
                && filterCheck(adv, AdvertFilterTypeEnum.BRAND_NAME, advQueryParam, filterTypeSets, req)
                // 人群兴趣点
                && filterCheck(adv, AdvertFilterTypeEnum.USER_INTEREST, advQueryParam, filterTypeSets, req)
                // 以下是复杂的走缓存的过滤，曾经单独拆出来分析过的-------------------------------------
                // 过滤当前请求媒体是否是在广告的可投放媒体列表里面; 如果广告的可投放媒体列表为空则不用校验;
                // 判断当前时段是否在广告的可投放媒体列表设置的时段内
                && filterCheck(adv, AdvertFilterTypeEnum.SPECIAL_APP, advQueryParam, filterTypeSets, req)
                // 媒体广告互选
                && filterCheck(adv, AdvertFilterTypeEnum.SELECT_ADVERT, advQueryParam, filterTypeSets, req)
                // 投放时段过滤
                && filterCheck(adv, AdvertFilterTypeEnum.PERIOD, advQueryParam, filterTypeSets, req)
                // 配置日预算
                && filterCheck(adv, AdvertFilterTypeEnum.BUDGET_PER_DAY, advQueryParam, filterTypeSets, req)
                // 限流媒体
                && !filterCheck(adv, AdvertFilterTypeEnum.LIMIT_APP, advQueryParam, filterTypeSets, req)
                //应急填充广告过滤
                && filterCheck(adv, AdvertFilterTypeEnum.URGENT_ADVERT, advQueryParam, filterTypeSets, req)
                //
        && filterCheck(adv, AdvertFilterTypeEnum.MEDIA_TAG, advQueryParam, filterTypeSets, req)
                //
        && filterCheck(adv, AdvertFilterTypeEnum.CHOOSE_ADVERT, advQueryParam, filterTypeSets, req);
    }

    /**
     * 用于二分法观察线上过滤耗时情况
     * 前置过滤：地域过滤、操作平台系统、活动类型、屏蔽流量类型、参与次数、屏蔽标签
     * @param advQueryParam
     * @param advOrientationItemList
     * @param filterTypeSets
     * @return
     */
    private List<AdvOrientationItem> getBeforeFilterList(AdvQueryParam advQueryParam,
                                                         List<AdvOrientationItem> advOrientationItemList,
                                                         Set<AdvertFilterType> filterTypeSets, ObtainAdvertReq req) {
        List<AdvOrientationItem> advOrientationItems;

        // 1.串行流过滤，关闭并行流方法
        if (StringUtils.isNotEmpty(parallelFlag) && "-1".equals(parallelFlag)) {
            advOrientationItems =  advOrientationItemList.stream()
                    .filter(adv ->isaBooleanBeforeFilter(advQueryParam, filterTypeSets, adv, req)).collect(Collectors.toList());
            return advOrientationItems;
        }

        // 2.【或】并行流执行过滤
        try {
            ForkJoinTask<List<AdvOrientationItem>> submit = forkJoinPoolBeforeFilter.submit(() ->
                    advOrientationItemList.parallelStream()
                            .filter(adv -> isaBooleanBeforeFilter(advQueryParam, filterTypeSets, adv, req)).collect(Collectors.toList()));
            advOrientationItems = submit.get();
        } catch (Exception e) {
            logger.error("AdvertQueryServiceImpl.getBeforeFilterList e:",e);
            advOrientationItems = new ArrayList<>();
        }
        return advOrientationItems;

    }

    /**
     * 前置过滤：地域过滤、操作平台系统、活动类型、屏蔽流量类型、参与次数、屏蔽标签
     * @param advQueryParam
     * @param filterTypeSets
     * @param adv
     * @return
     */
    private boolean isaBooleanBeforeFilter(AdvQueryParam advQueryParam, Set<AdvertFilterType> filterTypeSets, AdvOrientationItem adv, ObtainAdvertReq req) {
        return  // 地域过滤
                filterCheck(adv, AdvertFilterTypeEnum.REGION, advQueryParam, filterTypeSets, req)
                        // 操作平台系统
                        && filterCheck(adv, AdvertFilterTypeEnum.PLATFORM, advQueryParam, filterTypeSets, req)
                        // 活动类型
                        && filterCheck(adv, AdvertFilterTypeEnum.ACTIVITY_TYPE, advQueryParam, filterTypeSets, req)
                        // 屏蔽流量类型
                        && !filterCheck(adv, AdvertFilterTypeEnum.BANNED_APP_FLOW, advQueryParam, filterTypeSets, req)
                        // 参与次数
                        && filterCheck(adv, AdvertFilterTypeEnum.JOIN_NUM, advQueryParam, filterTypeSets, req)
                        // 媒体广告位关键词屏蔽
                        && !filterCheck(adv, AdvertFilterTypeEnum.SLOT_KEYWORD, advQueryParam, filterTypeSets, req)
                        // 已领取广告
//                && !filterCheck(adv, AdvertFilterTypeEnum.REPEAT_EXPOSURE, advQueryParam, filterTypeSets)
                        // 实际测试发现上述的操作时间复杂为O(1)，屏蔽标签存在一定问题
                        //广告位屏蔽白名单
                        && !filterCheck(adv,AdvertFilterTypeEnum.SLOT_BLACKLIST, advQueryParam,filterTypeSets, req)
                        // 屏蔽标签
                        && !filterCheck(adv, AdvertFilterTypeEnum.BANNED_TAG, advQueryParam, filterTypeSets, req)
                        //设备定向
                        && filterCheck(adv, AdvertFilterTypeEnum.DEVICE, advQueryParam, filterTypeSets, req)
                        //
                        && filterCheck(adv, AdvertFilterTypeEnum.MICRO_PROGRAM_AB_TEST, advQueryParam, filterTypeSets, req)

                        && filterCheck(adv, AdvertFilterTypeEnum.NET_CARRIER_AB_TEST, advQueryParam, filterTypeSets, req)
                        // 快应用AB测试
                        && filterCheck(adv, AdvertFilterTypeEnum.QUICK_APP, advQueryParam, filterTypeSets, req)
                ;
    }

    /**
     *
     * getUserJoinNum:(用户参与次数转换，最大值为6). <br/>
     *
     * @author chencheng
     * @param joinNum
     * @return
     * @since JDK 1.8
     */
    private Long getUserJoinNum(Long joinNum) {
        if (joinNum == null) {
            return null;
        }
        return joinNum.longValue() > MAX_JOIN ? MAX_JOIN: joinNum;
    }

    /**
     *  过滤检查
     *
     *  着急上线先用 switch - case，后续优化代码可用策略模式处理
     *
     * @param item
     * @param typeEnum
     * @param advQueryParam
     * @param filterTypeSets
     * @return
     */
    @SuppressWarnings("squid:S3776")
    private boolean filterCheck(AdvOrientationItem item, AdvertFilterTypeEnum typeEnum, AdvQueryParam advQueryParam,
                                Set<AdvertFilterType> filterTypeSets, ObtainAdvertReq req){

        boolean result = false;
        switch (typeEnum){
            case ACTIVITY_TYPE:
                result = checkActivityType(item.getActivityType(), advQueryParam.getActivityType(),
                        advQueryParam.getAdType(), req.getActivityTypeExt());
//               result = checkStrContains(item.getActivityType(), advQueryParam.getActivityType());
                if(!result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case JOIN_NUM:
                result = checkIntegerContains(item.getJoinNums(), advQueryParam.getFilterJoinNum());
                if(!result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case PERIOD:
                result = serviceManager.checkPeriods(item.getPeriodList(), item.getIsChangePeriodList());
                if(!result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case USER_INTEREST:
                result = checkUserInterest(item, advQueryParam);
                if(!result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case REGION:
                result = checkStrContains(item.getRegionIds(), advQueryParam.getRegionId());
                if(!result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case LIMIT_APP:
                result = checkLimitApp(item,advQueryParam);
                if(result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case BANNED_APP_FLOW:
                result = checkBannedAppFlowType(item.getBannedAppFlowType(), advQueryParam.getBannedAppFlowType());
                if(result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case BANNED_TAG:
                result = checkBannedTags(item, advQueryParam, filterTypeSets);
//                if(result){
//                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
//                }
                break;
            case BANNED_URL:
                result = checkBannedUrlsContains(item.getPromoteUrl(), advQueryParam.getBannedUrls());
                if(result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case SPECIAL_APP:
                result = checkSpecialApp(item,advertMapCacheManager.getAdvertCache(item.getAdvertId()), advQueryParam.getAppId());
                if(!result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case SELECT_ADVERT:
                result = appSelectAdvertCheck(advQueryParam, item.getLeftMaterial(),item.getAdvertId(), advertMapCacheManager.getAdvertCache(item.getAdvertId()));
                if(!result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case PLATFORM:
                result = checkStrContains(item.getPlatform(), advQueryParam.getPlatform());
                if(!result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case NETWORK_TYPE:
                result = checkIntegerContains(item.getNetworkTypes(), advQueryParam.getNetworkTypes());
                if(!result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case OPERATORS:
                result = checkIntegerContains(item.getOperators(), advQueryParam.getOperators());
                if(!result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case BRAND_NAME:
                String quryBrandName = StringTool.clearSpaceAndExtCaptial(advQueryParam.getBrandName());
                Set<String> branNameSets = StringTool.clearSpaceAndExtCaptial(item.getBrandName());
                result = checkStrContains(branNameSets, quryBrandName);
                if(!result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case BRAND_LEVEL:
                result = checkStrContains(item.getPhoneLevels(), advQueryParam.getPhoneLevels());
                if(!result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case REPEAT_EXPOSURE:
                result = checkNotInAdvertIds(item.getAdvertId(), advQueryParam.getReceiveIds());
                if(result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case BUDGET_PER_DAY:
                result = advertPkgPutFlagCacheService.getAdvertPkgPutFlag(item.getAdvertId(), item.getOrientationId(), item.getBudgetPerDay());
                if(!result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case TARGET_ACTIVITY:
                result = checkBindActivity(item.getBinActivityId(), advQueryParam.getActivityId());
                if(!result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;

            case URGENT_ADVERT:
                result = urgentAdvertFilter(item);
                if(!result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case SLOT_BLACKLIST:
                result = slotBlackListFilter(item,advQueryParam);
                if(result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case DEVICE:
                result = deviceFilter(item,advQueryParam);
                if(!result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case SLOT_KEYWORD:
                result = keywordFilter(item, advQueryParam, req, filterTypeSets);
//                if(result){
//                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
//                }
                break;
            case MICRO_PROGRAM_AB_TEST:
                result = microProgramABTestFilter(item, advQueryParam, req);
                if(!result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case QUICK_APP:
                result = quickAppABTestFilter(item, advQueryParam, req);
                if(!result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case NET_CARRIER_AB_TEST:
                result = netCarrierABTestFilter(item, advQueryParam, req);
                if(!result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case MEDIA_TAG:
                result = mediaTagFilter(item, advQueryParam, req);
                if(!result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            case CHOOSE_ADVERT:
                result = chooseAdvertFilter(item, advQueryParam);
                if(!result){
                    filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
                }
                break;
            default:
                break;
        }
        return result;
    }

    private boolean chooseAdvertFilter(AdvOrientationItem item, AdvQueryParam advQueryParam) {

        MediaList mediaWhiteList = advQueryParam.getMediaWhiteList();
        if(mediaWhiteList != null && mediaWhiteList.isAdvertInList(item.getAdvertId(),item.getAccountId())){
            //在白名单中 直接可投
            return true;
        }

        //资源标签
        String resourceTag = item.getResourceTag();
        //行业标签
        Set<String> advertTags = item.getAdvertTags();
        //定制的可投广告列表
        SlotChooseAdverttVO slotChooseAdverttVO = advQueryParam.getSlotChooseAdverttVO();

        return null == slotChooseAdverttVO || slotChooseAdverttVO.chooseItem(resourceTag,advertTags,item.getAdvertId(),item.getAccountId());
    }

    private boolean mediaTagFilter(AdvOrientationItem item, AdvQueryParam advQueryParam, ObtainAdvertReq req) {
        List<String> mediaTags = req.getMediaTags();
        if(CollectionUtils.isEmpty(mediaTags)){
            return true;
        }

        Long advertId = item.getAdvertId();
        Long orientationId = item.getOrientationId();
        Map<String, String> idMapByKeyStr = apolloPanGuService.getIdMapByKeyStr("tuia-engine.media-tag");
        String tags = MapUtils.isEmpty(idMapByKeyStr) ? null : idMapByKeyStr.get(advertId + "-" + orientationId);
        if (StringUtils.isBlank(tags)) {
            return true;
        }

        String[] split = tags.split(",");
        Set<String> hashSet = new HashSet();
        for (String s : split) {
            if (StringUtils.isNotBlank(s)) {
                hashSet.add(s);
            }
        }

        return mediaTags.stream().anyMatch(mediatag->hashSet.contains(mediatag));
    }

    private boolean netCarrierABTestFilter(AdvOrientationItem item, AdvQueryParam advQueryParam, ObtainAdvertReq req) {
        if(ExpNetCarrierServiceImpl.HIT_VALUE.equals(advQueryParam.getExpNetCarrierHit())){
            Integer netCarrier = req.getNetCarrier();
            Map<String, String> idMapByKeyStr = null;
            try {
                idMapByKeyStr = apolloPanGuService.getIdMapByKeyStr("tuia-engine.abtest.net.carrier");
            } catch (Exception e) {
                idMapByKeyStr = new HashMap<>();
                logger.warn("盘古获取配置失败异常。", e);
            }
            String carrier = MapUtils.isEmpty(idMapByKeyStr) ? null : idMapByKeyStr.get(String.valueOf(item.getAdvertId()));
            return null == carrier || (netCarrier != null && netCarrier.toString().equals(carrier));
        }
        return true;
    }

    private Boolean checkLimitApp(AdvOrientationItem item, AdvQueryParam advQueryParam) {
        Boolean result = limitingMaximunService.hasInLimitingMaximunApps(item.getAdvertId(), item.getOrientationId(), advQueryParam.getAppId(), advQueryParam.getSlotId(), item.getInitialOrientationId());

        //配置被过滤 且 满足释放条件
        //释放条件
        if(result && releaseCondition(item,advQueryParam)){
            //打标记
            item.setAppLimitReleaseMark("1");
            //释放
            return false;
        }

        return result;
    }

    private Boolean releaseCondition(AdvOrientationItem item, AdvQueryParam advQueryParam) {
        //命中实验 且
        // 配置的行业在 配置的媒体行业 之中 且
        // 不在黑名单中 且
        // 是oCPC-抢量优先（高）的配置
        Set<String> tradeSet = advQueryParam.getExpTradeSet();
        //广告的行业标签，基本只有一个 可能为 null
//        Set<String> advertTags = item.getAdvertTags();
        AdvertNewTradeDO advertNewTradeName = advertNewTradeCacheService.getAdvertNewTradeName(item.getAdvertId());
        String newTradeName = (null == advertNewTradeName ? "未知" : advertNewTradeName.getNewTradeName());

        Long advertId = item.getAdvertId();
        Set<Long> expBlackList = advQueryParam.getExpBlackList();

        // 配置的行业在 配置的媒体行业 之中 且
        //不在黑名单中
        //ocpc-抢量优先（高）的配置
        return CollectionUtils.isNotEmpty(tradeSet) &&  tradeSet.contains(newTradeName) &&
                (CollectionUtils.isEmpty(expBlackList) || !expBlackList.contains(advertId)) &&
                Objects.equals(ChargeTypeEnum.TYPE_CPA.getCode(),item.getChargeType()) && Objects.equals(3,item.getPutTargetType());
    }

    private boolean microProgramABTestFilter(AdvOrientationItem item, AdvQueryParam advQueryParam, ObtainAdvertReq req) {

        Map<String, String> abtestMap = advQueryParam.getAbtestMap();
        Map<String, String> idMapByKeyStr = apolloPanGuService.getIdMapByKeyStr("MiniProgramtest-payAD");

        /**
         * 此处逻辑修改了  命中 1 则过滤，其他（命中 2，不做此实验的流量）不过滤
         */

        Map<String, String> experimentUniqueKeyList = apolloPanGuService.getIdMapByKeyStr("MiniProgramtest-experiment");

        if (null != abtestMap && MapUtils.isNotEmpty(experimentUniqueKeyList) && experimentUniqueKeyList.keySet().stream().anyMatch(key -> abtestMap.containsKey(key))
                && null != idMapByKeyStr && idMapByKeyStr.containsKey(String.valueOf(item.getInitialOrientationId()))) {
            return false;
        }

        return true;
    }

    private boolean quickAppABTestFilter(AdvOrientationItem item, AdvQueryParam advQueryParam, ObtainAdvertReq req) {
        if (StringUtils.isNotBlank(req.getQuickApp()) && StringUtils.equalsIgnoreCase(req.getQuickApp(), "0")) {
            Map<String, String> idMapByKeyStr = null;
            try {
                idMapByKeyStr = apolloPanGuService.getIdMapByKeyStr("tuia-engine.quickapp.advertList");
            } catch (Exception e) {
                logger.warn("盘古配置获取异常", e);
            }
            if (MapUtils.isNotEmpty(idMapByKeyStr) && idMapByKeyStr.containsKey(String.valueOf(item.getAdvertId()))) {
                return false;
            }
        }
        return true;
    }

    /**
     * 过滤设备定向
     * @param item
     * @param advQueryParam
     * @return
     */
    private boolean deviceFilter(AdvOrientationItem item, AdvQueryParam advQueryParam) {
        if (item.getDeviceOrientType() && !advQueryParam.getHaveDevice()) {
            return false;
        }
        return true;
    }

    /**
     * 关键词屏蔽
     * @param item
     * @param advQueryParam
     * @return true 要屏蔽 false不需要屏蔽
     */
    private boolean keywordFilter(AdvOrientationItem item, AdvQueryParam advQueryParam, ObtainAdvertReq req, Set<AdvertFilterType> filterTypeSets) {

        //美团adx 不需要处理
        if (null != req.getAdxMediaType() && req.getAdxMediaType() == 1) {
            return false;
        }

        AdvertFilterKeywordDO advertFilterKeywordDO = advQueryParam.getAdvertFilterKeywordDO();
        if (null == advertFilterKeywordDO || Objects.isNull(advertFilterKeywordDO.getGeneralFilterKeywordDO()) || Objects.isNull(advertFilterKeywordDO.getNewTradeFilterKeywordDO())) {
            return false;
        }

        NewTradeFilterKeywordDO newTradeFilterKeywordDO = advertFilterKeywordDO.getNewTradeFilterKeywordDO();
        if (Objects.nonNull(newTradeFilterKeywordDO) && CollectionUtils.isNotEmpty(newTradeFilterKeywordDO.getAdvertIdList())) {
            Set<Long> advertIds = newTradeFilterKeywordDO.getAdvertIdList();
            boolean result = advertIds.contains(item.getAdvertId());
            if (result) {
                filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), AdvertFilterTypeEnum.SLOT_NEWTRADE_KEYWORD.getCode()));
                return true;
            }
        }


        GeneralFilterKeywordDO generalFilterKeywordDO = advertFilterKeywordDO.getGeneralFilterKeywordDO();
        if (Objects.nonNull(generalFilterKeywordDO) && CollectionUtils.isNotEmpty(generalFilterKeywordDO.getAdvertIdList())) {
            Set<Long> advertIds = generalFilterKeywordDO.getAdvertIdList();
            boolean result = advertIds.contains(item.getAdvertId());
            if (result) {
                filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), AdvertFilterTypeEnum.SLOT_KEYWORD.getCode()));
                return true;
            }
        }

        return false;
    }

    /**
     * 广告为黑名单过滤，判断是否在黑名单中
     * @param item
     * @param advQueryParam
     * @return
     */
    private boolean slotBlackListFilter(AdvOrientationItem item, AdvQueryParam advQueryParam) {

        MediaList mediaBlackList = advQueryParam.getMediaBlackList();
        if(null == mediaBlackList){
            return false;
        }
        return mediaBlackList.isAdvertInList(item.getAdvertId(),item.getAccountId());
//        advQueryParam.getMediaWhiteList();
    }

    /**
     *
     * @param activityTypeSet 配置的结果集合
     * @param activityType 传入的 类型
     * @param adType 广告类型
     * @return
     */
    private boolean checkActivityType(Set<String> activityTypeSet, String activityType, String adType, List<Integer> activityTypeExt) {
//        if(null != adType && PackagePlanConstants.VEDIO_AD_TYPE.equals(adType)){
//            //激励视屏投放类型，仅过滤 是 type = "8" 的视频广告
//            return null != activityTypeSet && activityTypeSet.contains(ActivityTypeEnum.VEDIO_ADVERT_ACTIVITY_TYPE.getCodeStr());
//        }
//        //请求的活动类型为 9 或者 11
//        else

        //12 代表 活动工具类型 和 视频素材类型
        if (null != activityTypeExt && activityTypeExt.contains(12)) {
            return checkStrContains(activityTypeSet, String.valueOf(PackagePlanConstants.ACT_ACTIVITY_TYPE));
//            || checkStrContains(activityTypeSet, PackagePlanConstants.NEW_VEDIO_AD_ACTIVITY_TYPE);
        }

        if(PackagePlanConstants.NEW_VEDIO_AD_ACTIVITY_TYPE.equals(activityType) || ActivityTypeEnum.DP_ADVERT_ACTIVITY_TYPE.getCodeStr().equals(activityType)){
            //不允许不限 必须包含 响应类型
            return CollectionUtils.isNotEmpty(activityTypeSet) && activityTypeSet.contains(activityType);
        }
        else if (CollectionUtils.isEmpty(activityTypeExt)) {
            //默认为老逻辑
            return checkStrContains(activityTypeSet, activityType);
        } else {
            if (checkStrContains(activityTypeSet, activityType)) {
                return true;
            }

            for (Integer ext : activityTypeExt) {
                if (checkStrContains(activityTypeSet, String.valueOf(ext))) {
                    return true;
                }
            }
            return false;
        }
    }

    private boolean urgentAdvertFilter(AdvOrientationItem item) {
        try {
            Long advertId = item.getAdvertId();
            Long orientId = item.getOrientationId();
            String key = advertId.toString() + "-" + orientId.toString();
            Boolean status = serviceManager.getUrgentAdvertStatusByKey(key);

            if(null == status){
                return true;
            }
            return !status;
        } catch (Exception e) {
            logger.error("urgentAdvertFilter获取配置消耗是否满足广告消耗占比失败，默认投放");
            return true;
        }
    }

    /**
     * 定向媒体过滤
     *
     * @param adv
     * @param advQueryParam
     * @return
     */
    private boolean targetAppFilter(AdvOrientationItem adv, AdvQueryParam advQueryParam) {
        return strongCheck(adv) && advertTargetAppCacheService.checkTargetApp(adv.getTargetApps(), adv.getTargetAppSlots(), advQueryParam.getAppId(), advQueryParam.getSlotId());
    }

    private boolean strongCheck(AdvOrientationItem adv) {
        if (adv.getTargetAppLimit().equals(TrusteeshipConstants.NOT_LIMIT)) {
            return true;
        } else if (adv.getAutoMatch().equals(TrusteeshipConstants.ENABLE_AUTO_MATCH)) {
            return true;
        } else {
            return adv.getStrongTarget();
        }
    }


    /**
     * 对配置包复制并设值
     *
     * @param originalList
     * @param advQueryParam
     * @param advertFilter
     * @return
     */
    private List<AdvOrientationItem> copyAndPutItem(List<AdvOrientationItem> originalList, AdvQueryParam advQueryParam,
        AdvertFilter advertFilter, ObtainAdvertReq req) {
        ConcurrentHashMap<String, AdvOrientationItem> mapList = new ConcurrentHashMap<>(originalList.size());
        ConcurrentHashSet<AdvertFilterType> resultSets = new ConcurrentHashSet<>(originalList.size());

        //串行流过滤，关闭并行流方法
        if (StringUtils.isNotEmpty(parallelFlag) && "-1".equals(parallelFlag)) {
            originalList.forEach(adv -> copyAndPutParaMethod(advQueryParam, mapList, resultSets, adv, req));
            List<AdvOrientationItem> result = new ArrayList<>(mapList.values());
            advertFilter.setReason(resultSets);
            return result;
        }

        // 并行流执行过滤
        try {
            ForkJoinTask submit = forkJoinPoolCopyAndPut.submit(() ->
                    originalList.parallelStream().forEach(adv -> copyAndPutParaMethod(advQueryParam, mapList, resultSets, adv, req)));
            submit.get();
        } catch (Exception e) {
            logger.error("AdvertQueryServiceImpl.copyAndPutParaMethod e", e);
        }
        List<AdvOrientationItem> result = new ArrayList<>(mapList.values());
        advertFilter.setReason(resultSets);
        return result;
    }

    /**
     * 复制广告配置，并行流
     * @param advQueryParam
     * @param mapList
     * @param resultSets
     * @param adv
     */

    private void copyAndPutParaMethod(AdvQueryParam advQueryParam, ConcurrentHashMap<String, AdvOrientationItem> mapList, ConcurrentHashSet<AdvertFilterType> resultSets, AdvOrientationItem adv, ObtainAdvertReq req) {
        //素材过滤
        Set<Long> materialIds = advertMaterialRecommendService.filterByAdvertId(adv.getAdvertId(),adv.getAccountId(), advQueryParam);

        if(CollectionUtils.isEmpty(materialIds)){
            // 添加素材标签过滤日志
            resultSets.add(new AdvertFilterType(adv.getAdvertId(), adv.getOrientationId(), AdvertFilterTypeEnum.BANNED_MATERIAL_TAG.getCode()));
            return;
        }

        materialIds = advertMaterialRecommendService.filterNewTradeBySlotId(advQueryParam, materialIds, adv.getAdvertId(), req);
        if(CollectionUtils.isEmpty(materialIds)){
            // 添加素材标签过滤日志
            resultSets.add(new AdvertFilterType(adv.getAdvertId(), adv.getOrientationId(), AdvertFilterTypeEnum.SLOT_NEWTRADE_KEYWORD.getCode()));
            return;
        }

        //媒体广告位下关键词过滤素材
        materialIds = advertMaterialRecommendService.filterBySlotId(advQueryParam, materialIds, adv.getAdvertId(), req);
        if(CollectionUtils.isEmpty(materialIds)){
            // 添加素材标签过滤日志
            resultSets.add(new AdvertFilterType(adv.getAdvertId(), adv.getOrientationId(), AdvertFilterTypeEnum.SLOT_KEYWORD.getCode()));
            return;
        }


        materialIds = advertMaterialRecommendService.filterByMaterialType(materialIds,adv.getAdvertId(),advQueryParam,req);

        if(CollectionUtils.isEmpty(materialIds)){
            resultSets.add(new AdvertFilterType(adv.getAdvertId(), adv.getOrientationId(), AdvertFilterTypeEnum.VIDEO_MATERIAL_TYPE.getCode()));
            return;
        }

        //爱奇艺流量判断
        if (iQiyiService.isIQiyiFlow(req)) {
            String key = adv.getAdvertId() + "|" + adv.getOrientationId();
            OrientPkgFilterUrlDO orientPkgFilterUrlDO = advertPkgCacheService.getAdvertOrientPkgCache(key);
            adv.setOrientPkgFilterUrlDO(orientPkgFilterUrlDO);
            if (Objects.isNull(orientPkgFilterUrlDO) || (!orientPkgFilterUrlDO.isAdvertSupport() && !orientPkgFilterUrlDO.isPkgSupport())) {
                resultSets.add(new AdvertFilterType(adv.getAdvertId(), adv.getOrientationId(), AdvertFilterTypeEnum.IQIYI_URL_FILTER.getCode()));
                return;
            }
        }

        //TODO 根据活动类型过滤素材
        materialIds = advertMaterialRecommendService.filterByActivityType(advQueryParam.getActivityMaterialType(),adv.getAdvertId(),materialIds);
        if(CollectionUtils.isEmpty(materialIds)){
            resultSets.add(new AdvertFilterType(adv.getAdvertId(), adv.getOrientationId(), AdvertFilterTypeEnum.ACTIVITY_MATERIAL_TYPE.getCode()));
        }else{

            // originalList从guava中取出（entry方式）后还是指向内存中的数据，多线程修改存在线程安全问题，此处copy一份item，指向新的内存对象，避免线程间的错乱
            AdvOrientationItem advOrientationItem = copy(adv);

            advOrientationItem.setLeftMaterial(materialIds);
            // 消耗模式校验修改
            serviceManager.checkBudgetSmooth(adv.getPeriodList(), advOrientationItem);

            // 设置定向媒体，是否开启智能采买
            Integer autoMatch = advOrientationItem.getAutoMatch();
            advOrientationItem.setAutoMatch(TrusteeshipConstants.DISABLE_AUTO_MATCH);
            //获取广告的行业标签或者落地页标签，用户获取广告对应的新行业
            advOrientationItem.setNewTradeTagNum(getAdvertTagNum(advQueryParam.getNewTradePromoteTags(), advOrientationItem));
            //通过NewTradeTagNum 去关联获取 NewTradeTagId
            advOrientationItem.setNewTradeTagId(getAdvertTagId(advOrientationItem.getNewTradeTagNum()));
            if (putTargetApps(advOrientationItem, advOrientationItem.getTargetAppLimit(), advQueryParam, autoMatch)) {
                String tempKey = advOrientationItem.getAdvertId() + "," + advOrientationItem.getOrientationId();
                mapList.put(tempKey, advOrientationItem);
            }


            // 有效的素材列表存于advQueryParam，用于侧漏监控
            List<AdvertMaterialDto> validAdvertMaterialList = advertMaterialRecommendService.getMaterialListByAdvertId(adv.getAdvertId());
            if(CollectionUtils.isNotEmpty(validAdvertMaterialList)){
                Set<Long> finalMaterialIds = materialIds;
                List<AdvertMaterialDto> validAdvertMaterialSet = validAdvertMaterialList.stream().filter(e -> finalMaterialIds.contains(e.getId())).collect(toList());
                if(CollectionUtils.isNotEmpty(validAdvertMaterialSet)){
                    advQueryParam.setValidAdvertMaterialSet(validAdvertMaterialSet);
                }
            }
        }
    }

    private String getAdvertTagId(String newTradeTagNum) {
        return advertNewTradeCacheService.getTagNewTradeId(newTradeTagNum);
    }


    private AdvOrientationItem copy(AdvOrientationItem item) {

        AdvOrientationItem advOrientationItem = new AdvOrientationItem();
        advOrientationItem.setBudgetSmooth(item.getBudgetSmooth());
        advOrientationItem.setOrder(item.getOrder());
        advOrientationItem.setPutTargetType(item.getPutTargetType());
        advOrientationItem.setFocusAppConvertCost(item.getFocusAppConvertCost());
        advOrientationItem.setAppTargetPackage(item.getAppTargetPackage());
        advOrientationItem.setSlotTargetPackage(item.getSlotTargetPackage());
        advOrientationItem.setPeriodList(item.getPeriodList());
        advOrientationItem.setNewTradeTagNum(item.getNewTradeTagNum());
        advOrientationItem.setNewTradeTagId(item.getNewTradeTagId());
        advOrientationItem.setResourceTag(item.getResourceTag());
        advOrientationItem.setStrongTarget(item.getStrongTarget());
        advOrientationItem.setTargetAppSlots(item.getTargetAppSlots());
        advOrientationItem.setLeftMaterial(item.getLeftMaterial());
        advOrientationItem.setSubtype(item.getSubtype());
        advOrientationItem.setMaterialIds(item.getMaterialIds());
        advOrientationItem.setTargetAppLimit(item.getTargetAppLimit());
        advOrientationItem.setAutoMatch(item.getAutoMatch());
        advOrientationItem.setSupportStatus(item.getSupportStatus());
        advOrientationItem.setAdvertWeight(item.getAdvertWeight());
        advOrientationItem.setIsChangePeriodList(item.getIsChangePeriodList());
        advOrientationItem.setId(item.getId());
        advOrientationItem.setPackageType(item.getPackageType());
        advOrientationItem.setOrientationId(item.getOrientationId());
        advOrientationItem.setAdvertId(item.getAdvertId());
        advOrientationItem.setOrderLevel(item.getOrderLevel());
        advOrientationItem.setLevelUpdateTime(item.getLevelUpdateTime());
        advOrientationItem.setStartDate(item.getStartDate());
        advOrientationItem.setEndDate(item.getEndDate());
        advOrientationItem.setCpcPrice(item.getCpcPrice());
        advOrientationItem.setCpaPrice(item.getCpaPrice());
        advOrientationItem.setChargeType(item.getChargeType());
        advOrientationItem.setAgeStart(item.getAgeStart());
        advOrientationItem.setAgeEnd(item.getAgeEnd());
        advOrientationItem.setPromoteUrl(item.getPromoteUrl());
        //判断推广链接是否是百奇或积木落地页链接，并设置标记信息
        advOrientationItem.setSourceId(item.getSourceId());
        advOrientationItem.setSourceType(item.getSourceType());

        advOrientationItem.setBudgetPerDay(item.getBudgetPerDay());
        advOrientationItem.setAdvertBudgetPerDay(item.getAdvertBudgetPerDay());
        advOrientationItem.setAccountId(item.getAccountId());
        advOrientationItem.setSource(item.getSource());
        advOrientationItem.setRegionIds(item.getRegionIds());
        advOrientationItem.setPlatform(item.getPlatform());
        advOrientationItem.setPhoneLevels(item.getPhoneLevels());
        advOrientationItem.setNetworkTypes(item.getNetworkTypes());
        advOrientationItem.setOperators(item.getOperators());
        advOrientationItem.setBannedTags(item.getBannedTags());
        advOrientationItem.setAdvertTags(item.getAdvertTags());
        advOrientationItem.setPromoteUrlTags(item.getPromoteUrlTags());
        advOrientationItem.setTargetApps(item.getTargetApps());
        advOrientationItem.setAllShieldTags(item.getAllShieldTags());
        advOrientationItem.setAdvBannedTag(item.getAdvBannedTag());
        advOrientationItem.setGlobalShieldTags(item.getGlobalShieldTags());
        advOrientationItem.setJoinNums(item.getJoinNums());
        advOrientationItem.setOldAdvertIds(item.getOldAdvertIds());
        advOrientationItem.setBannedAppFlowType(item.getBannedAppFlowType());
        advOrientationItem.setAppFlowType(item.getAppFlowType());
        advOrientationItem.setBrandName(item.getBrandName());
        advOrientationItem.setUserInterest(item.getUserInterest());
        advOrientationItem.setUserNotInterest(item.getUserNotInterest());
        advOrientationItem.setPeoplePkgPools(item.getPeoplePkgPools());
        advOrientationItem.setExcludePeoplePkgPools(item.getExcludePeoplePkgPools());
        advOrientationItem.setActivityType(item.getActivityType());
        advOrientationItem.setInitialOrientationId(item.getInitialOrientationId());
        advOrientationItem.setBinActivityId(item.getBinActivityId());
        advOrientationItem.setEnableAdvertUrl(item.getEnableAdvertUrl());
        advOrientationItem.setPromoteTestUrl(item.getPromoteTestUrl());
        advOrientationItem.setDisAppFeeType(item.getDisAppFeeType());
        advOrientationItem.setAppCostStableSwitch(item.getAppCostStableSwitch());
        advOrientationItem.setDepthSubtype(item.getDepthSubtype());
        advOrientationItem.setDepthTargetPrice(item.getDepthTargetPrice());
        advOrientationItem.setIsObctTag(item.getIsObctTag());
        advOrientationItem.setAutoBiddingType(item.getAutoBiddingType());
        advOrientationItem.setTfUserFilter(item.getTfUserFilter());
        advOrientationItem.setAssessType(item.getAssessType());
        advOrientationItem.setDeviceOrientType(item.getDeviceOrientType());
        advOrientationItem.setOutOrderRate(item.getOutOrderRate());
        advOrientationItem.setOrientPkgFilterUrlDO(item.getOrientPkgFilterUrlDO());
        return advOrientationItem;
    }


    /**
     * 人群兴趣标签过滤
     *
     * 如果 当前流量的标签为空， 1。有定向的情况 则当前过滤掉    2。有排查的情况  则不过滤掉  (@周艺伟)
     * @param item
     * @param advQueryParam
     * @return
     */
    private Boolean checkUserInterest(AdvOrientationItem item, AdvQueryParam advQueryParam) {

        List<String> userInterest = advQueryParam.getUserInterest();

        Boolean interest = doCheckUserInterest(item,userInterest);

        //人群包定向实验 添加逻辑
        Map<String, String> dayuArguments = advQueryParam.getDayuArguments();
        //命中实验 且 被人群包过滤
        if (null != dayuArguments &&
                TransferDayuServiceImpl.OPEN.equals(dayuArguments.get(TransferDayuServiceImpl.PEOPLE_PREFER))
                && interest.equals(false) && null != item.getChargeType() && ChargeTypeEnum.TYPE_CPA.getCode() == item.getChargeType()) {
            //人群包拓量打标
            item.setPeoplePrffer("1");

            return true;
        }
        return interest;

    }

    private Boolean doCheckUserInterest(AdvOrientationItem item, List<String> queryUserInterest) {
        List<? extends CustomMemFilter> peoplePkgPools = item.getPeoplePkgPools();
        List<? extends CustomMemFilter> exculdePeoplePkgPools = item.getExcludePeoplePkgPools();

        Set<String> userInterest = (null == queryUserInterest ? new HashSet<>() : new HashSet<>(queryUserInterest));

        //定向
        if(CollectionUtils.isNotEmpty(peoplePkgPools)){
            //无论定向排除 有一个池子被过滤 即被过滤
            for (CustomMemFilter peoplePkgPool : peoplePkgPools) {
                if(!peoplePkgPool.filter(userInterest)){
                    return false;
                }
            }
        }

        //排除
        if(CollectionUtils.isNotEmpty(exculdePeoplePkgPools)){
            for (CustomMemFilter exculdePeoplePkgPool : exculdePeoplePkgPools) {
                //有一个通过即可通过
                if(exculdePeoplePkgPool.filter(userInterest)){
                    return true;
                }
            }
            //全部都不通过 过滤
            return false;
        }

        //不限 或 全部通过
        return true;
    }

    /**
     * setTargetApps:(设置定向媒体). <br/>
     *
     * @param adv
     * @param targetAppLimit
     * @param advQueryParam
     * @param autoMatch
     * @return
     * @author chencheng
     * @since JDK 1.8
     */
    private Boolean putTargetApps(AdvOrientationItem adv, Integer targetAppLimit, AdvQueryParam advQueryParam, Integer autoMatch) {

        AdvertTargetAppVO targetAppVO = advertTargetAppCacheService.selectByAdvertIdAndPackageId(adv.getAdvertId(), adv.getOrientationId());
        if (targetAppVO == null) {
            return false;
        }

        Set<Long> targetApps = targetAppVO.getTargetApps();
        Set<String> targetAppSlots = targetAppVO.getTargetAppSlots();

        if(targetApps == null || targetApps.size() == 0 || targetAppSlots == null || targetAppSlots.size() == 0) {
            return false;
        }

        // 定向媒体
        adv.setTargetApps(targetApps);
        adv.setTargetAppSlots(targetAppSlots);

        adv.setExistTargetAppOrSlot(!targetApps.contains(-1L) || !targetAppSlots.contains("-1"));

        adv.setAppTargetPackage(targetAppVO.getAppTargetPackage());
        adv.setSlotTargetPackage(targetAppVO.getSlotTargetPackage());
        adv.setTargetRecommendType(getTargetRecommendType(targetAppVO.getTargetRecommendType(), advQueryParam.getAppId()));
        // 判断配置包强弱定向
        // 下面对strongTarget赋值的代码仅给哪吒使用，不参与过滤，参与过滤的是后面的strongCheck
        if (targetAppLimit == TrusteeshipConstants.AUTO_MODE || targetAppLimit == TrusteeshipConstants.OPTIMAL_MODE) {

            adv.setAutoMatch(isAutoMatchOpen(advQueryParam, adv, targetAppLimit, autoMatch));
            adv.setOcpcExpandTag(String.valueOf(adv.getAutoMatch()));
            Boolean aBoolean = advertTargetAppCacheService.checkTargetApp(targetApps, adv.getTargetAppSlots(), advQueryParam.getAppId(), advQueryParam.getSlotId());

            // 自动、优投模式开启了智能匹配,如果定向媒体为不限,则将该流量全部变为弱定向
            if (Objects.equals(adv.getAutoMatch(), TrusteeshipConstants.ENABLE_AUTO_MATCH) && (targetApps.contains(-1L))) {
                adv.setStrongTarget(false);
            } else {
                //此处强弱定向可能为true或者false，后面strongCheck逻辑就是过滤掉此处没有开启智能匹配并且为false的的配置
                adv.setStrongTarget(aBoolean);//强定向
            }
            adv.setTargetApps(new HashSet<>(Collections.singletonList(-1L)));
            adv.setTargetAppSlots(new HashSet<>(Collections.singletonList("-1")));
        } else {
            adv.setStrongTarget(true);//人工包，强定向
        }
        return true;
    }

    private Integer getTargetRecommendType(Map<Long, Integer> targetRecommendType, Long appId) {
        if (targetRecommendType == null || targetRecommendType.size() == 0) {
            return 0;
        }
        return Optional.ofNullable(targetRecommendType.get(appId)).orElse(0);
    }

    /**
     * getNotInIds:(汇总要剔除的广告id). <br/>
     */
    private Set<Long> getNotInIds(Set<Long> receiveIds) {
        Set<Long> notInAdvertIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(receiveIds)) {
            notInAdvertIds.addAll(receiveIds);
        }
        return notInAdvertIds;
    }

    /**
     * checkStrContains:(string类型，是否被包含。为空表示不限). <br/>
     */
    private Boolean checkStrContains(Set<String> list, String value) {
        // 请求参数或者广告属性为空，返回true
        if (list == null || list.size() == 0 || StringUtils.isBlank(value)) {
            return true;
        }
        return list.contains(value);
    }

    /**
     * checkNotInAdvertIds:(如果广告在被剔除列表中). <br/>
     */
    private Boolean checkNotInAdvertIds(Long advertId, Set<Long> notInAdvertIds) {
        if (CollectionUtils.isEmpty(notInAdvertIds)) {
            return false;
        }
        return notInAdvertIds.contains(advertId);
    }

    /**
     * checkBannedTags:(是否命中屏蔽标签). <br/>
     */
    private Boolean checkBannedTags(AdvOrientationItem item,  AdvQueryParam advQueryParam, Set<AdvertFilterType> filterTypeSets) {
        // 广告白名单不过滤
        MediaList mediaWhiteList = advQueryParam.getMediaWhiteList();
        if(mediaWhiteList != null && mediaWhiteList.isAdvertInList(item.getAdvertId(),item.getAccountId())){
           return false;
        }

        AdvBannedTag advBannedTag = item.getAdvBannedTag();
        AdvBannedTag advQueryBannedTag = advQueryParam.getAdvBannedTag();

        // 按照 行业-资源-属性-落地页 顺序匹配过滤
        boolean industryTagsMatch = isAnyMatch(advBannedTag.getIndustryTags(), advQueryBannedTag.getIndustryTags());
        if (industryTagsMatch) {
            filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), AdvertFilterTypeEnum.BANNED_INDUSTRY_TAG.getCode()));
            return true;
        }
        boolean resourceTagsMatch = isAnyMatch(advBannedTag.getResourceTags(), advQueryBannedTag.getResourceTags());
        if (resourceTagsMatch) {
            filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), AdvertFilterTypeEnum.BANNED_RESOURCE_TAG.getCode()));
            return true;
        }
        boolean attributeTagsMatch = isAnyMatch(advBannedTag.getAttributeTags(), advQueryBannedTag.getAttributeTags());
        if (attributeTagsMatch) {
            filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), AdvertFilterTypeEnum.BANNED_ATTRIBUTE_TAG.getCode()));
            return true;
        }

        //如果是百奇或积木域名，添加独有的落地页标签
        Set<String> promoteTagSet = advBannedTag.getPromoteUrlTags();
        if (item.getSourceId() != null && item.getSourceType() != null) {
            List<String> makeTags = makeTagCacheService.getMakeTagByKey(item.getSourceId(), item.getSourceType());
            if (CollectionUtils.isNotEmpty(makeTags)) {
                promoteTagSet.addAll(makeTags);
            }
        }
        boolean promoteUrlTagsMatch = isAnyMatch(promoteTagSet, advQueryBannedTag.getPromoteUrlTags());
        if (promoteUrlTagsMatch) {
            filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), AdvertFilterTypeEnum.BANNED_PROMOTEURL_TAG.getCode()));
            return true;
        }
        return false;
    }

    private static boolean isAnyMatch(Collection<String> collection1, Collection<String> collection2) {
        if (CollectionUtils.isEmpty(collection1) || CollectionUtils.isEmpty(collection2)) {
            return false;
        }
        return collection1.stream().anyMatch(collection2::contains);
    }

    /**
     * checkBannedUrlsContains:(是否命中屏蔽url). <br/>
     */
    private Boolean checkBannedUrlsContains(String promoteUrl, Set<String> bannedUrls) {
        // 请求参数或者广告属性为空，返回true
        if (CollectionUtils.isEmpty(bannedUrls) || StringUtils.isBlank(promoteUrl)) {
            return false;
        }
        return bannedUrls.contains(promoteUrl);
    }

    /**
     *checkBindActivity:(定向活动过滤)
     */
    private Boolean checkBindActivity(Set<Long> bindActivityId, Long avtivityId){
        // false : 过滤掉 true :  留下来
        if(CollectionUtils.isEmpty(bindActivityId)){
            return true;
        }

        return bindActivityId.contains(avtivityId);
    }


    /**
     * checkIntegerContains:(int类型，是否被包含。为空表示不限). <br/>
     */
    private Boolean checkIntegerContains(Set<Integer> adv, Object req) {
        // 请求参数或者广告属性为空，返回true
        if (adv == null || adv.size() == 0 || req == null) {
            return true;
        }
        return adv.contains(Integer.parseInt(req.toString()));

    }

    /**
     * checkBannedAppFlowType:(命中屏蔽流量). <br/>
     */
    private Boolean checkBannedAppFlowType(Set<String> advBannedAppFlowType, String reqBannedAppFlowType) {
        // 请求参数或者广告属性为空，返回false
        if (CollectionUtils.isEmpty(advBannedAppFlowType) || StringUtils.isBlank(reqBannedAppFlowType)) {
            return false;
        }
        return advBannedAppFlowType.contains(reqBannedAppFlowType);
    }

    /**
     * 人工定向判断是否开启智能拓量
     *
     * @param advQueryParam 广告查询参数
     * @param adv 广告券
     * @param targetAppLimit 投放模式
     * @param autoMatch 智能拓量开关
     * @return 是否开启智能拓量（1.开启，0.不开启）
     */
    private Integer isAutoMatchOpen(AdvQueryParam advQueryParam, AdvOrientationItem adv, Integer targetAppLimit,
                                    Integer autoMatch) {
        if (!(Objects.equals(adv.getChargeType(), ChargeTypeEnum.TYPE_CPA.getCode())
                && Objects.equals(adv.getPutTargetType(), PutTargetTypeEnum.manual_target.getPutTargetType()))) {
            return autoMatch;
        }

        // 判断当前请求流量是否命中实验分流
//        String expName = Optional.ofNullable(advQueryParam.getDayuArguments()).map(args -> args.get("name")).orElse(null);
//        if (!Objects.equals(expName, "expB") && !Objects.equals(expName, "expD")) {
//            return autoMatch;
//        }

        // 判断人工定向配置是否默认开启拓量
        Long advertId = adv.getAdvertId();
        try {
            // 校验人工定向开启拓量行业白名单, 强定向（即人工定向）配置默认开启拓量白名单，行业维度，需要配置新行业名称
            String whiteListStr = apolloPanGuService.getIdMapStrByKeyStr("whitelist.Strictlytargeted.invalid");
            Set<String> whiteList = StringTool.getStringSetByStr(whiteListStr);

            AdvertNewTradeDO newTrade = advertNewTradeCacheService.getAdvertNewTradeName(advertId);
            if (null == newTrade || null == newTrade.getNewTradeName() || !whiteList.contains(newTrade.getNewTradeName())) {
                return autoMatch;
            }

            // 人工定向开启拓量广告黑名单, 广告维度黑名单，黑名单内广告的强定向（即人工定向）配置不会默认开启拓量
            String blackListStr = apolloPanGuService.getIdMapStrByKeyStr("blacklist.Strictlytargeted.invalid");
            Set<Long> blackList = StringTool.getLongSetByStr(blackListStr);
            if (!blackList.contains(advertId)) {
                return TrusteeshipConstants.ENABLE_AUTO_MATCH;
            }
        } catch (Exception e) {
            logger.warn("isAutoMatchOpen error, advertId={}, targetAppLimit={}", advertId, targetAppLimit, e);
        }
        return autoMatch;
    }
}
