package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.AqyAttributeDto;
import cn.com.duiba.nezha.engine.api.constant.AlgFeatureMapConstant;
import cn.com.duiba.nezha.engine.api.dto.*;
import cn.com.duiba.nezha.engine.api.enums.ActivitySceneEnum;
import cn.com.duiba.nezha.engine.api.enums.FlowTypeEnum;
import cn.com.duiba.nezha.engine.api.remoteservice.advert.RemoteAdvertRecommendService;
import cn.com.duiba.tuia.api.TuiaMediaClientService;
import cn.com.duiba.tuia.bo.AdvertService;
import cn.com.duiba.tuia.cache.*;
import cn.com.duiba.tuia.constants.AdvertConstants;
import cn.com.duiba.tuia.constants.AdvertReqLogExtKeyConstant;
import cn.com.duiba.tuia.constants.CommonConstants;
import cn.com.duiba.tuia.constants.ErrorCode;
import cn.com.duiba.tuia.core.api.dto.rsp.RspMaterialList;
import cn.com.duiba.tuia.core.api.enums.advert.AdvertPkgPeriodTypeEnum;
import cn.com.duiba.tuia.dao.material.AdvertMaterialRealtionService;
import cn.com.duiba.tuia.dao.material.impl.AdvertMaterialRealtionServiceImpl;
import cn.com.duiba.tuia.dao.recommend_app.RecommendAppDAO;
import cn.com.duiba.tuia.domain.dataobject.*;
import cn.com.duiba.tuia.domain.enums.ABTestLayerCodeEnum;
import cn.com.duiba.tuia.domain.enums.ABTestSkipEnum;
import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.domain.model.abtest.ABArgumentKeyConstant;
import cn.com.duiba.tuia.domain.model.abtest.ABResult;
import cn.com.duiba.tuia.domain.vo.AdvertFilterVO;
import cn.com.duiba.tuia.domain.vo.AdvertPriceVO;
import cn.com.duiba.tuia.domain.vo.AdvertVO;
import cn.com.duiba.tuia.domain.vo.MaterialPromoteTestUrlsVO;
import cn.com.duiba.tuia.enums.AdvertSubtypeEnum;
import cn.com.duiba.tuia.enums.AppFlowTypeEnum;
import cn.com.duiba.tuia.enums.CatGroupEnum;
import cn.com.tuia.advert.enums.ResourceTagsTypeEnum;
import cn.com.duiba.tuia.enums.adx.AdxLoadTypeEnum;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.com.duiba.tuia.service.*;
import cn.com.duiba.tuia.service.AdvertSystemConfigService.AdvertSystemConfigEnum;
import cn.com.duiba.tuia.service.buildparam.NezhaAdvertExploreService;
import cn.com.duiba.tuia.service.router.FlowRouterProxyService;
import cn.com.duiba.tuia.service.router.FlowRouterService;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaTagDto;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.duiba.tuia.tool.StringTool;
import cn.com.duiba.tuia.utils.ActPreUtils;
import cn.com.duiba.tuia.utils.TuiaStringUtils;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.tuia.advert.constants.CommonConstant;
import cn.com.tuia.advert.constants.PangeaRelevantConstant;
import cn.com.tuia.advert.constants.SystemConfigKeyConstant;
import cn.com.tuia.advert.enums.*;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import com.alibaba.fastjson.JSON;
import com.duiba.tuia.abtest.api.dto.ABRequestDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.Map.Entry;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * Created by hujinliang on 2017/8/14.
 */
@Service
@RefreshScope
public class AdvertRecommendServiceImpl extends BaseCacheService implements AdvertRecommendService {

    private static final AtomicInteger COUNTER = new AtomicInteger(0);

    // 探索实验组
    private static final Set<String> EXPLORE_TRANSFORM_SET = Sets.newHashSet("expB", "expD");

    // 特殊代理商的ids配置
    @Value("${engine.config.special.agentids}")
    private String                       specialAgentIds;
    private List<String>                 specialAgentIdsList;
    @Autowired
    private ApolloConfig                 apolloConfig;
    @Autowired
    private AdvertMapCacheManager        advertMapCacheManager;
    @Autowired
    private AdvertOrderCacheService      advertOrderCacheService;
    @Autowired
    private ResourceTagsService          resourceTagsService;
    @Autowired
    private AdvertExposeService          advertExposeService;
    @Resource
    private FlowRouterProxyService flowRouterProxyService;
    @Resource
    private AdvertService                advertService;

    @Autowired
    private RecommendAppDAO recommendAppDAO;

    @Resource
    private RemoteAdvertRecommendService remoteAdvertRecommendService;
    @Autowired
    private MediaCacheService            mediaCacheService;
    @Resource
    private ExecutorService executorService;
    @Autowired
    private AdvertMaterialRecommendService advertMaterialRecommendService;

    /** 是流程元素*/
    private static final Integer IS_PREVALENT=1;
    @Autowired
    private TuiaMediaClientService tuiaMediaClientService;

    @Autowired
    private AppLowArpuCacheService appLowArpuCacheService;

    @Autowired
    private ServiceManager serviceManager;

    @Resource
    private AdvertCompensateCacheService advertCompensateCacheService;
    @Autowired
    private AdvertMaterialRealtionService advertMaterialRealtionService;
    @Autowired
    private AdvertMaterialTestPlanCacheService advertMaterialTestPlanCacheService;

    @Autowired
    private AdvertNewTradeCacheService advertNewTradeCacheService;

    @Autowired
    private LayeredStrategyService layeredStrategyService;

    @Autowired
    private AdvertPromoteTestCacheService advertPromoteTestCacheService;

    @Autowired
    private ApolloPanGuService apolloPanGuService;

    @Autowired
    private NezhaAdvertExploreService nezhaAdvertExploreService;
    @Resource
    private FlowRouterService flowRouterService;
    @Resource
    private ConsumerService consumerService;
    @Resource
    private MinPriceService minPriceService;

    /**
     * rcmdResult:(尝试投放算法推荐的广告). <br/>
     *
     * @param req
     * @param rsp
     * @param filterResult
     * @param recommendAdvertDto
     * @throws TuiaException
     * @author ZFZ
     * @param rcmdAdvertList 哪吒推荐回的广告列表
     * @since JDK 1.6
     */
    @SuppressWarnings("squid:S3776")
    public void rcmdResult(ObtainAdvertReq req, ObtainAdvertRsp rsp, FilterResult filterResult,
                           RcmdAdvertDto recommendAdvertDto, AdvertPriceVO advertPriceVO,
                           List<RcmdAdvertDto> rcmdAdvertList, AdvertFilter advertFilter) throws Exception {
        long advertId = recommendAdvertDto.getAdvertId();
        //获取广告信息
        AdvertVO advertVO = advertMapCacheManager.getAdvertCache(advertId);
        if (advertVO == null) {
            logger.info("serviceManager.getAdvert error, advertVO is null the advertId = [{}]", advertId);
            throw new TuiaException(ErrorCode.E0500008);
        }

        // 无CPA,CPC配置
        if (null == advertPriceVO) {
            logger.error("nezha recommend not callback orientationPackageId the advertId = [{}]", advertId);
            throw new TuiaException(ErrorCode.E0500031);
        }
        // 目标出价
        Long aFee = advertPriceVO.getFee();

        // 推荐算法返回的推荐价格
        Long finalFee = recommendAdvertDto.getFee();

        if ("CPA".equals(ChargeTypeEnum.getByCode(advertPriceVO.getChargeType()).getDesc())) {
            Integer cvrType = Optional.ofNullable(advertPriceVO.getSubtype()).orElse(0);
            try {
                DBTimeProfile.enter("rcmdResult->calFinalFeeHandle");
                finalFee = calFinalFeeHandle(finalFee, advertVO.getAdvertPlan().getAgentId(),cvrType, req.getSlotId(),req.getAppId(),filterResult);
            }finally {
                DBTimeProfile.release();
            }
        }
        // 设置最终价格
        advertPriceVO.setFee(finalFee);
        // 设置广告权重
        advertPriceVO.setWeight(recommendAdvertDto.getWeight());

        // 设置广告arpu值
        req.setArpuVal(Math.round(recommendAdvertDto.getFee() * recommendAdvertDto.getCtr()));
        filterResult.setArpuValue(recommendAdvertDto.getFee() * recommendAdvertDto.getCtr());

        filterResult.setFinalLowArpu(recommendAdvertDto.getFinalLowArpu());

        // 平滑因子
        filterResult.setSmoothFactor(recommendAdvertDto.getSmoothFactor());
        // 设置素材，如果素材为空，之后还会重新获取素材
        rsp.setMaterialId(recommendAdvertDto.getMaterialId());

        // 设置流量类型
        rsp.setFlowTag(recommendAdvertDto.getTag());

        if(StringUtils.isNotBlank(recommendAdvertDto.getApplyUserInterestTag())){
            // 设置nezha返回的使用了的tag维度的调价因子对应的tag,存放到订单中，发点击，计费，转化消息给nezha用的
            advertPriceVO.setHitUserInterest(Sets.newHashSet(recommendAdvertDto.getApplyUserInterestTag()));
        }


        // 设置nezha返回的配置与流量标签取交集的标签集，存放到订单中，用于曝光，点击，计费，转化日志打印
        advertPriceVO.setNezhaHitUserInterestTags(recommendAdvertDto.getHitUserInterestTags());


        //dmp命中广告打命中广告日志
        try {
            DBTimeProfile.enter("rcmdResult->dmpAdvertDOS");
            dmpAdvertDOS(filterResult, advertId, advertPriceVO);
        }finally {
            DBTimeProfile.release();
        }

        // 设置广告扶持
        String supportPlanPromote = (Objects.nonNull(recommendAdvertDto.getSupportSuccess()) && recommendAdvertDto.getSupportSuccess()) ? "1" : "0";
        // 判断是否广告扶持 是否AB分流，未提权
        if (advertPriceVO.getSupportStatus() != null && advertPriceVO.getSupportStatus() == 1
                && advertPriceVO.getSupportShunt() != null && !advertPriceVO.getSupportShunt()) {
            supportPlanPromote = "3";
        }

        filterResult.setSupportPlanPromote(supportPlanPromote);

        advertPriceVO.setSupportPlanPromote(supportPlanPromote);
        advertPriceVO.setSupportPlanWeight(Objects.isNull(recommendAdvertDto.getSupportWeight()) ? "0" : String.valueOf(recommendAdvertDto.getSupportWeight()));

        //设置维稳值
        filterResult.setAdjustPriceFactor(recommendAdvertDto.getAdjustPriceFactor());
        filterResult.setPreCtr(recommendAdvertDto.getPreCtr());
        filterResult.setPreCvr(recommendAdvertDto.getPreCvr());

        //设置extExpMap 打印全链路日志
        if (null == req.getLogExtExpMap()) {
            req.setLogExtExpMap(new HashMap<>());
        }
        Integer expandAdvert = recommendAdvertDto.getExpandAdvert();
        if(null != expandAdvert && 1 == expandAdvert) {
            req.getLogExtExpMap().put("ocpc_expand_tag", "1");
        }

        Integer expandPeople = recommendAdvertDto.getPeopleExpand();
        if (null != expandPeople) {
            req.getLogExtExpMap().put("people_expand_tag", String.valueOf(expandPeople));
        }

        List<ABResult.ABResultDTO> hitABResult = advertPriceVO.getHitABResult();
        if (CollectionUtils.isNotEmpty(hitABResult)) {
            try {
                String abtest = req.getLogExtExpMap().get(AdvertReqLogExtKeyConstant.ABTEST);
                if (StringUtils.isNotBlank(abtest)) {
                    List<ABResult.ABResultDTO> abResultList = JSON.parseArray(abtest, ABResult.ABResultDTO.class);
                    abResultList.addAll(hitABResult);
                    req.getLogExtExpMap().put(AdvertReqLogExtKeyConstant.ABTEST, JSON.toJSONString(abResultList));
                } else {
                    req.getLogExtExpMap().put(AdvertReqLogExtKeyConstant.ABTEST, JSON.toJSONString(hitABResult));
                }
            } catch (Exception e) {
                logger.warn("素材测试打印实验平台结果异常", e);
            }
        }
        // 券次序定制广告标识日志
//        if (null != recommendAdvertDto.getOrderCustomFlag()) {
//            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ORDER_CUSTOM_FLAG, String.valueOf(recommendAdvertDto.getOrderCustomFlag()));
//        }


        try {
            DBTimeProfile.enter("rcmdResult.finishBiz");
            advertExposeService.finishBiz(req, rsp, advertId, advertVO, filterResult, advertPriceVO, aFee, advertFilter);
        } finally {
            DBTimeProfile.release();
        }

        if(rsp.isResult()){
            // 推荐成功的情况需要记录过滤结果
            filterResult.setResultCode(ErrorCode.E0000000.getErrorCode());
            filterResult.setSuccessId(advertId);
            filterResult.setAdvertOrderId(rsp.getAdvertOrderId());
            filterResult.setChargeType(ChargeTypeEnum.getByCode(advertPriceVO.getChargeType()).getDesc());
            filterResult.setOrderId(recommendAdvertDto.getOrderId());
            filterResult.setFee(finalFee);
            filterResult.setPlanId(advertPriceVO.getAdvertOrientationPackageId());
            // 包的类型 1-人工生成的包 2-智能生成的策略包
            filterResult.setPackageType(advertPriceVO.getPackageType());
            // 活动类型
            filterResult.setActivitySceneType(advertPriceVO.getActivityType());
            // 设置后端调整因子
            filterResult.setSubtype(advertPriceVO.getSubtype());
            // 设置是否券次序定制广告
            filterResult.setOrderCustom(recommendAdvertDto.isOrderCustom());
            filterResult.setOrderCustomFilter(recommendAdvertDto.getOrderCustomFilter());

            //构建filterResult的推荐竞价排名列表日志
            buildRecommendRankList(filterResult, recommendAdvertDto, rcmdAdvertList);
        }
    }

    private static void buildRecommendRankList(FilterResult filterResult, RcmdAdvertDto recommendAdvertDto, List<RcmdAdvertDto> rcmdAdvertList) {
        Map<String, Object> logMap = filterResult.getLogExtMap();
        logMap.put("ctr", recommendAdvertDto.getCtr());
        logMap.put("statCtr", recommendAdvertDto.getStatCtr());
        logMap.put("preCtr", recommendAdvertDto.getPreCtr());
        logMap.put("cvr", recommendAdvertDto.getCvr());
        logMap.put("statCvr", recommendAdvertDto.getStatCvr());
        logMap.put("preCvr", recommendAdvertDto.getPreCvr());

        //竞价排名列表
        List<RecommendLogEntity> recommendLogList = Lists.newArrayList();
        int i = 1;
        for (RcmdAdvertDto rcmdAdvertDto : rcmdAdvertList) {
            //第一个也打印一下
            RecommendLogEntity recommendLogEntity = new RecommendLogEntity();
            recommendLogEntity.setAdvertId(rcmdAdvertDto.getAdvertId());
            recommendLogEntity.setPackageId(rcmdAdvertDto.getPackageId());
            recommendLogEntity.setCtr(rcmdAdvertDto.getCtr());
            recommendLogEntity.setCvr(rcmdAdvertDto.getCvr());
            recommendLogEntity.setCpc(rcmdAdvertDto.getFee());
            recommendLogEntity.setRank(i);
            recommendLogList.add(recommendLogEntity);
            i++;
        }

        logMap.put("recommendRankList", JSON.toJSONString(recommendLogList));
    }

    /**
     * 计算最终的广告出价处理
     *
     * @param finalFee 推荐算法返回的推荐价格，也是最终的返回价格
     * @param agentId 代理商id
     * @param cvrType
     * @param slotId 广告位Id
     * @return finalFee 最终比较计算出的价格
     * @throws TuiaException
     */
    public Long calFinalFeeHandle(Long finalFee, Long agentId, Integer cvrType, Long slotId,Long appId,FilterResult filterResult) throws TuiaException {
        List<String> specialAgentIds = TuiaStringUtils.getStringListByStr(this.specialAgentIds);
        // 特殊代理商
        if (specialAgentIds.contains(agentId.toString())) {
            Long ocpcConvertMinPrice = AdvertSystemConfigEnum.specialAgentOCPCMinPrice.getLongValue();
            finalFee = finalFee < ocpcConvertMinPrice ? ocpcConvertMinPrice : finalFee;
        } else {
            // 广告位白名单底价判断
            Long minPriceInSlot = minPriceService.getMinPriceFromSlotWhitelist(appId,slotId);
            if (null != minPriceInSlot) {
                finalFee = finalFee < minPriceInSlot ? minPriceInSlot : finalFee;
                return finalFee;
            }

            // 获取管理后台配置的最低点击价格
            Long minClickPrice;
            if (cvrType.equals(0)) {
                 minClickPrice = AdvertSystemConfigEnum.oCPCClickMinPrice.getLongValue();
                // 算出最终价格,如果推荐价格低于最低价格,则使用最低价格
            } else {
                 minClickPrice = serviceManager.getIntValue(SystemConfigKeyConstant.OCPA_MIN_PRICE).longValue();
            }

            //如果 打了这个标记 就不走后面的底价替换逻辑了 @产品 余非
            Integer isNeedExploit = filterResult.getIsNeedExploit();
            if ((finalFee < minClickPrice) ) {
                if (Objects.equals(isNeedExploit, ActivitySceneEnum.ACTIVITY_CUSTOMIZED_ADVERT.getCode())) {
                    //这种情况下不替换
                    CatUtil.log(CatGroupEnum.CAT_107033.getCode());
                }else{
                    return minClickPrice;
                }
            }

        }
        return finalFee;
    }

    /**
     * 【维稳】出价及底价数据传给算法
     * @param specialAgentIds
     * @param agentId
     * @param cvrType
     * @param ocpaMinPrice
     * @param minPriceInSlot 盘古配置的广告位白名单的ocpc底价
     * @return
     */
    private Long calFinalFeeHandle(List<String> specialAgentIds, Long agentId, Integer cvrType,
                                   Integer ocpaMinPrice, Long minPriceInSlot) {
        // 特殊代理商
        if (specialAgentIds.contains(String.valueOf(agentId))) {
            return AdvertSystemConfigEnum.specialAgentOCPCMinPrice.getLongValue();
        }
        // 广告位白名单底价判断
        if (null != minPriceInSlot) {
            return minPriceInSlot;
        }
        // 落地页转化
        if (AdvertSubtypeEnum.CVR.getSubtype().equals(cvrType)) {
            return AdvertSystemConfigEnum.oCPCClickMinPrice.getLongValue();
        }
        // 管理后台字典配置
        if (ocpaMinPrice != null) {
            return ocpaMinPrice.longValue();
        }
        return null;
    }
    /**
     * doObtainRecommendAdvert:(选取推荐算法，并尝试投放推荐的广告). <br/>
     *
     * @param req 请求广告接口的请求参数
     * @param rsp 请求广告接口的返回结果
     * @param filterResult 过滤结果对象
     * @return isNeedDegrade 是否需要降级
     * @author sunjiangrong
     * @since JDK 1.6
     */
    @Override
    @SuppressWarnings("squid:S3776")
    public void doObtainRecommendAdvert(ObtainAdvertReq req, ObtainAdvertRsp rsp, FilterResult filterResult,
                                        Map<Long, AdvertFilterVO> hasValidAdverts, AdvQueryParam advQueryParam,
                                        ConsumerDto consumerDto, AppDetail appDetail, AdvertFilter advertFilter) {

        try {
            DBTimeProfile.enter("RecommendAdvert.recommendAdvert");

            //1.构建推荐参数
            ReqAdvertNewDto dto = new ReqAdvertNewDto();

            //2.设置传入的广告列表
            List<AdvertNewDto> advertNewDtoList = CatUtils.executeInCatTransaction(
                    () -> this.getAdvertMaxFeeList(hasValidAdverts, filterResult, req),
                    "recommendAdvert", "getMaxFeeList");
            dto.setAdvertList(advertNewDtoList);

            //3.1判断是否走场景2
            boolean isSceneTwo = this.isSceneTwo(req, consumerDto);
            // 设置imei号
            buildImeiOaidIdfaMd5(req, consumerDto);
            dto.setConsumerDto(consumerDto);

            //4.设置传入媒体参数
            AppDto appDto = new AppDto();
            appDto.setAppId(req.getAppId());
            appDto.setSlotId(req.getSlotId());
            appDto.setAppUserInterest(StringTool.getStringBySet(Sets.newHashSet(advQueryParam.getUserInterest()), "_"));
            appDto.setImeiBasicTags(StringUtils.replace(advQueryParam.getImeiBasicTags(),",", "_"));

            appDto.setAqySex(consumerService.getAqySexFeature(req.getDeviceId()));
            this.setSlotSize(appDto);
            this.setAppTags(appDto);
            dto.setAppDto(appDto);

            //5.设置传入活动参数
            AdvertActivityDto advertActivityDto = new AdvertActivityDto();
            advertActivityDto.setActivityId(req.getDuibaActivityId());
            advertActivityDto.setActivityType(transformToLong(advQueryParam.getActivityType()));
            advertActivityDto.setActivityUseType(req.getActivityUseType());
            advertActivityDto.setTag(req.getTag());
            advertActivityDto.setOperatingActivityId(req.getActivityId());
            advertActivityDto.setActivityTypeExt(req.getActivityTypeExt());
            advertActivityDto.setActivityScene(filterResult.getIsNeedExploit());
            dto.setAdvertActivityDto(advertActivityDto);

            //6.设置传入广告参数
            RequestDto reqAdvertDto = getRequestDto(req, advQueryParam);
            dto.setRequestDto(reqAdvertDto);

            //7.走ABtest
            //7.1获取实验平台返回结果
            ABTestLayerCodeEnum layerCodeEnum = isSceneTwo ? ABTestLayerCodeEnum.SLOT_ID : ABTestLayerCodeEnum.NORMAL;
            ABResult handleResult = flowRouterProxyService.routeFlow(req, layerCodeEnum);

            if (req.getLogExtExpMap() == null) {
                req.setLogExtExpMap(new HashMap<>());
            }

            // 双出价第一层实验
            String sceneDoubleFeeStrategyPoint = getSceneDoubleFeeStrategyPoint(req, filterResult.getLogExtMap(), reqAdvertDto);

            //AB流量标识 放入filterResult过滤日志
            filterResult.setLinkParagraph(CommonConstants.DAYU);
            //7.2如果请求结果为空,走降级
            if (handleResult == null) {
                logger.error("Dayu AB-test has happened error !");
                return;
            }
            //7.3获取参数
            Map<String, String> arguments = handleResult.getArguments();
            String strategyPointString = arguments.getOrDefault("strategyPoint", "278");

            // 如果走大盘切流,看看要不要改成aqySexPoint
            strategyPointString = getReplacePoint(appDto, consumerDto, isSceneTwo, reqAdvertDto.getDayuArgumentsMap(), strategyPointString);

            //7.3.1 判断是否微信流量(不包含微信小程序)，如果是走oneId分流场景
            strategyPointString = getOneIdReplacePoint(req, consumerDto, strategyPointString);

            //7.4如果返回的参数为空,则说明没有命中,直接返回走降级
            if (StringUtils.isBlank(strategyPointString)){
                return;
            }
            //7.5代码走到这里说明大禹命中实验,则记录实验
            Long strategyPoint = Long.parseLong(strategyPointString);
            rsp.setExps(StringUtils.join(handleResult.getExpIds(), ","));


            //7.8如果是走人工排序，则type=6
            if (StrategyType.RECMD_VALID_LIST == strategyPoint.intValue()) {
                CatUtil.catLog(CatGroupEnum.CAT_102008.getCode());
                throw new TuiaException(ErrorCode.E0500007);
            }

            //7.7设置推荐类型
            filterResult.setType(FilterResult.getTypeByStrategyPoint(strategyPoint.intValue()));

            //7.9走推荐算法
            Long finalStrategyPoint = strategyPoint;
            List<RcmdAdvertDto> rcmdAdvertDtos = CatUtils.executeInCatTransaction(() -> doRecommendOperate(finalStrategyPoint, filterResult, dto, sceneDoubleFeeStrategyPoint), "recommendAdvert", "nezhaRecommend");

            //8.0推荐不出，降级走人工，type=5
            if (rcmdAdvertDtos.isEmpty()) {
                CatUtil.catLog(CatGroupEnum.CAT_102010.getCode());
                filterResult.setType(FilterResult.RECMD_DEGRADE_TYPE);
                throw new TuiaException(ErrorCode.E0500007);
            }

            //8.1打印排列第二的广告推荐，ctr,cvr.
            RcmdAdvertDto rcmdAdvertDto = rcmdAdvertDtos.get(0);

            //nezha有出劵，设置dsp竞价标识  设置用于竞价的价格
            if (rsp.getDspCompare() == null) {
                rsp.setDspCompare(true);
            }
            Double nezhaFe = BigDecimal.valueOf(rcmdAdvertDto.getFee() * rcmdAdvertDto.getCtr()).setScale(4, RoundingMode.HALF_UP).doubleValue();
            rsp.setFee(nezhaFe);

            //出单率 可以用于表示是否开启双出价  全链路日志
            req.getLogExtExpMap().put(AdvertReqLogExtKeyConstant.OUT_ORDE_RRATE, rcmdAdvertDto.getOutOrderRate() != null ? String.valueOf(rcmdAdvertDto.getOutOrderRate()) : null);
            // 哪吒返回的是否探索
            req.getLogExtExpMap().put(AdvertReqLogExtKeyConstant.AD_EXPLORE, String.valueOf(rcmdAdvertDto.getAdExplore()));
            // 是否开启提价保量模式（0=不开启，1=开启）
            req.getLogExtExpMap().put(AdvertReqLogExtKeyConstant.PRICE_RISE_MARK, String.valueOf(rcmdAdvertDto.getPriceRiseMark()));
            //出单率 可以用于表示是否开启双出价 放入filterResult过滤日志
            filterResult.getLogExtMap().put(AdvertReqLogExtKeyConstant.OUT_ORDE_RRATE, rcmdAdvertDto.getOutOrderRate());

            //8.根据推荐的广告中券
            //新增推荐的媒体或者关闭熔断的配置
            addRcmdAppOrCloseFusingPackage(rcmdAdvertDto.getRecommendApps(), rcmdAdvertDto.getFusingOrientationPackages());

            //8.2如果算法直接返回了具体的配置ID，则直接使用算法返回的
            AdvertPriceVO advertPriceVO = null;
            if (rcmdAdvertDto.getPackageId() != null) {
                //这里只会过滤出一条
                AdvertFilterVO advertFilterVO = hasValidAdverts.get(rcmdAdvertDto.getAdvertId());
                RcmdAdvertDto finalRcmdAdvertDto1 = rcmdAdvertDto;
                List<AdvertPriceVO> advertPriceList = advertFilterVO.getAdvertPriceVOSortedSet().stream()
                        .filter(orientation -> orientation.getAdvertOrientationPackageId().equals(finalRcmdAdvertDto1.getPackageId()) && orientation.getAdvertId().equals(finalRcmdAdvertDto1.getAdvertId()))
                        .collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(advertPriceList)) {
                    advertPriceVO = advertPriceList.get(0);
                }
                filterResult.setRcmdAdvertId(rcmdAdvertDto.getAdvertId());
                filterResult.setRcmdPackageId(rcmdAdvertDto.getPackageId());
            }
            if (advertPriceVO != null) {
                //设置KA广告扶持filterResult
                filterResult.setSupportStatus(advertPriceVO.getSupportStatus());
            }

            filterResult.setSupportWeightStatus(Optional.ofNullable(rcmdAdvertDto.getSupportSuccess()).orElse(false) ? CommonConstant.YES : CommonConstant.NO);
            filterResult.setSupportWeight(rcmdAdvertDto.getSupportWeight());
            filterResult.setNezhaLaunchStatus(CommonConstant.YES);

            //9.发券
//            rcmdResult(req, rsp, filterResult, rcmdAdvertDto, advertPriceVO, rcmdAdvertDtos);
            final AdvertPriceVO advertPriceVOTmp =advertPriceVO ;
            RcmdAdvertDto finalRcmdAdvertDto = rcmdAdvertDto;
            CatUtils.executeInCatTransaction(()->{
                rcmdResult(req, rsp, filterResult, finalRcmdAdvertDto, advertPriceVOTmp, rcmdAdvertDtos, advertFilter);
                return null;
            },"recommendAdvert","rcmdResult");
        } catch (Throwable ex) {
            if (ex instanceof TuiaException) {
            } else {
                logger.error("RecommendAdvert Service happen exception, begine degrade handle", ex);
            }
        } finally {
            DBTimeProfile.release();
        }
    }


    /**
     * 判断是否微信流量(不包含微信小程序)，如果是走oneId分流场景
     * @param req
     * @param consumerDto
     * @param strategyPointString
     * @return
     */
    private String getOneIdReplacePoint(ObtainAdvertReq req, ConsumerDto consumerDto, String strategyPointString) {
        try {
            if(StringUtils.isBlank(consumerDto.getOneId())){
                return strategyPointString;
            }

            //调用abTest平台根据oneId 进行uv分流
            ABResult abResult = flowRouterProxyService.routeFlow(req, ABTestLayerCodeEnum.ONE_ID);
            if (null == abResult) {
                return strategyPointString;
            }
            Map<String, String> arguments = abResult.getArguments();
            return arguments.getOrDefault("strategyPoint", strategyPointString);
        } catch (Exception e) {
            logger.error("getOneIdReplacePoint error!", e);
        }
        return strategyPointString;
    }

    /**
     * 获取替换的策略
     *
     * @param appDto
     * @param isSceneTwo
     * @param arguments
     * @param strategyPointString
     * @return
     */
    private String getReplacePoint(AppDto appDto, ConsumerDto consumerDto, boolean isSceneTwo,
                                   Map<String, String> arguments,
                                   String strategyPointString) {

        // 走大盘切流
        if (isSceneTwo || MapUtils.isEmpty(arguments)) {
            return strategyPointString;
        }

        // 性别标签分流实验
        if (StringUtils.isNotBlank(appDto.getAqySex())) {
            String sexExpStrategyPoint = arguments.get(ABArgumentKeyConstant.sexExpStrategyPoint);
            if (isValidStr(sexExpStrategyPoint)) {
                return sexExpStrategyPoint;
            }
        }

        // 设备号分流实验
        if (StringUtils.isNotBlank(consumerDto.getImeiOaidIdfaMd5())) {

            String imeiExp = arguments.get(ABArgumentKeyConstant.imeiExp);
            if (isValidStr(imeiExp)) {
                return imeiExp;
            }
        }


        // 冷启动探索修改模型实验
        if ("expD".equals(arguments.get("name")) || "expB".equals(arguments.get("name"))) {
            String coldExplore = arguments.get(ABArgumentKeyConstant.coldExplore);
            if (isValidStr(coldExplore)) {
                return coldExplore;
            }
        }

        return strategyPointString;
    }

    /**
     * 是否为有效值
     * @param str
     * @return
     */
    private boolean isValidStr(String str) {

        return StringUtils.isNotBlank(str) && !"-1".equals(str);
    }

    private Long transformToLong(String activityType) {
        try {
            return Long.valueOf(activityType);
        } catch (Exception e) {
            logger.warn("activityType 无法解析",e);
            return null;
        }
    }

    @NotNull
    private RequestDto getRequestDto(ObtainAdvertReq req, AdvQueryParam advQueryParam) {
        RequestDto reqAdvertDto = new RequestDto();
        reqAdvertDto.setPriceSection(advQueryParam.getPhoneLevels());
        reqAdvertDto.setPutIndex(advQueryParam.getJoinNum());
        reqAdvertDto.setUa(req.getUa());
        reqAdvertDto.setCityId(Long.parseLong(advQueryParam.getRegionId()));
        reqAdvertDto.setConnectionType(advQueryParam.getNetworkTypes());
        reqAdvertDto.setIp(req.getIp());
        reqAdvertDto.setModel(advQueryParam.getPhoneModel());
        reqAdvertDto.setOrderId(req.getOrderId());
        reqAdvertDto.setOperatorType(advQueryParam.getOperators());
        reqAdvertDto.setPhoneBrand(advQueryParam.getPhoneBrand());
        reqAdvertDto.setPhoneModel(advQueryParam.getPhoneModelNum());
        reqAdvertDto.setEncourageOrderId(req.getEncourageOrderId());
        Integer type = req.getPersonCrowdType();
        Integer value = req.getPersonCrowdValue();
        if(type!=null && type == UserResourceEnum.WORK_STATE.getCode()){
            reqAdvertDto.setWorkState(value);

        }
        if(type!=null && type ==UserResourceEnum.SEX.getCode()){
            reqAdvertDto.setSex(value);

        }

        //6.1 获取应用的arpu值，如果有，则替换掉，没有则不替换
        Double appArpu = appLowArpuCacheService.getAppLowArpu(req.getAppId());
        if(appArpu != null){
            reqAdvertDto.setLowArpuThresholdValue(appArpu);
        }else{
            reqAdvertDto.setLowArpuThresholdValue(advQueryParam.getLowArpuThresholdValue());
        }
        //添加 floorPriceWhiteListOff（缓存：底价白名单开关状态）
        reqAdvertDto.setFloorPriceWhiteListOff(serviceManager.getOcpcBasePriceWhiteListStatus());
        //添加 托管底价
        reqAdvertDto.setFloorPrice(serviceManager.getOcpcClickMinPrice());

        //增加流量场景
        setFlowType(reqAdvertDto, req);

        // 设置算法需要的特征(2020.07.21之后特征，且nezha不用，只是nezha算法用的)
        setAlgFeatureMap(reqAdvertDto, req, advQueryParam);

        // 设置优化ocpc实验参数
        reqAdvertDto.setDayuArgumentsMap(advQueryParam.getDayuArguments());

        return reqAdvertDto;
    }

    /**
     * 这个只给了adx的场景用.后面删掉，用setAlgFeatureMap这个
     * @param req
     * @return
     */
    private Map<String, String> getAdxAlgFeatureMap(ObtainAdvertReq req){

        Map<String, String> algFeatureMap = new HashMap<>();
        Map<String, String> logExtMap = Optional.ofNullable(req.getLogExtMap()).orElse(new HashMap<>());
        Map<String, String> logExtExpMap = Optional.ofNullable(req.getLogExtExpMap()).orElse(new HashMap<>());

        //奖品
        algFeatureMap.put(AlgFeatureMapConstant.ACT_PRIZE_ID, logExtExpMap.get(AlgFeatureMapConstant.ACT_PRIZE_ID));
        // 设置属性特征参数
        //广告位素材id
        algFeatureMap.put(AlgFeatureMapConstant.SLOT_MATERIAL_ID, logExtExpMap.get("sckId"));
        //活动的访问类型（广告位、浮标、返回拦截、弹层、区块）
        algFeatureMap.put(AlgFeatureMapConstant.ACTIVITY_SOURCE_TYPE, logExtMap.get(AlgFeatureMapConstant.ACTIVITY_SOURCE_TYPE));
        //券访问类型（活动发券、自动发券）
        algFeatureMap.put(AlgFeatureMapConstant.launchSourcetype, logExtMap.get(AlgFeatureMapConstant.launchSourcetype));

        // 分媒体ID，先从logExtExpMap取，取不到再从logExtMap里取.
        String baiduAppId = logExtExpMap.getOrDefault(AlgFeatureMapConstant.BAIDU_APP_ID, logExtMap.get(AlgFeatureMapConstant.BAIDU_APP_ID));
        algFeatureMap.put(AlgFeatureMapConstant.BAIDU_APP_ID, baiduAppId);

        return algFeatureMap;
    }

    /**
     * 组装给算法的特征, 只给了互动大盘用
     * @param requestDto 流量请求参数，给nezha的
     * @param req
     * @param advQueryParam
     */
    private void setAlgFeatureMap(RequestDto requestDto, ObtainAdvertReq req, AdvQueryParam advQueryParam){

        Map<String, String> algFeatureMap = new HashMap<>();

        Map<String, String> logExtMap = Optional.ofNullable(req.getLogExtMap()).orElse(new HashMap<>());

        algFeatureMap.put(AlgFeatureMapConstant.ACTIVITY_PAGE, logExtMap.get(AdvertReqLogExtKeyConstant.ACTIVITY_PAGE));
        algFeatureMap.put(AlgFeatureMapConstant.DMS2A, getDsm2A(logExtMap.get(AdvertReqLogExtKeyConstant.DSM2)));
        algFeatureMap.put(AlgFeatureMapConstant.OSVERSION, logExtMap.get(AdvertReqLogExtKeyConstant.OS_VERSION));
        algFeatureMap.put(AlgFeatureMapConstant.ACTIVITY_SKINTYPE, logExtMap.get(AdvertReqLogExtKeyConstant.ACTIVITY_SKIN_TYPE));
        algFeatureMap.put(AlgFeatureMapConstant.DEVICE_TRADEMARK, logExtMap.get(AlgFeatureMapConstant.DEVICE_TRADEMARK));

        Map<String, String> logExtExpMap = Optional.ofNullable(req.getLogExtExpMap()).orElse(new HashMap<>());

        algFeatureMap.put(AlgFeatureMapConstant.ACT_MAIN_TITLE_ID, logExtExpMap.get(AlgFeatureMapConstant.ACT_MAIN_TITLE_ID));
        algFeatureMap.put(AlgFeatureMapConstant.ACT_SUB_TITLE_ID, logExtExpMap.get(AlgFeatureMapConstant.ACT_SUB_TITLE_ID));
        algFeatureMap.put(AlgFeatureMapConstant.ACT_PRIZE_ID, logExtExpMap.get(AlgFeatureMapConstant.ACT_PRIZE_ID));


        algFeatureMap.put(AlgFeatureMapConstant.BRANDNAME, advQueryParam.getBrandName());

        // 设置属性特征参数
        //广告位素材id
        algFeatureMap.put(AlgFeatureMapConstant.SLOT_MATERIAL_ID, logExtExpMap.get("sckId"));

        //活动的访问类型（广告位、浮标、返回拦截、弹层、区块）
        algFeatureMap.put(AlgFeatureMapConstant.ACTIVITY_SOURCE_TYPE, logExtMap.get(AlgFeatureMapConstant.ACTIVITY_SOURCE_TYPE));

        //券访问类型（活动发券、自动发券）
        algFeatureMap.put(AlgFeatureMapConstant.launchSourcetype, logExtMap.get(AlgFeatureMapConstant.launchSourcetype));

        // 分媒体ID，先从logExtExpMap取，取不到再从logExtMap里取.
        String baiduAppId = logExtExpMap.getOrDefault(AlgFeatureMapConstant.BAIDU_APP_ID, logExtMap.get(AlgFeatureMapConstant.BAIDU_APP_ID));
        algFeatureMap.put(AlgFeatureMapConstant.BAIDU_APP_ID, baiduAppId);


        requestDto.setAlgFeatureMap(algFeatureMap);
    }

    /**
     * 获取dsm2A,dsm2的格式是"1.123.123.666"; A指获取第一位数值，活动访问类型
     * @param dsm2
     * @return
     */
    private String getDsm2A(String dsm2){

        if(StringUtils.isBlank(dsm2)){
            return null;
        }

        try {
            return dsm2.split("\\.")[0];
        }catch (Exception e){
            logger.error("getDsm2A is error, dsm2:{}", dsm2);
            return null;
        }
    }


    /**
     * 获取双出价场景的实验ID
     * @return
     */
    private String getSceneDoubleFeeStrategyPoint(ObtainAdvertReq req,
                                                  Map<String, Object> filterResultLogExtMap,
                                                  RequestDto requestDto){

        ABResult handleResult = flowRouterProxyService.routeFlow(req, ABTestLayerCodeEnum.DOUBLE_FEE);

        Map<String, String> arguments = handleResult.getArguments();

        // 双出价第一层实验
        String sceneDoubleFeeStrategyPoint = arguments.getOrDefault("strategyPoint", "1");
        // 双出价第二层实验-model
        String sceneDoubleFeeModel = arguments.getOrDefault("model", "0");

        // 放到全链路日志里
        req.getLogExtExpMap().put(AdvertReqLogExtKeyConstant.DOUBLE_FEE_EXPID, sceneDoubleFeeStrategyPoint + "," + sceneDoubleFeeModel);

        //AB流量标识 放入filterResult过滤日志
        filterResultLogExtMap.put(AdvertReqLogExtKeyConstant.DOUBLE_FEE_EXPID, sceneDoubleFeeStrategyPoint + "," + sceneDoubleFeeModel);

        requestDto.setSceneDoubleFeeModel(sceneDoubleFeeModel);

        return sceneDoubleFeeStrategyPoint;
    }

    /**
     * 获取双出价场景的实验ID
     * @return
     */
    private void getSceneAppRadStrategyPoint(ObtainAdvertReq req,
                                             Map<String, Object> filterResultLogExtMap,
                                             AppDto appDto){

        // 媒体所要多张券的 券类型，1-代表排名前列的券， 2-代表多个行业最高的的券
        ABResult handleResult = flowRouterProxyService.routeFlow(req, ABTestLayerCodeEnum.APP_RAD);
        Map<String, String> arguments = handleResult.getArguments();
        String sceneAppRadStrategyPoint = arguments.getOrDefault("appRad", "1");

        // 放到全链路日志里
        req.getLogExtExpMap().put(AdvertReqLogExtKeyConstant.APP_RETURN_ADVERT, sceneAppRadStrategyPoint);

        //AB流量标识 放入filterResult过滤日志
        filterResultLogExtMap.put(AdvertReqLogExtKeyConstant.APP_RETURN_ADVERT, sceneAppRadStrategyPoint);

        appDto.setAdVirtue(Integer.parseInt(sceneAppRadStrategyPoint));
    }

    /**
     * 获取美团场景
     * @return
     */
    private int getMeituanStrategyPoint(ObtainAdvertReq req, boolean isAqyTag) {
        try {
            ABTestLayerCodeEnum layerCodeEnum = isAqyTag ? ABTestLayerCodeEnum.AQY_TAG : ABTestLayerCodeEnum.NORMAL;
            ABResult handleResult = flowRouterProxyService.routeFlow(req, layerCodeEnum);
            Map<String, String> arguments = handleResult.getArguments();
            String strategyPoint = arguments.getOrDefault("mtStrategy", "316");
            return Integer.parseInt(strategyPoint);
        } catch (Exception e) {
            logger.error("美团ADX-哪吒推荐-获取大禹失败", e);
        }
        return 316;
    }

    /**
     * 设置请求流量类型
     * @param reqAdvertDto
     * @param req
     */
    private static void setFlowType(RequestDto reqAdvertDto, ObtainAdvertReq req) {

        if (req.getLogExtMap() == null) {
            return;
        }

        Map<String, String> logExtMap = req.getLogExtMap();

        if (StringUtils.isNotBlank(logExtMap.get(AdvertReqLogExtKeyConstant.SDK_VERSION))) {

            reqAdvertDto.setFlowType(FlowTypeEnum.SDK_FLOW.getIndex());
            return;
        }

        if (StringUtils.isNotBlank(logExtMap.get(AdvertReqLogExtKeyConstant.ADX_RID))
                && getImeiByLogExtMap(logExtMap)) {

            reqAdvertDto.setFlowType(FlowTypeEnum.ADX_FLOW.getIndex());
            return;
        }

        reqAdvertDto.setFlowType(FlowTypeEnum.OTHER_FLOW.getIndex());
    }

    private static boolean getImeiByLogExtMap(Map<String, String> logExtMap) {

        String deviceId;
        deviceId = logExtMap.get(AdvertReqLogExtKeyConstant.IMEI);
        if (StringUtils.isNotBlank(deviceId)) {
            return true;
        }

        deviceId = logExtMap.get(AdvertReqLogExtKeyConstant.IMEI_MD5);
        return StringUtils.isNotBlank(deviceId);

    }


    @Override
    @SuppressWarnings("squid:S3776")
    public List<RcmdAdvertDto> adxRecommendAdvert(ObtainAdvertReq req, ObtainAdvertRsp rsp, FilterResult filterResult,
        Map<Long, AdvertFilterVO> hasValidAdverts, AdvQueryParam advQueryParam,ConsumerDto consumerDto, AdvertFilter advertFilter) {

        try {

            AdxLoadTypeEnum adxLoadType = AdxLoadTypeEnum.findByType(req.getAdxLoadType());

            DBTimeProfile.enter("adxRecommendAdvert");

            //1.构建推荐参数
            ReqAdvertNewDto dto = new ReqAdvertNewDto();

            //2.设置传入的广告列表
            List<AdvertNewDto> advertNewDtoList = CatUtils.executeInCatTransaction(
                    () -> this.getAdvertMaxFeeList(hasValidAdverts, filterResult, req),
                    "adxRecommendAdvert", "getMaxFeeList");
            dto.setAdvertList(advertNewDtoList);

            //3.1判断是否走场景2
            dto.setConsumerDto(consumerDto);

            //3.2设置活动预发券返回广告数量
            if (ActPreUtils.isActPre(req)) {
                dto.setReturnAdvertSum(ActPreUtils.getAdvertCount(req));
            }

            //4.设置传入媒体参数
            AppDto appDto = new AppDto();
            appDto.setAppId(req.getAppId());
            appDto.setSlotId(req.getSlotId());
            appDto.setAdxMediaType(req.getAdxMediaType());
            appDto.setAdxSceneType(req.getAdxSceneType());
            this.setSlotSize(appDto);
            this.setAppTags(appDto);
            dto.setAppDto(appDto);

            //5.设置传入活动参数
            AdvertActivityDto advertActivityDto = new AdvertActivityDto();
            advertActivityDto.setActivityId(req.getDuibaActivityId());
            advertActivityDto.setActivityType(req.getDuibaActivityType().longValue());
            advertActivityDto.setActivityUseType(req.getActivityUseType());
            advertActivityDto.setTag(req.getTag());
            advertActivityDto.setOperatingActivityId(req.getActivityId());
            advertActivityDto.setAdxRid(req.getLogExtMap().get(AdvertReqLogExtKeyConstant.ADX_RID));

            dto.setAdvertActivityDto(advertActivityDto);

            //6.设置传入广告参数
            RequestDto reqAdvertDto = new RequestDto();
            reqAdvertDto.setPriceSection(advQueryParam.getPhoneLevels());
            reqAdvertDto.setPutIndex(advQueryParam.getJoinNum());
            reqAdvertDto.setUa(req.getUa());
            reqAdvertDto.setCityId(Long.parseLong(advQueryParam.getRegionId()));
            reqAdvertDto.setConnectionType(advQueryParam.getNetworkTypes());
            reqAdvertDto.setIp(req.getIp());
            reqAdvertDto.setModel(advQueryParam.getPhoneModel());
            reqAdvertDto.setOrderId(req.getOrderId());
            reqAdvertDto.setOperatorType(advQueryParam.getOperators());
            reqAdvertDto.setPhoneBrand(advQueryParam.getPhoneBrand());
            reqAdvertDto.setPhoneModel(advQueryParam.getPhoneModelNum());
            // 添加adx请求类型
            reqAdvertDto.setAdxLoadType(req.getAdxLoadType());
            reqAdvertDto.setOrderIds(req.getOrderIds());
            reqAdvertDto.setDayuArgumentsMap(advQueryParam.getDayuArguments());
            //设置算法特征参数
            reqAdvertDto.setAlgFeatureMap(getAdxAlgFeatureMap(req));
            setFlowType(reqAdvertDto, req);

            //6.1 获取应用的arpu值，如果有，则替换掉，没有则不替换
            Double appArpu = CatUtils.executeInCatTransaction(() -> appLowArpuCacheService.getAppLowArpu(req.getAppId()), "adxRecommendAdvert", "getAppLowArpu");
            if(appArpu != null){
                reqAdvertDto.setLowArpuThresholdValue(appArpu);
            }else{
                reqAdvertDto.setLowArpuThresholdValue(advQueryParam.getLowArpuThresholdValue());
            }
            dto.setRequestDto(reqAdvertDto);

            //添加 floorPriceWhiteListOff（缓存：底价白名单开关状态）
            Boolean ocpcBasePriceWhiteListStatus = CatUtils.executeInCatTransaction(() -> serviceManager.getOcpcBasePriceWhiteListStatus(), "adxRecommendAdvert", "getOcpcBasePriceWhiteListStatus");
            reqAdvertDto.setFloorPriceWhiteListOff(ocpcBasePriceWhiteListStatus);
            //添加 托管底价
            Long ocpcClickMinPrice = CatUtils.executeInCatTransaction(() -> serviceManager.getOcpcClickMinPrice(), "adxRecommendAdvert", "getOcpcClickMinPrice");
            reqAdvertDto.setFloorPrice(ocpcClickMinPrice);

            //7.5 策略模型，如果不是用户选广告则写死 239
            Long strategyPoint = Objects.equals(req.getAdxSceneType(), AdxSceneEnum.OPTIONAL_AD.getCode())
                    ? getStrategyPoint(req)
                    : 239L;
            rsp.setExps(strategyPoint.toString());

            //7.7设置推荐类型
            filterResult.setType(FilterResult.getTypeByStrategyPoint(strategyPoint.intValue()));

            //7.9走推荐算法
            List<RcmdAdvertDto> rcmdAdvertDtos = CatUtils.executeInCatTransaction(() -> adxRecommendOperate(req, strategyPoint, filterResult, dto), "adxRecommendAdvert", "nezhaRecommend");

            // 预发券请求直接返回
            if(AdxLoadTypeEnum.PRE_LOAD.equals(adxLoadType)){
                return rcmdAdvertDtos;
            }

            // 真实发券继续往下走
            if(CollectionUtils.isEmpty(rcmdAdvertDtos)){
                return Lists.newArrayList();
            }

            //8.1打印排列第二的广告推荐，ctr,cvr.
            RcmdAdvertDto rcmdAdvertDto = rcmdAdvertDtos.get(0);

            // 是否开启提价保量模式（0=不开启，1=开启）
            req.getLogExtExpMap().put(AdvertReqLogExtKeyConstant.PRICE_RISE_MARK, String.valueOf(rcmdAdvertDto.getPriceRiseMark()));


            //8.根据推荐的广告中券
            //新增推荐的媒体或者关闭熔断的配置
            addRcmdAppOrCloseFusingPackage(rcmdAdvertDto.getRecommendApps(), rcmdAdvertDto.getFusingOrientationPackages());

            //8.2如果算法直接返回了具体的配置ID，则直接使用算法返回的
            AdvertPriceVO advertPriceVO = new AdvertPriceVO();
            if (rcmdAdvertDto.getPackageId() != null) {
                //这里只会过滤出一条计划
                AdvertFilterVO advertFilterVO = hasValidAdverts.get(rcmdAdvertDto.getAdvertId());

                // 过滤出配置
                List<AdvertPriceVO> advertPriceList = advertFilterVO.getAdvertPriceVOSortedSet()
                                                                    .stream()
                                                                    .filter(orientation ->
                                                                        orientation.getAdvertOrientationPackageId().equals(rcmdAdvertDto.getPackageId())
                                                                        && orientation.getAdvertId().equals(rcmdAdvertDto.getAdvertId()))
                                                                    .collect(Collectors.toList());

                if (CollectionUtils.isNotEmpty(advertPriceList)) {
                    advertPriceVO = advertPriceList.get(0);
                }
            }

            //设置KA广告扶持filterResult
            filterResult.setSupportStatus(advertPriceVO.getSupportStatus());

            filterResult.setSupportWeightStatus(Optional.ofNullable(rcmdAdvertDto.getSupportSuccess()).orElse(false) ? CommonConstant.YES : CommonConstant.NO);
            filterResult.setSupportWeight(rcmdAdvertDto.getSupportWeight());
            filterResult.setNezhaLaunchStatus(CommonConstant.YES);

            //9.发券
            final AdvertPriceVO advertPriceVOTmp =advertPriceVO ;
            CatUtils.executeInCatTransaction(()->{
                rcmdResult(req, rsp, filterResult, rcmdAdvertDto, advertPriceVOTmp, rcmdAdvertDtos, advertFilter);
                return null;
            },"adxRecommendAdvert","rcmdResult");

            return rcmdAdvertDtos;
        } catch (Throwable ex) {
            if (ex instanceof TuiaException) {
            } else {
                logger.error("RecommendAdvert Service happen exception, begine degrade handle", ex);
            }
            return Lists.newArrayList();
        } finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public void addRcmdAppOrCloseFusingPackage(Set<RecommendAppDto> recommendApps, Set<FusingOrientationPackageDto> fusingOrientationPackages) {
        if (CollectionUtils.isEmpty(recommendApps) && CollectionUtils.isEmpty(fusingOrientationPackages)) {
            return;
        }

        executorService.execute(() -> {
            if (!CollectionUtils.isEmpty(recommendApps)) {
                addRecommendApp(recommendApps);
            }
            //熔断需要关闭配置并且发钉钉提醒给AE，所以该处理放到center
            if (!CollectionUtils.isEmpty(fusingOrientationPackages)) {
                Set<FusingOrientationPackageDto> filterResult = fillterWhite(fusingOrientationPackages);
                publishFusingOrientPackage(filterResult);
            }
        });
    }

    /**
     *
     * fillterWhite:(过滤在白名单的不需要熔断的广告). <br/>
     *
     * @author chencheng
     * @param fusingOrientationPackages
     * @return
     * @since JDK 1.8
     */
    private Set<FusingOrientationPackageDto> fillterWhite(Set<FusingOrientationPackageDto> fusingOrientationPackages) {
        String fusingWhiteAdvert = apolloPanGuService.getIdMapStrByKeyStr(PangeaRelevantConstant.FUSING_WHITE_ADVERT);

        Set<Long> advertIds = StringTool.getLongSetByStr(fusingWhiteAdvert);
        return fusingOrientationPackages.stream().filter(dto -> !advertIds.contains(dto.getAdvertId())).collect(Collectors.toSet());
    }

    private void addRecommendApp(Set<RecommendAppDto> recommendApps) {
        Date curDate = DateUtils.getDayDate(new Date());
        for (RecommendAppDto recommendAppDto : recommendApps) {
            if (Objects.equals(1,recommendAppDto.getType())) {
                continue;
            }
            RecommendAppDO recommendAppDO = new RecommendAppDO();
            recommendAppDO.setAdvertId(recommendAppDto.getAdvertId());
            recommendAppDO.setPackageId(recommendAppDto.getPackageId());
            recommendAppDO.setAppId(recommendAppDto.getAppId());
            recommendAppDO.setCurDate(curDate);
            recommendAppDO.setBias(recommendAppDto.getBias());
            recommendAppDO.setRecommendType(recommendAppDto.getType());
            recommendAppDAO.insertSelective(recommendAppDO);
        }
    }

    private void setSlotSize(AppDto appDto) {
        Optional.ofNullable(tuiaMediaClientService.getSlotInfo(appDto.getSlotId())).ifPresent(slotMsInfoDto -> {
            appDto.setSlotHeight(slotMsInfoDto.getHeight());
            appDto.setSlotWidth(slotMsInfoDto.getWidth());
            appDto.setSlotType(slotMsInfoDto.getSlotType());
        });
    }

    /**
     * 是否走场景2：设备ID在列表里面，并且根据设备ID查询redis有大于10个安装应用
     * 如果走场景2会给consumerDto设置设备号和应用列表
     * @param req
     * @param consumerDto
     * @return
     */
    private boolean isSceneTwo(ObtainAdvertReq req, ConsumerDto consumerDto) {

        Map<String, String> logExtMap = req.getLogExtMap();
        return null != logExtMap && StringUtils.isNotBlank(logExtMap.get(AdvertReqLogExtKeyConstant.SDK_VERSION));

//        if (StringUtils.isBlank(req.getDeviceId())) {
//            return Boolean.FALSE;
//        }
//        // 获取安装应用列表
//        List<String> installApps = consumerDto.getInstallApps();
//        // 获取短信签名列表
//        List<String> msgList = consumerDto.getMsgList();
//        // 获取用户基础标签
//        List<String> userTagList = consumerDto.getUserTagList();
//
//        // 其中一个不为null,则走场景2
//        return CollectionUtils.isNotEmpty(installApps) || CollectionUtils.isNotEmpty(msgList) || CollectionUtils.isNotEmpty(userTagList);
    }


    /**
     * 构建数据请求用的字段，
     * md5: imei->oaid->idfa;
     * 依次有什么用什么，md5加密过后的值
     * @param req
     * @param consumerDto
     */
    private void buildImeiOaidIdfaMd5(ObtainAdvertReq req, ConsumerDto consumerDto){

        Map<String, String> logExtMap = Optional.ofNullable(req.getLogExtMap()).orElse(new HashMap<>());

        String imeiOaidIdfaMd5;

        imeiOaidIdfaMd5 = logExtMap.get(AdvertReqLogExtKeyConstant.IMEI_MD5);
        if(StringUtils.isNotBlank(imeiOaidIdfaMd5)){
            consumerDto.setImeiOaidIdfaMd5(imeiOaidIdfaMd5);
            return;
        }

        imeiOaidIdfaMd5 = logExtMap.get(AdvertReqLogExtKeyConstant.OAID_MD5);
        if(StringUtils.isNotBlank(imeiOaidIdfaMd5)){
            consumerDto.setImeiOaidIdfaMd5(imeiOaidIdfaMd5);
            return;
        }

        imeiOaidIdfaMd5 = logExtMap.get(AdvertReqLogExtKeyConstant.IDFA_MD5);
        if(StringUtils.isNotBlank(imeiOaidIdfaMd5)){
            consumerDto.setImeiOaidIdfaMd5(imeiOaidIdfaMd5);
            return;
        }

    }

    private void setAppTags(AppDto appDto) {

        List<String> flowAppTags = mediaCacheService.getAppFlowTags(appDto.getAppId());
        List<String> industryTags = mediaCacheService.getAppIndustryTags(appDto.getAppId());

        List<MediaTagDto> slotidTags = mediaCacheService.getSlotidTags(appDto.getSlotId());

        Long emoBlockTags = mediaCacheService.getAppEmoBlockTag(appDto.getAppId());

        // 设置流量标签
        if (flowAppTags.size() == 2) {
            appDto.setTrafficTagId(flowAppTags.get(0));
            appDto.setTrafficTagPid(flowAppTags.get(1));
        }

        // 设置行业标签
        if (industryTags.size() == 2) {
            appDto.setAppIndustryTagPid(industryTags.get(0));
            appDto.setAppIndustryTagId(industryTags.get(1));
        }

        // 设置广告位标签
        // 广告位性质Pid
        Long slotIndustryType = 9L;
        // 广告位接入放入Pid
        Long slotAccessType = 59L;
        slotidTags.forEach(dto ->{

            Long tagPid = dto.getPid();
            if(slotIndustryType.equals(tagPid)){
                appDto.setSlotIndustryTagPid(String.valueOf(tagPid));
                appDto.setSlotIndustryTagId(String.valueOf(dto.getTagId()));
            }

            if(slotAccessType.equals(tagPid)){
                appDto.setSlotAccessTagId(dto.getTagId());
            }
        });

        if(emoBlockTags != null && emoBlockTags != -1L){
            appDto.setAppEmoBlockTagId(emoBlockTags);
        }

    }

    /**
     * 转为推荐系统需要的参数 广告ID -> 最大广告出价
     *
     * @return
     */
    @SuppressWarnings("squid:S3776")
    private List<AdvertNewDto> getAdvertMaxFeeList(Map<Long, AdvertFilterVO> hasValidAdverts, FilterResult filterResult, ObtainAdvertReq req) throws Exception {

        List<AdvertNewDto> advertDtoList = Lists.newArrayList();
        try {
            DBTimeProfile.enter("RecommendAdvert.getAdvertMaxFeeList");
            if (hasValidAdverts == null) {
                return advertDtoList;
            }
            // 根据有效列表从缓存中取出发券次数
            Map<String, String> advertUserd = advertOrderCacheService.getAdvertLaunchedTimes(filterResult,
                                                                                             hasValidAdverts.keySet().stream().collect(Collectors.toList()));

            //获取特殊权重广告列表
            Set<String> specialWeightAppIdList = mediaCacheService.getSpecialWeightAppIdList();

            // 提交到推荐引擎的广告列表，打印在过滤日志里面
            Map<Long, AdvertFilterVO> nezhaFilterMap = Maps.newHashMap();

            // 所有测试计划
            Map<Long, AdvertMaterialTestPlanDO> testPlanMap = advertMaterialTestPlanCacheService.getAdvertMaterialTestPlanDoNew();

            // 获取所有老素材列表
            Map<Long, List<Long>> oldMaterialMap = advertMaterialRealtionService.getAppAdvertMaterialCache(req.getAppId());

            // 获取所有广告新行业名称
            Map<Long, String> advertNewTradeNameMap = advertNewTradeCacheService.getAdvertNewTradeNameByAdIds(new ArrayList<>(hasValidAdverts.keySet()));

            // 提交到推荐引擎的广告配置列表
            List<RecommendOrient> recommendOrientList = Lists.newArrayListWithExpectedSize(hasValidAdverts.size());
            List<RecommendOrient> freeRecommendOrientList = Lists.newArrayListWithExpectedSize(hasValidAdverts.size());
//            int flagInt = ThreadLocalRandom.current().nextInt(2);//获取0或1随机数  进行切量
            Map<Long,List<AdvertNewDto>> supportAdvertList = new HashMap<>();
            Map<Long,List<AdvertPriceVO>> supportPrivceVOList = new HashMap<>();

            // 查询分层投放的媒体权重
            Map<Long, List<LayeredStrategyWeightDto>> strategyMap = CatUtils.executeInCatTransaction(() ->
                            layeredStrategyService.queryStrategyWeightMapCache(filterResult.getAppId()),
                    "layeredStrategy", "queryStrategyWeightMapCache");

            // 广告指定媒体提权
            Map<Long, Double> specifyWeightMap = CatUtils.executeInCatTransaction(() ->
                            layeredStrategyService.querySpecifyWeightMap(filterResult.getAppId(), req),
                    "layeredStrategy", "querySpecifyWeightMap");

            // 准备维稳价格参数
            List<String> specialAgentIdsList = getSpecialAgentIdsList();
            Integer ocpaMinPrice = null;
            try {
                ocpaMinPrice = serviceManager.getIntValue(SystemConfigKeyConstant.OCPA_MIN_PRICE);
            } catch (TuiaException e) {
                logger.warn("准备维稳价格参数 异常", e);
            }

            // 查询盘古配置的广告位白名单的ocpc底价
            Long minPriceInSlot = minPriceService.getMinPriceFromSlotWhitelist(req.getAppId(),req.getSlotId());

            // 探索相似广告白名单
            Map<String, List<String>> exploreWhitelist = nezhaAdvertExploreService.getWhitelist();

            List<MaterialTestDTO> newMaterialSupportList = new ArrayList<>();
            Map<String,MaterialTestPlanDO> materialTestPlanDOMap = new HashMap<>();

            for (Entry<Long, AdvertFilterVO> entry : hasValidAdverts.entrySet()) {
                Long key = entry.getKey();
                AdvertFilterVO filterVO = entry.getValue();

                //广告的推广链接标签
                Set<String> spreadTags = resourceTagsService.getResoureTagsDOById(key, ResourceTagsTypeEnum.AD);

                //广告权重
                Double weight = advertService.getWeightByIdFromCache(key, filterResult.getAppId(), specialWeightAppIdList, filterVO.getAdvertWeight());

                AdvertVO advertVO = advertMapCacheManager.getAdvertCache(key);

                Integer flowBiddingType = Optional.ofNullable(advertVO.getAdvertPlan().getFlowBiddingType()).orElse(1);
                //1、取出自动托管的所有配置；2、非自动托管最大出价的配置
                List<AdvertPriceVO> maxFeeAdvertPriceList;
                // 拓量实验判断是否命中流量
                if (!isExpandHit(req)) {
                    maxFeeAdvertPriceList = filterVO.getMaxFeeAdvertListForNezha(flowBiddingType);
                } else {
                    maxFeeAdvertPriceList = filterVO.getMaxFeeAdvertListForNezhaInExpand(flowBiddingType);
                }

                //广告维度落地页链接
                List<String> advertPromoteList = getAdvertPromoteList(advertVO);

                //相似广告修改为 广告维度
                boolean enabledExplore = nezhaAdvertExploreService.enabledExplore(exploreWhitelist, key, req.getAppId());

                for (AdvertPriceVO advertPriceVO : maxFeeAdvertPriceList) {

                    AdvertNewDto advertDto = new AdvertNewDto();
                    advertDto.setAdvertId(key);

                    //关键词过滤
                    if (!filterKeyword(advertDto.getAdvertId(), filterResult, advertPriceVO, req)) {
                        continue;
                    }

                    this.buildByPriceVO(advertDto, advertPriceVO, advertVO,filterResult);

                    // 设置广告扶持信息
                    Optional.ofNullable(advertPriceVO.getSupportAdvertInfoDto()).ifPresent(dto -> {
                        advertDto.setSupportStatus(dto.getSupportAdvert());
                        advertDto.setSupportAdvertInfoDto(dto);
                        //如果是扶持广告 并且分流开关开启  设置分流
                        if (dto.getSupportAdvert() != null && dto.getSupportAdvert()
                                && dto.getIsAbShuntSwitch() != null && dto.getIsAbShuntSwitch()) {

                            List<AdvertNewDto> advertNewDtos = supportAdvertList.get(key);
                            if(null == advertNewDtos){
                                advertNewDtos = new ArrayList<>();
                                supportAdvertList.put(key,advertNewDtos);
                            }
                            advertNewDtos.add(advertDto);

                            List<AdvertPriceVO> advertPriceVOS = supportPrivceVOList.get(key);
                            if(null == advertPriceVOS){
                                advertPriceVOS = new ArrayList<>();
                                supportPrivceVOList.put(key,advertPriceVOS);
                            }
                            advertPriceVOS.add(advertPriceVO);

                            //                            boolean flag = flagInt == 0 ? true : false;
//                            advertDto.setSupportShunt(flag);
//                            advertPriceVO.setSupportShunt(flag);
                        }
                    });

                    // 处理用户参与的素材测试的素材ID
                    this.preHandlerTestMaterialId(advertPriceVO, advertDto, filterResult, testPlanMap, oldMaterialMap);
                    // 新素材扶持预处理
                    preHandlerNewMaterialSupport(advertPriceVO, advertDto, newMaterialSupportList);
                    //设置 素材测试对象到 filterResult
                    Optional.ofNullable(advertPriceVO.getMaterialTestPlanDO()).ifPresent(planDO -> materialTestPlanDOMap.put(advertPriceVO.getAdvertId()+"#"+advertPriceVO.getAdvertOrientationPackageId(),planDO));

                    // cvrType
                    advertDto.setCvrType(CVRTypeEnum.changeSubtypeToCVRType(advertPriceVO.getSubtype()));
                    advertDto.setDepthCvrType(advertPriceVO.getDepthSubtype());
                    advertDto.setDepthTargetPrice(advertPriceVO.getDepthTargetPrice() != null ? advertPriceVO.getDepthTargetPrice().longValue() : null);
                    // 配置维度没有设置深度考核目标的情况下，使用广告维度的设置
                    if (null == advertDto.getDepthCvrType()) {
                        advertDto.setDepthCvrType(advertVO.getDepthSubtype());
                        advertDto.setDepthTargetPrice(advertVO.getDepthTargetPrice() != null ? advertVO.getDepthTargetPrice().longValue() : null);
                    }

                    advertDto.setAccountId(filterVO.getAccountId().toString());
                    advertDto.setMatchTagNums(filterVO.getMatchTags());

                    advertDto.setReleaseTarget(advertPriceVO.getPutTargetType());
                    // 重点媒体转化出价
                    advertDto.setImportantAppFee(advertPriceVO.getFocusAppConvertCost());
                    //分媒体出价类型
                    advertDto.setDisAppFeeType(advertPriceVO.getDisAppFeeType());

                    //广告身上的资源标签，可能为空
                    advertDto.setResourceTagNum(advertVO.getAdvertTagDO().getResourceTag());

                    //是否开启自动托管
                    advertDto.setTargetAppLimit(advertPriceVO.getTargetAppLimit());
                    advertDto.setStrongTarget(advertPriceVO.getStrongTarget());
                    advertDto.setPackageType(advertPriceVO.getPackageType());

                    // 是否存在定向媒体或者广告位
                    advertDto.setExistTargetAppOrSlot(advertPriceVO.getExistTargetAppOrSlot());

                    //设置KA广告扶持信息
                    // advertDto.setSupportStatus(Optional.ofNullable(advertPriceVO.getSupportStatus()).orElse(0) == CommonConstant.YES);
                    // advertDto.setNeedSupportWeight(advertPriceVO.isNeedSupportWeight());
                    advertDto.setNewTradeTagNum(advertPriceVO.getNewTradeTagNum());
                    advertDto.setNewTradeTagId(advertPriceVO.getNewTradeTagId());
                    //考核成本
                    advertDto.setAssessCost(advertVO.getAdvertPlan().getAssessCost());

                    //潜力广告扶持
                    // advertDto.setPotentionalStatus(0);
                    // advertDto.setNeedPotentionalSupport(advertPriceVO.getNeedPotentionalSupport());

                    advertDto.setCanReplaceLowArpu(advertPriceVO.getCanReplaceLowArpu());

                    // 在原dtos中增加发券次数
                    String times = advertUserd.get(String.valueOf(key));
                    if (StringUtils.isNotBlank(times)) {
                        advertDto.setLaunchCountToUser(Long.parseLong(times));
                    } else {
                        advertDto.setLaunchCountToUser(0L);
                    }

                    // 记录过滤日志中参与竞价的配置信息
                    buildFilterResultRecommendPackage(advertDto, recommendOrientList, freeRecommendOrientList);

                    // 广告推广链接标签
                    advertDto.setSpreadTags(spreadTags);
                    // 素材标签参数
                    Map<Long, Set<String>> materialTagMap = resourceTagsService.getResourceTagsMapByIdSet(advertPriceVO.getMaterialsBind(), ResourceTagsTypeEnum.MATERIAL);
                    //如果广告没有可以投放的素材，则过滤掉该广告
                    if (MapUtils.isEmpty(materialTagMap)) {
                        continue;
                    }

                    advertDto.setMaterialMapNew(materialTagMap);
                    //行业标签
                    if(advertVO != null && advertVO.getAdvertTagDO() != null){
                        Optional.ofNullable(advertVO.getAdvertTagDO().getAdvertTradeId()).ifPresent(advertTradeId -> advertDto.setIndustryTag(String.valueOf(advertTradeId)));
                        Optional.ofNullable(advertVO.getAdvertTagDO().getNewAdvertTradeId()).ifPresent(newAdvertTradeId -> advertDto.setIndustryTagNew(String.valueOf(newAdvertTradeId)));
                    }

                    // 设置广告赔付权重
                    Double compensateWeight = getCompensateWeight(advertDto.getAdvertId(), weight);

                    // 广告权重
                    advertDto.setWeight(compensateWeight);

                    // 计算分层投放的媒体权重(计算异常会降级返回原来的权重)
                    advertDto.setWeight(layeredStrategyService.calculateAppWeight(advertPriceVO, advertDto.getWeight(), strategyMap));
                    // 广告指定媒体提权
                    advertDto.setWeight(layeredStrategyService.calculateSpecifyWeight(advertPriceVO, advertDto.getWeight(), specifyWeightMap));

                    // 消耗速度，0：加速投放，1：匀速投放
                    advertDto.setBudgetSmooth(advertPriceVO.getBudgetSmooth());
                    //设置是否在 托管底价白名单 中
                    advertDto.setFloorPriceWhilteAdvert(advertPriceVO.getIsObctTag());

                    //当广告在白名单中（白名单关闭或广告在白名单中），且 计费类型为 cpc
                    advertDto.setAutoBiddingType(advertPriceVO.getAutoBiddingType());

                    // 与流量命中的人群定向标签
                    advertDto.setHitUserInterest(advertPriceVO.getHitUserInterest());

                    // 新行业名称
                    advertDto.setNewTradeName(advertNewTradeNameMap.get(key));
                    //设置转化类型联动配置的数据
                    advertDto.setLinkageSubtype(advertMapCacheManager.getPutLinkageConfig(advertDto.getNewTradeName()));

                    //出单率
                    advertDto.setOutOrderRate(null);

                    // 新增字段：ocpcReversePrice::ocpc底价
                    Integer cvrType = Optional.ofNullable(advertPriceVO.getSubtype()).orElse(AdvertSubtypeEnum.CVR.getSubtype());
                    advertDto.setOcpcReversePrice(calFinalFeeHandle(specialAgentIdsList, advertVO.getAdvertPlan().getAgentId(), cvrType, ocpaMinPrice, minPriceInSlot));

                    //
                    Integer expandAdvert = advertPriceVO.getOcpcExpandTag() == null ? null : Integer.valueOf(advertPriceVO.getOcpcExpandTag());
                    advertDto.setExpandAdvert(expandAdvert);

                    Integer peoplePrffer = advertPriceVO.getPeoplePrffer() == null ? null : Integer.valueOf(advertPriceVO.getPeoplePrffer());
                    advertDto.setPeopleExpand(peoplePrffer);



                    //新增字段 落地页链接
                    List<String> promoteList = getOrientationPromoteList(advertPromoteList,advertPriceVO);
                    advertDto.setPromoteList(promoteList);

                    advertDto.setEnabledExplore(enabledExplore);
                    advertDto.setAppLimitReleaseMark(StringUtils.isBlank(advertPriceVO.getAppLimitReleaseMark()) ? 0 : Integer.valueOf(advertPriceVO.getAppLimitReleaseMark()));
                    advertDtoList.add(advertDto);
                }

                // 计划配置id集
                List<Long> orientationIdList = filterVO.getAdvertPriceVOSortedSet().stream().map(AdvertPriceVO::getAdvertOrientationPackageId).collect(Collectors.toList());

                // nezha配置id集
                List<Long> nezhaOrientationIdList = advertDtoList.stream().map(AdvertNewDto::getPackageId).collect(Collectors.toList());

                // 去除给nezha的就是被过滤掉的
                orientationIdList.removeAll(nezhaOrientationIdList);
                if(!CollectionUtils.isEmpty(orientationIdList)){
                    Set<AdvertPriceVO>  filterSet = filterVO.getAdvertPriceVOSortedSet().stream().filter(e -> orientationIdList.contains(e.getAdvertOrientationPackageId())).collect(Collectors.toSet());

                    // copy
                    AdvertFilterVO advertFilterVOCopy = BeanUtils.copy(filterVO, AdvertFilterVO.class);
                    advertFilterVOCopy.setAdvertPriceVOSortedSet(new TreeSet<>(filterSet));
                    nezhaFilterMap.put(key, advertFilterVOCopy);
                }
            }

            List<ABRequestDto> request = new ArrayList<>();
            String layerCodeAdSupport = flowRouterProxyService.getLayerCode(ABTestLayerCodeEnum.AD_SUPPORT);
            request.addAll(getADSupportAbTestRequest(supportAdvertList.keySet(), req.getSlotId(), req.getDeviceId(), layerCodeAdSupport));

            List<ABResult> abResultList = flowRouterService.batchABTestHandleResult(request);

            analyseABResult(abResultList,layerCodeAdSupport,supportAdvertList,supportPrivceVOList);

            // 新素材扶持
            newMaterialSupportBatch(req, newMaterialSupportList);

            // 提交到引擎的广告个数
            filterResult.setSendEngineCnt(advertDtoList.size());
            filterResult.setRecomAdIds(recommendOrientList);
            filterResult.setRecomFreeAdIds(freeRecommendOrientList);

            filterResult.setNezhaFilterMap(nezhaFilterMap);
            //美团adx 测试素材对象
            filterResult.setMaterialTestPlanDOMap(materialTestPlanDOMap);
        } catch (Exception ex) {
            if (ex instanceof TuiaException) {
            } else {
                logger.error("RecommendAdvert getAdvertMaxFeeList happen exception, begine degrade handle", ex);
            }
        } catch (Throwable throwable) {
            logger.error("getAdvertMaxFeeList error", throwable);
        } finally {
            DBTimeProfile.release();
        }
        return advertDtoList;
    }

    private void analyseABResult(List<ABResult> abResultList, String layerCodeAdSupport, Map<Long, List<AdvertNewDto>> supportAdvertList, Map<Long, List<AdvertPriceVO>> supportPrivceVOList) {
        if (CollectionUtils.isEmpty(abResultList)) {
            return;
        }

        for (ABResult abResult : abResultList) {
            List<ABResult.ABResultDTO> abResultDTOS= abResult.getAbResultList();
            if (CollectionUtils.isEmpty(abResultDTOS)) {
                continue;
            }

            ABResult.ABResultDTO abResultDTO = abResultDTOS.get(0);
            if (!layerCodeAdSupport.equals(abResultDTO.getLayerCode())) {
                continue;
            }

            Map<String, String> arguments = abResult.getArguments();
            String advertIdStr = arguments.get("advertId");
            String supportType = arguments.get("supportType");

            Long advertId;
            try {
                advertId = Long.valueOf(advertIdStr);
            } catch (NumberFormatException e) {
                advertId = null;
                logger.info("实验平台返回数据异常，异常数据="+JSON.toJSONString(abResult));
            }

            if(null == advertId){
                continue;
            }

            Boolean flag = "1".equals(supportType);
            List<AdvertNewDto> advertNewDtos = supportAdvertList.get(advertId);
            if(CollectionUtils.isNotEmpty(advertNewDtos)){
                advertNewDtos.forEach(dto->dto.setSupportShunt(flag));
            }

            List<AdvertPriceVO> advertPriceVOS = supportPrivceVOList.get(advertId);
            if (CollectionUtils.isNotEmpty(advertPriceVOS)) {
                advertPriceVOS.forEach(vo -> {
                    vo.setSupportShunt(flag);

                    List<ABResult.ABResultDTO> hitABResult = vo.getHitABResult();
                    if(null == hitABResult){
                        hitABResult = new ArrayList<>();
                        vo.setHitABResult(hitABResult);
                    }
                    hitABResult.add(abResultDTO);
                });
            }

        }

    }

    private List<ABRequestDto> getADSupportAbTestRequest(Set<Long> keySet,Long slotId,String deviceId,String layerCode) {

        if (CollectionUtils.isEmpty(keySet)) {
            return Collections.emptyList();
        }

        // 构造实验平台批量分流接口的请求参数
        return  keySet.stream().map(advertId->{
            ABRequestDto abRequestDto = new ABRequestDto();
            abRequestDto.setLayerCode(layerCode);
            abRequestDto.setSlotId(slotId);
            abRequestDto.setDeviceId(deviceId);
            abRequestDto.setAdvertId(advertId);
            return abRequestDto;
        }).collect(Collectors.toList());
    }


    private List<String> getOrientationPromoteList(List<String> advertPromoteList, AdvertPriceVO advertPriceVO) {

        List<String> rtnList = new ArrayList<>(advertPromoteList);
        //多链接测试 配置维度
        if (StringUtils.isNotBlank(advertPriceVO.getPromoteTestUrl())) {
            rtnList.add(advertPriceVO.getPromoteTestUrl());
        }

        return rtnList;
    }

    private List<String> getAdvertPromoteList(AdvertVO advertVO) {
        List<String> rtnList = new LinkedList<>();

        AdvertPlan advertPlan = advertVO.getAdvertPlan();
        if(null == advertPlan){
            return rtnList;
        }

        Long advertId = advertVO.getAdvertPlan().getId();
        if(null == advertId){
            return rtnList;
        }

        //广告基本优惠券
        CouponBase advertCoupon;
        try {
            advertCoupon = advertVO.getCouponBase();
        } catch (Throwable t) {
            advertCoupon = null;
            logger.info("广告计划的的优惠券为空",t);
        }
        if (null != advertCoupon && StringUtils.isNotBlank(advertCoupon.getPromoteURL())) {
            rtnList.add(advertCoupon.getPromoteURL());
        }

        //测试落地页
        MaterialPromoteTestUrlsVO testUrlsVO = advertPromoteTestCacheService.getMaterialPromoteTest(advertId);
        if (testUrlsVO != null && CollectionUtils.isNotEmpty(testUrlsVO.getPromoteUrls())) {
            rtnList.addAll(testUrlsVO.getPromoteUrls());
        }

        //新媒体测试落地页
        if (StringUtils.isNotBlank(advertPlan.getNewAppTestUrl())) {
            rtnList.add(advertPlan.getNewAppTestUrl());
        }

        return rtnList;
    }

    /**
     * 关键词过滤 广告位维度
     * @param advertId
     * @param filterResult
     * @param advertPriceVO
     * @return
     */
    private boolean filterKeyword(Long advertId, FilterResult filterResult, AdvertPriceVO advertPriceVO, ObtainAdvertReq req) {

        //美团adx 不需要过滤
        if (null != req.getAdxMediaType() && req.getAdxMediaType() == 1) {
            return true;
        }

        //兼容命中主链接并且只有主链接情况
        if (filterNormalLoadingPage(advertId, filterResult) && isOnlyPromoteUrl(advertId, filterResult, advertPriceVO)) {
            return false;
        }

        //主链接过滤 配置链接 特殊广告
        if (!filterNormalLoadingPage(advertId, filterResult)
                || !filterConfigLoadingPage(advertId, filterResult, advertPriceVO)) {
            return true;
        }

        return false;
    }

    /**
     * 配置落地页过滤
     * @param advertId
     * @param filterResult
     * @param advertPriceVO
     * @return
     */
    private boolean filterConfigLoadingPage(Long advertId, FilterResult filterResult, AdvertPriceVO advertPriceVO) {
        AdvertFilterKeywordDO advertFilterKeywordDO = filterResult.getAdvertFilterKeywordDO();
        if (Objects.nonNull(advertFilterKeywordDO)) {

            NewTradeFilterKeywordDO newTradeFilterKeywordDO = advertFilterKeywordDO.getNewTradeFilterKeywordDO();
            if (Objects.nonNull(newTradeFilterKeywordDO) && MapUtils.isNotEmpty(newTradeFilterKeywordDO.getShieldConfigLandingPageList())) {
                Map<Long, Set<Long>> advertShieldList = newTradeFilterKeywordDO.getShieldConfigLandingPageList();
                if (null != advertShieldList && advertShieldList.containsKey(advertId)) {
                    Set<Long> configIdShieldList = advertShieldList.get(advertId);
                    if (CollectionUtils.isNotEmpty(configIdShieldList) && configIdShieldList.contains(advertPriceVO.getOriginalOrientationId())) {
                        return true;
                    }
                }
            }

            GeneralFilterKeywordDO generalFilterKeywordDO = advertFilterKeywordDO.getGeneralFilterKeywordDO();
            if (Objects.nonNull(generalFilterKeywordDO) && MapUtils.isNotEmpty(generalFilterKeywordDO.getShieldConfigLandingPageList())) {
                Map<Long, Set<Long>> advertShieldList = generalFilterKeywordDO.getShieldConfigLandingPageList();
                if (null != advertShieldList && advertShieldList.containsKey(advertId)) {
                    Set<Long> configIdShieldList = advertShieldList.get(advertId);
                    if (CollectionUtils.isNotEmpty(configIdShieldList) && configIdShieldList.contains(advertPriceVO.getOriginalOrientationId())) {
                        return true;
                    }
                }
            }

        }
        return false;
    }

    /**
     * 主链接过滤
     * @param advertId
     * @param filterResult
     * @return
     */
    private boolean filterNormalLoadingPage(Long advertId, FilterResult filterResult) {
        AdvertFilterKeywordDO advertFilterKeywordDO = filterResult.getAdvertFilterKeywordDO();
        if (Objects.nonNull(advertFilterKeywordDO)) {
            NewTradeFilterKeywordDO newTradeFilterKeywordDO = advertFilterKeywordDO.getNewTradeFilterKeywordDO();
            if (Objects.nonNull(newTradeFilterKeywordDO) && CollectionUtils.isNotEmpty(newTradeFilterKeywordDO.getShieldNormalLandingList())) {
                if (newTradeFilterKeywordDO.getShieldNormalLandingList().contains(advertId)) {
                    return true;
                }
            }

            GeneralFilterKeywordDO generalFilterKeywordDO = advertFilterKeywordDO.getGeneralFilterKeywordDO();
            if (Objects.nonNull(generalFilterKeywordDO) && CollectionUtils.isNotEmpty(generalFilterKeywordDO.getShieldNormalLandingList())) {
                if (generalFilterKeywordDO.getShieldNormalLandingList().contains(advertId)) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * 是否只有主链接
     * @param advertId
     * @param filterResult
     * @return
     */
    private boolean isOnlyPromoteUrl(Long advertId, FilterResult filterResult, AdvertPriceVO advertPriceVO) {
        AdvertFilterKeywordDO advertFilterKeywordDO = filterResult.getAdvertFilterKeywordDO();

        if (Objects.nonNull(advertFilterKeywordDO)) {
            NewTradeFilterKeywordDO newTradeFilterKeywordDO = advertFilterKeywordDO.getNewTradeFilterKeywordDO();
            if (Objects.nonNull(newTradeFilterKeywordDO) && newTradeFilterKeywordDO.getOnlyPromoteUrl().containsKey(advertId)) {
                Map<Long, Long> map = newTradeFilterKeywordDO.getOnlyPromoteUrl().get(advertId);
                if (map.containsKey(advertPriceVO.getOriginalOrientationId())) {
                    if (map.get(advertPriceVO.getOriginalOrientationId()).equals(1L)) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }

            GeneralFilterKeywordDO generalFilterKeywordDO = advertFilterKeywordDO.getGeneralFilterKeywordDO();
            if (Objects.nonNull(generalFilterKeywordDO) && generalFilterKeywordDO.getOnlyPromoteUrl().containsKey(advertId)) {
                Map<Long, Long> map = generalFilterKeywordDO.getOnlyPromoteUrl().get(advertId);
                if (map.containsKey(advertPriceVO.getOriginalOrientationId())) {
                    if (map.get(advertPriceVO.getOriginalOrientationId()).equals(1L)) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }

        return false;
    }

    /**
     * 设置广告赔付权重
     *
     * @param advertId 广告计划id
     * @param weight   当前广告权重
     * @return
     */
    private Double getCompensateWeight(Long advertId, Double weight) {

        /**
         * 当前计划是否在赔付列表中，不在列表说明不要赔付，返回已往权重，在列表中时返回1.2D的权重
         */
        boolean isNeedCompensate = advertCompensateCacheService.isNeedCompensate(advertId);
        if(isNeedCompensate){
            return 1.2D;
        }

        return weight;
    }

    /**
     * 记录过滤日志中参与竞价的配置信息
     *
     * @param advertDto
     */
    private void buildFilterResultRecommendPackage(AdvertNewDto advertDto,  List<RecommendOrient> recommendOrientList, List<RecommendOrient> freeRecommendOrientList) {
        // 免费券
        if (advertDto.getFee() == 0) {

            freeRecommendOrientList.add(new RecommendOrient(advertDto.getAdvertId(), advertDto.getPackageId()));
        } else {
            // 付费券

            recommendOrientList.add(new RecommendOrient(advertDto.getAdvertId(), advertDto.getPackageId()));
        }
    }

    /**
     * 将advertPriceVO的参数传给nezha
     * @param advertDto
     * @param advertPriceVO
     */
    private void buildByPriceVO(AdvertNewDto advertDto,AdvertPriceVO advertPriceVO, AdvertVO advertVO,FilterResult filterResult){

        if(advertPriceVO == null){
            return;
        }

        advertDto.setFee(advertPriceVO.getFee());

        if (advertPriceVO.getMarketConvertCost() != null) {
            advertDto.setConvertCost(advertPriceVO.getMarketConvertCost());
        } else {
            advertDto.setConvertCost(advertPriceVO.getConvertCost());
        }
        advertDto.setConvertTypeCost(advertPriceVO.getConvertTypeCost());

        advertDto.setChargeType(advertPriceVO.getChargeType());
        advertDto.setPackageId(advertPriceVO.getAdvertOrientationPackageId());
        // 设置每个时段的预算
        this.pacingPeriod(advertPriceVO, advertDto);
        // 设置折扣率
        advertDto.setDiscountRate(advertMapCacheManager.getAdvertBidRateNoCache(advertPriceVO.getChargeType(), advertVO));
    }

    private void setMaterialFeature(AdvertPriceVO advertPriceVO,AdvertNewDto advertNewDto){

        //materialIds前面已经过滤掉了被屏蔽的素材，此处不需要在处理了
        Set<Long> materialIds=advertPriceVO.getMaterialsBind();
        if(CollectionUtils.isEmpty(materialIds)){
              return ;
        }

        List<AdvertMaterialDto> advertMaterialDtos=advertMaterialRecommendService.getMaterialListByAdvertId(advertPriceVO.getAdvertId());

        if(CollectionUtils.isEmpty(advertMaterialDtos)){
            return;
        }
        Set<MaterialDto> materialDtos= Sets.newHashSet();
        advertMaterialDtos.stream().forEach(dto->{
            if(materialIds.contains(dto.getId())){
                setMaterials(materialDtos,dto);
            }
        });
        advertNewDto.setMaterials(materialDtos);
    }

    /**
     * 处理用户参与的素材测试的素材ID
     * @param advertPriceVO
     * @param advertNewDto
     * @param filterResult
     * @param testPlanMap
     * @param oldMaterialMap
     */
    private void preHandlerTestMaterialId(AdvertPriceVO advertPriceVO, AdvertNewDto advertNewDto,
                                          FilterResult filterResult, Map<Long, AdvertMaterialTestPlanDO> testPlanMap,
                                          Map<Long, List<Long>> oldMaterialMap) {

        // 设置有效素材列表
        setMaterialFeature(advertPriceVO, advertNewDto);

        // 广告ID
        Long advertId = advertNewDto.getAdvertId();

        // 有效的素材列表
        List<Long> validMaterials = getValidMaterial(advertNewDto);
        if (CollectionUtils.isEmpty(validMaterials)) {
            logger.info("validMaterialsIsEmpty {}", advertId);
            // 没有有效的素材列表
            return;
        }

        MaterialTestPlanDO materialTestPlanDO = new MaterialTestPlanDO();
        materialTestPlanDO.setTestPlanMaterial(false);
        materialTestPlanDO.setValidMaterialIds(validMaterials);
        advertPriceVO.setMaterialTestPlanDO(materialTestPlanDO);

        // 获取广告的新老素材列表
        RspMaterialList materialIds = getMaterialList(advertId, validMaterials, oldMaterialMap);
        materialTestPlanDO.setRspMaterialList(materialIds);

        // 获取已经参与的素材测试
        Set<Long> testMaterialAdvertIdSet = getTestMaterialAdvertIdSet(filterResult);
        if (testMaterialAdvertIdSet.contains(advertId)) {
            materialTestPlanDO.setAbTestSkip(ABTestSkipEnum.AB2005);
            // 已经参与该广告的素材测试
            return;
        }

        // 没有参与该广告的素材测试

        // 素材测试计划
        AdvertMaterialTestPlanDO advertMaterialTestPlanDo = testPlanMap.get(advertId);

        // 有效的测试素材列表
        List<Long> validTestMaterial = getValidTestMaterial(validMaterials, advertMaterialTestPlanDo);
        materialTestPlanDO.setValidTestMaterial(validTestMaterial);

        List<Long> newMaterials = Optional.ofNullable(materialIds)
                .map(v -> v.getNewMaterials()).orElseGet(() -> Collections.emptyList());

        List<Long> oldMaterials = Optional.ofNullable(materialIds)
                .map(v -> v.getOldMaterials()).orElseGet(() -> Collections.emptyList());


        // 判断是否要测试
//        if (CollectionUtils.isEmpty(newMaterials) && !checkTestMaterialAdvert(advertNewDto, advertMaterialTestPlanDo)) {
            // logger.info("checkTestMaterialAdvert {} {} {}", advertId, validTestMaterial, materialIds);
            // 不需要测试
//            return;
//        }



        // 判断是否要素材测试
        if (!checkTestMaterialAdvert(advertNewDto, advertMaterialTestPlanDo)) {
            materialTestPlanDO.setAbTestSkip(ABTestSkipEnum.AB2006);
            return;
        }

        // 如果测试素材中,只有一个老素材
        if (checkOneTestOldMaterial(validTestMaterial, oldMaterials)) {
            // ignore 不需要打标
            logger.info("checkOneTestOldMaterial {} {} {}", advertId, validTestMaterial, materialIds);
            materialTestPlanDO.setAbTestSkip(ABTestSkipEnum.AB2007);
            return;
        }

        // 在finishBiz中调用实验平台素材测试
        materialTestPlanDO.setTestPlanMaterial(true);
    }

    /**
     * 获取有效的新老素材
     * @param advertId
     * @param validMaterials
     * @param oldMaterialMap
     * @return
     */
    private RspMaterialList getMaterialList(Long advertId, List<Long> validMaterials, Map<Long, List<Long>> oldMaterialMap) {

        RspMaterialList rspMaterialList = new RspMaterialList();
        //设置老素材流量比率
        rspMaterialList.setOldMaterialTraffic(AdvertMaterialRealtionServiceImpl.OLD_MATERIAL_TRAFFIC);
        rspMaterialList.setOldMaterialRatio(AdvertMaterialRealtionServiceImpl.OLD_MATERIAL_RATIO);

        // 获取老素材
        List<Long> oldMaterials = Optional.ofNullable(oldMaterialMap)
                .map(v -> v.get(advertId))
                .orElseGet(() -> Collections.emptyList());

        // 没有老素材, 都是新素材
        if (CollectionUtils.isEmpty(oldMaterials)) {
            rspMaterialList.setNewMaterials(validMaterials);
            rspMaterialList.setOldMaterials(oldMaterials);
            return rspMaterialList;
        }

        // 计算老素材
        List<Long> oldTmpList = Lists.newArrayList(validMaterials);
        oldTmpList.retainAll(oldMaterials);
        rspMaterialList.setOldMaterials(oldTmpList);

        // 计算新素材
        List<Long> newTmpList = Lists.newArrayList(validMaterials);
        newTmpList.removeAll(oldMaterials);
        rspMaterialList.setNewMaterials(newTmpList);

        return rspMaterialList;
    }

    /**
     * 获取广告有效的素材列表
     * @param advertNewDto
     * @return
     */
    private static List<Long>  getValidMaterial(AdvertNewDto advertNewDto) {
        if(CollectionUtils.isEmpty(advertNewDto.getMaterials())) {
            return Collections.emptyList();
        }
        return advertNewDto.getMaterials().stream()
                .map(MaterialDto::getId).collect(Collectors.toList());
    }

    /**
     * 获取有效的测试素材列表
     * @param validMaterials
     * @param advertMaterialTestPlanDo
     * @return
     */
    private static List<Long> getValidTestMaterial(List<Long> validMaterials, AdvertMaterialTestPlanDO advertMaterialTestPlanDo) {
        List<Long> testMaterials = Optional.ofNullable(advertMaterialTestPlanDo)
                .map(v -> v.getMaterialIds()).orElse(null);
        if (CollectionUtils.isEmpty(testMaterials)) {
            return Collections.emptyList();
        }
        List<Long> validTestMaterial = new ArrayList<>(testMaterials);
        validTestMaterial.retainAll(validMaterials);
        return validTestMaterial;
    }

    private static Set<Long> getTestMaterialAdvertIdSet(FilterResult filterResult) {
        return Optional.ofNullable(filterResult)
                .map(v -> v.getTestMaterialAdvertIdSet())
                .orElseGet(() -> Collections.emptySet());
    }

    /**
     * 测试计划判断要不要测试
     *
     * @return true=需要测试, false=不用测试
     */
    private boolean checkTestMaterialAdvert(AdvertNewDto advertNewDto, AdvertMaterialTestPlanDO advertMaterialTestPlanDo) {
        // 测试计划生效
        return Objects.nonNull(advertMaterialTestPlanDo)
                // 配置包在测试计划中
                && checkOrients(advertNewDto.getPackageId(), advertMaterialTestPlanDo.getOrientIds())
                // 测试计划没有过期
                && checkTestPlanEndtime(advertMaterialTestPlanDo);
    }

    /**
     * 判断配置包ID,是否在测试计划中
     * @return true=有效   false=无效
     */
    private static boolean checkOrients(Long orientId, String orientIds) {

        if(null == orientIds||"".equals(orientIds.trim())){
            return true;
        }

        String[] split = orientIds.split(",");
        Set<String> orientIdSet = new HashSet<>(Arrays.asList(split));
        return orientIdSet.contains(String.valueOf(orientId));
    }

    /**
     *
     * @param advertMaterialTestPlanDo
     * @return true=有效   false=无效
     */
    private boolean checkTestPlanEndtime(AdvertMaterialTestPlanDO advertMaterialTestPlanDo) {
        //取日期的 23：59：59.999
        String endTime = advertMaterialTestPlanDo.getEndtime();
        //如果没有设置结束时间 则 直接通过校验
        if(null == endTime || "".equals(endTime.trim())){
            return true;
        }else {
            //结束时间在 当下 之后 为true
            if(DateUtils.getDayEndTime(endTime).after(new Date())){
                return true;
            }else{
                //异步(改数据库 并 缓存失效)
                // 通过缓存刷新机制来更新
//                advertMaterialTestPlanCacheService.changeAndExpire();
                return false;
            }
        }
    }

    /**
     * 如果测试素材中,只有一个老素材
     * @param validTestMaterial
     * @param oldMaterials
     * @return true=不用测试, false=需要测试
     */
    private static boolean checkOneTestOldMaterial(List<Long> validTestMaterial, List<Long> oldMaterials) {
        // 测试素材等于1 且 老素材包含测试素材
        if (CollectionUtils.isNotEmpty(validTestMaterial) && 1 == validTestMaterial.size()
                && CollectionUtils.isNotEmpty(oldMaterials) && oldMaterials.contains(validTestMaterial.get(0))) {
            return true;
        }
        return false;
    }

    /**
     * 有素材测试计划 且 开始命中切量比的
     *
     * @param testPlanDO
     * @return true=命中, false=没有命中
     */
    private static boolean checkTestFlowRatio(int flowRatio, AdvertMaterialTestPlanDO testPlanDO) {
        return flowRatio <= Optional.ofNullable(testPlanDO).map(v -> v.getTestFlowRatio()).orElse(10);
    }

    /**
     * 获取随机素材
     * @param validTestMaterial
     * @param newMaterials
     * @return
     */
    private Long getRandomMaterial(Long advertId, List<Long> validTestMaterial, List<Long> newMaterials) {
        Set<Long> testAndNewMaterialsSet = null;
        if (CollectionUtils.isNotEmpty(validTestMaterial)) {
            testAndNewMaterialsSet = new HashSet<>(validTestMaterial);
            if (CollectionUtils.isNotEmpty(newMaterials)) {
                testAndNewMaterialsSet.addAll(newMaterials);
            }
        } else if (CollectionUtils.isNotEmpty(newMaterials)) {
            testAndNewMaterialsSet = new HashSet<>(newMaterials);
            if (CollectionUtils.isNotEmpty(validTestMaterial)) {
                testAndNewMaterialsSet.addAll(validTestMaterial);
            }
        }
        if (testAndNewMaterialsSet == null || testAndNewMaterialsSet.size() == 0) {
            //logger.info("getRandomMaterialEmpty {} validTestMaterial={}, newMaterials={}", advertId, validTestMaterial, newMaterials);
            return null;
        }
        List<Long> testAndNewMaterials = new ArrayList<>(testAndNewMaterialsSet);
        Long testMaterialId = testAndNewMaterials.get(getRandom(1, testAndNewMaterials.size()) - 1);
        //logger.info("getRandomMaterial {} testMaterialId={} validTestMaterial={}, newMaterials={}", advertId, testMaterialId, validTestMaterial, newMaterials);
        return testMaterialId;
    }

    private static int getRoundRobin() {
        if (100 <= COUNTER.getAndIncrement()) {
            COUNTER.set(1);
        }
        return COUNTER.get();
    }

    private static int getRandom(int min, int max) {
        return (int) (Math.random()*((max+1)-min)+min);
    }

    /**
     * 将配置的绑定素材和广告下的其他试投素材传递给nezha
     * @param materialDtos
     * @param dto
     */
    private void setMaterials(Set<MaterialDto> materialDtos,AdvertMaterialDto dto){
        MaterialDto materialDto=new MaterialDto();
        materialDto.setId(dto.getId());
        //如果素材没有绑定新属性则
        if(null != dto.getPhotoId()){
            materialDto.setAtmosphere(dto.getAtmosphere());
            materialDto.setBackgroundColour(dto.getBgColour());
            materialDto.setBodyElement(dto.getBodyElement());
            materialDto.setCarton(dto.getCarton());
            materialDto.setInterception(dto.getInterception());
            materialDto.setPrevalent(IS_PREVALENT.equals(dto.getIsPrevalent()));
        }
        materialDtos.add(materialDto);
    }



    private List<RcmdAdvertDto> adxRecommendOperate(ObtainAdvertReq req, Long strategyPoint, FilterResult filterResult, ReqAdvertNewDto dto) throws Exception {
        filterResult.setLinkParagraph(CommonConstants.NEZHA);
        int newStrategyPoint = StrategyType.getNewTypeByStrategyPoint(strategyPoint.intValue());

        if (req.getLogExtExpMap() == null) {
            req.setLogExtExpMap(new HashMap<>());
        }

        String sceneDoubleFeeStrategyPoint = getSceneDoubleFeeStrategyPoint(req, filterResult.getLogExtMap(), dto.getRequestDto());

        // 设置媒体所需多张券的 广告类型xxx
        getSceneAppRadStrategyPoint(req, filterResult.getLogExtMap(), dto.getAppDto());

        try {
            DBTimeProfile.enter("adxRecommendOperate");

            int mediaType = req.getAdxMediaType();

            // 如果是adx预发券且流量类型是普通的，调用预发券
            if(AdxLoadTypeEnum.PRE_LOAD.getLoadType() == dto.getRequestDto().getAdxLoadType() &&  mediaType == 0){
                return remoteAdvertRecommendService.preRecommend(dto, String.valueOf(newStrategyPoint), sceneDoubleFeeStrategyPoint);
            }else{
                // 美团adx mediaType = 1，也调用 真实发券，策略id写死，用真实发券的nezha接口..
                if(mediaType == 1){
                    //调用dmp判断是否有爱奇艺标签
                    AqyAttributeDto aqyDto = consumerService.getAqyAttribute(req.getDeviceId());
                    boolean isAqyTag = false;
                    if (aqyDto != null
                            && (aqyDto.getAge() != null || aqyDto.getSex() != null)
                            && dto.getAppDto() != null) {
                        isAqyTag = true;
                        dto.getAppDto().setAqyAge(aqyDto.getAge());
                        dto.getAppDto().setAqySex(aqyDto.getSex());
                    }
                    // newStrategyPoint = 252;
                    newStrategyPoint = getMeituanStrategyPoint(req, isAqyTag);

                    if (req.getLogExtMap() == null) {
                        req.setLogExtMap(new HashMap<>());
                    }
                    filterResult.getLogExtMap().put(AdvertReqLogExtKeyConstant.SCENCE_NUM, newStrategyPoint);
                    req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SCENCE_NUM, String.valueOf(newStrategyPoint));

                    // 真实发券
                    dto.getRequestDto().setAdxLoadType(2);
                }
                // 如果是真实发券
                return remoteAdvertRecommendService.batchRecommend(dto, String.valueOf(newStrategyPoint), sceneDoubleFeeStrategyPoint);
            }
        }catch(Exception e){
            logger.error("adxRecommendOperate error,the error is", e);
            return Lists.newArrayList();
        }finally {
            DBTimeProfile.release();
        }
    }

    /**
     * Do recommend operator.
     *
     * @param strategyPoint the strategy point
     * @param filterResult the filter result
     * @param dto the dto
     * @return the dubbo result< rcmd advert dto>
     * @throws TuiaException the tuia exception
     */
    private List<RcmdAdvertDto> doRecommendOperate(Long strategyPoint, FilterResult filterResult,ReqAdvertNewDto dto, String sceneDoubleFeeStrategyPoint) throws Exception {
        filterResult.setLinkParagraph(CommonConstants.NEZHA);
        int newStrategyPoint = StrategyType.getNewTypeByStrategyPoint(strategyPoint.intValue());
        try {
            DBTimeProfile.enter("recommendList");
            return remoteAdvertRecommendService.batchRecommend(dto, String.valueOf(newStrategyPoint), sceneDoubleFeeStrategyPoint);
        }catch(Exception e){
            logger.error("batchRecommend error,the error is", e);
            return Lists.newArrayList();
        }finally {
            DBTimeProfile.release();
        }
    }

    /**
     * pacing 设置每个时段的预算
     *
     * @param advertPriceVO
     * @param advertNewDto
     */
    @java.lang.SuppressWarnings("squid:S3776")
    private void pacingPeriod(AdvertPriceVO advertPriceVO, AdvertNewDto advertNewDto) {

        List<AdvertPlanPeriodDO> advertPlanPeriodDOS = advertPriceVO.getPeriods();
        // 设置配置的总预算
        advertNewDto.setPackageBudget(advertPriceVO.getBudgetPerDay());
        // 设置广告预算
        advertNewDto.setAdvertBudget(advertPriceVO.getAdvertBudgetPerDay());

        Map<Integer, Long> hourlyBudgetFeeMap = Maps.newConcurrentMap();
        Map<Integer, Long> hourlyBudgetCountMap = Maps.newConcurrentMap();
        // 投放时段只取小时范围内的数据，因为pacing需求不需要精准的，如果之后需要精准的，需要求比例
        for (AdvertPlanPeriodDO advertPlanPeriodDO : advertPlanPeriodDOS) {

            // 如果是空值，代表是不限，不需要在计算
            if (advertPlanPeriodDO.getPeriodValue() == null) {
                continue;
            }

            Integer startHour = DateUtils.getHour(advertPlanPeriodDO.getStartHour());
            Integer endHour = DateUtils.getHour(advertPlanPeriodDO.getEndHour());
            if (startHour == endHour) {
                endHour = startHour + 1;
            }
            Long averageFee = 0L;
            Long averageCount = 0L;
            AdvertPkgPeriodTypeEnum periodTypeEnum = AdvertPkgPeriodTypeEnum.getByCode(advertPlanPeriodDO.getPeriodType());
            // 获取时段内的平均值
            switch (periodTypeEnum) {
                case PERIOD_TYPE_HOUR_BUDGET:
                    averageFee = advertPlanPeriodDO.getPeriodValue();
                    break;
                case PERIOD_TYPE_HOUR_COUPON:
                    averageCount = advertPlanPeriodDO.getPeriodValue();
                    break;
                case PERIOD_TYPE_COUNT_BUDGET:
                    averageFee = advertPlanPeriodDO.getPeriodValue() / (endHour - startHour);
                    break;
                case PERIOD_TYPE_COUNT_COUPON:
                    averageCount = advertPlanPeriodDO.getPeriodValue() / (endHour - startHour);
                    break;
            }

            if (averageFee != 0) {

                for (; startHour <= endHour; startHour++) {
                    hourlyBudgetFeeMap.put(startHour, averageFee);
                }
            }

            if (averageCount != 0) {
                for (; startHour <= endHour; startHour++) {
                    hourlyBudgetCountMap.put(startHour, averageCount);
                }
            }
        }

        List<Double> hourlyBudgetFees = Lists.newArrayListWithCapacity(24);
        List<Double> hourlyBudgetCounts = Lists.newArrayListWithCapacity(24);
        for (int i = 0; i < 24; i++) {

            Long feeVal = hourlyBudgetFeeMap.get(i);
            Long countVal = hourlyBudgetCountMap.get(i);
            hourlyBudgetFees.add(feeVal == null ? AdvertConstants.PACING_BUDGET_ONLY : feeVal.doubleValue());
            hourlyBudgetCounts.add(countVal == null ? AdvertConstants.PACING_BUDGET_ONLY : countVal.doubleValue());
        }

        advertNewDto.setHourlyBudgetFees(hourlyBudgetFees);
        advertNewDto.setHourlyBudgetCounts(hourlyBudgetCounts);
    }

    @Override
    public void dmpAdvertDOS(FilterResult filterResult,Long advertId,AdvertPriceVO advertPriceVO){

        Map<String, Object> dmpTagMap = filterResult.getDmpTagMap();

        if(dmpTagMap ==null || dmpTagMap.size() == 0){
            return;
        }

        List<DmpAdvertDO> dmpAdvertDOS = filterResult.getDmpAdvertDOS();

        Long orientPackageId = advertPriceVO.getAdvertOrientationPackageId();

        String key = String.valueOf(advertId).concat(String.valueOf(orientPackageId));

        Map<String,String> advertTradePackageTagMap = filterResult.getAdvertTradePackageTags();

        List<Long> adList = new ArrayList<>();

        List<Integer> typeList = new ArrayList<>();

        List<String> tagList = new ArrayList<>();

        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(dmpAdvertDOS)){
            //判断当前广告是否是dmp命中的测试广告，组装日志
            for(DmpAdvertDO vo: dmpAdvertDOS){
                if(vo.getAdvertId().equals(advertId)&& null != orientPackageId && orientPackageId.equals(vo.getOrientId())){
                    adList.add(advertId);
                    typeList.add(vo.getPutOnType());
                    tagList.add(vo.getTestTag());
                    break;
                }
            }
        }else if(advertTradePackageTagMap != null && advertTradePackageTagMap.size()>0 && StringUtils.isNotEmpty(advertTradePackageTagMap.get(key))){
            //如果命中了行业人群包，则组装日志

            adList.add(advertId);
            typeList.add(2);
            tagList.add(advertTradePackageTagMap.get(key));
        }

        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(adList)){
            //组装日志,如果有多个标签，只取一个
            dmpTagMap.put("Ad",adList.get(0));
            dmpTagMap.put("type",typeList.get(0));
            dmpTagMap.put("tag",tagList.get(0));

            filterResult.setDmpTagMap(dmpTagMap);
        }
    }

    public List<String> getSpecialAgentIdsList() {
        if (specialAgentIdsList == null) {
            specialAgentIdsList = TuiaStringUtils.getStringListByStr(specialAgentIds);
        }
        return specialAgentIdsList;
    }

    /**
     * 拓量实验判断是否命中流量
     *
     * 判断实验组是否命中:expB、expD
     *
     * @param req 广告请求参数
     * @return true.命中;false.未命中
     */
    private boolean isExpandHit(ObtainAdvertReq req) {
        if (null == req || null == req.getLogExtExpMap()) {
            return false;
        }

        String exploreExpName = req.getLogExtExpMap().get(AdvertReqLogExtKeyConstant.MAJOR_OCPC_EXPNAME);
        return EXPLORE_TRANSFORM_SET.contains(exploreExpName);
    }

    /**
     * 获取策略模型Id
     *
     * @return 策略模型Id
     */
    private Long getStrategyPoint(ObtainAdvertReq req) {
        ABResult handleResult = flowRouterProxyService.routeFlow(req, ABTestLayerCodeEnum.NORMAL);
        Map<String, String> arguments = handleResult.getArguments();
        return Long.valueOf(arguments.getOrDefault("strategyPoint", "1"));
    }

    /**
     * 素材测试没有命中，剩下10%的流量新素材扶持
     *
     * @param deviceId 设备号
     * @param materialTestPlan 素材测试计划
     * @return 新素材
     */
    private Long newMaterialSupport(String deviceId, MaterialTestPlanDO materialTestPlan) {
        // 新素材扶持切量的判断，默认10%
        int random = Math.abs(deviceId.hashCode()) % 100;
        if (random >= apolloConfig.getNewMaterialSupportRatio()) {
            return null;
        }

        // 获取新素材列表并随机出一个
        List<Long> newMaterials = Optional.ofNullable(materialTestPlan.getRspMaterialList())
                .map(RspMaterialList::getNewMaterials).orElseGet(Collections::emptyList);
        if (CollectionUtils.isNotEmpty(newMaterials)) {
            int rand = new Random().nextInt(newMaterials.size());
            return newMaterials.get(rand);
        }
        return null;
    }

    /**
     * 没有素材测试的广告走新素材扶持逻辑
     *
     * @param req 广告请求参数
     * @param newMaterialSupportList 新素材扶持列表
     */
    private void newMaterialSupportBatch(ObtainAdvertReq req, List<MaterialTestDTO> newMaterialSupportList) {
        if (CollectionUtils.isEmpty(newMaterialSupportList)) {
            return;
        }

        for (MaterialTestDTO materialTestDTO : newMaterialSupportList) {
            MaterialTestPlanDO materialTestPlan = materialTestDTO.getMaterialTestPlan();
            if (null == materialTestPlan) {
                continue;
            }

            // 新素材扶持逻辑，分流没命中或者命中无效素材的情况下用10%的流量出新素材
            if (null == materialTestPlan.getMaterialId()) {
                Long testMaterialId = newMaterialSupport(req.getDeviceId(), materialTestPlan);
                materialTestPlan.setMaterialId(testMaterialId);
                materialTestPlan.setSupportMaterialId(testMaterialId);
            }

            // 替换传给 nezha 的素材列表
            if (null != materialTestPlan.getMaterialId()) {
                Set<MaterialDto> materials = materialTestDTO.getAdvertNewDto().getMaterials();
                for (MaterialDto materialDto : materials) {
                    if (Objects.equals(materialDto.getId(), materialTestPlan.getMaterialId())) {
                        materialTestDTO.getAdvertNewDto().setMaterials(Sets.newHashSet(materialDto));
                        break;
                    }
                }
            }
        }
    }

    /**
     * 新素材扶持预处理逻辑
     */
    private void preHandlerNewMaterialSupport(AdvertPriceVO advertPriceVO, AdvertNewDto advertNewDto,
                                              List<MaterialTestDTO> newMaterialSupportList) {

        MaterialTestPlanDO materialTestPlanDO = advertPriceVO.getMaterialTestPlanDO();
        if (null == materialTestPlanDO) {
            return;
        }

        // 构造新素材扶持参数
        MaterialTestDTO materialTestDTO = new MaterialTestDTO();
        materialTestDTO.setMaterialTestPlan(materialTestPlanDO);
        materialTestDTO.setAdvertNewDto(advertNewDto);

        // 新素材扶持
        newMaterialSupportList.add(materialTestDTO);
    }
}
