package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.constants.AdvertSystemConfigureConstants;
import cn.com.duiba.tuia.dao.engine.SystemConfigDAO;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.service.AdvertSystemConfigureService;
import cn.com.tuia.advert.constants.SystemConfigKeyConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年05月02日 17:31
 * @descript:
 * @version: 1.0
 */
@Service
public class AdvertSystemConfigureServiceImpl implements AdvertSystemConfigureService, InitializingBean {

    private final Logger logger = LoggerFactory.getLogger(AdvertSystemConfigureServiceImpl.class);

    @Autowired
    private SystemConfigDAO systemConfigDAO;

    @Override
    public void afterPropertiesSet() throws Exception {
        //初始化dmp和风控接口配置
        this.iniDmpAndRiskCheat();
    }

    private String getSysConfigStrVal(String key) throws TuiaException {
        String value = systemConfigDAO.getSystemConfig(key);
        return value;
    }

    private Boolean getSysConfigBooleanVal(String key) throws TuiaException {
        String value = systemConfigDAO.getSystemConfig(key);
        return Boolean.valueOf(value);
    }

    private void iniDmpAndRiskCheat() {
        try {
            AdvertSystemConfigureConstants.riskPercent = this.getSysConfigStrVal(SystemConfigKeyConstant.RISK_CHEAT_PERCENT);
            AdvertSystemConfigureConstants.riskAdvertId = this.getSysConfigStrVal(SystemConfigKeyConstant.RISK_CHEAT_ADVERT);

            AdvertSystemConfigureConstants.dmpSwitch = this.getSysConfigBooleanVal(SystemConfigKeyConstant.DPM_DATA_OPEN);
            //AdvertSystemConfigureConstants.dmpTestDate = this.getSysConfigStrVal(SystemConfigKeyConstant.DPM_TEST_DATA);
        } catch (TuiaException e) {
            logger.error("初始化DMP和风控反作弊流量全局配置异常！");
        }
    }
}
