/**
 * Project Name:engine-service
 * File Name:AdvertTargetAppServiceImpl.java
 * Package Name:cn.com.duiba.tuia.service.impl
 * Date:2018年7月10日下午2:25:51
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.service.impl;

import java.util.*;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import cn.com.duiba.tuia.dao.engine.AdvertOrientationPackageDAO;
import cn.com.duiba.tuia.dao.engine.OrientationFocusAppConvertCostDAO;
import cn.com.duiba.tuia.domain.dataobject.AdvertOrientationPackageDO;
import cn.com.duiba.tuia.domain.dataobject.OrientationFocusAppConvertCostDO;
import cn.com.tuia.advert.enums.PutTargetTypeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.tuia.dao.targetapp.AdvertTargetAppDAO;
import cn.com.duiba.tuia.domain.dataobject.AdvertTargetAppDO;
import cn.com.duiba.tuia.domain.dataobject.AppPackageDO;
import cn.com.duiba.tuia.service.AdvertAppPackageService;
import cn.com.duiba.tuia.service.AdvertOrientationService;
import cn.com.duiba.tuia.service.AdvertTargetAppService;
import cn.com.duiba.tuia.tool.StringTool;


/**
 * ClassName:AdvertTargetAppServiceImpl <br/>
 * Function: 定向配置的定向媒体-广告位. <br/>
 * Date:     2018年7月10日 下午2:25:51 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
@Service
public class AdvertTargetAppServiceImpl implements AdvertTargetAppService {

    private static final Logger logger = LoggerFactory.getLogger(AdvertTargetAppServiceImpl.class);

    
    @Autowired
    private AdvertTargetAppDAO advertTargetAppDAO;
    
    @Resource
    private AdvertAppPackageService advertAppPackageService;
    
    @Override
    public Set<Long> selectAllTargetApps(Long advertId, Long orientId, Long rawOrientId, Map<Long, Long> appTargetPackage) {
        Set<Long> allAppIds = new HashSet<>();
        AdvertTargetAppDO targetAppDO = selectAppByAdvertId(advertId, orientId);

        if (targetAppDO != null) {
            if (StringUtils.isNotBlank(targetAppDO.getAppIds())) {
                List<Long> targetAppIds = StringTool.getLongListByStr(targetAppDO.getAppIds());
                if (CollectionUtils.isNotEmpty(targetAppIds)) {
                    allAppIds.addAll(targetAppIds);
                }
            }

        }

        // 根据配置包id查询流量包中的appIds
        List<AppPackageDO> appPackageList = advertAppPackageService.getAppPackageByAdvertOrientationId(rawOrientId);

        if (CollectionUtils.isNotEmpty(appPackageList)) {
            List<Long> packageTargetAppIds = appPackageList.stream()
                    .map(appPackageDO -> StringTool.getLongListByStr(appPackageDO.getAppIds()))
                    .flatMap(List::stream)
                    .distinct()
                    .collect(Collectors.toList());

            if (CollectionUtils.isNotEmpty(packageTargetAppIds)) {
                allAppIds.addAll(packageTargetAppIds);

                appPackageList.forEach(appPackage -> {
                    List<Long> packageAppIds = StringTool.getLongListByStr(appPackage.getAppIds());
                    packageAppIds.forEach(packageAppId -> appTargetPackage.put(packageAppId, appPackage.getId()));
                });
            }
        }

        return allAppIds;
    }

    @Override
    public AdvertTargetAppDO selectAppByAdvertId(Long advertId, Long orientPkgId){
        return advertTargetAppDAO.selectAppByAdvertId(advertId, orientPkgId);
    }
    
}

