package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.dao.dmp.AdvertTradePackageDAO;
import cn.com.duiba.tuia.domain.dataobject.AdvertTradePackageDO;
import cn.com.duiba.tuia.service.AdvertTradePackageService;
import cn.com.duiba.tuia.service.BaseService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

import static java.util.stream.Collectors.toList;

/**
 * @author zhangmeng
 * @date 2018/12/10
 * @function 获取行业人群包 service
 */
@Service
public class AdvertTradePackageServiceImpl extends BaseService implements AdvertTradePackageService {

    private static final String key = "advertTradePackage";

    @Resource
    private ExecutorService executorService;

    @Autowired
    private AdvertTradePackageDAO advertTradePackageDAO;

    //有消息同步，不用设置过期时间来保证避免读取旧值
    private final LoadingCache<String,List<String>> ADVERT_TRADE_PACKAGE_CACHE = CacheBuilder.newBuilder().initialCapacity(1000).
            recordStats().refreshAfterWrite(5, TimeUnit.MINUTES).build(new CacheLoader<String,List<String>>() {
        @Override
        public List<String> load(String key) {

            List<AdvertTradePackageDO> advertTradePackageDO = advertTradePackageDAO.queryAllTradePackageDOs();

            return advertTradePackageDO.stream().map(AdvertTradePackageDO::getTagValue).collect(toList());

        }

        @Override
        public ListenableFuture<List<String>> reload(final String key, List<String> oldValue) {

            ListenableFutureTask<List<String>> task = ListenableFutureTask.create(() -> load(key));

            executorService.submit(task);

            return task;
        }
    });

    @Override
    public List<String> getAllValidTradePackageDO() {
        return ADVERT_TRADE_PACKAGE_CACHE.getUnchecked(key);
    }

    @Override
    public void refreshCache() {
        ADVERT_TRADE_PACKAGE_CACHE.refresh(key);
    }
}
