package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.dao.advert.AdvertWhiteDAO;
import cn.com.duiba.tuia.service.AdvertWhiteService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2018年04月19日 21:11
 * @descript:
 * @version: 1.0
 */
@Service
public class AdvertWhiteServiceImpl implements AdvertWhiteService {

    @Autowired
    private AdvertWhiteDAO advertWhiteDAO;

    @Resource
    private ExecutorService executorService;

    private final Long key = 1L;

    private final LoadingCache<Long, Set<Long>> ADVERT_WHITE_CACHE = CacheBuilder.newBuilder().initialCapacity(100)
            .refreshAfterWrite(10, TimeUnit.MINUTES).expireAfterWrite(1, TimeUnit.HOURS).build(new CacheLoader<Long, Set<Long>>() {

                @Override
                public Set<Long> load(Long key) {
                    return buildAll();
                }

                @Override
                public ListenableFuture<Set<Long>> reload(final Long key, Set<Long> oldValue) {

                    ListenableFutureTask<Set<Long>> task = ListenableFutureTask.create(() -> load(key));
                    executorService.submit(task);
                    return task;
                }
            });

    @Override
    public Set<Long> getAllAdvertWhite() {
        return ADVERT_WHITE_CACHE.getUnchecked(key);
    }

    private Set<Long> buildAll() {

        List<Long> allWhite = advertWhiteDAO.selectAll();
        return CollectionUtils.isEmpty(allWhite) ? Collections.emptySet() : Sets.newHashSet(allWhite);
    }
}
