package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.cache.ServiceManager;
import cn.com.duiba.tuia.constants.CommonConstants;
import cn.com.duiba.tuia.dao.privilege.AppPrivilegeDAO;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.service.AppPrivilegeService;
import cn.com.tuia.advert.constants.SystemConfigKeyConstant;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年05月31日 10:43
 * @descript:
 * @version: 1.0
 */
@Service
public class AppPrivilegeServiceImpl implements AppPrivilegeService,InitializingBean {

    private final Logger logger = LoggerFactory.getLogger(AppPrivilegeServiceImpl.class);

    /**
     * 特权库缓存
     */
    private final Cache<String, Set<Long>> APP_PRIVILEGE_CACHE = CacheBuilder.newBuilder().initialCapacity(1000).
            recordStats().expireAfterWrite(1, TimeUnit.HOURS).build();

    private final String CACHE_KEY = "APP_PRIVILEGE_CACHE";

    @Autowired
    private AppPrivilegeDAO appPrivilegeDAO;

    @Autowired
    private ServiceManager serviceManager;


    @Override
    public Set<Long> getAppPrivileges() {
        try {
            return APP_PRIVILEGE_CACHE.get(CACHE_KEY, new Callable<Set<Long>>() {
                @Override
                public Set<Long> call() throws Exception {
                    return Sets.newConcurrentHashSet(appPrivilegeDAO.selectAllPrivileges());
                }
            });
        } catch (ExecutionException e) {
            logger.error("获取App特权库列表异常", e);
        }

        return Collections.emptySet();
    }

    @Override
    public void updateAppPrivilege() {

        APP_PRIVILEGE_CACHE.invalidate(CACHE_KEY);
        this.getAppPrivileges();
    }

    @Override
    public boolean isAppPrivilege(Long appId) {
        try {
            String isAppPrivilege = serviceManager.getStrValue(SystemConfigKeyConstant.APP_PRIVILEGE_ALL);
            return StringUtils.equals(CommonConstants.OPEN_ALL_APP_PRIVILEGE, isAppPrivilege) || getAppPrivileges().contains(appId);
        } catch (TuiaException e) {
            logger.error("AppPrivilegeServiceImpl.isAppPrivilege error! appId = [{}]", appId, e);
            return false;
        }
    }



    @Override
    public void afterPropertiesSet() throws Exception {
        this.getAppPrivileges();
    }
}
