package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DeviceTagDto;
import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.boot.utils.WarningUtils;
import cn.com.duiba.geo.api.dto.AdministrativeDivisionDto;
import cn.com.duiba.geo.api.dto.IpAreaDto;
import cn.com.duiba.geo.api.dto.IpGeoInfoDto;
import cn.com.duiba.geo.api.params.IpGeoInfoParams;
import cn.com.duiba.geo.api.remoteservice.RemoteAdministrativeDivisionService;
import cn.com.duiba.geo.api.remoteservice.RemoteIpAreaService;
import cn.com.duiba.tuia.bo.AdvertService;
import cn.com.duiba.tuia.cache.AdvertMapCacheManager;
import cn.com.duiba.tuia.cache.BaseCacheService;
import cn.com.duiba.tuia.constants.AdvertDirectionalConstant;
import cn.com.duiba.tuia.constants.AdvertReqLogExtKeyConstant;
import cn.com.duiba.tuia.dao.account.AccountCompanySwitchRecordDAO;
import cn.com.duiba.tuia.dao.account.AccountDAO;
import cn.com.duiba.tuia.dao.account.AccountFinanceDAO;
import cn.com.duiba.tuia.dao.advert.AdvertConsumeDAO;
import cn.com.duiba.tuia.dao.advert.AdvertDAO;
import cn.com.duiba.tuia.dao.ip_library.IpLibraryDAO;
import cn.com.duiba.tuia.domain.dataobject.AccountAccountCompanySwitchRecordDO;
import cn.com.duiba.tuia.domain.dataobject.AccountDO;
import cn.com.duiba.tuia.domain.dataobject.AccountFinanceDO;
import cn.com.duiba.tuia.domain.dataobject.AdvertDO;
import cn.com.duiba.tuia.domain.dataobject.IpLibraryDO;
import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.domain.vo.AdvertVO;
import cn.com.duiba.tuia.enums.CatGroupEnum;
import cn.com.duiba.tuia.enums.GeoOrDmpEnum;
import cn.com.duiba.tuia.enums.OperatorsEnum;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.service.AccountFinanceService;
import cn.com.duiba.tuia.service.AdvertRealDataService;
import cn.com.duiba.tuia.service.CommonService;
import cn.com.duiba.tuia.service.PhoneLibraryService;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.tuia.advert.enums.AccountBalanceEffectTypeEnum;
import cn.com.tuia.advert.enums.AppFlowOS;
import cn.com.tuia.advert.enums.CurrentMainStatusEnum;
import com.alibaba.fastjson.JSON;
import com.dianping.cat.Cat;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年08月02日 11:54
 * @descript:
 * @version: 1.0
 */
@RefreshScope
@Service
public class CommonServiceImpl implements CommonService {

    private static final String BRAND_OTHER = "其他";

    private static final String BRAND_APPLE = "苹果";

    private static final String APPLE_MODEL = "IPHONE";

    /** 海外城市的区划码，目前用999*/
    private static final String INTERNATIONAL_CITY = "999";

    /** 其他城市的区划码，目前用0 */
    private static final String OTHER_CITY = "0";

    /** 百川游戏标签碰撞请求失败 或者没有 请求百川平台*/
    public static  final  String BAICHUAN_GAME_TAG = "2";

    private static final Logger logger = LoggerFactory.getLogger(CommonServiceImpl.class);

    private static final String SEMICOLON = ";";

    private static final String ZH_CN = "zh_cn\\)";

    /** 直辖市和港澳地区的编码 */
    private static final Set<Integer> MUNICIPALITIES_SPECIAL_AREA_CODE = Sets.newHashSet(11, 12, 31, 50, 81, 82,83);

    @Resource
    private AccountFinanceDAO accountFinanceDAO;

    @Autowired
    private AccountDAO accountDAO;

    @Resource
    private AdvertConsumeDAO advertConsumeDAO;

    @Resource
    private AdvertService advertService;

    @Resource
    private IpLibraryDAO ipLibraryDAO;

    @Resource(name = "PhoneLibraryServiceProxyImpl")
    private PhoneLibraryService phoneLibraryService;

    @Autowired
    private AdvertRealDataService advertRealDataService;

    @Resource
    private RemoteIpAreaService remoteIpAreaService;

    @Resource
    protected StringRedisTemplate stringRedisTemplate;

    @Autowired
    private  CatMonitorWarnThreshold catMonitorWarnThreshold;
    @Autowired
    private AccountFinanceService accountFinanceService;
	@Autowired
	private AccountCompanySwitchRecordDAO accountCompanySwitchRecordDAO;

    @Autowired
    private AdvertDAO advertDAO;

    @Autowired
    private BaseCacheService baseCacheService;

    @Autowired
    private RemoteAdministrativeDivisionService remoteAdministrativeDivisionService;

    //经纬度hash  黑名单列表，多个用,隔开
    @Value("${engine.black.geohash:7zzzzzz}")
    private String blackGeoHashs;

    @Override
    public boolean isEnoughBudget(AdvertVO advertVO, Long fee) throws TuiaException {
        //0.免费有效点击不判断帐户
        if(fee.equals(0L)){
            return true;
        }

        AdvertPlan advertPlan = advertVO.getAdvertPlan();
        Long advertId = advertPlan.getId();
        Long accountId = advertPlan.getAccountId();
        Long advertPlanId = advertPlan.getAdvertPlanId();

        //1.查询广告主帐号
        AccountFinanceDO accountFinanceDO = accountFinanceDAO.getBankByAccountId(accountId);
        //获取billing还没有消费的余额
        Long totalBalance = advertRealDataService.incrTuiaAccountBalance(accountId, fee);
        //广告主信息
        AccountDO accountDO = accountDAO.selectAccountById(accountFinanceDO.getAccountId());
        if(Objects.isNull(accountDO)){
        	logger.error("account can not be null,accountId:{}",accountFinanceDO.getAccountId());
        	return false;
		}
        //检验账户余额
        boolean isBalanceEnough = accountBalanceCheck(accountDO,accountFinanceDO, advertVO, totalBalance);
        advertVO.setEffectMainType(CurrentMainStatusEnum.ORIGINAL_MAIN_TYPE_CHANGING_STATUS.getStatus().equals(advertVO.getCurrentMainStatus()) ? accountDO.getPreCompanyOwner() : accountDO.getCompanyOwner() );
        //2.当前帐号余额不够此次计费，则直接返回
        if (!isBalanceEnough) {
            advertRealDataService.incrTuiaAccountBalance(accountId, -fee);
            advertService.updateAdvert(advertId, AdvertDO.INVALID_BALANCE_NOT_ENOUGH);
            return false;
        }

        String today = new DateTime().toString("yyyy-MM-dd");
        //账户的预算防止有消息积压时多扣钱，如果在billing扣费失败会回滚
        Long totalAcConsume = advertRealDataService.incrTuiaAccountConsumeFee(accountId, fee);
        //3.判断账号剩余预算不够此次计费，则直接返回
        if (accountFinanceDO.getBudgetPerDay() != null) {
            //3.1 查询广告数据库真实消费
            Long todayConsume = advertConsumeDAO.getTotalFeeByAccountId(accountId, today);
            Long surplusTodayBudget = Math.min(accountFinanceDO.getBudgetPerDay() - todayConsume,
                                               accountFinanceDO.getBudgetPerDay() - (totalAcConsume - fee));

            if (surplusTodayBudget < fee) {
                advertRealDataService.incrTuiaAccountBalance(accountId, -fee);
                advertRealDataService.incrTuiaAccountConsumeFee(accountId, -fee);
                // 把广告置为帐号预算不足状态， 防止继续发券
                advertService.updateAdvert(advertId, AdvertDO.INVALID_BALANCE_BUDGET_SHORTFALL);
                logger.info("accountBalanceCheck account have not today budget, accountId:{},budgetPerDay:{}, totalAcConsume:{},todayConsume:{},fee:{}",
                        accountDO.getId(), accountFinanceDO.getBudgetPerDay(), totalAcConsume, todayConsume, fee);
                return false;
            }
        }
        //广告预算防止有消息积压时多扣钱，如果在billing扣费失败会回滚
        Long totalAdConsume = advertRealDataService.incrTuiaAdvertConsumeFee(advertId, fee);
        Long totalAdPlanConsume = advertRealDataService.incrTuiaAdvertPlanConsumeFee(advertPlanId, fee);

        //4.判断广告剩余预算不够此次计费，则直接返回
        if (advertPlan.getBudgetPerDay() != null) {

            Long todayConsume = 0L;
            Long totalCurrConsume = 0L;
            //4.1查询数据库广告真实消费
            if(advertPlanId !=-1){
                todayConsume =  advertConsumeDAO.getTodayConsumeByAdvertPlanId(advertPlanId,today);
                totalCurrConsume = totalAdPlanConsume;
            }else {
                todayConsume = advertConsumeDAO.getTodayConsumeByAdvertId(advertId, today);
                totalCurrConsume = totalAdConsume;
            }


            Long surplusTodayBudget = Math.min(advertPlan.getBudgetPerDay() - todayConsume,
                    advertPlan.getBudgetPerDay() - (totalCurrConsume - fee));

            if (surplusTodayBudget < fee) {
                advertRealDataService.incrTuiaAccountBalance(accountId, -fee);
                advertRealDataService.incrTuiaAccountConsumeFee(accountId, -fee);
                advertRealDataService.incrTuiaAdvertConsumeFee(advertId, -fee);
                advertRealDataService.incrTuiaAdvertPlanConsumeFee(advertPlanId, -fee);
                // 把广告置为广告预算不足状态， 防止继续发券
                advertService.updateAdvert(advertId, AdvertDO.INVALID_ADVERT_BUDGET_SHORTFALL);
                logger.info("advert have not today budget, advertId:{}，advertPlanId, budgetPerDay:{}, totalCurrConsume:{}, todayConsume:{},surplusTodayBudget:{} fee:{}",
                        advertId, advertPlanId, advertPlan.getBudgetPerDay(), totalCurrConsume, todayConsume, surplusTodayBudget, fee);
                return false;
            }
        }

        return true;
    }

    private boolean accountBalanceCheck(AccountDO accountDO, AccountFinanceDO accountFinance, AdvertVO advertVO, Long totalBalance) throws TuiaException{
		CurrentMainStatusEnum currentMainStatusEnum = CurrentMainStatusEnum.getByStatus(accountDO.getCurrentMainStatus());
		Long oldCurrentBalance;
		Long newCurrentBalance;
		advertVO.setCurrentMainStatus(currentMainStatusEnum.getStatus());
		switch (currentMainStatusEnum) {
			//没有发生过主体切换-取当前主体余额
			case ORIGINAL_MAIN_TYPE_STATUS:
				oldCurrentBalance = accountFinanceService.fetchAccountMainTypBalance(accountFinance, accountDO.getCompanyOwner());
				logger.info("accountBalanceCheck accountId:{},无主体变更信息,主体:{},余额:{},totalBalance:{}",accountDO.getId(),accountDO.getCompanyOwner(),oldCurrentBalance, totalBalance);
				return oldCurrentBalance >= totalBalance;
			//处于变更主体中间状态-老主体不够扣则进行主体切换，取新主体余额
			case ORIGINAL_MAIN_TYPE_CHANGING_STATUS:
				oldCurrentBalance = accountFinanceService.fetchAccountMainTypBalance(accountFinance, accountDO.getPreCompanyOwner());
				if (oldCurrentBalance >= totalBalance) {
					logger.info("accountBalanceCheck accountId:{},中间态,主体:{},余额:{},totalBalance:{}",accountDO.getId(),accountDO.getCompanyOwner(),oldCurrentBalance, totalBalance);
					return true;
				}
                newCurrentBalance = accountFinanceService.fetchAccountMainTypBalance(accountFinance, accountDO.getCompanyOwner());
                logger.info("accountBalanceCheck accountId:{},中间态,主体:{},余额:{},totalBalance:{}",accountDO.getId(),accountDO.getCompanyOwner(),newCurrentBalance, totalBalance);
                //变更主体
                douUpdateRecordMainType(accountDO,advertVO);
                advertVO.setCurrentMainStatus(CurrentMainStatusEnum.CURRENT_MAIN_TYPE_CHANGE_SUCCESS_STATUS.getStatus());
                advertService.updateAdvert(advertVO.getAdvertPlan().getId());
                return newCurrentBalance >= totalBalance;
            //处于已经切换主体成功状态-取新主体余额
			case CURRENT_MAIN_TYPE_CHANGE_SUCCESS_STATUS:
				newCurrentBalance = accountFinanceService.fetchAccountMainTypBalance(accountFinance, accountDO.getCompanyOwner());
				logger.info("accountBalanceCheck accountId:{},成功变更了主体信息,主体:{},余额:{},totalBalance:{}",accountDO.getId(),accountDO.getCompanyOwner(),newCurrentBalance, totalBalance);
				return newCurrentBalance >= totalBalance;
			default:
				return false;
		}
    }
	private void douUpdateRecordMainType(AccountDO accountDO, AdvertVO advertVO) throws TuiaException{
        //老主体余额不够扣则切换主体,更新条数为0则直接返回

        if(accountDAO.updateAccountMainType(accountDO.getId(),CurrentMainStatusEnum.CURRENT_MAIN_TYPE_CHANGE_SUCCESS_STATUS.getStatus()) == 0){
            logger.warn("commonServiceImpl  updateMainType error,accountDO:{}",accountDO);
            return;
        }
        // 刷新所有广告的消息
        List<AdvertDO> adverts = advertDAO.queryAccountValidAdvertIds(accountDO.getId());
        if (!CollectionUtils.isEmpty(adverts)) {
            Map<Integer, List<Long>> collectMap = adverts.stream().collect(Collectors.groupingBy(AdvertDO::getAdvertType, Collectors.collectingAndThen(Collectors.toList(), list1 -> list1.stream().map(AdvertDO::getId).collect(Collectors.toList()))));
            collectMap.forEach((advertType, advertIds) -> {
                baseCacheService.publishUpdateAdvertsMsg(advertIds, advertType);
            });
        }
        //切换记录
        AccountAccountCompanySwitchRecordDO switchRecordDO = new AccountAccountCompanySwitchRecordDO();
        switchRecordDO.setAccountId(accountDO.getId());
        switchRecordDO.setPreCompanyOwner(accountDO.getPreCompanyOwner());
        switchRecordDO.setCurCompanyOwner(accountDO.getCompanyOwner());
        switchRecordDO.setAgentId(accountDO.getAgentId());
        switchRecordDO.setAccountType(accountDO.getUserType());
        switchRecordDO.setBalanceEffectType(AccountBalanceEffectTypeEnum.ADVERTISE_CONSUME.getType());
        accountCompanySwitchRecordDAO.batchInsert(Collections.singletonList(switchRecordDO));

	}

    @Override
    public PhoneInfo getPhoneInfo(String ua, String userAgent) {
        try {
            DBTimeProfile.enter("getPhoneInfo");
            //手机价格
            String phoneLevel = "";
            //手机品牌 + 型号
            String phoneType = "";
            //手机品牌
            String phoneBrand = "";
            //手机型号
            String phoneModelNum = "";
            //品牌名称
            String brandName = "";

            //操作系统版本
            String osVersion = "";

            //ABTest新老设备库标识
            String equipmentType = "";

            if (StringUtils.equalsIgnoreCase("ios", ua)) {
                osVersion = AppFlowOS.getOsVersion(userAgent);
                return new PhoneInfo(AdvertDirectionalConstant.PHONE_LEVEL_IOS, APPLE_MODEL, BRAND_APPLE,osVersion);
            }
            if (StringUtils.isBlank(userAgent)) return new PhoneInfo(phoneLevel, null, BRAND_OTHER,osVersion);
            // 1.正则表达式（区分是否包含Build）
            if (!userAgent.contains("Build")) {
                return parseUserAgent(userAgent);
            }

            Pattern pattern = Pattern.compile("Android\\s\\S*(\\szh-cn;|\\szh-CN;)?\\s?((\\S*)\\s(\\S*\\s\\S*)|(\\w*)-(\\w*)|(\\S*)\\s(\\S*))\\sBuild/");
            Matcher matcher = pattern.matcher(userAgent);
            if(!matcher.find()){
                return new PhoneInfo(phoneLevel, phoneType, BRAND_OTHER,osVersion);
            }

            try {

                String matchPhoneType = matcher.group(2);
                //通过对历史数据分析，将解析出来的杂乱数据优化一下
                phoneType = parsePhoneType(matchPhoneType);
                PhoneCacheEntity phoneInfo = phoneLibraryService.getPhoneInfoCacheByType(phoneType);
                if (phoneInfo != null) {
                    equipmentType = phoneInfo.getEquipmentType();
                    phoneLevel = phoneInfo.getPhoneLevel();
                    brandName = phoneInfo.getBrandName();
                }

                if(matcher.group(0) !=null){
                    osVersion = matcher.group(0).split("; ")[0];
                }

                if (matcher.group(3) != null) {
                    phoneBrand = matcher.group(3);
                    phoneModelNum = matcher.group(4);
                }

                if (matcher.group(5) != null) {
                    phoneBrand = matcher.group(5);
                    phoneModelNum = matcher.group(6);
                }

                if (matcher.group(7) != null) {
                    phoneBrand = matcher.group(7);
                    phoneModelNum = matcher.group(8);
                }

                // 去除空格
                phoneBrand = phoneBrand.replaceAll("\\s", "");
                phoneModelNum = phoneModelNum.replaceAll("\\s", "");

            } catch (Exception e) {
                Cat.logError("获取手机价格区间异常,userAgent:" + userAgent, e.getCause());
                WarningUtils.markThresholdWarning("parsingUserAgentException", catMonitorWarnThreshold.getPhoneLevelExc());
                CatUtil.log(CatGroupEnum.CAT_107010.getCode());
            }

            return new PhoneInfo(phoneLevel, phoneType, phoneBrand, phoneModelNum, StringUtils.isBlank(brandName) ? BRAND_OTHER : brandName,StringUtils.isBlank(osVersion)? AppFlowOS.ANDROID.getNewDesc():osVersion, equipmentType);
        } finally {
            DBTimeProfile.release();
        }
    }

    /**
     *
     * ipGeoAnalysis:(调用geo接口解析ip). <br/>
     *
     * @author chencheng
     * @param ip
     * @return
     * @since JDK 1.8
     */
    @Override
    public AdvQueryParam ipGeoAnalysis(String ip) {
        try {
            DBTimeProfile.enter("ipGeoAnalysis");
            IpAreaDto ipAreaDto = remoteIpAreaService.findIpInfo(ip);
            // 1.校验是否可用
            if (checkGeoIpAreaDto(ipAreaDto)) {
                return geoIpAnalysisResult(ipAreaDto);
            }
            // 2.降级
            return ipAnalysisDegrading(ip);
        } catch (Exception e) {
            logger.error("geo find ip error，ip=[{}]", ip, e);
            return ipAnalysisDegrading(ip);
        } finally{
            DBTimeProfile.release();
        }

    }

    /**
     * ipGeoAnalysis:(调用geo接口解析ip). <br/>
     *
     * @param ip
     * @param ip        ip地址
     * @param ipAreaDto 活动传过来的geo查询结果
     * @param reqMap    相关的经纬度信息
     * @return
     * @author chencheng
     * @since JDK 1.8
     */
    @Override
    public AdvQueryParam ipGeoAnalysis(String ip, IpAreaDto ipAreaDto, Map<String, String> reqMap, String deviceId, boolean activityPriorityCondition, DeviceTagDto deviceTagDto, FilterResult filterResult) {

        try {
            DBTimeProfile.enter("ipGeoAnalysis");

            //第一优先级（使用活动传过来的数据）--> 1.优先拿活动传过来的值，校验是否可用
            if (activityPriorityCondition) {
                return geoIpAnalysisResult(ipAreaDto);
            }

            Map<String, String> resultMap = Optional.ofNullable(reqMap).orElse(new HashMap<>());
            String geohash = resultMap.get(AdvertReqLogExtKeyConstant.GEOHASH);

            //第二/三/四优先级 --> 2.调用geo和dmp获取结果
            IpGeoInfoDto ipGeoInfoDto = getAddressInfoByGeoAndDmp(ip, geohash, isMeetGeoHashCondition(resultMap, ipAreaDto), deviceTagDto, filterResult);
            if (checkIpGeoInfoDto(ipGeoInfoDto)) {
                return geoIpAnalysisResult(ip, ipGeoInfoDto);
            }

            //降级方案 --> 3.不能通过geo接口解析，走降级查询
            return ipAnalysisDegrading(ip);
        } catch (Exception e) {
            logger.error("geo find ip error，ip=[{}]", ip, e);
            return ipAnalysisDegrading(ip);
        } finally {
            DBTimeProfile.release();
        }

    }


    private IpGeoInfoDto getAddressInfoByGeoAndDmp(String ip, String geohash, boolean geoHashCondition, DeviceTagDto deviceTagDto,FilterResult filterResult) {

        IpGeoInfoParams params = new IpGeoInfoParams();
        params.setIp(ip);

        if (geoHashCondition) {
            params.setGeoHash(geohash);
        }
        //这一步必然调用 因为即使dmp返回了地理位置 也需要将运营商等信息进行返回
        IpGeoInfoDto ipGeoInfoDto =  remoteIpAreaService.findIpGeoInfo(params);
        filterResult.setGeoRegion(JSON.toJSONString(ipGeoInfoDto));
        filterResult.setRegionUseDmpOrGeo(GeoOrDmpEnum.GEO.getCode());

        //第二优先级（geo数组满足条件即返回）--> 如果经纬度参数满足条件 结果直接返回
        if (geoHashCondition && checkIpGeoInfoDto(ipGeoInfoDto)) {
            return ipGeoInfoDto;
        }

        //第三优先级（如果dmp查到了相关的值 则对里面的值进行覆盖）--> 设置地理位置信息
        Optional.ofNullable(deviceTagDto).flatMap(tempDeviceTagDto -> Optional.ofNullable(tempDeviceTagDto.getRegionInfoTags())).ifPresent(regionInfoTags ->
        {
                List<String> acNames = new ArrayList<>(4);
                acNames.add(StringUtils.EMPTY);
                Optional.ofNullable(regionInfoTags.getProvince()).ifPresent(acNames::add);
                Optional.ofNullable(regionInfoTags.getCity()).ifPresent(acNames::add);
                Optional.ofNullable(regionInfoTags.getArea()).ifPresent(acNames::add);
                ipGeoInfoDto.setAcNames(acNames);
                ipGeoInfoDto.setAdCode(regionInfoTags.getAdCode());
                filterResult.setRegionUseDmpOrGeo(GeoOrDmpEnum.DMP.getCode());
        });

        //第四优先级--> 根据经纬度没有查到主要信息并且dmp没有包含数据信息（就是根据IP查询到的地理位置信息）
        return ipGeoInfoDto;

    }

    /**
     * 如果线上出现问题，通过开关调用 老的ip解析接口
     *
     * @param ip
     * @return
     */
    private AdvQueryParam getOldIpGeoAnalysis(String ip) {
        // 2.活动解析无结果或者没有传过来，再调用geo接口查询一次。校验是否可用
        IpAreaDto newIpAreaDto = remoteIpAreaService.findIpInfo(ip);
        if (checkGeoIpAreaDto(newIpAreaDto)) {
            return geoIpAnalysisResult(newIpAreaDto);
        }
        // 3.不能通过geo接口解析，走降级查询
        return ipAnalysisDegrading(ip);
    }

    @Override
    public AdvQueryParam ipOrCityIdGeoAnalysis(String ip, String cityId, Integer typeGeo, Map<String, String> reqMap, boolean meetGeoHashCondition, DeviceTagDto deviceTagDto,FilterResult filterResult) {
        if (typeGeo == null || typeGeo == 1) {
            return ipGeoAnalysis(ip, null, reqMap,null, meetGeoHashCondition, deviceTagDto,filterResult);
        } else {
            return cityIdGeoAnalysis(cityId);
        }
    }

    @Override
    public boolean isMeetActivityPriorityCondition(Map<String, String> logExtMap, IpAreaDto ipAreaDto) {

        //不在黑名单中 才满足条件
        return isMeetGeoHashCondition(logExtMap, ipAreaDto) && checkGeoIpAreaDto(ipAreaDto);
    }

    @Override
    public boolean isMeetGeoHashCondition(Map<String, String> logExtMap, IpAreaDto ipAreaDto) {
        if(logExtMap == null){
            return false;
        }

        //从extMap中获取geo参数
        String geohash = logExtMap.get(AdvertReqLogExtKeyConstant.GEOHASH);

        //如果geo参数本身为空则不满足
        if (StringUtils.isBlank(geohash)) {
            return false;
        }

        //黑名单列表
        List<String> geohashs = Lists.newArrayList(blackGeoHashs.split(","));

        return !geohashs.contains(geohash) ;
    }

    /**
     * 根据城市编码解析成省份，城市等
     *
     * @param cityId
     * @return
     */
    private AdvQueryParam cityIdGeoAnalysis(String cityId) {
        try {
            DBTimeProfile.enter("cityIdGeoAnalysis");

            AdvQueryParam advQueryParam = new AdvQueryParam();
            // 如果传过来的城市编码为空字符串，则代码国外城市。
            if (cityId.equals("")) {
                advQueryParam.setRegionId(INTERNATIONAL_CITY);
                advQueryParam.setOperators(OperatorsEnum.OTHER.getCode().toString());
                return advQueryParam;
            }

            List<AdministrativeDivisionDto> administrativeDivisionByCode = remoteAdministrativeDivisionService.findAdministrativeDivisionByCode(cityId);

            // 因为没用Apache的工具类，所以没用正表达
            if (!CollectionUtils.isEmpty(administrativeDivisionByCode)) {
                Map<Integer, String> areaMap = Maps.newHashMapWithExpectedSize(administrativeDivisionByCode.size());
                administrativeDivisionByCode.forEach(cityCode -> areaMap.put(cityCode.getLevel(), cityCode.getName()));

                advQueryParam.setProvince(areaMap.get(1));
                advQueryParam.setCity(Optional.ofNullable(areaMap.get(2)).orElse(areaMap.get(1)));
                advQueryParam.setRegionId(transformJustCityCode(Integer.parseInt(cityId)));
                advQueryParam.setOperators(OperatorsEnum.OTHER.getCode().toString());

                return advQueryParam;

            }

            // 2.如果通过城市ID，获取不到城市，则降级
            return buildOtherCity(new AdvQueryParam());
        } catch (Exception e) {
            logger.error("cityIdGeoAnalysis error，cityId=[{}]", cityId, e);
            return buildOtherCity(new AdvQueryParam());
        } finally {
            DBTimeProfile.release();
        }
    }

    /**
     * geo接口返回结果校验。
     *
     * @param ipAreaDto
     * @return 调geo接口返回对象不为空，国内的区划码和运营商不为空
     */
    private boolean checkGeoIpAreaDto(IpAreaDto ipAreaDto) {
        return null != ipAreaDto && StringUtils.isNotBlank(ipAreaDto.getCityCode()) && StringUtils.isNotBlank(ipAreaDto.getIsp());
    }

    /**
     * geo接口返回结果校验。
     *
     * @param ipGeoInfoDto
     * @return 调geo接口返回对象不为空，国内的区划码和运营商不为空
     */
    private boolean checkIpGeoInfoDto(IpGeoInfoDto ipGeoInfoDto) {
        return null != ipGeoInfoDto && StringUtils.isNotBlank(ipGeoInfoDto.getAdCode()) && StringUtils.isNotBlank(ipGeoInfoDto.getIsp());
    }

    /**
     * geo返回的ip解析参数构建过滤请求结果
     *
     * @param ipAreaDto
     * @return
     */
    private AdvQueryParam geoIpAnalysisResult(IpAreaDto ipAreaDto) {
        //参数封装
        AdvQueryParam advQueryParam = new AdvQueryParam();
        //1.省份
        advQueryParam.setProvince(ipAreaDto.getRegion());
        //2.运营商
        advQueryParam.setOperators(OperatorsEnum.getByEqualsName(ipAreaDto.getIsp()).getCode().toString());
        //3.局域网,设置为其它
        if (ipAreaDto.getLanIp()) {
            advQueryParam.setRegionId(OTHER_CITY);
            return advQueryParam;
        }
        //4.海外的城市
        if (null != ipAreaDto.getInternational() && ipAreaDto.getInternational()) {
            advQueryParam.setRegionId(INTERNATIONAL_CITY);
            return advQueryParam;
        }
        //5.城市区划码
        advQueryParam.setRegionId(transformJustCityCode(Integer.parseInt(ipAreaDto.getCityCode())));
        //6.城市
        advQueryParam.setCity(ipAreaDto.getCity());
        return advQueryParam;
    }

    /**
     * geo返回的ip解析参数构建过滤请求结果
     *
     * @param ipGeoInfoDto
     * @return
     */
    private AdvQueryParam geoIpAnalysisResult(String ip, IpGeoInfoDto ipGeoInfoDto) {
        //参数封装
        AdvQueryParam advQueryParam = new AdvQueryParam();
        //按照国家，地区，城市，区县，乡镇 排列
        List<String> names = Optional.ofNullable(ipGeoInfoDto.getAcNames()).orElse(Lists.newArrayList());
        //1.省份
        advQueryParam.setProvince("");
        if (names.size() > 1) {
            advQueryParam.setProvince(names.get(1));
        }

        //2.运营商
        advQueryParam.setOperators(OperatorsEnum.getByEqualsName(ipGeoInfoDto.getIsp()).getCode().toString());
        //3.局域网,设置为其它
        if (NetUtils.isLanIp(ip)) {
            advQueryParam.setRegionId(OTHER_CITY);
            return advQueryParam;
        }
        //4.海外的城市
        if (null != ipGeoInfoDto.getInternational() && ipGeoInfoDto.getInternational()) {
            advQueryParam.setRegionId(INTERNATIONAL_CITY);
            return advQueryParam;
        }
        //5.城市区划码
        advQueryParam.setRegionId(transformJustCityCode(Integer.parseInt(ipGeoInfoDto.getAdCode())));
        //6.城市 如果是直辖市 特殊处理获取城市
        advQueryParam.setCity("");
        //城市码两位是直辖市  如果是直辖市   省份数据是城市
        if (advQueryParam.getRegionId().length() == 2 && names.size() > 1) {
            advQueryParam.setCity(names.get(1));
        }
        //如果不是直辖市，并且地址数据有城市数据
        if (advQueryParam.getRegionId().length() > 2 && names.size() > 2) {
            advQueryParam.setCity(names.get(2));
        }

        return advQueryParam;
    }

    /**
     * ipAnalysisDegrading:(IP解析降级，打cat日志，本地查询). <br/>
     *
     * @param ip
     * @return
     * @author chencheng
     * @since JDK 1.8
     */
    private AdvQueryParam ipAnalysisDegrading(String ip) {
        try {
            DBTimeProfile.enter("ipAnalysisDegrading");
            //1.打印降级到本地ip解析的量
            CatUtil.catLog(CatGroupEnum.CAT_105001.getCode());
            WarningUtils.markThresholdWarning("ipAnalysisDegrading", catMonitorWarnThreshold.getIpDegrade());
            AdvQueryParam advQueryParam = getCacheCityId(ip);
            //2.降级到本地ip解析后依然查询不到的量
            if (null == advQueryParam.getRegionId() || OTHER_CITY.equals(advQueryParam.getRegionId())) {
                CatUtil.catLog(CatGroupEnum.CAT_105002.getCode());
            }
            return advQueryParam;
        } finally {
            DBTimeProfile.release();
        }
    }

    /**
     * getCacheCityId:(本地解析ip). <br/>
     *
     * @param ip
     * @return
     * @author chencheng
     * @since JDK 1.8
     */
    private AdvQueryParam getCacheCityId(String ip) {
        AdvQueryParam advQueryParam = new AdvQueryParam();
        try {
            //判断是否ipv4
            if (StringUtils.isNotBlank(ip) && ip.indexOf(".") < 0) {
                return buildOtherCity(advQueryParam);
            }
            Long ipLong = IpLibraryDO.convertIpLong(ip);
            IpLibraryDO ipLibraryDO = ipLibraryDAO.findByIpLong(ipLong);
            if (ipLibraryDO == null) {
                //根据ip查询城市无结果
                return buildOtherCity(advQueryParam);
            }
            // 城市区划码
            advQueryParam.setRegionId(transformJustCityCode(ipLibraryDO.getAreaCode()));
            // 运营商
            advQueryParam.setOperators(String.valueOf(OperatorsEnum.getByName(ipLibraryDO.getIsp()).getCode()));
            // 省份
            advQueryParam.setProvince(ipLibraryDO.getProvince());
            // 城市
            advQueryParam.setCity(ipLibraryDO.getCity());
            return advQueryParam;
        } catch (Exception e) {
            //异常后，返回其他城市
            logger.error("get ip Library error, ip=[{}]", ip, e);
            return buildOtherCity(advQueryParam);
        }
    }

    /**
     * buildOtherCity:(根据ip查询城市无结果). <br/>
     *
     * @param advQueryParam
     * @return
     * @author chencheng
     * @since JDK 1.8
     */
    private AdvQueryParam buildOtherCity(AdvQueryParam advQueryParam) {
        CatUtil.catLog(CatGroupEnum.CAT_105003.getCode());
        advQueryParam.setRegionId(OTHER_CITY);
        advQueryParam.setOperators(OperatorsEnum.getByName(null).getCode().toString());
        return advQueryParam;
    }

    /**
     * TransformCityCode:(区划码转换). <br/>
     *
     * @param areaCode
     * @return
     * @author chencheng
     * @since JDK 1.8
     */
    private String transformCityCode(Integer areaCode) {
        if (null == areaCode) {
            return OTHER_CITY;
        }
        int cityId;
        // 直辖市的情况
        if (areaCode % 10000 == 0) {
            cityId = areaCode / 10000;
            if (!MUNICIPALITIES_SPECIAL_AREA_CODE.contains(cityId)) {
                // 只解析到省级的行政区代码的话，cityId设置成"其他"
                cityId = cityId * 100 + 99;
            }

        } else {
            cityId = areaCode / 100;
        }
        return String.valueOf(cityId);
    }

    /**
     * 当只有城市ID的时候，做处理
     *
     * @param areaCode
     * @return
     */
    private String transformJustCityCode(Integer areaCode) {
        if (null == areaCode) {
            return OTHER_CITY;
        }

        // 直辖市
        int municipality = Integer.parseInt(areaCode.toString().substring(0, 2));

        if (MUNICIPALITIES_SPECIAL_AREA_CODE.contains(municipality)) {
            return String.valueOf(municipality);
        }

        int cityId;
        // 不是直辖市，如果是230000, 则返回2399，则23这个省的其他
        if (areaCode % 10000 == 0) {
            cityId = areaCode / 100 + 99;
            return String.valueOf(cityId);
        }
        String val = areaCode.toString();
        //如果城市码不足四位
        if (val.length() < 4) {
            return OTHER_CITY;
        }
        //获取精确到城市的编码
        val = val.substring(0, 4);
        return val;
    }


    private static String parsePhoneType(String matchPhoneType) {
        if (StringUtils.isBlank(matchPhoneType)) {
            return matchPhoneType;
        }
        if (matchPhoneType.contains(SEMICOLON)) {
            String[] split = matchPhoneType.split(SEMICOLON);
            String phoneType = "";
            if (split.length == 1) {
                phoneType = split[0];
            }
            if (split.length >= 2) {
                phoneType = split[1];
            }
            return phoneType.replaceAll(SEMICOLON, StringUtils.EMPTY).replaceAll(ZH_CN, StringUtils.EMPTY).trim();
        }
        return matchPhoneType.replaceAll(ZH_CN, StringUtils.EMPTY).trim();
    }

    /**
     * 解析不带 Build 的 UserAgent
     */
    private PhoneInfo parseUserAgent(String userAgent) {
        // 手机价格
        String phoneLevel = "";
        // 手机品牌 + 型号
        String phoneType = "";
        // 手机品牌
        String phoneBrand = "";
        // 手机型号
        String phoneModelNum = "";
        // 品牌名称
        String brandName = "";
        // 操作系统版本
        String osVersion = "";
        // ABTest新老设备库标识
        String equipmentType = "";

        Pattern pattern = Pattern.compile("Android\\s\\S*(\\szh-cn;|\\szh-CN;)?\\s?((\\S*)\\s(\\S*\\s\\S*)|(\\w*)-(\\w*)|(\\S*)\\s(\\S*));");
        Matcher matcher = pattern.matcher(userAgent);
        if (!matcher.find()) {
            return new PhoneInfo(phoneLevel, phoneType, BRAND_OTHER, osVersion);
        }

        try {
            String matchPhoneType = matcher.group(2);
            //通过对历史数据分析，将解析出来的杂乱数据优化一下
            phoneType = parsePhoneType(matchPhoneType);
            PhoneCacheEntity phoneInfo = phoneLibraryService.getPhoneInfoCacheByType(phoneType);
            if (phoneInfo != null) {
                equipmentType = phoneInfo.getEquipmentType();
                phoneLevel = phoneInfo.getPhoneLevel();
                brandName = phoneInfo.getBrandName();
            }

            if (matcher.group(0) != null) {
                osVersion = matcher.group(0).split("; ")[0];
            }

            if (matcher.group(5) != null) {
                phoneBrand = matcher.group(5);
                phoneModelNum = matcher.group(6);
            }

            // 去除空格
            phoneBrand = phoneBrand.replaceAll("\\s", "");
            phoneModelNum = phoneModelNum.replaceAll("\\s", "");

        } catch (Exception e) {
            Cat.logError("获取手机价格区间异常,userAgent:" + userAgent, e.getCause());
            WarningUtils.markThresholdWarning("parsingUserAgentException", catMonitorWarnThreshold.getPhoneLevelExc());
            CatUtil.log(CatGroupEnum.CAT_107010.getCode());
        }

        return new PhoneInfo(phoneLevel, phoneType, phoneBrand, phoneModelNum,
                StringUtils.isBlank(brandName) ? BRAND_OTHER : brandName,
                StringUtils.isBlank(osVersion) ? AppFlowOS.ANDROID.getNewDesc() : osVersion,
                equipmentType);
    }
}
