/**
 * Project Name:engine-service
 * File Name:ConsumerRecordServiceImpl.java
 * Package Name:cn.com.duiba.tuia.service.impl
 * Date:2017年5月12日下午2:07:32
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.dao.engine.ConsumerRecordDAO;
import cn.com.duiba.tuia.domain.dataobject.AdvertOrderDO;
import cn.com.duiba.tuia.domain.dataobject.ConsumerInteractiveRecordDO;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.duiba.tuia.domain.vo.ConsumerRecordJsonVO;
import cn.com.duiba.tuia.domain.vo.OrderJsonVO;
import cn.com.duiba.tuia.service.ConsumerRecordSerivce;
import cn.com.duiba.tuia.utils.RecordTimeUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.tuia.advert.enums.AdvertTypeEnum;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
/**
 * ClassName:ConsumerRecordServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2017年5月12日 下午2:07:32 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class ConsumerRecordServiceImpl implements ConsumerRecordSerivce{

    private static Logger log = LoggerFactory.getLogger(ConsumerRecordServiceImpl.class);
   
    @Autowired
    private ConsumerRecordDAO consumerRecordDAO;
    
    @Resource
    private ExecutorService executorService;

    @Override
    public Integer getTodayAcJoinTimes(List<ConsumerInteractiveRecordDO> consumerVOs, Long activityId) {
        if(CollectionUtils.isEmpty(consumerVOs)){
            return 0;
        }
        return (int)consumerVOs.stream().filter(vo -> vo.getActivityId().equals(activityId)).count();

    }


    @Override
    public List<Long> getHistoryJoinAdverts(List<ConsumerInteractiveRecordDO> consumerVOs, Integer days) {
        try{
            if(consumerVOs.isEmpty()){
                return Collections.emptyList();
            }
            List<Long> list = Lists.newArrayList();
            Date orderTime = RecordTimeUtils.getTodayMMdd(DateUtils.changeByDay(new Date(), ~days + 1));
            for(ConsumerInteractiveRecordDO vo : consumerVOs){
                if(orderTime.before(vo.getGmtCreate())){
                    list.add(vo.getAdvertId());
                }
            }
            return list;
        }catch(Exception e){
            log.error("",e);
        }
        return Collections.emptyList();
    }

    @Override
    public Map<Long, Integer> getHistoryAdvertTimsMysql(ObtainAdvertReq req, Integer days){
        if(null==req||null==req.getConsumerId()){
            return Collections.emptyMap();
        }
        Long consumerId = req.getConsumerId();
        try{
            Date orderTime = RecordTimeUtils.getTodayMMdd(DateUtils.changeByDay(new Date(), ~days + 1));
            // 该方法是可异步，而且有异步时间差的
            Map<Long, Integer> advertIdMap = CatUtils.executeInCatTransaction(() ->
                    consumerRecordDAO.selectAdvertIdNumGroup(consumerId, orderTime),"getConsumerRecord", "recordFromMysqlGroup");
            // used获取的是小周期之内的点击数
            if (CollectionUtil.isNotEmpty(advertIdMap)) {
                return advertIdMap;
            }
        }catch(Exception e){
            log.error("ConsumerRecordServiceImpl.getHistoryAdvertTimsMysql e：",e);
        }catch (Throwable throwable) {
            throwable.printStackTrace();
            return Collections.emptyMap();
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<Long, Integer> getHistoryAdvertTimes(ObtainAdvertReq req, Integer days, Map<String, Integer> allUserAdxMap) {
        if(null==req||null==req.getConsumerId()){
            return Collections.emptyMap();
        }
        try{
            //推啊广告对应的发券次数
            Map<Long, Integer> allUserTimesMap = new HashMap<>();
            Long consumerId = req.getConsumerId();
            Date orderTime = RecordTimeUtils.getTodayMMdd(DateUtils.changeByDay(new Date(), ~days + 1));
            // 该方法是可异步，而且有异步时间差的
            List<ConsumerInteractiveRecordDO> recordList = CatUtils.executeInCatTransaction(() ->
                    consumerRecordDAO.selectAdvertAndAccount(consumerId, orderTime),"selectAdvertAndAccount", "recordFromMysqlGroup");
            // 分别获取 推啊广告和dsp广告的发券次数
            if (CollectionUtils.isNotEmpty(recordList)) {
                for (ConsumerInteractiveRecordDO record : recordList) {
                    ConsumerRecordJsonVO vo = JSON.parseObject(record.getJson(), ConsumerRecordJsonVO.class);
                    if (vo != null && vo.getDspId() != null) {
                        String key = String.valueOf(vo.getDspId()) + ";" + String.valueOf(record.getAdvertId());
                        allUserAdxMap.put(key, Optional.ofNullable(allUserTimesMap.get(key)).orElse(0) + 1);
                    } else {
                        allUserTimesMap.put(record.getAdvertId(), Optional.ofNullable(allUserTimesMap.get(record.getAdvertId())).orElse(0) + 1);
                    }
                }
            }
            return allUserTimesMap;
        }catch(Exception e){
            log.error("ConsumerRecordServiceImpl.getHistoryAdvertTimsMysql e：",e);
        }catch (Throwable throwable) {
            throwable.printStackTrace();
            return  Collections.emptyMap();
        }
        return Collections.emptyMap();
    }


    @Override
    public Map<Long, Integer> getHistoryAdvertTims(List<ConsumerInteractiveRecordDO> consumerVOs, Integer days){
        try{
            if(consumerVOs.isEmpty()){
                return Collections.emptyMap();
            }
            Date orderTime = RecordTimeUtils.getTodayMMdd(DateUtils.changeByDay(new Date(), ~days + 1));
            Map<Long,Integer> used = Maps.newHashMap();
            for(ConsumerInteractiveRecordDO vo : consumerVOs){
                if(orderTime.before(vo.getGmtCreate())){
                    //排查dsp 可能的重复广告id
                    ConsumerRecordJsonVO json = JSON.parseObject(vo.getJson(), ConsumerRecordJsonVO.class);
                    if (vo != null && json.getDspId() != null) {
                        continue;
                    }
                    if (used.containsKey(vo.getAdvertId())) {
                        used.put(vo.getAdvertId(), used.get(vo.getAdvertId()) + 1);
                    } else {
                        used.put(vo.getAdvertId(), 1);
                    }
                }
            }
            return used;
        }catch(Exception e){
            log.error("",e);
        }
        return Collections.emptyMap();
    }

    @Override
    public Boolean isNewConsumer(List<ConsumerInteractiveRecordDO> consumerVOList) {
        try{
            if(consumerVOList.isEmpty()){
                return true;
            }
            boolean flag = true;
            Date todayMMdd = DateUtils.getDayDate(new Date());
            for(ConsumerInteractiveRecordDO vo : consumerVOList){
                if(!todayMMdd.equals(vo.getCurDate())){
                    flag = false;
                    break;
                }
            }
            return flag;
        }catch(Exception e){
            log.error("",e);
            return false;
        }
    }
    
    @Override
    public Set<String> getTags(List<ConsumerInteractiveRecordDO> consumerVOList,Integer times){
        Set<String> tags = Sets.newHashSet();
        if(consumerVOList.isEmpty()){
            return tags;
        }

        int i = 0;
        for(ConsumerInteractiveRecordDO vo : consumerVOList){
            if(StringUtils.isNotBlank(vo.getTags())){
                String[] tagArray = vo.getTags().split(",");
                tags.addAll(Arrays.asList(tagArray));
                i++;
            }
            if(i >= times){
                break;
            }
        }
        return tags;
    }


    
    /**
     * 异步执行用户数据记录
     * @author zp
     * @param materialId
     * @param order
     * @param tags
     * @since JDK 1.6
     */
    @Override
    public void addRecordReq(final AdvertOrderDO order,final String tags,Long materialId, Long accountId,
                             String limitAccountType, String slotDirection, FilterResult filterResult,
                             Boolean testPlanMaterial, OrderJsonVO vo){
        executorService.submit(new Runnable() {
            @Override
            public void run() {
                try{
                    addConsumerInteractiveRecord(order, tags, materialId, accountId, limitAccountType,
                            slotDirection, filterResult, testPlanMaterial, vo);
                }catch(Exception e){
                    log.error("ConsumerRecordServiceImpl.recordAdd advertId = [{}],ConsumerId = [{}]", order.getAdvertId(), order.getConsumerId(),e);
                }
            }

        });
    }

    private void addConsumerInteractiveRecord(AdvertOrderDO order, String tags,Long materialId, Long accountId,
                                              String limitAccountType, String slotDirection, FilterResult filterResult, Boolean testPlanMaterial, OrderJsonVO vo) {
        ConsumerInteractiveRecordDO record = new ConsumerInteractiveRecordDO();
        record.setAdvertId(order.getAdvertId());
        record.setAppId(order.getAppId());
        record.setConsumerId(order.getConsumerId());
        record.setCurDate(DateUtils.getDayDate(new Date()));
        record.setActivityId(order.getDuibaActivityId());
        record.setTags(tags);
        record.setGroupId(0L);
        record.setMaterialId(materialId);
        record.setAccountId(accountId);
        record.setLimitAccountType(limitAccountType);
        if(slotDirection != null){
            record.setDirectSolt(Integer.valueOf(slotDirection));
        }
        // json构建
        ConsumerRecordJsonVO jsonVO = new ConsumerRecordJsonVO();
        jsonVO.setRepeatLunchType(filterResult.getRepeatLunchType());
        jsonVO.setResourceTag(filterResult.getRepeatResourceTag());
        jsonVO.setTat(filterResult.getTradeAppLunchType());
        if (testPlanMaterial != null && testPlanMaterial) {
            jsonVO.setTmaId(1L);
        }

        Long randomServiceTag = null;
        try {
            randomServiceTag = filterResult.getRandomServiceTag();
        } catch (Exception e) {
            randomServiceTag = null;
            log.info("重复曝光优化日志",e);
        }

        jsonVO.setRandomServiceTag(randomServiceTag);

        // 添加广告类型
        jsonVO.setAdt(AdvertTypeEnum.HD_ADVERT_TYPE.getCode());
        jsonVO.setSlotId(order.getSlotId());
        Optional.ofNullable(vo).ifPresent(val->jsonVO.setDspId(val.getDspId()));
        record.setJson(JSON.toJSONString(jsonVO));
        consumerRecordDAO.addConsumerInteractiveRecord(record);

    }

}

