package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.cache.ServiceManager;
import cn.com.duiba.tuia.domain.vo.AdvertVO;
import cn.com.duiba.tuia.domain.vo.OrderJsonVO;
import cn.com.duiba.tuia.enums.CatGroupEnum;
import cn.com.duiba.tuia.log.LogConfig;
import cn.com.duiba.tuia.service.DataReportService;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.duiba.tuia.utils.SiginUtils;
import cn.com.duiba.tuia.utils.UrlParseUtils;
import cn.com.duiba.wolf.utils.UrlUtils;
import cn.com.duiba.wolf.utils.UrlUtils2;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import cn.com.tuia.advert.model.SpmlogReq;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Wangpf
 * @description
 * @date 2020/3/2 4:41 PM
 */
@Service
@Slf4j
public class DataReportServiceImpl implements DataReportService, InitializingBean {

    private static final Logger LOGGER = LoggerFactory.getLogger(DataReportServiceImpl.class);

    private static final String IS_ENCODE = "isEncode";

    private static final String IS_ENCODE_VALUE = "1";

    @Value("${tuia.report.taobao.channel:15}")
    public String channel;

    @Value("${tuia.report.taobao.adid:201905071753}")
    public String adid;

    @Value("${tuia.report.taobao.advertKey:A631483FF91C148E42395B0D9B5281DC}")
    public String advertKey;

    @Value("${tuia.report.taobao.callbackUrl:https://activity.tuiatest.cn/log/effect/v2}")
    private  String callbackUrl;

    @Autowired
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;

    @Autowired
    protected LogConfig logConfig;

    /**
     * advertKey
     */
    private static final String ADVERT_KEY = "advertKey";

    /**
     * 淘宝参数
     */
    private static final String CHANNEL = "channel";
    @Autowired
    private ServiceManager serviceManager;

    @Override
    public void reportShouTao(SpmlogReq req, AdvertVO advertVO,String promoteBackUserUrl) {
        String orderId = req.getActivityOrderId();
        String userIp = req.getIp();
        String userAgent = req.getUserAgent();

        doReportShouTao(promoteBackUserUrl,orderId,userIp,userAgent,req);
    }

    @Override
    public void reportStandard(SpmlogReq req,AdvertVO advertVO,OrderJsonVO vo,String promoteBackUserUrl) {
        doReportStandard(req,advertVO,vo,promoteBackUserUrl);
    }


    /**
     * 执行数据上报
     *
     * @param url 上报地址
     * @param orderId 订单ID
     * @param userIp 用户IP
     * @param userAgent ua
     * @param req 点击
     */
    private void doReportShouTao(String url,String orderId,String userIp,String userAgent,SpmlogReq req) {
        Map<String, String> logExtMap = req.getLogExtMap();
        Map<String,String> urlParam = new HashMap<>();


        if (!url.contains("adid=")) {
            urlParam.put("adid",adid);
        }
        String imeiMd5 = req.getDeviceId();

        if (StringUtils.isBlank(imeiMd5)) {
            LOGGER.warn("report to taobao, imeiMd5 is null; orderId:{},logExtMap:{}",orderId,JSON.toJSONString(logExtMap));
            return;
        }
        urlParam.put("imeiMd5",imeiMd5);

        String transformType = UrlParseUtils.findValueByKey(url, "transformType");
        if (StringUtils.isBlank(transformType)) {
            transformType = "2";//淘宝回调，固定值 2
            urlParam.put("transformType",transformType);
        }

        Map<String,String> paramMap = UrlParseUtils.uRLRequest(url);

        //获取新的advertKey
        String newAdvertKey = getNewAdvertKey(paramMap,advertKey);

        //获取新的url
        url = getNewUrl(paramMap,url);

        //获取新的channel
        String newChannel = getNewChannel(paramMap);

        //淘宝参数
        urlParam.put(CHANNEL,newChannel);

        //callbackUrl
        String callbackUrl = UrlUtils.appendParams(this.callbackUrl, ImmutableMap.<String, String>builder()
            .put("advertKey", newAdvertKey)
            .put("a_oId", orderId)
            .put("a_tuiaId", orderId)
            .put("sign", SiginUtils.genV1Sign(orderId))
            //.put("type", "8")
            .put("reportAdvert", "taobao")
            .put("transformType", transformType) //淘宝回调，固定值 2
            .build());
        urlParam.put("callbackUrl", URLEncoder.encode(callbackUrl));
        try {
            if(logConfig.getInfoEnable()){
                LOGGER.info("report to taobao start... url:{},urlParam:{}",url, urlParam);
            }
            String result = restTemplate.getForObject(UrlUtils.appendParams(url,urlParam),String.class);
            LOGGER.info("report result :{}",result);
            if (!StringUtils.equals(result,"\"success\"")) {
                throw new Exception(result);
            }

            CatUtil.log(CatGroupEnum.CAT_107014.getCode());
            CatUtil.log(CatGroupEnum.CAT_107015.getCode());
        } catch (Exception e) {
            LOGGER.warn("report to taobao error " ,e);
            CatUtil.log(CatGroupEnum.CAT_107016.getCode());
            CatUtil.log(CatGroupEnum.CAT_107017.getCode());
        }
    }
    private JSONObject jsonObject = null;
    // 启动时从数据表里加载配置
    @Override
    public void afterPropertiesSet() throws Exception {
        String strValue = serviceManager.getStrValue("tuia.url.back.macro.replace");
        jsonObject = JSON.parseObject(strValue);
    }
    @SuppressWarnings("squid:S3776")
    private void doReportStandard(SpmlogReq req,AdvertVO advertVO,OrderJsonVO vo,String promoteBackUserUrl) {
        Map<String, String> urlParamMap = new HashMap<>(8);

        Map<String, String> promoteBackUserUrlParam = UrlUtils2.extractUrlParamsFromUrl(promoteBackUserUrl);

        if (logConfig.getInfoEnable()) {
            LOGGER.info("doReportStandard advertId:{},promoteBackUserUrl:{}", req.getAdvertId(), promoteBackUserUrl);
        }

        //是否需要回传数据
        if (promoteBackUserUrlParam != null && "1".equals(promoteBackUserUrlParam.get("macro")) && jsonObject!=null ) {
            //开启了宏替换
            Class<?> voClass = vo.getClass();
            Class<?> reqClass = req.getClass();

            for (Map.Entry<String, String> entry : promoteBackUserUrlParam.entrySet()) {
                // 将参数中的宏挨个替换
                repliceMacroParam(vo, req,urlParamMap, voClass,reqClass, entry);
            }
        } else {
            //        ip、ua、device、a_old、a_tuiaId、imeiMd5/idfaMd5/oaidMd5
            String orderId = req.getActivityOrderId();
            String userIp = req.getIp();
            String userAgent = req.getUserAgent();

            urlParamMap.put("ip", userIp);
            try {
                urlParamMap.put("ua", StringUtils.isBlank(userAgent) ? "" : URLEncoder.encode(userAgent, "UTF-8"));
            } catch (Exception e) {
                LOGGER.warn("请求广告订单userAgent出现异常, e=", e);
            }

            urlParamMap.put("a_oId", orderId);
            urlParamMap.put("a_tuiaId", orderId);

            String imeiMd5 = vo.getIme5();
            String idfaMd5 = vo.getIdfa5();
            String oaidMd5 = vo.getOaid5();
            String device = StringUtils.isNotBlank(imeiMd5) ?
                    imeiMd5 : StringUtils.isNotBlank(idfaMd5) ?
                    idfaMd5 : StringUtils.isNotBlank(oaidMd5) ?
                    oaidMd5 : "";
            urlParamMap.put("imeiMd5", imeiMd5);
            urlParamMap.put("idfaMd5", idfaMd5);
            urlParamMap.put("oaidMd5", oaidMd5);
            urlParamMap.put("device", device);
            // cn.com.duiba.wolf.utils.UrlUtils2.extractUrlParamsFromUrl 内部有限制 promoteBackUserUrlParam不会为空
            urlParamMap.putAll(promoteBackUserUrlParam);
        }

        try {
            String extractUrl = UrlUtils2.extractUrl(promoteBackUserUrl);
            if(StringUtils.isBlank(extractUrl)){
                extractUrl =promoteBackUserUrl;
            }

            //日志打印后移
            if (logConfig.getInfoEnable()) {
                LOGGER.info("testLog:ynn promoteBackUserUrl：{},urlParam:{}", extractUrl, JSON.toJSONString(urlParamMap));
            }

            if (isNewHandler(promoteBackUserUrlParam)) {
                replaceUa(urlParamMap);
                UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl(UrlUtils2.appendParams(extractUrl, urlParamMap));
                restTemplate.getForObject(builder.build(true).toUri(), String.class);
            } else {
                String result = restTemplate.getForObject(UrlUtils2.appendParams(extractUrl, urlParamMap), String.class);
                if (logConfig.getInfoEnable()) {
                    LOGGER.info("doReportStandard Result：advertId:{},result:{}", req.getAdvertId(), result);
                }
            }
            CatUtil.log(CatGroupEnum.CAT_107015.getCode());
        } catch (Exception e) {
            log.warn("doReportStandard exception",e);
            CatUtil.log(CatGroupEnum.CAT_107016.getCode());
        }
    }

    /**
     * 将加秘后的ua 中的"+" 替换为 "%20"
     * @param urlParamMap
     */
    private void replaceUa(Map<String, String> urlParamMap) {
        String encodeUa = urlParamMap.get("ua");

        if(StringUtils.isNotBlank(encodeUa)){
            encodeUa = encodeUa.replace("+","%20");
            urlParamMap.put("ua",encodeUa);
        }
    }

    @NotNull
    private Boolean isNewHandler(Map<String, String> promoteBackUserUrlParam) {
        Boolean flag = false;
        if(MapUtils.isEmpty(promoteBackUserUrlParam)){
            return flag;
        }

        if(promoteBackUserUrlParam.keySet().contains(IS_ENCODE) && IS_ENCODE_VALUE.equals(promoteBackUserUrlParam.get(IS_ENCODE))){
            flag = true;
        }
        return flag;
    }

    /**
     * 根据 数据库中的配置来替换 url中链接。
     * 如果 宏映射为String 类型。表示 替换掉参数中的value
     * 例如：监测链接：https://www.baidu.com?imei=__tuia-imeiMd5__    替换后：https://www.baidu.com?imei=123456789012345
     * 如果 宏映射的是Map 代表优先级顺序替换
     * 例如：__tuia-deviceId__  替换整个参数，包括参数名与参数值。优先顺序imei>idfa>oaid（监测链接：https://www.baidu.com?deviceId=__tuia-deviceId__   替换后：https://www.baidu.com?imei=123456789012345
     *
     * @param vo
     * @param urlParam
     * @param voClass
     * @param entry
     */
    private void repliceMacroParam(OrderJsonVO vo, SpmlogReq req,Map<String, String> urlParam, Class<?> voClass, Class<?>reqClass, Map.Entry<String, String> entry) {
        //从vo里面获取
        String mappingKey = entry.getValue();
        Object mappingValue = jsonObject.get(mappingKey);
        if(mappingValue==null){
            //参数不是宏的情况下原有参数继续保存
            //判断是否是链接
            if(mappingKey.startsWith("http")){
                //如果是链接，链接中的参数也要支持宏替换
                processParamHasUrl(vo, req, urlParam, voClass, reqClass, entry, mappingKey);
            }else {
                //如果不是链接则不需要特殊处理。直接保存改参数即可
                urlParam.put(entry.getKey(),mappingKey);
            }
        }
        if (mappingValue instanceof String) {
            // 属于直接替换类型
            Object fieldValue = getFieldValue(vo, req, voClass, reqClass, mappingValue);
            if (fieldValue != null) {
                String value = String.valueOf(fieldValue);
                // imei=__tuia-imeiMd5__
                // imei=123456789012345
                urlParam.put(entry.getKey(), value);
            }
        } else if (mappingValue instanceof List) {
            // 属于有优先级的类型
            for (Object fieldName : (List) mappingValue) {
                Object fieldValue = getFieldValue(vo, req, voClass, reqClass, fieldName);
                if (fieldValue != null) {
                    String value = String.valueOf(fieldValue);
                    urlParam.put(entry.getKey(), value);
                    return;
                }
            }
        }
    }
    /**
     * 处理当参数中有url的情况
     * 1、参数中链接必须encoding
     * 2、判断参数是不是连接通过http开头来判断
     * 3、不支持参数中有链接，链接里面的参数还有链接。如果这样配置出现错误我们不负责
     * 4、参数中的连接宏替换后encoding回去
     * @param vo
     * @param req
     * @param urlParam
     * @param voClass
     * @param reqClass
     * @param entry
     * @param mappingKey
     * @throws UnsupportedEncodingException
     */
    private void processParamHasUrl(OrderJsonVO vo, SpmlogReq req, Map<String, String> urlParam, Class<?> voClass, Class<?> reqClass, Map.Entry<String, String> entry, String mappingKey) {
        try {
            String parmUrl = URLDecoder.decode(mappingKey, "UTF-8");
            Map<String, String> urlParamMap = UrlUtils2.extractUrlParamsFromUrl(parmUrl);
            Map<String, String> parmUrlParam = new HashMap<>();

            if (urlParamMap != null && "1".equals(urlParamMap.get("macro")) && jsonObject != null) {
                //开启了宏替换
                for (Map.Entry<String, String> entry1 : urlParamMap.entrySet()) {
                    // 将参数中的宏挨个替换
                    repliceMacroParam(vo, req, parmUrlParam, voClass, reqClass, entry1);
                }
            } else {
                parmUrlParam = urlParamMap;
            }
            String extractUrl = UrlUtils2.extractUrl(parmUrl);
            if (StringUtils.isBlank(extractUrl)) {
                extractUrl = parmUrl;
            }
            String appendParamsUrl = UrlUtils2.appendParams(extractUrl, parmUrlParam);
            String finalUrl = URLEncoder.encode(appendParamsUrl, "UTF-8");
            urlParam.put(entry.getKey(), finalUrl);
        } catch (UnsupportedEncodingException e) {
            log.error("decodeing error---");
        }
    }


    /**
     * 分别从OrderJsonVO 和
     *
     * @param voClass
     * @param reqClass
     * @param mappingValue
     * @return
     */
    private Object getFieldValue(OrderJsonVO vo,SpmlogReq req,Class<?> voClass,Class<?>reqClass, Object mappingValue)  {

        try {
            Field field = voClass.getDeclaredField(String.valueOf(mappingValue));
            field.setAccessible(true);
            return field.get(vo);
        } catch (NoSuchFieldException e) {
            try {
                Field field = reqClass.getDeclaredField(String.valueOf(mappingValue));
                field.setAccessible(true);
                return  field.get(req);
            } catch (NoSuchFieldException ex) {
                LOGGER.info("NoSuchFieldException 配置出错了！字段名：{}",mappingValue);
            } catch (IllegalAccessException ex) {
                LOGGER.info("");
            }
        } catch (IllegalAccessException e) {
            LOGGER.info("");
        }
        return null;
    }


    private String getNewUrl(Map<String,String> paramMap,String url) {
        //paramMap不需要校验为空
        String advertKeyTemp = paramMap.get(ADVERT_KEY);
        if(advertKeyTemp == null){
            return url;
        }

        paramMap.remove(ADVERT_KEY);

        String urlTemp = UrlUtils.urlPage(url);

        if(paramMap.size() > 0){
            //将url剔除advertKey后 重新赋值
            return UrlUtils.appendParams(urlTemp,paramMap);
        }

        return urlTemp;
    }

    private String getNewAdvertKey(Map<String,String> paramMap,String advertKey) {
        //paramMap不需要校验为空
        String advertKeyTemp = paramMap.get(ADVERT_KEY);

        return advertKeyTemp == null ? advertKey : advertKeyTemp;
    }

    private String getNewChannel(Map<String,String> paramMap) {
        //如果参数中已经包含了channel 则以其位置 否则用默认配置的值
        String tempChannel;
        return (tempChannel = paramMap.get(CHANNEL)) == null ? channel : tempChannel;
    }

}
