package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.cache.MediaCacheService;
import cn.com.duiba.tuia.domain.dataobject.AppDO;
import cn.com.duiba.tuia.domain.dataobject.SlotDO;
import cn.com.duiba.tuia.domain.model.AppDetail;
import cn.com.duiba.tuia.domain.model.AdvBannedTag;
import cn.com.duiba.tuia.domain.model.CheckStrategyRet;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.service.ShieldingStrategyService;
import cn.com.duiba.tuia.utils.ShieldingStrategyUtil;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.tuia.advert.enums.StrategyTypeEnum;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 默认配置策略
 * Created by zhengjy on 2017/4/14.
 */
@Service
public class DefaultStrategyServiceImpl implements ShieldingStrategyService {

    /** 默认流量策略广告白名单排序位数 */
    public static final int DEFULT_STRATEGY_WHITE_SORT = 0;

    @Autowired
    private MediaCacheService mediaCacheService;

    @Override
    public List<String> getTags(AppDO appDO, SlotDO slotDO, Boolean isHandledSlot) {
        if(appDO == null){
            return Lists.newArrayListWithCapacity(0);
        }
        return ShieldingStrategyUtil.getTags(appDO.getBannedTagNums(),appDO.getBannedAdvertTags(), appDO.getPromoteUrlTags(), appDO.getAppBannedResourceTags());
    }

    @Override
    public void handleBannedTag(AppDO appDO, SlotDO slotDO, boolean isHandledSlot, AdvBannedTag advBannedTag) {
        if(appDO == null){
            return;
        }
        if (StringUtils.isNotEmpty(appDO.getBannedTagNums())) {
            advBannedTag.getAttributeTags().addAll(Arrays.asList(appDO.getBannedTagNums().split(",")));
        }
        if (StringUtils.isNotEmpty(appDO.getBannedAdvertTags())) {
            advBannedTag.getIndustryTags().addAll(Arrays.asList(appDO.getBannedAdvertTags().split(",")));
        }
        if (StringUtils.isNotEmpty(appDO.getPromoteUrlTags())) {
            advBannedTag.getPromoteUrlTags().addAll(Arrays.asList(appDO.getPromoteUrlTags().split(",")));
        }
        if (StringUtils.isNotEmpty(appDO.getAppBannedResourceTags())) {
            advBannedTag.getResourceTags().addAll(Arrays.asList(appDO.getAppBannedResourceTags().split(",")));
        }
    }

    @Override
    public List<String> getShieldMaterialTags(AppDO appDO, SlotDO slotDO) {
        if (appDO == null || StringUtils.isBlank(appDO.getShieldMaterialTag())) {
            return Lists.newArrayListWithCapacity(0);
        }
        return Arrays.asList(appDO.getShieldMaterialTag().split(","));
    }

    @Override
    public CheckStrategyRet checkStrategy(AppDO appDO, SlotDO slotDO, Boolean isProxy, String cityId, Long slotId) {
        Boolean isHandledSlot = null == slotDO ? Boolean.FALSE : Boolean.TRUE;
        if(isHandledSlot){
            return new CheckStrategyRet(Boolean.FALSE, slotDO.getIsSendLuckybag(), Collections.<String> emptyList(), isHandledSlot, 1);
        }
        return new CheckStrategyRet(Boolean.FALSE, appDO.getIsSendLuckybag(), Collections.<String> emptyList(), isHandledSlot, 1);
    }

    @Override
    public String getShieldingStrategyType() {
        return StrategyTypeEnum.STRATEGY_TYEP_DEFAULT.getCode();
    }

    @Override
    public boolean isSendLuckybag(Object obj) {
        return (boolean) obj;
    }

    @Override
    public List<Long> getSlotWhiteList(AppDetail appDetail) throws TuiaException {
        try {
            DBTimeProfile.enter("default getSlotWhiteList");
            return mediaCacheService.getSlotWhiteList(appDetail.getSlotDO().getSlotId());
        } finally {
            DBTimeProfile.release();
        }
    }

    /**
     * 获取策略code用于计算白名单竞价排序开关
     */
    @Override
    public Integer getStrategyCode() {
        return DEFULT_STRATEGY_WHITE_SORT;
    }
}
